/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TAppDriverStructObject;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFile;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dosutil;
import utility.objectutil;

public class TDriverStruct {
    private TApplication Application;
    public ArrayList FieldColl;
    public ArrayList arFilterTreeNodes;
    public Hashtable HashFields;
    public Hashtable HashDescriptions;
    public String StructureID;
    public int RecordSize;
    private int Offset = 0;
    public boolean HasTreeNodes = false;
    public boolean HasSubtotals = false;
    private int cAbsoluteIndex = 0;
    private int cPhysicalIndex = 0;
    private String DriverParams = "";
    public int ProfileCountCalls = 0;
    public int ProfileCountAsFile = 0;
    private static Hashtable hashDriverStruct = new Hashtable();
    private TFormulaEvaluator feval = null;

    public static TDriverStruct getDriverStruct(String string) {
        return TDriverStruct.getDriverStruct(null, string, "", false);
    }

    public static TDriverStruct getDriverStruct(TAppDriversObject tAppDriversObject, String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("ExecuteScriptInitializationStructure")) {
            return new TDriverStruct(TMainWin.Application, string);
        }
        if (string.equalsIgnoreCase("Aspect_Dimensional_Driver")) {
            return new TDriverStruct(TMainWin.Application, string);
        }
        if (string.equalsIgnoreCase("ConsolidatedHorzDriver")) {
            return new TDriverStruct(TMainWin.Application, string);
        }
        if (string.equalsIgnoreCase("ConsolidatedVertDriver")) {
            return new TDriverStruct(TMainWin.Application, string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.toUpperCase() + "_" + string2.toUpperCase());
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != '|' && stringBuilder.charAt(i) != '=') continue;
            stringBuilder.setCharAt(i, '_');
        }
        TDriverStruct tDriverStruct = null;
        if (hashDriverStruct.containsKey(stringBuilder.toString())) {
            tDriverStruct = (TDriverStruct)hashDriverStruct.get(stringBuilder.toString());
        } else {
            tDriverStruct = string2.trim().length() > 0 ? new TDriverStruct(TMainWin.Application, string, string2) : new TDriverStruct(TMainWin.Application, string);
            if (string2.toUpperCase().indexOf("CACHESTRUCT=FALSE") < 0) {
                hashDriverStruct.put(stringBuilder.toString(), tDriverStruct);
            } else {
                System.out.println("not caching structure: " + string);
            }
        }
        ++tDriverStruct.ProfileCountCalls;
        if (bl) {
            ++tDriverStruct.ProfileCountAsFile;
        }
        return tDriverStruct;
    }

    public static void clearHashedStructures() {
        hashDriverStruct.clear();
    }

    public TDriverStruct(TApplication tApplication, String string) {
        Date date = new Date();
        this.Application = tApplication;
        this.StructureID = string.trim();
        this.FieldColl = new ArrayList();
        this.arFilterTreeNodes = new ArrayList();
        this.HashFields = new Hashtable(100, 0.75f);
        this.HashDescriptions = new Hashtable(100, 0.75f);
        this.RecordSize = 0;
        this.Offset = 0;
        this.cAbsoluteIndex = 0;
        this.cPhysicalIndex = 0;
        int n = this.add_fields(this.StructureID, "", "", 2, 2);
    }

    public TDriverStruct(TApplication tApplication, String string, String string2) {
        Date date = new Date();
        this.Application = tApplication;
        this.StructureID = string.trim();
        this.FieldColl = new ArrayList();
        this.arFilterTreeNodes = new ArrayList();
        this.HashFields = new Hashtable(100, 0.75f);
        this.HashDescriptions = new Hashtable(100, 0.75f);
        this.RecordSize = 0;
        this.DriverParams = string2;
        this.Offset = 0;
        this.cAbsoluteIndex = 0;
        this.cPhysicalIndex = 0;
        int n = this.add_fields(this.StructureID, "", "", 2, 2);
    }

    public int add_fields(String string, String string2, String string3, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i = 0; i < this.Application.AppDriverStruct.ResourceColl.size(); ++i) {
            String string4;
            int n4;
            TAppDriverStructObject tAppDriverStructObject = (TAppDriverStructObject)this.Application.AppDriverStruct.ResourceColl.get(i);
            if (tAppDriverStructObject.StructureID.compareToIgnoreCase(string) != 0 || tAppDriverStructObject.FieldType == 23) continue;
            if (tAppDriverStructObject.FieldType == 17) {
                String[] stringArray = charutil.getSubStringArray(tAppDriverStructObject.FieldDescription, ',', true);
                for (n4 = 0; n4 < tAppDriverStructObject.ArraySize; ++n4) {
                    String string5;
                    string4 = tAppDriverStructObject.FieldID.toString();
                    if (tAppDriverStructObject.ArraySize > 1) {
                        string4 = string4 + "[" + new Integer(n4 + 1).toString() + "]";
                    }
                    string4 = string4 + ".";
                    if (!charutil.nullstr(string2)) {
                        string4 = string2 + string4;
                    }
                    if (stringArray != null && stringArray.length >= tAppDriverStructObject.ArraySize) {
                        string5 = stringArray[n4] + " ";
                    } else {
                        string5 = tAppDriverStructObject.FieldDescription.toString() + " ";
                        if (tAppDriverStructObject.ArraySize > 1) {
                            string5 = string5 + " " + new Integer(n4 + 1) + " ";
                        }
                    }
                    if (!charutil.nullstr(string3)) {
                        string5 = string3 + " " + string5;
                    }
                    if (string4.equalsIgnoreCase(".")) {
                        string4 = "";
                    }
                    n3 += this.add_fields(tAppDriverStructObject.StructureIndex.toString(), string4, string5, tAppDriverStructObject.Visible, tAppDriverStructObject.IsEditable);
                }
                continue;
            }
            int n5 = 1;
            int n6 = tAppDriverStructObject.ArraySize;
            if (TAbstractDriver.isString(tAppDriverStructObject.FieldType)) {
                n5 = tAppDriverStructObject.ArraySize;
                n6 = 1;
            }
            if (tAppDriverStructObject.FieldType == 16) {
                n6 = tAppDriverStructObject.ArraySize * 8;
            }
            for (n4 = 0; n4 < n6; ++n4) {
                TDriverStructRecord tDriverStructRecord = new TDriverStructRecord();
                String string6 = tAppDriverStructObject.FieldID;
                String string7 = tAppDriverStructObject.FieldDescription;
                if ((string6.startsWith("=") || string7.startsWith("=")) && this.feval == null) {
                    this.feval = new TFormulaEvaluator();
                    if (this.DriverParams.length() > 0) {
                        this.feval.setConstant("Params", this.DriverParams);
                        String[] stringArray = charutil.getSubStringArray(this.DriverParams, '|', false);
                        if (stringArray != null) {
                            for (int j = 0; j < stringArray.length; ++j) {
                                String[] stringArray2 = charutil.getSubStringArray(stringArray[j], '=', false);
                                if (stringArray2 == null || stringArray2.length < 2) continue;
                                for (int k = 2; k < stringArray2.length; ++k) {
                                    stringArray2[1] = stringArray2[1] + "=" + stringArray2[k];
                                }
                                this.feval.setConstant("#" + stringArray2[0], stringArray2[1]);
                            }
                        }
                    }
                }
                if (string6.startsWith("=")) {
                    string6 = objectutil.convertToString(this.feval.getFormulaValue(string6));
                }
                if (string7.startsWith("=")) {
                    string7 = objectutil.convertToString(this.feval.getFormulaValue(string7));
                }
                if (string6.trim().length() <= 0) continue;
                tDriverStructRecord.ID = string6;
                tDriverStructRecord.FullID = string2 + string6;
                tDriverStructRecord.Description = string3 + string7;
                if (n6 > 1) {
                    string4 = "[" + new Integer(n4 + 1).toString() + "]";
                    tDriverStructRecord.ID = tDriverStructRecord.ID + string4;
                    tDriverStructRecord.FullID = tDriverStructRecord.FullID + string4;
                    tDriverStructRecord.Description = tDriverStructRecord.Description + " " + new Integer(n4 + 1);
                }
                tDriverStructRecord.FieldType = tAppDriverStructObject.FieldType;
                tDriverStructRecord.CollectionID = tAppDriverStructObject.CollectionIndex;
                tDriverStructRecord.MinValue = tAppDriverStructObject.MinValue;
                tDriverStructRecord.MaxValue = tAppDriverStructObject.MaxValue;
                tDriverStructRecord.StepValue = tAppDriverStructObject.StepValue;
                tDriverStructRecord.Decimals = tAppDriverStructObject.Decimals;
                tDriverStructRecord.FormatPattern = tAppDriverStructObject.FormatPattern;
                tDriverStructRecord.ArraySize = n5;
                tDriverStructRecord.ArrayIndex = n4;
                switch (n) {
                    case 0: {
                        tDriverStructRecord.Visible = false;
                        break;
                    }
                    case 1: {
                        tDriverStructRecord.Visible = true;
                        break;
                    }
                    default: {
                        tDriverStructRecord.Visible = false;
                        if (tAppDriverStructObject.Visible <= 0) break;
                        tDriverStructRecord.Visible = true;
                    }
                }
                switch (n2) {
                    case 0: {
                        tDriverStructRecord.IsEditable = false;
                        break;
                    }
                    case 1: {
                        tDriverStructRecord.IsEditable = true;
                        break;
                    }
                    default: {
                        tDriverStructRecord.IsEditable = false;
                        if (tAppDriverStructObject.IsEditable <= 0) break;
                        tDriverStructRecord.IsEditable = true;
                    }
                }
                tDriverStructRecord.IsLookup = tAppDriverStructObject.IsLookup;
                tDriverStructRecord.IsToken = tAppDriverStructObject.IsToken;
                tDriverStructRecord.IsCalculated = tAppDriverStructObject.IsCalculated;
                tDriverStructRecord.IsVirtual = tAppDriverStructObject.IsVirtual;
                if (tDriverStructRecord.IsToken) {
                    tDriverStructRecord.IsVirtual = true;
                }
                tDriverStructRecord.Formula = tAppDriverStructObject.Formula.toString();
                tDriverStructRecord.DefaultOnInsert = tAppDriverStructObject.DefaultOnInsert.toString();
                tDriverStructRecord.DefaultOnDelete = tAppDriverStructObject.DefaultOnDelete.toString();
                tDriverStructRecord.IsUniqueBoolean = tAppDriverStructObject.IsUniqueBoolean;
                tDriverStructRecord.EditorType = tAppDriverStructObject.EditorType;
                tDriverStructRecord.RendererType = tAppDriverStructObject.RendererType;
                tDriverStructRecord.IsRootNode = tAppDriverStructObject.IsRootNode;
                tDriverStructRecord.ChildNode = tAppDriverStructObject.ChildNode;
                tDriverStructRecord.CalcSubtotal = tAppDriverStructObject.CalcSubtotal;
                tDriverStructRecord.EditorBackground = tAppDriverStructObject.EditorBackground;
                tDriverStructRecord.EditorForeground = tAppDriverStructObject.EditorForeground;
                tDriverStructRecord.EditorLabel = tAppDriverStructObject.EditorLabel;
                tDriverStructRecord.EditorIcon = tAppDriverStructObject.EditorIcon;
                tDriverStructRecord.EditorLabelPosition = tAppDriverStructObject.EditorLabelPosition;
                tDriverStructRecord.EditorActionID = tAppDriverStructObject.EditorActionID;
                tDriverStructRecord.EditorParams = tAppDriverStructObject.EditorParams;
                tDriverStructRecord.RendererBackground = tAppDriverStructObject.RendererBackground;
                tDriverStructRecord.RendererForeground = tAppDriverStructObject.RendererForeground;
                tDriverStructRecord.RendererLabel = tAppDriverStructObject.RendererLabel;
                tDriverStructRecord.RendererIcon = tAppDriverStructObject.RendererIcon;
                tDriverStructRecord.RendererHorzLabelPosition = tAppDriverStructObject.RendererHorzLabelPosition;
                tDriverStructRecord.RendererVertLabelPosition = tAppDriverStructObject.RendererVertLabelPosition;
                tDriverStructRecord.RendererHorzIconPosition = tAppDriverStructObject.RendererHorzIconPosition;
                tDriverStructRecord.RendererVertIconPosition = tAppDriverStructObject.RendererVertIconPosition;
                tDriverStructRecord.MinimumCellWidth = tAppDriverStructObject.MinimumCellWidth;
                tDriverStructRecord.MaximumCellWidth = tAppDriverStructObject.MaximumCellWidth;
                tDriverStructRecord.RendererParams = tAppDriverStructObject.RendererParams;
                tDriverStructRecord.Tooltip = tAppDriverStructObject.Tooltip;
                tDriverStructRecord.SubtotalAsFormula = tAppDriverStructObject.SubtotalAsFormula;
                tDriverStructRecord.SuppressZeros = tAppDriverStructObject.SuppressZeros;
                tDriverStructRecord.EditorDriverCommand = tAppDriverStructObject.EditorDriverCommand;
                tDriverStructRecord.WizardFrame = tAppDriverStructObject.WizardFrame;
                tDriverStructRecord.WizardExplanation = tAppDriverStructObject.WizardExplanation;
                tDriverStructRecord.WizardAltDialog = tAppDriverStructObject.WizardAltDialog;
                tDriverStructRecord.DoNotPaste = tAppDriverStructObject.DoNotPaste;
                tDriverStructRecord.WizardSkipFrame = tAppDriverStructObject.WizardSkipFrame;
                tDriverStructRecord.WizardSkipToFrame = tAppDriverStructObject.WizardSkipToFrame;
                tDriverStructRecord.WizardInitField = tAppDriverStructObject.WizardInitField;
                tDriverStructRecord.WizardValidateField = tAppDriverStructObject.WizardValidateField;
                tDriverStructRecord.AlternateCollection = tAppDriverStructObject.AlternateCollection;
                tDriverStructRecord.EditorScript = tAppDriverStructObject.EditorScript;
                tDriverStructRecord.DialogTab = tAppDriverStructObject.DialogTab;
                tDriverStructRecord.DialogGroup = tAppDriverStructObject.DialogGroup;
                tDriverStructRecord.Html = tAppDriverStructObject.Html;
                tDriverStructRecord.Html_Permit_Editing = tAppDriverStructObject.Html_Permit_Editing;
                tDriverStructRecord.HtmlSectionStart = tAppDriverStructObject.HtmlSectionStart;
                tDriverStructRecord.Html_Enable_Sections = tAppDriverStructObject.Html_Enable_Sections;
                tDriverStructRecord.KeyField = tAppDriverStructObject.KeyField;
                tDriverStructRecord.HtmlEditAttributes = tAppDriverStructObject.HtmlEditAttributes;
                tDriverStructRecord.HtmlCollapseSection = tAppDriverStructObject.HtmlCollapseSection;
                tDriverStructRecord.NoBuffer = tAppDriverStructObject.NoBuffer;
                tDriverStructRecord.TDClass = tAppDriverStructObject.TDClass;
                tDriverStructRecord.TDAttributes = tAppDriverStructObject.TDAttributes;
                tDriverStructRecord.External_Data_Filename = tAppDriverStructObject.External_Data_Filename;
                tDriverStructRecord.External_Data_Key = tAppDriverStructObject.External_Data_Key;
                tDriverStructRecord.External_Data_Is_External = tAppDriverStructObject.External_Data_Is_External;
                tDriverStructRecord.DataSize = TAbstractDriver.getFieldSize(tAppDriverStructObject.FieldType);
                tDriverStructRecord.Offset = 0;
                if (tDriverStructRecord.IsRootNode) {
                    this.HasTreeNodes = true;
                }
                if (tDriverStructRecord.CalcSubtotal) {
                    this.HasSubtotals = true;
                }
                if (!tDriverStructRecord.IsVirtual) {
                    tDriverStructRecord.Offset = this.Offset++;
                    if (tAppDriverStructObject.FieldType == 16) {
                        if ((n4 + 1) % 8 == 0) {
                            ++this.RecordSize;
                            ++this.cPhysicalIndex;
                            tDriverStructRecord.PhysicalIndex = tDriverStructRecord.PhysicalIndex;
                        }
                    } else {
                        this.Offset += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
                        this.RecordSize += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
                        ++this.cPhysicalIndex;
                        tDriverStructRecord.PhysicalIndex = tDriverStructRecord.PhysicalIndex;
                    }
                }
                ++this.cAbsoluteIndex;
                tDriverStructRecord.AbsoluteIndex = tDriverStructRecord.AbsoluteIndex;
                this.FieldColl.add(tDriverStructRecord);
                this.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.FieldColl.size() - 1));
                stringBuilder.setLength(0);
                stringBuilder.append(tDriverStructRecord.Description.toUpperCase());
                charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
                this.HashDescriptions.put(stringBuilder.toString(), new Integer(this.FieldColl.size() - 1));
                if (tDriverStructRecord.IsRootNode) {
                    this.arFilterTreeNodes.add(tDriverStructRecord.ID.toUpperCase());
                    if (tDriverStructRecord.ChildNode.length() > 0) {
                        this.arFilterTreeNodes.add(tDriverStructRecord.ChildNode.toUpperCase());
                    }
                }
                ++n3;
            }
        }
        return n3;
    }

    public int addFields(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            TDriverStructRecord tDriverStructRecord = new TDriverStructRecord(stringArray[i]);
            if (!tDriverStructRecord.IsVirtual) {
                tDriverStructRecord.Offset = n2++;
                if (tDriverStructRecord.FieldType == 16) {
                    if ((i + 1) % 8 == 0) {
                        ++this.RecordSize;
                        ++this.cPhysicalIndex;
                        tDriverStructRecord.PhysicalIndex = tDriverStructRecord.PhysicalIndex;
                    }
                } else {
                    n2 += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
                    this.RecordSize += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
                    ++this.cPhysicalIndex;
                    tDriverStructRecord.PhysicalIndex = tDriverStructRecord.PhysicalIndex;
                }
            }
            this.FieldColl.add(tDriverStructRecord);
            if (tDriverStructRecord.IsRootNode) {
                this.HasTreeNodes = true;
            }
            if (tDriverStructRecord.CalcSubtotal) {
                this.HasSubtotals = true;
            }
            this.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.FieldColl.size() - 1));
            stringBuilder.setLength(0);
            stringBuilder.append(tDriverStructRecord.Description.toUpperCase());
            charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
            this.HashDescriptions.put(stringBuilder.toString(), new Integer(this.FieldColl.size() - 1));
            if (tDriverStructRecord.IsRootNode) {
                this.arFilterTreeNodes.add(tDriverStructRecord.ID.toUpperCase());
                if (tDriverStructRecord.ChildNode.length() > 0) {
                    this.arFilterTreeNodes.add(tDriverStructRecord.ChildNode.toUpperCase());
                }
            }
            ++n;
        }
        return n;
    }

    public int updateFieldIndices() {
        int n = 0;
        int n2 = 0;
        this.RecordSize = 0;
        this.Offset = 0;
        for (int i = 0; i < this.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(i);
            tDriverStructRecord.AbsoluteIndex = n++;
            if (tDriverStructRecord.IsVirtual) continue;
            tDriverStructRecord.Offset = this.Offset++;
            tDriverStructRecord.PhysicalIndex = n2++;
            if (tDriverStructRecord.FieldType == 16) {
                ++this.RecordSize;
                continue;
            }
            this.Offset += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
            this.RecordSize += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        }
        return this.RecordSize;
    }

    public boolean isFilterTreeNode(String string) {
        return this.arFilterTreeNodes.contains(string);
    }

    public int getRecordSize() {
        return this.RecordSize;
    }

    public int getFieldCount() {
        return this.FieldColl.size();
    }

    public TDriverStructRecord getDriverStructRecord(int n) {
        TDriverStructRecord tDriverStructRecord = null;
        if (n >= 0 && n < this.FieldColl.size()) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(n);
            return tDriverStructRecord;
        }
        return null;
    }

    public String getFieldID(int n) {
        TDriverStructRecord tDriverStructRecord = null;
        if (n >= 0 && n < this.FieldColl.size()) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(n);
            return tDriverStructRecord.FullID;
        }
        return "";
    }

    public String getFieldID(int n, boolean bl) {
        if (bl) {
            return this.getFieldDescription(n);
        }
        TDriverStructRecord tDriverStructRecord = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.FieldColl.size(); ++i) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(i);
            if (!tDriverStructRecord.IsVirtual) {
                arrayList.add(tDriverStructRecord.FullID);
            }
            if (arrayList.size() <= n) continue;
            return (String)arrayList.get(n);
        }
        return "";
    }

    public String getFieldDescription(int n) {
        TDriverStructRecord tDriverStructRecord = null;
        if (n >= 0 && n < this.FieldColl.size()) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(n);
            return tDriverStructRecord.Description;
        }
        return "";
    }

    public String getFieldDescription(int n, boolean bl) {
        if (bl) {
            return this.getFieldDescription(n);
        }
        TDriverStructRecord tDriverStructRecord = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.FieldColl.size(); ++i) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(i);
            if (!tDriverStructRecord.IsVirtual) {
                arrayList.add(tDriverStructRecord.Description);
            }
            if (arrayList.size() <= n) continue;
            return (String)arrayList.get(n);
        }
        return "";
    }

    public String getFieldTooltip(int n) {
        TDriverStructRecord tDriverStructRecord = null;
        if (n >= 0 && n < this.FieldColl.size()) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(n);
            return tDriverStructRecord.Tooltip;
        }
        return "";
    }

    public boolean containsField(String string) {
        Object v = this.HashFields.get(string.toUpperCase());
        if (v != null) {
            return true;
        }
        for (int i = 0; i < this.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(i);
            if (!tDriverStructRecord.ID.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public TDriverStructRecord getField(String string) {
        TDriverStructRecord tDriverStructRecord = null;
        Object v = this.HashFields.get(string.toUpperCase());
        if (v != null) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get((Integer)v);
            return tDriverStructRecord;
        }
        for (int i = 0; i < this.FieldColl.size(); ++i) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(i);
            if (tDriverStructRecord.ID.equalsIgnoreCase(string)) {
                return tDriverStructRecord;
            }
            int n = tDriverStructRecord.ID.indexOf(46);
            if (n < 0 || !tDriverStructRecord.ID.substring(n + 1).equalsIgnoreCase(string)) continue;
            return tDriverStructRecord;
        }
        return null;
    }

    public TDriverStructRecord getField(StringBuilder stringBuilder) {
        return this.getField(stringBuilder.toString());
    }

    public TDriverStructRecord getFieldFromDescription(String string) {
        TDriverStructRecord tDriverStructRecord = null;
        Object v = this.HashDescriptions.get(string.toUpperCase());
        if (v != null) {
            tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get((Integer)v);
            return tDriverStructRecord;
        }
        return null;
    }

    public int getFieldIndex(String string) {
        Object v = this.HashFields.get(string.toUpperCase());
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    public String getFieldIDFromDescription(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        charutil.remove_quotes(stringBuilder, stringBuilder);
        TDriverStructRecord tDriverStructRecord = this.getFieldFromDescription(stringBuilder.toString());
        if (tDriverStructRecord != null) {
            return tDriverStructRecord.FullID;
        }
        return "";
    }

    public ArrayList getAssociatedRecords(TDriverStruct tDriverStruct) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(i);
            boolean bl = false;
            for (int j = 0; !bl && j < tDriverStruct.FieldColl.size(); ++j) {
                TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)tDriverStruct.FieldColl.get(j);
                if (charutil.strcmpi(tDriverStructRecord.FullID, tDriverStructRecord2.FullID) != 0) continue;
                bl = true;
                arrayList.add(new Integer(j));
            }
            if (bl) continue;
            arrayList.add(new Integer(-1));
        }
        return arrayList;
    }

    public void outputFieldsForDebugging() {
        System.out.println("==========================================================");
        System.out.println("DriverStruct: " + this.StructureID);
        System.out.println("==========================================================");
        for (int i = 0; i < this.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.FieldColl.get(i);
            System.out.println("\t" + i + "\tFullID=" + tDriverStructRecord.FullID);
        }
    }

    public void write_to_file(String string) {
        dosutil.deleteFile(string);
        TAsciiOutput tAsciiOutput = new TAsciiOutput(string, '\t', false);
        StringBuilder stringBuilder = new StringBuilder("Offset,FieldID,FullID,FieldType,(FieldType),ArraySize,ArrayIndex,DataSize,");
        stringBuilder.append("Description,Visible,Min,Max,Step,Decimals,IsLookup,IsCalculated,IsVirtual,Formula,CollectionID,");
        stringBuilder.append("Abs_Index,Physical_Index,");
        stringBuilder.append("PivotTableValueField,PivotTableNameField,PivotTableName,IsPivotField,IsPivotOtherField,IsPivotNameField,IsPivotTotal,");
        stringBuilder.append("External_Data_Filename,External_Data_Key,Is_External,IsExternalStructField,Html,Calc Subtotal,Subtotal As Formula,");
        stringBuilder.append("HorzBaseFieldID,ControllablesDriverID,Measurement,DimensionalValues,Format Pattern");
        tAsciiOutput.writeString(stringBuilder, false);
        tAsciiOutput.write_crlf();
        for (TDriverStructRecord tDriverStructRecord : this.FieldColl) {
            tAsciiOutput.writeInt(tDriverStructRecord.Offset);
            tAsciiOutput.writeString(tDriverStructRecord.ID, true);
            tAsciiOutput.writeString(tDriverStructRecord.FullID, true);
            tAsciiOutput.writeInt(tDriverStructRecord.FieldType);
            tAsciiOutput.writeString(TAbstractDriver.getFieldTypeName(tDriverStructRecord.FieldType), true);
            tAsciiOutput.writeInt(tDriverStructRecord.ArraySize);
            tAsciiOutput.writeInt(tDriverStructRecord.ArrayIndex);
            tAsciiOutput.writeInt(tDriverStructRecord.DataSize);
            tAsciiOutput.writeString(tDriverStructRecord.Description, true);
            tAsciiOutput.writeBool(tDriverStructRecord.Visible);
            tAsciiOutput.writeString(tDriverStructRecord.MinValue, true);
            tAsciiOutput.writeString(tDriverStructRecord.MaxValue, true);
            tAsciiOutput.writeString(tDriverStructRecord.StepValue, true);
            tAsciiOutput.writeInt(tDriverStructRecord.Decimals);
            tAsciiOutput.writeBool(tDriverStructRecord.IsLookup);
            tAsciiOutput.writeBool(tDriverStructRecord.IsCalculated);
            tAsciiOutput.writeBool(tDriverStructRecord.IsVirtual);
            String string2 = charutil.replaceChar(tDriverStructRecord.Formula, '\"', '\'');
            if (string2.startsWith("=")) {
                string2 = string2.substring(1);
            }
            tAsciiOutput.writeString(string2, true);
            tAsciiOutput.writeString(tDriverStructRecord.CollectionID, true);
            tAsciiOutput.writeInt(tDriverStructRecord.AbsoluteIndex);
            tAsciiOutput.writeInt(tDriverStructRecord.PhysicalIndex);
            tAsciiOutput.writeString(tDriverStructRecord.PivotTableValueField, true);
            tAsciiOutput.writeString(tDriverStructRecord.PivotTableNameField, true);
            tAsciiOutput.writeString(tDriverStructRecord.PivotTableName, true);
            tAsciiOutput.writeBool(tDriverStructRecord.IsPivotField);
            tAsciiOutput.writeBool(tDriverStructRecord.IsPivotOtherField);
            tAsciiOutput.writeBool(tDriverStructRecord.IsPivotNameField);
            tAsciiOutput.writeBool(tDriverStructRecord.IsPivotTotal);
            tAsciiOutput.writeString(tDriverStructRecord.External_Data_Filename, true);
            string2 = charutil.replaceChar(tDriverStructRecord.External_Data_Key, '\"', '\'');
            if (string2.startsWith("=")) {
                string2 = string2.substring(1);
            }
            tAsciiOutput.writeString(string2, true);
            tAsciiOutput.writeBool(tDriverStructRecord.External_Data_Is_External);
            tAsciiOutput.writeBool(tDriverStructRecord.IsExternalStructField);
            string2 = charutil.replaceAllSubstrings(tDriverStructRecord.Html, "<", "&lt;");
            string2 = charutil.replaceAllSubstrings(string2, ">", "&gt;");
            string2 = charutil.replaceAllSubstrings(string2, "=", "&#61;");
            tAsciiOutput.writeString(string2, true);
            tAsciiOutput.writeBool(tDriverStructRecord.CalcSubtotal);
            tAsciiOutput.writeBool(tDriverStructRecord.SubtotalAsFormula);
            tAsciiOutput.writeString(tDriverStructRecord.HorzBaseFieldID, true);
            tAsciiOutput.writeString(tDriverStructRecord.ControllablesDriverID, true);
            tAsciiOutput.writeString(tDriverStructRecord.Measurement, true);
            tAsciiOutput.writeString(tDriverStructRecord.DimensionalValues, true);
            tAsciiOutput.writeString(tDriverStructRecord.FormatPattern, true);
            tAsciiOutput.write_crlf();
        }
        tAsciiOutput.dispose();
    }

    public static String writeProfileSummary() {
        Object object;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = hashDriverStruct.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = (TDriverStruct)hashDriverStruct.get(string);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            for (int i = 0; i < ((TDriverStruct)object).FieldColl.size(); ++i) {
                n2 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cRead;
                n3 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cWrite;
                n4 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cCached;
                n5 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cReadMs;
                n6 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cWriteMs;
                n7 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cReadBytes;
                n8 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cWriteBytes;
                n9 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cFormatHtml;
                n10 += ((TDriverStructRecord)((TDriverStruct)object).FieldColl.get((int)i)).cFormatHtmlMs;
            }
            if (n > 0) {
                stringBuilder.append("\r\n");
            }
            stringBuilder.append(string + ",");
            stringBuilder.append(((TDriverStruct)object).StructureID + ",");
            String string2 = ((TDriverStruct)object).DriverParams;
            string2 = charutil.replaceAllSubstrings(string2, ",", "&#44;");
            string2 = charutil.replaceAllSubstrings(string2, "<", "&#60;");
            string2 = charutil.replaceAllSubstrings(string2, ">", "&#62;");
            string2 = charutil.replaceAllSubstrings(string2, "\"", "&#34;");
            string2 = charutil.replaceAllSubstrings(string2, "=", "&#61;");
            stringBuilder.append(string2 + ",");
            stringBuilder.append(Integer.toString(((TDriverStruct)object).ProfileCountCalls) + ",");
            stringBuilder.append(Integer.toString(((TDriverStruct)object).ProfileCountAsFile) + ",");
            stringBuilder.append(Integer.toString(n2) + ",");
            stringBuilder.append(Integer.toString(n3) + ",");
            stringBuilder.append(Integer.toString(n4) + ",");
            stringBuilder.append(Integer.toString(n5) + ",");
            stringBuilder.append(Integer.toString(n6) + ",");
            stringBuilder.append(Integer.toString(n7) + ",");
            stringBuilder.append(Integer.toString(n8) + ",");
            stringBuilder.append(Integer.toString(n9) + ",");
            stringBuilder.append(Integer.toString(n10));
            ++n;
        }
        string = TMainWin.Application.getTemporaryFiles() + "Profile_DriverStruct_Totals.$$$";
        if (dosutil.fileExists(string)) {
            dosutil.deleteFile(string);
        }
        try {
            new TFile(string).validatePathToFile(true);
            object = new RandomAccessFile(string, "rwd");
            ((RandomAccessFile)object).setLength(0L);
            ((RandomAccessFile)object).writeBytes(stringBuilder.toString());
            ((RandomAccessFile)object).close();
        }
        catch (Exception exception) {
            System.out.println("Error writing driverstruct profile summary " + string + " " + exception.toString());
        }
        return string;
    }

    public static String writeProfileDetail(String string) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (hashDriverStruct.containsKey(string)) {
            object = (TDriverStruct)hashDriverStruct.get(string);
            for (int i = 0; i < ((TDriverStruct)object).FieldColl.size(); ++i) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)((TDriverStruct)object).FieldColl.get(i);
                if (i > 0) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append(tDriverStructRecord.FullID + ",");
                stringBuilder.append(((TDriverStruct)object).StructureID + ",");
                String string2 = ((TDriverStruct)object).DriverParams;
                string2 = charutil.replaceAllSubstrings(string2, ",", "&#44;");
                string2 = charutil.replaceAllSubstrings(string2, "<", "&#60;");
                string2 = charutil.replaceAllSubstrings(string2, ">", "&#62;");
                string2 = charutil.replaceAllSubstrings(string2, "\"", "&#34;");
                string2 = charutil.replaceAllSubstrings(string2, "=", "&#61;");
                stringBuilder.append(string2 + ",");
                stringBuilder.append(Integer.toString(((TDriverStruct)object).ProfileCountAsFile) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cRead) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cWrite) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cCached) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cReadMs) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cWriteMs) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cReadBytes) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cWriteBytes) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cFormatHtml) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.cFormatHtmlMs) + ",");
                stringBuilder.append(Integer.toString(tDriverStructRecord.FieldType) + ",");
                stringBuilder.append(Boolean.toString(tDriverStructRecord.IsLookup) + ",");
                stringBuilder.append(Boolean.toString(tDriverStructRecord.IsCalculated) + ",");
                string2 = tDriverStructRecord.Formula;
                string2 = charutil.replaceAllSubstrings(string2, ",", "&#44;");
                string2 = charutil.replaceAllSubstrings(string2, "<", "&#60;");
                string2 = charutil.replaceAllSubstrings(string2, ">", "&#62;");
                string2 = charutil.replaceAllSubstrings(string2, "\"", "&#34;");
                string2 = charutil.replaceAllSubstrings(string2, "=", "&#61;");
                stringBuilder.append(string2 + ",");
                stringBuilder.append(Boolean.toString(tDriverStructRecord.Html_Permit_Editing) + ",");
                string2 = tDriverStructRecord.Html;
                string2 = charutil.replaceAllSubstrings(string2, ",", "&#44;");
                string2 = charutil.replaceAllSubstrings(string2, "<", "&#60;");
                string2 = charutil.replaceAllSubstrings(string2, ">", "&#62;");
                string2 = charutil.replaceAllSubstrings(string2, "\"", "&#34;");
                string2 = charutil.replaceAllSubstrings(string2, "=", "&#61;");
                stringBuilder.append(string2);
            }
        } else {
            System.out.println("TDriverStruct.writeProfileDetail Key is not valid: " + string);
        }
        object = charutil.replaceAllSubstrings(string, "\\", "_");
        object = charutil.replaceAllSubstrings(string, "/", "_");
        object = TMainWin.Application.getTemporaryFiles() + (String)object + ".$$$";
        if (dosutil.fileExists((String)object)) {
            dosutil.deleteFile((String)object);
        }
        try {
            new TFile((String)object).validatePathToFile(true);
            RandomAccessFile randomAccessFile = new RandomAccessFile((String)object, "rwd");
            randomAccessFile.setLength(0L);
            randomAccessFile.writeBytes(stringBuilder.toString());
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("Error writing driverstruct profile detail " + (String)object + " " + exception.toString());
        }
        return object;
    }
}

