/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCacheWidget;
import collections.TComboBoxColl;
import drivers.files.TBinaryFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.netutil;
import utility.objectutil;

public class TDriverDisplay {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private boolean Debug = false;
    String sDriverID;
    String sParentDocumentID;
    String sParentWidget;
    String sContainerItemID;
    String sUserAgent = null;
    public String sMetadata = "";
    String sDisplayName = "New Display";
    boolean bDialogHeader = false;
    public Hashtable hashDisplayOptions = new Hashtable();
    private Hashtable hashDriverIncludeOptions = null;
    private static String sHtmlTemplateDesktop = null;
    private static String sHtmlTemplateMobile = null;
    Hashtable hashLibraryServers = null;
    Hashtable hashLibraryDocumentID = null;

    public TDriverDisplay(String string, String string2, String string3, String string4, String string5, Hashtable hashtable, String string6) {
        String[] stringArray;
        this.sDriverID = string;
        this.sParentDocumentID = string2;
        this.sParentWidget = string3;
        this.sContainerItemID = string4;
        this.sUserAgent = string5;
        this.hashDriverIncludeOptions = hashtable;
        this.sMetadata = string6.trim();
        if (this.hashDriverIncludeOptions.containsKey("DIALOGHEADER")) {
            this.bDialogHeader = charutil.boolval(charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("DIALOGHEADER")));
        }
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init with DriverID=" + this.sDriverID + " DocumentID=" + this.sParentDocumentID + " Widget=" + this.sParentWidget + " ContainerItemID=" + this.sContainerItemID);
        }
        if (this.Debug) {
            this.outputToConsole("hashDriverIncludeOptions", this.hashDriverIncludeOptions);
        }
        this.hashDisplayOptions = new Hashtable();
        boolean bl = false;
        if (this.hashDriverIncludeOptions.containsKey("DISPLAY")) {
            this.sDisplayName = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("DISPLAY"));
        }
        if (this.hashDriverIncludeOptions.containsKey("DISPLAYID") && !this.sDisplayName.equalsIgnoreCase("none")) {
            stringArray = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("DISPLAYID"));
            if (this.sContainerItemID.length() == 0 && this.hashDriverIncludeOptions.containsKey("CONTAINERITEMID")) {
                this.sContainerItemID = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("CONTAINERITEMID"));
            }
            this.sDisplayName = this.getDisplayName((String)stringArray);
            if (this.displayExists(this.sDisplayName)) {
                if (this.Debug) {
                    MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init with DisplayID=" + (String)stringArray + " Found display named " + this.sDisplayName);
                }
                this.loadDisplay(this.sDisplayName);
                bl = true;
            } else if (this.Debug) {
                MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init with Display=" + this.sDisplayName + " (Display does not exist)");
            }
        } else if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init No display ID was specified for driver " + string);
        }
        if (!bl) {
            if (this.hashDriverIncludeOptions.containsKey("DISPLAY")) {
                this.sDisplayName = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("DISPLAY"));
                if (!this.sDisplayName.equalsIgnoreCase("none")) {
                    if (this.displayExists(this.sDisplayName)) {
                        if (this.Debug) {
                            MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init with Display=" + this.sDisplayName + " (Display exists)");
                        }
                        this.loadDisplay(this.sDisplayName);
                        bl = true;
                    } else if (this.Debug) {
                        MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init with Display=" + this.sDisplayName + " (Display does not exist)");
                    }
                }
            }
            if (!bl && !this.sDisplayName.equalsIgnoreCase("none")) {
                this.sDisplayName = this.getDefaultDisplay();
                if (this.sDisplayName.length() > 0) {
                    if (this.Debug) {
                        MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init using default display: " + this.sDisplayName);
                    }
                    this.loadDisplay(this.sDisplayName);
                    bl = true;
                } else {
                    if (this.Debug) {
                        MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init could not find default display");
                    }
                    this.sDisplayName = "New Display";
                }
            }
        }
        if (!bl) {
            String string7;
            String[] stringArray2;
            int n;
            String[] stringArray3;
            int n2;
            if (this.Debug) {
                MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init initializing from include tag arguments");
            }
            stringArray = new String[4];
            String[] stringArray4 = new String[4];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray[n2] = "0";
                stringArray4[n2] = "0";
            }
            if (this.hashDriverIncludeOptions.containsKey("SORT") && (stringArray3 = charutil.getSubStringArray(charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("SORT")), ',', true)) != null) {
                for (n = 0; n < stringArray3.length; ++n) {
                    if (stringArray3[n].startsWith("-")) {
                        stringArray4[n] = "1";
                        stringArray3[n] = stringArray3[n].substring(1);
                    }
                    if (n >= stringArray.length) continue;
                    stringArray[n] = stringArray3[n];
                }
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.hashDisplayOptions.put("SORT" + Integer.toString(n2 + 1), stringArray[n2]);
                this.hashDisplayOptions.put("SORTORDER" + Integer.toString(n2 + 1), stringArray4[n2]);
            }
            if (this.hashDriverIncludeOptions.containsKey("FIELDS")) {
                this.hashDisplayOptions.put("SELECTEDFIELDS", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("FIELDS")));
            }
            if (this.hashDriverIncludeOptions.containsKey("DETAILS")) {
                String string8 = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("DETAILS"));
                n = !charutil.boolval(string8) ? 1 : 0;
                this.hashDisplayOptions.put("SUBTOTALSONLY", Boolean.toString(n != 0));
            }
            if (this.hashDriverIncludeOptions.containsKey("GRANDTOTALS")) {
                this.hashDisplayOptions.put("GRANDTOTALS", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("GRANDTOTALS")));
            }
            String[] stringArray5 = new String[3];
            for (n = 0; n < stringArray5.length; ++n) {
                stringArray5[n] = "false";
            }
            if (this.hashDriverIncludeOptions.containsKey("SUBTOTAL") && (stringArray2 = charutil.getSubStringArray(string7 = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("SUBTOTAL")), ',', true)) != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray5[i] = stringArray2[i];
                }
            }
            for (int i = 0; i < stringArray5.length; ++i) {
                this.hashDisplayOptions.put("SUBTOTAL" + Integer.toString(i + 1), stringArray5[i]);
            }
            this.setSubtotalArguments();
            if (this.hashDriverIncludeOptions.containsKey("FILTER")) {
                this.hashDisplayOptions.put("FILTER", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("FILTER")));
            }
            if (this.hashDriverIncludeOptions.containsKey("CHARTTYPE")) {
                this.hashDisplayOptions.put("CHARTTYPE", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("CHARTTYPE")));
            }
            if (this.hashDriverIncludeOptions.containsKey("CHARTWIDTH")) {
                this.hashDisplayOptions.put("CHARTWIDTH", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("CHARTWIDTH")));
            }
            if (this.hashDriverIncludeOptions.containsKey("CHARTHEIGHT")) {
                this.hashDisplayOptions.put("CHARTHEIGHT", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("CHARTHEIGHT")));
            }
            if (this.hashDriverIncludeOptions.containsKey("CHARTLABELS")) {
                this.hashDisplayOptions.put("CHARTLABELS", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("CHARTLABELS")));
            }
            if (this.hashDriverIncludeOptions.containsKey("CHARTTITLE")) {
                this.hashDisplayOptions.put("CHARTTITLE", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("CHARTTITLE")));
            }
            if (this.hashDriverIncludeOptions.containsKey("CHARTSERIES")) {
                this.hashDisplayOptions.put("CHARTSERIES", charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("CHARTSERIES")));
            }
        }
        if (this.Debug) {
            this.outputToConsole("hashDisplayOptions", this.hashDisplayOptions);
        }
    }

    public TDriverDisplay(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        String string8;
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init for getDisplayDialog() with DocumentID=" + string2 + " Widget=" + string3 + " Item=" + string4 + " WidgetID=" + string5 + " Metadata=" + string7);
        }
        this.sDriverID = string;
        this.sParentDocumentID = string2;
        this.sParentWidget = string3;
        this.sContainerItemID = string4;
        this.sUserAgent = string6;
        this.sMetadata = string7.trim();
        this.bDialogHeader = bl;
        TBinaryFile tBinaryFile = TCacheWidget.getWidgetMetadataDriver();
        int n = tBinaryFile.getMatchingRecord(string8 = "(ID=\"" + string5 + "\")", 0);
        if (n < 0) {
            tBinaryFile.clearBuffer();
            n = tBinaryFile.getMatchingRecord(string8, 0);
        }
        if (n >= 0) {
            String string9 = (String)tBinaryFile.getField("Name", n);
            this.sDisplayName = charutil.replaceAllSubstrings(string9, this.getMetadata(), "");
            if (this.Debug) {
                MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init for getDisplayDialog() found display named: " + this.sDisplayName);
            }
        } else {
            this.sDisplayName = this.getDefaultDisplay();
            if (this.Debug) {
                MainWin.appendToLog("TDriverDisplay", "init", Thread.currentThread(), null, 10, "TDriverDisplay init for getDisplayDialog() using default display: " + this.sDisplayName);
            }
        }
        this.loadDisplay(this.sDisplayName);
    }

    public void outputToConsole(String string, Hashtable hashtable) {
        System.out.println("--------------------------------");
        System.out.println("Dump hashtable: " + string);
        System.out.println("--------------------------------");
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            System.out.println("\t " + n + "\t" + string2 + " = " + hashtable.get(string2));
            ++n;
        }
    }

    public boolean isMobileDevice() {
        if (this.sUserAgent == null) {
            if (this.Debug) {
                MainWin.appendToLog("TDriverDisplay", "isMobileDevice", Thread.currentThread(), null, 10, "TDriverDisplay isMobileDevice returns false because no user agent specified");
            }
            return false;
        }
        boolean bl = netutil.isMobileDevice(this.sUserAgent);
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "isMobileDevice", Thread.currentThread(), null, 10, "TDriverDisplay isMobileDevice returns " + bl + " for user-agent=" + this.sUserAgent);
        }
        return bl;
    }

    public static String getMetadata(String string, String string2, String string3, String string4, boolean bl) {
        return string + "|" + string2 + "|" + string3 + "|" + string4 + "|Mobile_false";
    }

    public String getMetadata() {
        if (this.sMetadata.length() > 0) {
            if (this.Debug) {
                MainWin.appendToLog("TDriverDisplay", "getDisplayName", Thread.currentThread(), null, 10, "TDriverDisplay getMetadata using Metadata string: " + this.sMetadata);
            }
            return this.sMetadata;
        }
        String string = TDriverDisplay.getMetadata(this.sDriverID, this.sParentDocumentID, this.sParentWidget, this.sContainerItemID, this.isMobileDevice());
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "getDisplayName", Thread.currentThread(), null, 10, "TDriverDisplay getMetadata calculating metadata = " + string);
        }
        return string;
    }

    public String getDisplayName(String string) {
        String string2;
        TBinaryFile tBinaryFile = TCacheWidget.getWidgetMetadataDriver();
        int n = tBinaryFile.getMatchingRecord(string2 = "(ID=\"" + string + "\")", 0);
        if (n < 0) {
            tBinaryFile.clearBuffer();
            n = tBinaryFile.getMatchingRecord(string2, 0);
        }
        if (n < 0) {
            if (this.Debug) {
                MainWin.appendToLog("TDriverDisplay", "getDisplayName", Thread.currentThread(), null, 10, "TDriverDisplay getDisplayName could not find name for the display with ID=" + string);
            }
            return "";
        }
        String string3 = (String)tBinaryFile.getField("Metadata", n);
        String string4 = (String)tBinaryFile.getField("Name", n);
        String string5 = charutil.replaceSubstring(string4, string3, "");
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "getDisplayName", Thread.currentThread(), null, 10, "TDriverDisplay getDisplayName returns name=" + string5 + " for the display with ID=" + string);
        }
        return string5;
    }

    public String getDefaultDisplay() {
        String string;
        new TFormulaEvaluator();
        TFormulaEvaluator.eval("getDefault(\"DefaultDisplay_" + this.sMetadata + "\",\"\")");
        new TFormulaEvaluator();
        String string2 = (String)TFormulaEvaluator.eval("getDefault(\"DefaultDisplay_" + this.getMetadata() + "\",\"\")");
        if (string2.length() > 0) {
            return string2;
        }
        TBinaryFile tBinaryFile = TCacheWidget.getWidgetMetadataDriver();
        int n = tBinaryFile.getMatchingRecord(string = "(Used) and (Metadata=\"" + this.getMetadata() + "\")", 0);
        if (n < 0) {
            if (this.Debug) {
                MainWin.appendToLog("TDriverDisplay", "getDefaultDisplay", Thread.currentThread(), null, 10, "TDriverDisplay getDefaultDisplay could not find a display with Metadata=" + this.getMetadata());
            }
            return "";
        }
        String string3 = (String)tBinaryFile.getField("Name", n);
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "getDefaultDisplay", Thread.currentThread(), null, 10, "TDriverDisplay getDefaultDisplay returns " + string3);
        }
        return charutil.replaceSubstring(string3, this.getMetadata(), "");
    }

    public boolean displayExists(String string) {
        TBinaryFile tBinaryFile = TCacheWidget.getWidgetMetadataDriver();
        String string2 = "Name=\"" + this.getMetadata() + string + "\"";
        int n = tBinaryFile.getMatchingRecord(string2, 0);
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "displayExists", Thread.currentThread(), null, 10, "TDriverDisplay displayExists returns " + (n >= 0) + " for " + string + " Metadata=" + this.getMetadata());
        }
        return n >= 0;
    }

    public void loadDisplay(String string) {
        String string2 = "DriverID=" + this.sDriverID + "&DocumentID=" + this.sParentDocumentID + "&Widget=" + this.sParentWidget;
        string2 = string2 + "&DisplayName=" + string + "&ContainerItemID=" + this.sContainerItemID + "&Mobile=" + Boolean.toString(this.isMobileDevice()) + "&Text=true";
        string2 = string2 + "&metadata=" + this.sMetadata;
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "loadDisplay", Thread.currentThread(), null, 10, "TDriverDisplay loadDisplay loading " + string + " Params=" + string2);
        }
        String string3 = TFormulaEvaluator.getCache().getCachedContent(4, Application.getAspectHashID(), string2, true, "", this.sUserAgent);
        if (this.Debug) {
            MainWin.appendToLog("TDriverDisplay", "loadDisplay", Thread.currentThread(), null, 10, "TDriverDisplay loadDisplay got " + string3.length() + " bytes");
        }
        String[] stringArray = charutil.getSubStringArray(string3, '|', true);
        this.hashDisplayOptions.clear();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].indexOf("=");
                if (n <= 0) continue;
                String string4 = charutil.replaceAllSubstrings(stringArray[i].substring(0, n), "field_", "");
                String string5 = stringArray[i].substring(n + 1);
                if (string4.equalsIgnoreCase("FieldsSelected")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String[] stringArray2 = charutil.getSubStringArray(string5, ',', true);
                    if (stringArray2 == null) continue;
                    for (int j = 0; j < stringArray2.length; ++j) {
                        n = stringArray2[j].indexOf("^");
                        if (n <= 0) continue;
                        stringBuilder.append("," + stringArray2[j].substring(0, n));
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.deleteCharAt(0);
                    }
                    this.hashDisplayOptions.put("SELECTEDFIELDS", stringBuilder.toString());
                    if (!this.Debug) continue;
                    MainWin.appendToLog("TDriverDisplay", "loadDisplay", Thread.currentThread(), null, 10, "TDriverDisplay loadDisplay fields selected = " + stringBuilder);
                    continue;
                }
                this.hashDisplayOptions.put(string4.toUpperCase(), string5.trim());
            }
            new TFormulaEvaluator();
            TFormulaEvaluator.eval("putDefault(\"DefaultDisplay_" + this.sMetadata + "\",\"" + string + "\")");
        }
        this.setSubtotalArguments();
    }

    public String getChartType() {
        if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYCHARTTYPE")) {
            return charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYCHARTTYPE"));
        }
        if (this.hashDisplayOptions.containsKey("CHARTTYPE")) {
            return charutil.removeQuotes((String)this.hashDisplayOptions.get("CHARTTYPE"));
        }
        return "0";
    }

    public String[] getSelectedFields() {
        if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYFIELDSSELECTED")) {
            String[] stringArray = charutil.getSubStringArray(charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYFIELDSSELECTED")), ',', true);
            if (stringArray == null) {
                return null;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].indexOf("^");
                if (n < 0) continue;
                stringArray[i] = stringArray[i].substring(0, n);
            }
            return stringArray;
        }
        if (this.hashDisplayOptions.containsKey("SELECTEDFIELDS")) {
            return charutil.getSubStringArray(charutil.removeQuotes((String)this.hashDisplayOptions.get("SELECTEDFIELDS")), ',', true);
        }
        return null;
    }

    public String[] getPivotFields(String string) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 1; i < 4; ++i) {
            if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYPIVOTNAME" + Integer.toString(i))) {
                object2 = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYPIVOTNAME" + Integer.toString(i)));
                object = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYPIVOTVALUE" + Integer.toString(i)));
                if (((String)object2).equalsIgnoreCase("0") || ((String)object).equalsIgnoreCase("0")) continue;
                arrayList.add(object2);
                arrayList2.add(object);
                arrayList3.add((String)object2 + "$" + (String)object);
                continue;
            }
            if (!this.hashDisplayOptions.containsKey("PIVOTNAME" + Integer.toString(i))) continue;
            object2 = charutil.removeQuotes((String)this.hashDisplayOptions.get("PIVOTNAME" + Integer.toString(i)));
            object = charutil.removeQuotes((String)this.hashDisplayOptions.get("PIVOTVALUE" + Integer.toString(i)));
            if (((String)object2).equalsIgnoreCase("0") || ((String)object).equalsIgnoreCase("0")) continue;
            arrayList.add(object2);
            arrayList2.add(object);
            arrayList3.add((String)object2 + "$" + (String)object);
        }
        String[] stringArray = new String[arrayList.size()];
        object2 = new String[arrayList2.size()];
        object = new String[arrayList3.size()];
        for (int i = 0; i < arrayList3.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
            object2[i] = (String)arrayList2.get(i);
            object[i] = (String)arrayList3.get(i);
        }
        if (string.equalsIgnoreCase("name")) {
            return stringArray;
        }
        if (string.equalsIgnoreCase("value")) {
            return object2;
        }
        return object;
    }

    public String[] getSortOptions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < 5; ++i) {
            if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYSORT" + Integer.toString(i))) {
                stringBuilder.append(",");
                if (this.hashDriverIncludeOptions.containsKey("XDISPLAYSORTORDER" + Integer.toString(i)) && charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYSORTORDER" + Integer.toString(i))).equalsIgnoreCase("1")) {
                    stringBuilder.append("-");
                }
                stringBuilder.append(charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYSORT" + Integer.toString(i))));
                continue;
            }
            if (!this.hashDisplayOptions.containsKey("SORT" + Integer.toString(i))) continue;
            stringBuilder.append(",");
            if (this.hashDisplayOptions.containsKey("SORTORDER" + Integer.toString(i)) && charutil.removeQuotes((String)this.hashDisplayOptions.get("SORTORDER" + Integer.toString(i))).equalsIgnoreCase("1")) {
                stringBuilder.append("-");
            }
            stringBuilder.append(charutil.removeQuotes((String)this.hashDisplayOptions.get("SORT" + Integer.toString(i))));
        }
        if (stringBuilder.toString().startsWith(",")) {
            stringBuilder.deleteCharAt(0);
        }
        if (stringBuilder.toString().equalsIgnoreCase("__sort__")) {
            stringBuilder.setLength(0);
        }
        String[] stringArray = charutil.getSubStringArray(stringBuilder.toString(), ',', true);
        String[] stringArray2 = new String[4];
        for (int i = 0; i < 4; ++i) {
            stringArray2[i] = stringArray != null && i < stringArray.length ? stringArray[i] : "0";
        }
        return stringArray2;
    }

    public int[] getSortOrder() {
        int[] nArray = new int[4];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < 4; ++i) {
            if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYSORTORDER" + Integer.toString(i))) {
                nArray[i - 1] = charutil.ival(charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYSORTORDER" + Integer.toString(i))));
                continue;
            }
            if (!this.hashDisplayOptions.containsKey("SORTORDER" + Integer.toString(i))) continue;
            nArray[i - 1] = charutil.ival(charutil.removeQuotes((String)this.hashDisplayOptions.get("SORTORDER" + Integer.toString(i))));
        }
        return nArray;
    }

    public String getFilter() {
        String string;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYFILTER")) {
            object = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYFILTER"));
            if (((String)object).trim().length() > 0) {
                object = charutil.replaceChar((String)object, '\'', '\"');
                stringBuilder.append("(" + (String)object + ")");
            } else if (this.hashDisplayOptions.containsKey("FILTER") && ((String)(object = charutil.removeQuotes((String)this.hashDisplayOptions.get("FILTER")))).length() > 0) {
                stringBuilder.append("(" + (String)object + ")");
            }
        } else if (this.hashDisplayOptions.containsKey("FILTER") && ((String)(object = charutil.removeQuotes((String)this.hashDisplayOptions.get("FILTER")))).length() > 0) {
            stringBuilder.append("(" + (String)object + ")");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("(true)");
        }
        object = this.hashDriverIncludeOptions.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (!string.toUpperCase().startsWith("XDISPLAYXFILTER")) continue;
            String string2 = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get(string));
            String[] stringArray = charutil.getSubStringArray(string2, '^', true);
            if (stringArray != null && stringArray.length >= 2) {
                String string3;
                boolean bl = true;
                if (stringArray.length >= 3) {
                    string3 = charutil.replaceAllSubstrings(stringArray[2], "$value$", stringArray[1]);
                    Object object2 = new TFormulaEvaluator().getFormulaValue(string3 = charutil.replaceAllSubstrings(string3, "'", "\""));
                    if (object2 != null) {
                        bl = charutil.boolval(objectutil.convertToString(object2));
                    }
                }
                String string4 = string3 = stringArray.length == 4 ? stringArray[3] : "and";
                if (!bl) continue;
                stringBuilder.append(" " + string3 + " ");
                stringBuilder.append("(" + charutil.replaceAllSubstrings(stringArray[0], "$value$", stringArray[1]) + ")");
                continue;
            }
            MainWin.appendToLog("TDriverDisplay", "getFilter", Thread.currentThread(), null, 10, "Invalid filter argument: " + string + "=" + string2);
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "'", "\"");
        string = charutil.tokenizeSpecialChars(stringBuilder.toString(), false);
        return string;
    }

    public boolean subtotalsOnly() {
        if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYSUBTOTALSONLY")) {
            return charutil.boolval(charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYSUBTOTALSONLY")));
        }
        if (this.hashDisplayOptions.containsKey("SUBTOTALSONLY")) {
            return charutil.boolval(charutil.removeQuotes((String)this.hashDisplayOptions.get("SUBTOTALSONLY")));
        }
        return false;
    }

    public boolean showGrandTotals() {
        if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYGRANDTOTALS")) {
            return charutil.boolval(charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYGRANDTOTALS")));
        }
        if (this.hashDisplayOptions.containsKey("GRANDTOTALS")) {
            return charutil.boolval(charutil.removeQuotes((String)this.hashDisplayOptions.get("GRANDTOTALS")));
        }
        return false;
    }

    public boolean isSubtotalEnabled(int n) {
        if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYSUBTOTAL" + Integer.toString(n))) {
            return charutil.boolval(charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYSUBTOTAL" + Integer.toString(n))));
        }
        if (this.hashDisplayOptions.containsKey("SUBTOTAL" + Integer.toString(n))) {
            return charutil.boolval(charutil.removeQuotes((String)this.hashDisplayOptions.get("SUBTOTAL" + Integer.toString(n))));
        }
        return false;
    }

    public String[] getSubtotalFields() {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.subtotalsOnly();
        boolean bl2 = false;
        for (int i = 1; !bl2 && i < 5; ++i) {
            String string = "";
            if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYSORT" + Integer.toString(i))) {
                string = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYSORT" + Integer.toString(i)));
            } else if (this.hashDisplayOptions.containsKey("SORT" + Integer.toString(i))) {
                string = charutil.removeQuotes((String)this.hashDisplayOptions.get("SORT" + Integer.toString(i)));
            }
            if (string != "0" && this.isSubtotalEnabled(i)) {
                arrayList.add(string);
                continue;
            }
            if (bl) continue;
            bl2 = true;
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public void setSubtotalArguments() {
        String[] stringArray = new String[5];
        String[] stringArray2 = this.getSubtotalFields();
        switch (stringArray2.length) {
            case 1: {
                stringArray[0] = "Sum," + stringArray2[0];
                break;
            }
            case 2: {
                stringArray[0] = "Sum," + stringArray2[0] + "," + stringArray2[1];
                stringArray[1] = "Sum," + stringArray2[0];
                break;
            }
            case 3: {
                stringArray[0] = "Sum," + stringArray2[0] + "," + stringArray2[1] + "," + stringArray2[2];
                stringArray[1] = "Sum," + stringArray2[0] + "," + stringArray2[1];
                stringArray[2] = "Sum," + stringArray2[0];
                break;
            }
            case 4: {
                stringArray[0] = "Sum," + stringArray2[0] + "," + stringArray2[1] + "," + stringArray2[2] + "," + stringArray2[3];
                stringArray[1] = "Sum," + stringArray2[0] + "," + stringArray2[1] + "," + stringArray2[2];
                stringArray[2] = "Sum," + stringArray2[0] + "," + stringArray2[1];
                stringArray[3] = "Sum," + stringArray2[0];
            }
        }
        if (this.showGrandTotals()) {
            stringArray[stringArray2.length] = "Sum";
        }
        for (int i = 0; i < 4; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            this.hashDisplayOptions.put("SUBTOTALFIELDS" + Integer.toString(i), stringArray[i]);
        }
    }

    public String toHtmlSelect() {
        TBinaryFile tBinaryFile = TCacheWidget.getWidgetMetadataDriver();
        String string = "(Used) and (Metadata=\"" + this.getMetadata() + "\")";
        int[] nArray = tBinaryFile.getMatchingRecords(string);
        String string2 = "0";
        TComboBoxColl tComboBoxColl = new TComboBoxColl(true, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            String string3;
            String string4 = (String)tBinaryFile.getField("ID", nArray[i]);
            String string5 = (String)tBinaryFile.getField("NameForReportFilters", nArray[i]);
            String string6 = (String)tBinaryFile.getField("Name", nArray[i]);
            if (charutil.replaceAllSubstrings(string6, string3 = (String)tBinaryFile.getField("Metadata", nArray[i]), "").equalsIgnoreCase(this.sDisplayName)) {
                string2 = string4;
            }
            tComboBoxColl.add(string4, string5);
        }
        if (tComboBoxColl.size() == 0) {
            tComboBoxColl.add("0", "New Display");
        }
        return tComboBoxColl.toHtmlSelect(string2);
    }

    private void initializeHtmlTemplate() {
        String string;
        String string2 = Application.getHomeDir() + "cache/widgetEdit_77NaWu0FhKDKXL7C70JpnKmy_Displays Dialog 2012.html";
        if (sHtmlTemplateDesktop == null || new File(string2).exists()) {
            string = "DocumentID=77NaWu0FhKDKXL7C70JpnKmy&Widget=Displays Dialog 2012";
            sHtmlTemplateDesktop = TFormulaEvaluator.getCache().getCachedContent(0, Application.getAspectHashID(), string, true, "127.0.0.1", "desktop");
        }
        string2 = Application.getHomeDir() + "cache/widgetEdit_77NaWu0FhKDKXL7C70JpnKmy_Displays Dialog Mobile 2012.html";
        if (sHtmlTemplateMobile == null || new File(string2).exists()) {
            string = "DocumentID=77NaWu0FhKDKXL7C70JpnKmy&Widget=Displays Dialog Mobile 2012";
            sHtmlTemplateMobile = TFormulaEvaluator.getCache().getCachedContent(0, Application.getAspectHashID(), string, true, "127.0.0.1", "mobile");
        }
    }

    public String getMetadataID(String string) {
        String string2;
        TBinaryFile tBinaryFile = TCacheWidget.getWidgetMetadataDriver();
        int n = tBinaryFile.getMatchingRecord(string2 = "(used) and (Name=\"" + this.getMetadata() + string + "\")", 0);
        if (n < 0) {
            tBinaryFile.clearBuffer();
            n = tBinaryFile.getMatchingRecord(string2, 0);
        }
        if (n >= 0) {
            return (String)tBinaryFile.getField("ID", n);
        }
        return "0";
    }

    public String toHtmlDialog(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        String[] stringArray4;
        Object object2;
        int n6;
        int n7;
        this.initializeHtmlTemplate();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sHtmlTemplateDesktop);
        if (!this.bDialogHeader && (n7 = stringBuilder.indexOf("<!--dialog header-->")) >= 0 && (n6 = stringBuilder.indexOf("<!--end dialog header-->", n7)) > 0) {
            stringBuilder.delete(n7, n6 + 25);
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$SelectDisplay$", this.toHtmlSelect());
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Arrays.sort(stringArray);
        String[] stringArray5 = new String[stringArray.length];
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n8 = stringArray[i].indexOf("^");
            if (n8 < 0) {
                System.out.println("Error parsing fields from " + stringArray[i]);
                continue;
            }
            stringArray5[i] = stringArray[i].substring(n8 + 1);
            hashtable.put(stringArray5[i].toUpperCase(), stringArray[i].substring(0, n8));
        }
        String[] stringArray6 = this.getSortOptions();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 1; i < 5; ++i) {
            stringBuilder2.setLength(0);
            String string2 = stringArray6[i - 1];
            if (string2.startsWith("-")) {
                string2 = string2.substring(1);
            }
            if (string2.trim().length() == 0) {
                string2 = "0";
            }
            if (string2.equalsIgnoreCase("0")) {
                stringBuilder2.append("<option value=\"0\" selected=\"selected\">-- Select --</option>");
            } else {
                stringBuilder2.append("<option value=\"0\">-- Select --</option>");
            }
            object2 = new ArrayList();
            for (int j = 0; j < stringArray.length; ++j) {
                if (((ArrayList)object2).contains(stringArray5[j].toUpperCase())) continue;
                if (string2.equalsIgnoreCase(stringArray5[j])) {
                    stringBuilder2.append("<option selected=\"selected\" ");
                } else {
                    stringBuilder2.append("<option ");
                }
                stringArray4 = charutil.replaceAllSubstrings((String)hashtable.get(stringArray5[j].toUpperCase()), "<br>", " ");
                stringBuilder2.append("value=\"" + stringArray5[j] + "\">" + (String)stringArray4 + "</option>");
                ((ArrayList)object2).add(stringArray5[j].toUpperCase());
            }
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$SelectSort" + Integer.toString(i) + "$", stringBuilder2.toString());
        }
        int[] nArray = this.getSortOrder();
        for (n5 = 1; n5 < 5; ++n5) {
            object2 = "";
            object2 = this.isMobileDevice() ? (nArray[n5 - 1] == 0 ? "arrowUp32x32white.png" : "arrowDown32x32white.png") : (nArray[n5 - 1] == 0 ? "arrowUp12x12.png" : "arrowDown12x12.png");
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$sortorderimg" + Integer.toString(n5) + "$", (String)object2);
            String string3 = nArray[n5 - 1] == 0 ? "DisplayDialogSortAscendingIcon" : "DisplayDialogSortDescendingIcon";
            stringArray4 = nArray[n5 - 1] == 0 ? "Ascending" : "Descending";
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$sortorderclass" + Integer.toString(n5) + "$", string3);
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$sortordervalue" + Integer.toString(n5) + "$", (String)stringArray4);
        }
        for (n5 = 1; n5 < 5; ++n5) {
            object2 = this.isSubtotalEnabled(n5) ? "checked" : "";
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$subtotal" + Integer.toString(n5) + "$", (String)object2);
        }
        String string4 = this.subtotalsOnly() ? "checked" : "";
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$subtotalsonly$", string4);
        string4 = this.showGrandTotals() ? "checked" : "";
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$grandtotals$", string4);
        object2 = "";
        if (this.hashDriverIncludeOptions != null && this.hashDriverIncludeOptions.containsKey("XDISPLAYFILTER")) {
            object2 = charutil.removeQuotes((String)this.hashDriverIncludeOptions.get("XDISPLAYFILTER"));
            object2 = charutil.replaceChar((String)object2, '\'', '\"');
        } else if (this.hashDisplayOptions.containsKey("FILTER")) {
            object2 = charutil.removeQuotes((String)this.hashDisplayOptions.get("FILTER"));
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$filter$", (String)object2);
        String string5 = this.getChartType();
        stringArray4 = new String[]{"0", "Bar", "Column", "Line", "Line2", "Pie", "Scatter", "AspectLine", "AspectLineIndex", "AspectLine2", "AspectColumn", "AspectColumn2", "AspectScatter", "AspectScatter2"};
        String[] stringArray7 = new String[]{"-- None --", "Bar", "Column", "Line", "Line (2-Axis)", "Pie", "Scatter", "Aspect Line", "Aspect Line (Indexed)", "Aspect Line (2-Axis)", "Aspect Column", "Aspect Column (2-Axis)", "Aspect Scatter", "Aspect Scatter (2-Axis)"};
        stringBuilder2.setLength(0);
        for (int i = 0; i < stringArray4.length; ++i) {
            stringBuilder2.append("<option value=\"" + stringArray4[i] + "\"");
            if (string5.equalsIgnoreCase(stringArray4[i])) {
                stringBuilder2.append(" selected=\"selected\" ");
            }
            stringBuilder2.append(">" + stringArray7[i] + "</option>");
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$SelectChartType$", stringBuilder2.toString());
        stringBuilder2.setLength(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray8 = this.getSelectedFields();
        if (stringArray8 != null) {
            for (n4 = 0; n4 < stringArray8.length; ++n4) {
                object = (StringBuilder[])hashtable.get(stringArray8[n4].toUpperCase());
                if (object == null) continue;
                object = charutil.replaceAllSubstrings((String)object, "<br>", " ");
                stringBuilder2.append("<tr onClick=\"tableRowSelected(this)\"><td class=\"DisplayDialogFieldsTableCheckbox\" AspectFieldID=\"" + stringArray8[n4] + "\" valign='center'><input type='checkbox' ID=\"check" + stringArray8[n4] + "\" checked></td><td class=\"DisplayDialogFieldsTableDescription\" onClick='tableCellSelected(this)' valign='center'>" + (String)object + "</td><td>&nbsp;</td></tr>\n");
                arrayList.add(stringArray8[n4].toUpperCase());
            }
        }
        for (n4 = 0; n4 < stringArray5.length; ++n4) {
            if (arrayList.contains(stringArray5[n4].toUpperCase())) continue;
            object = (String)hashtable.get(stringArray5[n4].toUpperCase());
            object = charutil.replaceAllSubstrings((String)object, "<br>", " ");
            stringBuilder2.append("<tr onClick=\"tableRowSelected(this)\"><td style='margin:0px;padding:0px' AspectFieldID=\"" + stringArray5[n4] + "\" valign='center'><input type='checkbox' ID=\"check" + stringArray5[n4] + "\"></td><td style='margin:0px;padding:0px 0px 0px 5px; width:200px; vertical-align:middle' onClick='tableCellSelected(this)' valign='center'>" + (String)object + "</td><td>&nbsp;</td></tr>");
            arrayList.add(stringArray5[n4].toUpperCase());
        }
        String string6 = charutil.replaceAllSubstrings(stringBuilder2.toString(), "<br>", "");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$SelectedFields$", string6);
        object = new StringBuilder[3];
        StringBuilder[] stringBuilderArray = new StringBuilder[3];
        String[] stringArray9 = new String[3];
        String[] stringArray10 = new String[3];
        String[] stringArray11 = this.getPivotFields("both");
        for (n3 = 0; n3 < 3; ++n3) {
            stringArray9[n3] = "0";
            stringArray10[n3] = "0";
            if (n3 >= stringArray11.length || (n2 = stringArray11[n3].indexOf("$")) <= 0) continue;
            stringArray9[n3] = stringArray11[n3].substring(0, n2);
            stringArray10[n3] = stringArray11[n3].substring(n2 + 1);
        }
        for (n3 = 0; n3 < 3; ++n3) {
            object[n3] = new StringBuilder();
            stringBuilderArray[n3] = new StringBuilder();
            object[n3].append("<option value=\"0\">-- Select --</option>");
            stringBuilderArray[n3].append("<option value=\"0\">-- Select --</option>");
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (stringArray2 != null) {
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                arrayList2.add(stringArray2[n2].toUpperCase());
            }
        }
        arrayList.clear();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (arrayList.contains(stringArray5[n2].toUpperCase()) || arrayList2.contains(stringArray5[n2].toUpperCase())) continue;
            for (n = 0; n < 3; ++n) {
                if (stringArray9[n].equalsIgnoreCase(stringArray5[n2])) {
                    object[n].append("<option selected=\"selected\" ");
                } else {
                    object[n].append("<option ");
                }
                object[n].append("value=\"" + stringArray5[n2] + "\">" + (String)hashtable.get(stringArray5[n2].toUpperCase()) + "</option>");
                arrayList.add(stringArray5[n2].toUpperCase());
            }
        }
        arrayList.clear();
        if (stringArray3 != null) {
            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                if (arrayList.contains(stringArray3[n2].toUpperCase())) continue;
                for (n = 0; n < 3; ++n) {
                    if (stringArray10[n].equalsIgnoreCase(stringArray3[n2])) {
                        stringBuilderArray[n].append("<option selected=\"selected\" ");
                    } else {
                        stringBuilderArray[n].append("<option ");
                    }
                    stringBuilderArray[n].append("value=\"" + stringArray3[n2] + "\">" + (String)hashtable.get(stringArray3[n2].toUpperCase()) + "</option>");
                    arrayList.add(stringArray3[n2].toUpperCase());
                }
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$pivotvalue" + Integer.toString(n2 + 1) + "$", stringBuilderArray[n2].toString());
            charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$pivotname" + Integer.toString(n2 + 1) + "$", object[n2].toString());
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$tableid$", string);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$DriverID$", this.sDriverID);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$DocumentID$", this.sParentDocumentID);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$Widget$", this.sParentWidget);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$ContainerItemID$", this.sContainerItemID);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$library_location$", this.sContainerItemID);
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "$WidgetMetadataID$", this.getMetadataID(this.sDisplayName));
        return stringBuilder.toString();
    }
}

