/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryBuffer;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import resources.TAppDisplaysObject;
import resources.TAppDriversObject;
import resources.TApplication;
import scrollwin.table.TScrollTablePanel;
import utility.TFormulaEvaluator;
import utility.charutil;

public class TDisplaysFile
extends TBinaryBuffer {
    private static String[] arSubtotalTypeDescription = new String[]{"sum", "count", "minimum", "maximum", "average", "stddev"};
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDisplaysFile");
    public TDriverStruct ClientDriverStruct;
    public TAspectDriver ClientDriver;
    private TAppDriversObject FileListObj = null;
    private int[] arSubtotalType;
    private TComboBoxColl SubtotalTypeColl;
    public static TScrollTablePanel ActiveTabelPanel;

    public TDisplaysFile(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) throws IOException {
        super(tApplication, tAppDriversObject, n, bl);
        StringBuilder stringBuilder = new StringBuilder();
        this.setUndoRecording(false);
        this.arSubtotalType = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.arSubtotalType[i] = 0;
        }
        this.Application.getTokenValue(stringBuilder, "Collection_Display_Subtotal_Types");
        this.SubtotalTypeColl = this.Application.AppCollections.getCollection(stringBuilder.toString(), null, null, false, "", "");
        this.Application.getTokenValue(stringBuilder, "$ScrollWinFileID");
        this.FileListObj = this.Application.AppDrivers.getAppDriversObject(stringBuilder);
        this.ClientDriver = TDisplaysFile.ActiveTabelPanel.AspectDriver;
        this.ClientDriverStruct = TDisplaysFile.ActiveTabelPanel.AspectDriver.getDriverStruct();
        if (this.ClientDriverStruct == null) {
            System.out.println("TDisplaysFile.init: ClientDriverStruct=null");
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public int makeEditableFile() throws IOException {
        return 1;
    }

    @Override
    public synchronized Object getFieldForTable(TDriverStructRecord tDriverStructRecord, int n) {
        TDriverStructRecord tDriverStructRecord2;
        Object object = super.getField(tDriverStructRecord, n);
        if ((tDriverStructRecord.FullID.equalsIgnoreCase("Aspect_Displays_Columns_Structure_FieldID") || tDriverStructRecord.FullID.equalsIgnoreCase("Aspect_Displays_Rows_Structure_FieldID") || tDriverStructRecord.FullID.equalsIgnoreCase("Aspect_Displays_Subtotals_Structure_FieldID")) && (tDriverStructRecord2 = this.ClientDriverStruct.getField((String)object)) != null) {
            return tDriverStructRecord2.Description;
        }
        return object;
    }

    public void resetFilters() {
        for (int i = 0; i < this.getRecordCount(); ++i) {
            TAppDisplaysObject tAppDisplaysObject = new TAppDisplaysObject(this, i);
            tAppDisplaysObject.FilterOperator[0] = 0;
            tAppDisplaysObject.FilterOperator[1] = 0;
            tAppDisplaysObject.FilterValue[0] = "";
            tAppDisplaysObject.FilterValue[1] = "";
            tAppDisplaysObject.FilterComparator = 0;
            tAppDisplaysObject.writeToFile(this, i);
        }
    }

    public void resetSubtotals() {
        for (int i = 0; i < this.getRecordCount(); ++i) {
            TAppDisplaysObject tAppDisplaysObject = new TAppDisplaysObject(this, i);
            for (int j = 0; j < 6; ++j) {
                tAppDisplaysObject.Subtotal[j] = false;
                tAppDisplaysObject.SubtotalType[j] = 0;
            }
            tAppDisplaysObject.writeToFile(this, i);
        }
    }

    public void selectAll(boolean bl) {
        for (int i = 0; i < this.getRecordCount(); ++i) {
            TAppDisplaysObject tAppDisplaysObject = new TAppDisplaysObject(this, i);
            tAppDisplaysObject.IsVisible = bl;
            tAppDisplaysObject.writeToFile(this, i);
        }
    }

    public void moveSelectedToTop() {
        boolean bl;
        do {
            bl = true;
            for (int i = 0; bl && i < this.getRecordCount() - 1; ++i) {
                TAppDisplaysObject tAppDisplaysObject = new TAppDisplaysObject(this, i);
                TAppDisplaysObject tAppDisplaysObject2 = new TAppDisplaysObject(this, i + 1);
                if (!tAppDisplaysObject2.IsVisible || tAppDisplaysObject.IsVisible) continue;
                this.swapRecords(i, i + 1);
                bl = false;
            }
        } while (!bl);
    }

    public boolean deleteDisplay(String string) {
        return this.Application.AppDisplays.deleteDisplay(string, this.FileListObj.UnparsedID);
    }

    public void updateTempFileFromBinary(String string, boolean bl) {
        int n;
        TDriverStructRecord tDriverStructRecord;
        TAppDisplaysObject tAppDisplaysObject;
        int n2;
        ArrayList arrayList;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        if (this.Debug) {
            string2 = "null";
            if (string != null) {
                string2 = string;
            }
            this.MainWin.appendToLog("TDisplaysFile", "updateTempFileFromBinary", Thread.currentThread(), null, 10, "Initializing temp display file with: " + string2);
        }
        if (bl && !this.Application.AppDisplays.isPredefineDisplay(string, this.FileListObj.UnparsedID.toString())) {
            JOptionPane.showMessageDialog(null, "There is a custom display that has no default.", "Information...", 1);
        }
        this.f_create();
        if (this.Debug) {
            this.MainWin.appendToLog("TScrollDisplayDialog", "scrollDialogPanelEventOccurred", Thread.currentThread(), null, 10, "Getting display records for display: " + string + " ID: " + this.FileListObj.UnparsedID);
        }
        if ((arrayList = this.Application.AppDisplays.getDisplayRecords(stringBuilder, string, this.FileListObj.UnparsedID, bl)) != null) {
            boolean bl2;
            do {
                bl2 = true;
                for (n2 = 0; bl2 && n2 < arrayList.size(); ++n2) {
                    tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(n2);
                    tDriverStructRecord = this.ClientDriverStruct.getField(tAppDisplaysObject.StructureFieldID);
                    if (tDriverStructRecord != null) continue;
                    arrayList.remove(n2);
                    bl2 = false;
                }
            } while (!bl2);
        }
        if (this.Debug) {
            this.MainWin.appendToLog("TDisplaysFile", "updateTempFileFromBinary", Thread.currentThread(), null, 10, "Writing record to temp file");
        }
        if (arrayList != null) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(n2);
                tAppDisplaysObject.writeToFile(this, n2);
                if (n2 != 0) continue;
                for (n = 0; n < 6; ++n) {
                    this.arSubtotalType[n] = tAppDisplaysObject.SubtotalType[n];
                }
                if (!this.Debug) continue;
                string2 = "Subtotal Types: ";
                for (n = 0; n < 6; ++n) {
                    string2 = string2 + arSubtotalTypeDescription[this.arSubtotalType[n]] + " ";
                }
                this.MainWin.appendToLog("TDisplaysFile", "updateTempFileFromBinary", Thread.currentThread(), null, 10, string2);
            }
        }
        if (this.Debug) {
            this.MainWin.appendToLog("TDisplaysFile", "updateTempFileFromBinary", Thread.currentThread(), null, 10, "Adding records not included in the display");
        }
        for (n2 = 0; n2 < this.ClientDriverStruct.FieldColl.size(); ++n2) {
            tDriverStructRecord = (TDriverStructRecord)this.ClientDriverStruct.FieldColl.get(n2);
            if (!tDriverStructRecord.Visible) continue;
            boolean bl3 = false;
            if (arrayList != null) {
                for (n = 0; !bl3 && n < arrayList.size(); ++n) {
                    tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(n);
                    if (charutil.strcmpi(tAppDisplaysObject.StructureFieldID, tDriverStructRecord.FullID) != 0) continue;
                    bl3 = true;
                }
            } else if (this.Debug) {
                System.out.println(" - not a visible field.");
            }
            if (bl3) continue;
            tAppDisplaysObject = new TAppDisplaysObject(tDriverStructRecord);
            tAppDisplaysObject.Description.append(string);
            tAppDisplaysObject.IsVisible = false;
            tAppDisplaysObject.DriverID.append(this.FileListObj.UnparsedID);
            if (arrayList == null) {
                tAppDisplaysObject.AutoResize = true;
            }
            tAppDisplaysObject.writeToFile(this, this.getRecordCount());
        }
        this.AspectDriver.initializeFilteredList();
    }

    public void recordTempFileToBinary(String string, boolean bl, boolean bl2, String string2) {
        TAppDisplaysObject tAppDisplaysObject;
        int n;
        ArrayList<TAppDisplaysObject> arrayList = new ArrayList<TAppDisplaysObject>();
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < this.getRecordCount(); ++n) {
            tAppDisplaysObject = new TAppDisplaysObject(this, n);
            boolean bl3 = false;
            if (tAppDisplaysObject.IsVisible) {
                bl3 = true;
            }
            if (!bl3) {
                for (int i = 0; i < 4; ++i) {
                    if (!tAppDisplaysObject.Sort[i]) continue;
                    bl3 = true;
                }
            }
            if (!(bl3 || charutil.nullstr(tAppDisplaysObject.FilterValue[0]) && charutil.nullstr(tAppDisplaysObject.FilterValue[1]))) {
                bl3 = true;
            }
            if (!bl3) continue;
            arrayList.add(tAppDisplaysObject);
        }
        if (arrayList.size() == 0) {
            arrayList.add(new TAppDisplaysObject(this, 0));
        }
        tAppDisplaysObject = (TAppDisplaysObject)arrayList.get(0);
        tAppDisplaysObject.AutoResize = bl2;
        tAppDisplaysObject.AdvancedFilter = string2;
        for (n = 0; n < 6; ++n) {
            tAppDisplaysObject.SubtotalType[n] = this.arSubtotalType[n];
        }
        if (this.Debug) {
            this.MainWin.appendToLog("TDisplaysFile", "recordTempFileToBinary", Thread.currentThread(), null, 3, "recordTempFileToBinary(" + string + "," + bl + "," + bl2 + "," + string2 + ")");
        }
        this.Application.AppDisplays.writeDisplayRecords(string, this.FileListObj.UnparsedID, arrayList, bl);
    }

    public String getAdvancedFilter() {
        TAppDisplaysObject tAppDisplaysObject = new TAppDisplaysObject(this, 0);
        return tAppDisplaysObject.AdvancedFilter;
    }

    public boolean getAutoResize() {
        TAppDisplaysObject tAppDisplaysObject = new TAppDisplaysObject(this, 0);
        return tAppDisplaysObject.AutoResize;
    }

    @Override
    public String getFieldDescription(int n, String string) {
        if (n >= 25 && n <= 30) {
            int n2 = n - 25;
            String string2 = (String)this.SubtotalTypeColl.getValueOfKey(Integer.toString(this.arSubtotalType[n2]));
            return string + '\n' + string2;
        }
        return string;
    }

    @Override
    public TComboBoxColl getComboBoxColl(String string, StringBuilder stringBuilder, TFormulaEvaluator tFormulaEvaluator, boolean bl, boolean bl2, int n) {
        String string2 = string;
        if (string2.startsWith("Aspect_Displays_Rows")) {
            string2 = "Aspect_Displays_Columns" + string2.substring(20);
        }
        return super.getComboBoxColl(string2, stringBuilder, tFormulaEvaluator, bl, bl2, n);
    }

    @Override
    public int mouseClickedOnTableHeader(int n, boolean bl, TDriverStruct tDriverStruct) {
        if (n >= 25 && n <= 30) {
            int n2;
            int n3 = n2 = n - 25;
            this.arSubtotalType[n3] = this.arSubtotalType[n3] + 1;
            if (this.arSubtotalType[n2] > this.SubtotalTypeColl.size() - 1) {
                this.arSubtotalType[n2] = 0;
            }
        }
        return 1;
    }
}

