/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TProgressBar;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.aspect.TSubtotalsDriver;
import drivers.consolidated.TConsolidatedVertDriver;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import resources.TAppDisplaysObject;
import resources.TAppDriversObject;
import resources.TAppTablesObject;
import resources.TApplication;
import scrollwin.filtertree.TScrollFilterTree;
import scrollwin.subtotaltree.TScrollSubtotalTree;
import scrollwin.subtotaltree.TScrollSubtotalTreeNode;
import utility.TProfiler;

public class TAspectDriverFilter {
    private static int cDebugCntr = 0;
    private static TProgressBar SortProgressBar = null;
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTAspectDriverFilter");
    private TAspectDriver AspectDriver;
    private TDriverStruct DriverStruct;
    private TApplication Application;
    public TAppDriversObject FileListObj;
    public boolean ApplyFilter;
    public TSubtotalsDriver SubtotalsDriver;
    public TScrollFilterTree FilterTree = null;
    public TScrollSubtotalTree SubtotalTree = null;
    public StringBuilder DisplayName = new StringBuilder();
    public StringBuilder DeleteFilter = null;
    public StringBuilder ActiveFilter = null;
    public ArrayList ColumnList = null;
    public ArrayList FilteredList = new ArrayList();
    public ArrayList arSortDirectives = null;
    public TAppTablesObject ActiveAppTablesObj = null;
    public boolean MaxRecordsMsgDisplayed = false;
    private TProfiler Profiler = null;
    private Hashtable HashForSort = new Hashtable();
    private Hashtable HashForSortNull = new Hashtable();
    private boolean ForceFilterEvaluation = false;
    public boolean isInitializingFilteredList = false;

    public TAspectDriverFilter(TAspectDriver tAspectDriver) {
        TAppDriversObject tAppDriversObject;
        this.AspectDriver = tAspectDriver;
        this.DriverStruct = this.AspectDriver.DriverStruct;
        this.Application = this.AspectDriver.Application;
        this.FileListObj = this.AspectDriver.AppDriverObj;
        this.ApplyFilter = this.AspectDriver.ApplyFilter;
        this.SubtotalsDriver = this.AspectDriver.SubtotalsDriver;
        if (this.ApplyFilter && tAspectDriver.F != null && (tAppDriversObject = tAspectDriver.F.getAppDriversObject()) != null && tAppDriversObject.DeleteMask.toString().trim().length() > 0) {
            this.DeleteFilter = new StringBuilder(tAppDriversObject.DeleteMask.toString());
        }
        this.ActiveFilter = new StringBuilder();
        if (this.AspectDriver.AppDriverObj.DriverID.toString().toUpperCase().indexOf("ACTIVITY") >= 0) {
            this.Profiler = new TProfiler("TAspectDriverFilter");
            this.Profiler.addMark("TAspectDriverFilter initialized - " + this.AspectDriver.AppDriverObj.DriverID.toString());
        }
    }

    public void dispose() {
        this.FilteredList.clear();
        if (this.ColumnList != null) {
            this.ColumnList.clear();
        }
    }

    public void setForceFilterEvaluation(boolean bl) {
        this.ForceFilterEvaluation = bl;
    }

    public int getRecordCount() {
        int n = !this.ApplyFilter ? this.AspectDriver.F.getRecordCount() : this.FilteredList.size();
        return n;
    }

    public int getFieldCount() {
        if (!this.ApplyFilter) {
            return this.DriverStruct.FieldColl.size();
        }
        if (this.ColumnList == null) {
            return this.DriverStruct.FieldColl.size();
        }
        return this.ColumnList.size();
    }

    public void applyDisplay(boolean bl) {
        String[] stringArray = new String[]{"<", "<=", "=", ">", ">=", "<>"};
        String[] stringArray2 = new String[]{"and", "or", "xor", "nor"};
        boolean[] blArray = new boolean[4];
        if (this.AspectDriver.DefaultAppTablesObj == null) {
            return;
        }
        if (this.Debug) {
            this.MainWin.appendToLog("TAspectDriverFilter", "applyDisplay", Thread.currentThread(), null, 10, "Applying display: " + this.DisplayName);
        }
        this.ActiveAppTablesObj = new TAppTablesObject(this.AspectDriver.DefaultAppTablesObj);
        if (this.ApplyFilter) {
            String string;
            int n;
            TAppDisplaysObject tAppDisplaysObject;
            if (this.ColumnList.size() > 0) {
                tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(0);
                this.ActiveAppTablesObj.AutoResize = tAppDisplaysObject.AutoResize;
                this.ActiveAppTablesObj.AdvancedFilter = tAppDisplaysObject.AdvancedFilter;
                this.Application.setTokenValue("$ScrollWinDisplayAdvancedFilter", this.ActiveAppTablesObj.AdvancedFilter);
                this.Application.setTokenValue("$ScrollWinDisplayAutoResize", Boolean.toString(this.ActiveAppTablesObj.AutoResize));
                if (this.AspectDriver.isDisplayOptionsFile()) {
                    this.ActiveAppTablesObj.CanSort = false;
                    this.ActiveAppTablesObj.AutoResize = true;
                }
            }
            if (this.ActiveAppTablesObj.CanSort) {
                if (this.arSortDirectives == null) {
                    this.arSortDirectives = new ArrayList();
                } else {
                    this.arSortDirectives.clear();
                }
                for (n = 0; n < 4; ++n) {
                    blArray[n] = false;
                    for (int i = 0; !blArray[n] && i < this.ColumnList.size(); ++i) {
                        tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(i);
                        if (!tAppDisplaysObject.Sort[n]) continue;
                        int n2 = 1;
                        if (tAppDisplaysObject.SortOrder != 0) {
                            n2 = -1;
                        }
                        this.arSortDirectives.add(new TSortDirective(tAppDisplaysObject.AbsoluteFieldIndex, n2));
                        blArray[n] = true;
                    }
                }
            }
            this.ActiveFilter.setLength(0);
            for (n = 0; n < this.ColumnList.size(); ++n) {
                tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(n);
                if (tAppDisplaysObject.FilterOperator[0] <= 0 || tAppDisplaysObject.FilterOperator[0] - 1 >= stringArray.length) continue;
                if (this.ActiveFilter.length() > 0) {
                    this.ActiveFilter.append(" and ");
                }
                if (tAppDisplaysObject.FilterOperator[1] > 0) {
                    this.ActiveFilter.append("(");
                }
                this.ActiveFilter.append("(");
                TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(tAppDisplaysObject.StructureFieldID.toString());
                string = tDriverStructRecord.IsLookup ? (tDriverStructRecord.AlternateCollection.length() > 0 ? "lookup(" + tDriverStructRecord.AlternateCollection + "," + tDriverStructRecord.FullID + ")" : "lookup(" + tDriverStructRecord.CollectionID + "," + tDriverStructRecord.FullID + ")") : '\"' + tDriverStructRecord.Description + '\"';
                this.ActiveFilter.append(string);
                this.ActiveFilter.append(stringArray[tAppDisplaysObject.FilterOperator[0] - 1]);
                if (tDriverStructRecord.IsLookup || tDriverStructRecord.FieldType == 3 || tDriverStructRecord.FieldType == 24) {
                    this.ActiveFilter.append('\"' + tAppDisplaysObject.FilterValue[0] + '\"');
                } else {
                    this.ActiveFilter.append(tAppDisplaysObject.FilterValue[0]);
                }
                this.ActiveFilter.append(") ");
                if (tAppDisplaysObject.FilterOperator[1] <= 0) continue;
                this.ActiveFilter.append(stringArray2[tAppDisplaysObject.FilterComparator]);
                this.ActiveFilter.append(" (");
                tDriverStructRecord = this.AspectDriver.getDriverStructRecord(tAppDisplaysObject.StructureFieldID.toString());
                string = tDriverStructRecord.IsLookup ? (tDriverStructRecord.AlternateCollection.length() > 0 ? "lookup(" + tDriverStructRecord.AlternateCollection + "," + tDriverStructRecord.FullID + ")" : "lookup(" + tDriverStructRecord.CollectionID + "," + tDriverStructRecord.FullID + ")") : '\"' + tDriverStructRecord.Description + '\"';
                this.ActiveFilter.append(string);
                this.ActiveFilter.append(stringArray[tAppDisplaysObject.FilterOperator[1] - 1]);
                if (tDriverStructRecord.FieldType == 3 || tDriverStructRecord.FieldType == 24 || tDriverStructRecord.FieldType == 26) {
                    this.ActiveFilter.append('\"' + tAppDisplaysObject.FilterValue[1] + '\"');
                } else {
                    this.ActiveFilter.append(tAppDisplaysObject.FilterValue[1]);
                }
                this.ActiveFilter.append(")");
                this.ActiveFilter.append(") ");
            }
            if (this.ColumnList.size() > 0) {
                tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(0);
                string = tAppDisplaysObject.AdvancedFilter.toString().trim();
                if (string.length() > 0 && !string.equals("0")) {
                    if (this.ActiveFilter.length() > 0) {
                        this.ActiveFilter.append(" AND ");
                    }
                    this.ActiveFilter.append("(");
                    this.ActiveFilter.append(tAppDisplaysObject.AdvancedFilter);
                    this.ActiveFilter.append(")");
                }
            }
            if (this.Debug) {
                this.MainWin.appendToLog("TAspectDriverFilter", "applyDisplay", Thread.currentThread(), null, 10, "Active Filter: " + this.ActiveFilter);
            }
            if (this.SubtotalsDriver != null) {
                this.SubtotalsDriver.updateSubtotalTemplates(this.ColumnList);
            }
            if (this.SubtotalTree != null) {
                this.SubtotalTree.initializeTree();
            }
            if (bl) {
                this.initializeFilteredList();
                if (this.FilterTree != null) {
                    this.FilterTree.initializeTree();
                }
            }
        }
    }

    public String[] getDisplayedFields() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.ColumnList.size(); ++i) {
            TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(i);
            arrayList.add(((TDriverStructRecord)this.DriverStruct.FieldColl.get((int)tAppDisplaysObject.AbsoluteFieldIndex)).FullID);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String[] getFilterTreeFields() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (!tDriverStructRecord.IsRootNode) continue;
            while (tDriverStructRecord != null) {
                arrayList.add(tDriverStructRecord.FullID);
                if (tDriverStructRecord.ChildNode.length() > 0) {
                    tDriverStructRecord = this.DriverStruct.getField(tDriverStructRecord.ChildNode);
                    continue;
                }
                tDriverStructRecord = null;
            }
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String[] getSortFields() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.arSortDirectives != null) {
            for (int i = 0; i < this.arSortDirectives.size(); ++i) {
                TSortDirective tSortDirective = (TSortDirective)this.arSortDirectives.get(i);
                arrayList.add(tSortDirective.DSRec.FullID);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String getSortOptions() {
        String string = "";
        if (this.arSortDirectives != null) {
            for (int i = 0; i < this.arSortDirectives.size(); ++i) {
                TSortDirective tSortDirective = (TSortDirective)this.arSortDirectives.get(i);
                if (i > 0) {
                    string = string + "|";
                }
                string = tSortDirective.Direction == 1 ? string + "+" : string + "-";
                string = string + tSortDirective.DSRec.FullID;
            }
        }
        return string;
    }

    public void setSortOptions(String[] stringArray, boolean bl) {
        Object object;
        int n;
        if (this.arSortDirectives == null) {
            this.arSortDirectives = new ArrayList();
        }
        this.arSortDirectives.clear();
        for (n = 0; n < stringArray.length && n < 4; ++n) {
            String string = stringArray[n];
            if (string.equalsIgnoreCase("0") || string.equalsIgnoreCase("+0") || string.equalsIgnoreCase("-0")) continue;
            int n2 = 1;
            if (string.startsWith("+")) {
                string = string.substring(1);
                n2 = 1;
            } else if (string.startsWith("-")) {
                string = string.substring(1);
                n2 = -1;
            }
            TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
            if (tDriverStructRecord != null) {
                this.arSortDirectives.add(new TSortDirective(tDriverStructRecord.AbsoluteIndex, n2));
                continue;
            }
            object = this.AspectDriver.AppDriverObj == null ? "Undefine dAppDriverObj" : this.AspectDriver.AppDriverObj.DriverID.toString();
            this.MainWin.appendToLog("TAspectDriverFilter", "SetSortOptions", Thread.currentThread(), null, 4, "Invalid sort key: " + string + " in driver " + (String)object);
        }
        if (bl) {
            for (n = 0; n < this.arSortDirectives.size(); ++n) {
                object = (TSortDirective)this.arSortDirectives.get(n);
            }
            this.clearFilteredList();
            this.initializeFilteredList();
        }
    }

    public void setDisplayColumns(String[] stringArray) {
        if (this.ColumnList == null) {
            this.ColumnList = new ArrayList();
        }
        this.ColumnList.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(stringArray[i]);
            if (tDriverStructRecord != null) {
                TAppDisplaysObject tAppDisplaysObject = new TAppDisplaysObject(tDriverStructRecord);
                tAppDisplaysObject.AbsoluteFieldIndex = tDriverStructRecord.AbsoluteIndex;
                tAppDisplaysObject.AutoResize = false;
                if (this.FileListObj != null) {
                    tAppDisplaysObject.DriverID.append(this.AspectDriver.AppDriverObj.UnparsedID);
                }
                if (this.AspectDriver.DefaultAppTablesObj != null) {
                    tAppDisplaysObject.CallbackTime = this.AspectDriver.DefaultAppTablesObj.CallbackTime;
                    tAppDisplaysObject.TableRowHeight = this.AspectDriver.DefaultAppTablesObj.TableRowHeight;
                    tAppDisplaysObject.WindowX = this.AspectDriver.DefaultAppTablesObj.WindowX;
                    tAppDisplaysObject.WindowY = this.AspectDriver.DefaultAppTablesObj.WindowY;
                    tAppDisplaysObject.WindowW = this.AspectDriver.DefaultAppTablesObj.WindowW;
                    tAppDisplaysObject.WindowH = this.AspectDriver.DefaultAppTablesObj.WindowH;
                    tAppDisplaysObject.CanMaximize = this.AspectDriver.DefaultAppTablesObj.CanMaximize;
                    tAppDisplaysObject.CanResize = this.AspectDriver.DefaultAppTablesObj.CanResize;
                    tAppDisplaysObject.MaximizeOnOpen = this.AspectDriver.DefaultAppTablesObj.MaximizeOnOpen;
                }
                this.ColumnList.add(tAppDisplaysObject);
                continue;
            }
            this.MainWin.appendToLog("TAspectDriverFilter", "setDisplayColumns", Thread.currentThread(), null, 4, "Unrecognized field ID: " + stringArray[i] + " while setting display columns.in driver " + this.AspectDriver.getDriverID());
        }
    }

    public void initializeDisplayFromStructure() {
        if (this.ColumnList == null) {
            this.ColumnList = new ArrayList();
        }
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (this.ApplyFilter && !tDriverStructRecord.Visible) continue;
            TAppDisplaysObject tAppDisplaysObject = new TAppDisplaysObject(tDriverStructRecord);
            tAppDisplaysObject.AbsoluteFieldIndex = i;
            tAppDisplaysObject.AutoResize = false;
            if (this.FileListObj != null) {
                tAppDisplaysObject.DriverID.append(this.AspectDriver.AppDriverObj.UnparsedID);
            }
            if (this.AspectDriver.DefaultAppTablesObj != null) {
                tAppDisplaysObject.CallbackTime = this.AspectDriver.DefaultAppTablesObj.CallbackTime;
                tAppDisplaysObject.TableRowHeight = this.AspectDriver.DefaultAppTablesObj.TableRowHeight;
                tAppDisplaysObject.WindowX = this.AspectDriver.DefaultAppTablesObj.WindowX;
                tAppDisplaysObject.WindowY = this.AspectDriver.DefaultAppTablesObj.WindowY;
                tAppDisplaysObject.WindowW = this.AspectDriver.DefaultAppTablesObj.WindowW;
                tAppDisplaysObject.WindowH = this.AspectDriver.DefaultAppTablesObj.WindowH;
                tAppDisplaysObject.CanMaximize = this.AspectDriver.DefaultAppTablesObj.CanMaximize;
                tAppDisplaysObject.CanResize = this.AspectDriver.DefaultAppTablesObj.CanResize;
                tAppDisplaysObject.MaximizeOnOpen = this.AspectDriver.DefaultAppTablesObj.MaximizeOnOpen;
            }
            this.ColumnList.add(tAppDisplaysObject);
        }
    }

    public void setActiveFilter(String string, boolean bl) {
        this.ActiveFilter.setLength(0);
        this.ActiveFilter.append(string);
        if (bl) {
            this.clearFilteredList();
            this.initializeFilteredList();
        }
    }

    public ArrayList getFilteredList() {
        return this.FilteredList;
    }

    public void setFilteredList(ArrayList arrayList) {
        this.clearFilteredList();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.FilteredList.add(arrayList.get(i));
            }
        }
    }

    public void applySortAndFilter() {
        this.ApplyFilter = true;
        if (this.Profiler != null) {
            this.Profiler.addMark("applySortAndFilter - clearFilteredList");
        }
        this.clearFilteredList();
        if (this.Profiler != null) {
            this.Profiler.addMark("applySortAndFilter - initializeFilteredList");
        }
        this.initializeFilteredList();
        if (this.Profiler != null) {
            this.Profiler.addMark("applySortAndFilter - initializeTree");
        }
        if (this.FilterTree != null) {
            Date date = new Date();
            this.FilterTree.initializeTree();
        }
        if (this.Profiler != null) {
            this.Profiler.addMark("applySortAndFilter - complete");
        }
    }

    public String getActiveFilter() {
        return this.ActiveFilter.toString();
    }

    public void loadDisplay(String string, boolean bl) {
        if (this.AspectDriver.AppDriverObj != null && this.AspectDriver.AppDriverObj.DriverID.toString().equalsIgnoreCase("ExecScriptDriver")) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.ApplyFilter) {
            this.initializeDisplayFromStructure();
            this.DisplayName.setLength(0);
            this.DisplayName.append("Default Display");
        } else {
            if (this.AspectDriver.AppDriverObj != null) {
                this.ColumnList = this.Application.AppDisplays.getDisplayRecords(this.DisplayName, string, this.AspectDriver.AppDriverObj.UnparsedID, false);
            }
            if (this.ColumnList == null || this.ColumnList.size() == 0) {
                this.initializeDisplayFromStructure();
                this.DisplayName.setLength(0);
                this.DisplayName.append("Default Display");
                if (this.AspectDriver.AppDriverObj != null) {
                    this.Application.AppDisplays.writeDisplayRecords(this.DisplayName.toString(), this.AspectDriver.AppDriverObj.UnparsedID, this.ColumnList, true);
                }
            } else {
                int n = 0;
                while (n < this.ColumnList.size()) {
                    TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(n);
                    if (this.DriverStruct == null) continue;
                    TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(tAppDisplaysObject.StructureFieldID);
                    if (tDriverStructRecord == null) {
                        this.ColumnList.remove(n);
                        continue;
                    }
                    tAppDisplaysObject.AbsoluteFieldIndex = tDriverStructRecord.AbsoluteIndex;
                    ++n;
                }
            }
        }
        this.applyDisplay(bl);
    }

    public void updateColumnOrderFromTable(TableColumnModel tableColumnModel) {
        int n;
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            arrayList.add(this.ColumnList.get(tableColumn.getModelIndex()));
        }
        for (n = 0; n < this.ColumnList.size(); ++n) {
            if (arrayList.contains(this.ColumnList.get(n))) continue;
            arrayList.add(this.ColumnList.get(n));
        }
        this.ColumnList = arrayList;
    }

    public void updateSortOptionsFromTable() {
        if (this.arSortDirectives == null || this.ColumnList == null) {
            return;
        }
        for (int i = 0; i < this.ColumnList.size(); ++i) {
            int n;
            TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(i);
            tAppDisplaysObject.SortOrder = 0;
            for (n = 0; n < 4; ++n) {
                tAppDisplaysObject.Sort[n] = false;
            }
            for (n = 0; n < 4 && n < this.arSortDirectives.size(); ++n) {
                TSortDirective tSortDirective = (TSortDirective)this.arSortDirectives.get(n);
                if (!tSortDirective.DSRec.FullID.equalsIgnoreCase(tAppDisplaysObject.StructureFieldID.toString())) continue;
                tAppDisplaysObject.Sort[n] = true;
                tAppDisplaysObject.SortOrder = 0;
                if (tSortDirective.Direction >= 0) continue;
                tAppDisplaysObject.SortOrder = 1;
            }
        }
    }

    public void updateSubtotalSelectionsFromTable() {
        TAppDisplaysObject tAppDisplaysObject;
        int n;
        if (this.SubtotalsDriver == null) {
            return;
        }
        if (this.SubtotalTree == null) {
            return;
        }
        for (n = 0; n < this.ColumnList.size(); ++n) {
            tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(n);
            tAppDisplaysObject.ShowDetails = false;
            tAppDisplaysObject.ShowDisplayedSum = false;
            tAppDisplaysObject.ShowDisplayedCount = false;
            tAppDisplaysObject.ShowDisplayedMinimum = false;
            tAppDisplaysObject.ShowDisplayedMaximum = false;
            tAppDisplaysObject.ShowDisplayedAverage = false;
            tAppDisplaysObject.ShowDisplayedStdDev = false;
            tAppDisplaysObject.ShowDisplayedUnused1 = false;
            tAppDisplaysObject.ShowDisplayedUnused2 = false;
            tAppDisplaysObject.ShowDisplayedUnused3 = false;
            tAppDisplaysObject.ShowDisplayedUnused4 = false;
            tAppDisplaysObject.ShowGrandSum = false;
            tAppDisplaysObject.ShowGrandCount = false;
            tAppDisplaysObject.ShowGrandMinimum = false;
            tAppDisplaysObject.ShowGrandMaximum = false;
            tAppDisplaysObject.ShowGrandAverage = false;
            tAppDisplaysObject.ShowGrandStdDev = false;
            tAppDisplaysObject.ShowGrandUnused1 = false;
            tAppDisplaysObject.ShowGrandUnused2 = false;
            tAppDisplaysObject.ShowGrandUnused3 = false;
            tAppDisplaysObject.ShowGrandUnused4 = false;
        }
        if (this.ColumnList.size() < 1) {
            return;
        }
        tAppDisplaysObject = (TAppDisplaysObject)this.ColumnList.get(0);
        for (n = 0; n < this.SubtotalTree.TopNode.getChildCount(); ++n) {
            TScrollSubtotalTreeNode tScrollSubtotalTreeNode = (TScrollSubtotalTreeNode)this.SubtotalTree.TopNode.getChildAt(n);
            if (tScrollSubtotalTreeNode.GroupType == 0) {
                if (!tScrollSubtotalTreeNode.isSelected()) continue;
                tAppDisplaysObject.ShowDetails = true;
                continue;
            }
            if (tScrollSubtotalTreeNode.GroupType != 1 && tScrollSubtotalTreeNode.GroupType != 2) continue;
            block18: for (int i = 0; i < tScrollSubtotalTreeNode.getChildCount(); ++i) {
                TScrollSubtotalTreeNode tScrollSubtotalTreeNode2 = (TScrollSubtotalTreeNode)tScrollSubtotalTreeNode.getChildAt(i);
                if (!tScrollSubtotalTreeNode2.isSelected()) continue;
                if (tScrollSubtotalTreeNode.GroupType == 1) {
                    switch (i) {
                        case 0: {
                            tAppDisplaysObject.ShowGrandSum = true;
                            break;
                        }
                        case 1: {
                            tAppDisplaysObject.ShowGrandCount = true;
                            break;
                        }
                        case 2: {
                            tAppDisplaysObject.ShowGrandMinimum = true;
                            break;
                        }
                        case 3: {
                            tAppDisplaysObject.ShowGrandMaximum = true;
                            break;
                        }
                        case 4: {
                            tAppDisplaysObject.ShowGrandAverage = true;
                            break;
                        }
                        case 5: {
                            tAppDisplaysObject.ShowGrandStdDev = true;
                        }
                    }
                    continue;
                }
                switch (i) {
                    case 0: {
                        tAppDisplaysObject.ShowDisplayedSum = true;
                        continue block18;
                    }
                    case 1: {
                        tAppDisplaysObject.ShowDisplayedCount = true;
                        continue block18;
                    }
                    case 2: {
                        tAppDisplaysObject.ShowDisplayedMinimum = true;
                        continue block18;
                    }
                    case 3: {
                        tAppDisplaysObject.ShowDisplayedMaximum = true;
                        continue block18;
                    }
                    case 4: {
                        tAppDisplaysObject.ShowDisplayedAverage = true;
                        continue block18;
                    }
                    case 5: {
                        tAppDisplaysObject.ShowDisplayedStdDev = true;
                    }
                }
            }
        }
    }

    public void saveCurrentDisplay(boolean bl) {
        this.Application.AppDisplays.writeDisplayRecords(this.DisplayName.toString(), this.AspectDriver.AppDriverObj.UnparsedID, this.ColumnList, bl);
    }

    public int getAbsoluteDiskIndex(int n) {
        int n2 = -1;
        n2 = !this.ApplyFilter ? n : (n < this.FilteredList.size() ? ((TAspectDriverObj)this.FilteredList.get((int)n)).AbsoluteDiskIndex : n);
        return n2;
    }

    public int getAbsoluteFieldIndex(int n) {
        int n2 = n;
        int n3 = -1;
        if (this.ApplyFilter) {
            for (int i = 0; i < this.ColumnList.size(); ++i) {
                if (!((TAppDisplaysObject)this.ColumnList.get((int)i)).IsVisible || ++n3 != n) continue;
                return ((TAppDisplaysObject)this.ColumnList.get((int)i)).AbsoluteFieldIndex;
            }
        }
        return n2;
    }

    public synchronized void removeFromFilteredList(int n) {
        int n2 = 0;
        while (n2 < this.FilteredList.size()) {
            TAspectDriverObj tAspectDriverObj = (TAspectDriverObj)this.FilteredList.get(n2);
            if (tAspectDriverObj.RecordType == n) {
                this.FilteredList.remove(n2);
                continue;
            }
            ++n2;
        }
    }

    public synchronized void addDetailsToFilteredList() {
        boolean bl;
        long l = new Date().getTime();
        int n = this.AspectDriver.F.getRecordCount();
        int n2 = this.AspectDriver.F.getMaxRecords();
        this.removeFromFilteredList(0);
        boolean bl2 = bl = this.ActiveFilter.length() == 0 || this.ActiveFilter.toString().equalsIgnoreCase("true") || this.ActiveFilter.toString().equalsIgnoreCase("(true)");
        if (bl) {
            if (this.AspectDriver.AppDriverObj.BaseFilter.trim().length() > 0) {
                bl = false;
            }
            if (this.AspectDriver.F instanceof TConsolidatedVertDriver) {
                bl = false;
            }
        }
        for (int i = 0; (n2 == 0 || i < n2) && i < n; ++i) {
            if (!(this.FilterTree != null && !this.FilterTree.isInTree(this.FilterTree.TopNode, i) || (this.DeleteFilter != null || this.AspectDriver.F instanceof TConsolidatedVertDriver) && this.AspectDriver.isAbsoluteIndexDeleted(i) || !bl && !this.AspectDriver.isInFilterAbsolute(i, this.ActiveFilter))) {
                TAspectDriverObj tAspectDriverObj = new TAspectDriverObj(0, i);
                if (this.FileListObj == null) {
                    this.FilteredList.add(tAspectDriverObj);
                } else {
                    int n3 = Collections.binarySearch(this.FilteredList, tAspectDriverObj);
                    this.FilteredList.add(Math.abs(n3 + 1), tAspectDriverObj);
                }
            }
            if (n2 <= 0 || i != n2 - 1 || i >= n - 1 || this.MaxRecordsMsgDisplayed) continue;
            this.MaxRecordsMsgDisplayed = true;
            this.AspectDriver.showMaxRecordsReachedMessage();
        }
        this.HashForSort.clear();
        this.HashForSortNull.clear();
    }

    public synchronized void addSubtotalsToFilteredList() {
        if (this.SubtotalsDriver == null) {
            return;
        }
        if (this.SubtotalTree == null) {
            return;
        }
        int n = this.AspectDriver.F.getRecordCount();
        int n2 = this.SubtotalsDriver.getRecordCount();
        if (this.Debug) {
            this.MainWin.appendToLog("TAspectDriverFilter", "addSubtotalsToFilteredList", Thread.currentThread(), null, 3, "Adding subtotals to table...");
        }
        this.removeFromFilteredList(1);
        for (int i = 0; i < n2; ++i) {
            if (this.SubtotalTree == null || !this.SubtotalTree.isInTree(i)) continue;
            boolean bl = false;
            if (this.SubtotalTree != null && this.SubtotalTree.isVisibleFilteredTotal(i)) {
                bl = true;
            } else if (this.FilterTree == null || this.FilterTree.isInTree(this.FilterTree.TopNode, i + n)) {
                bl = true;
            }
            if (!bl) continue;
            TAspectDriverObj tAspectDriverObj = new TAspectDriverObj(1, n + i);
            if (this.FileListObj == null) {
                this.FilteredList.add(tAspectDriverObj);
                continue;
            }
            int n3 = Collections.binarySearch(this.FilteredList, tAspectDriverObj);
            this.FilteredList.add(Math.abs(n3 + 1), tAspectDriverObj);
        }
    }

    public synchronized void clearFilteredList() {
        this.FilteredList.clear();
    }

    public synchronized boolean initializeFilteredList() {
        if (!this.ApplyFilter) {
            return true;
        }
        if (this.isInitializingFilteredList) {
            return false;
        }
        this.isInitializingFilteredList = true;
        if (this.Profiler != null) {
            this.Profiler.addMark("initializeFilteredList - started");
        }
        Cursor cursor = this.MainWin.setWaitCursor(this.MainWin, null);
        this.clearFilteredList();
        if (this.Debug) {
            this.MainWin.appendToLog("TAspectDriverFilter", "applyDisplay", Thread.currentThread(), null, 10, "initializeFilteredList: Active Filter: " + this.ActiveFilter);
        }
        this.addDetailsToFilteredList();
        if (this.Profiler != null) {
            this.Profiler.addMark("initializeFilteredList - addDetailsToFilteredList complete");
        }
        if (this.Profiler != null) {
            this.Profiler.addMark("initializeFilteredList - calculateSubtotals started");
        }
        if (this.SubtotalsDriver != null) {
            this.SubtotalsDriver.calculateSubtotals();
        }
        if (this.Profiler != null) {
            this.Profiler.addMark("initializeFilteredList - calculateSubtotals complete");
        }
        if (this.SubtotalTree != null && !this.SubtotalTree.showDetails()) {
            this.FilteredList.clear();
        }
        if (this.SubtotalTree != null) {
            this.addSubtotalsToFilteredList();
        }
        if (this.Profiler != null) {
            this.Profiler.addMark("initializeFilteredList - addSubtotalsToFilteredList complete");
        }
        this.AspectDriver.clearBuffer();
        this.MainWin.setWaitCursor(this.MainWin, cursor);
        this.isInitializingFilteredList = false;
        return true;
    }

    public synchronized int addToFilterList(int n) {
        if (this.FilteredList == null) {
            this.FilteredList = new ArrayList(1);
        }
        TAspectDriverObj tAspectDriverObj = new TAspectDriverObj(0, n);
        int n2 = Collections.binarySearch(this.FilteredList, tAspectDriverObj);
        this.FilteredList.add(Math.abs(n2 + 1), tAspectDriverObj);
        return Math.abs(n2 + 1);
    }

    public synchronized int addToFilterList(int n, int n2) {
        int n3;
        if (this.FilteredList == null) {
            this.FilteredList = new ArrayList(1);
        }
        if (n2 >= 0 && n2 <= this.FilteredList.size()) {
            n3 = n2;
            this.FilteredList.add(n3, new TAspectDriverObj(0, n));
        } else {
            n3 = this.FilteredList.size();
            this.FilteredList.add(new TAspectDriverObj(0, n));
        }
        return n3;
    }

    public synchronized int removeFromFilterList(int n) {
        if (this.FilteredList == null) {
            return -1;
        }
        int n2 = this.getFilteredIndex(n);
        if (n2 >= 0 && n2 < this.FilteredList.size()) {
            this.FilteredList.remove(n2);
            return n2;
        }
        return -1;
    }

    public synchronized int getFilteredIndex(int n) {
        int n2 = -1;
        if (!this.ApplyFilter) {
            return n;
        }
        for (int i = 0; n2 < 0 && i < this.FilteredList.size(); ++i) {
            if (((TAspectDriverObj)this.FilteredList.get((int)i)).AbsoluteDiskIndex != n) continue;
            n2 = i;
        }
        return n2;
    }

    public int getSortDirection(int n) {
        int n2 = this.getAbsoluteFieldIndex(n);
        if (this.arSortDirectives != null) {
            for (int i = 0; i < this.arSortDirectives.size(); ++i) {
                TSortDirective tSortDirective = (TSortDirective)this.arSortDirectives.get(i);
                if (tSortDirective.FieldIndex != n2) continue;
                return tSortDirective.Direction;
            }
        }
        return 0;
    }

    public void addSortOption(int n, boolean bl) {
        TSortDirective tSortDirective;
        if (!this.ActiveAppTablesObj.CanSort) {
            return;
        }
        if (this.arSortDirectives == null) {
            this.arSortDirectives = new ArrayList();
        }
        int n2 = this.getAbsoluteFieldIndex(n);
        if (bl && this.arSortDirectives.size() > 0) {
            tSortDirective = (TSortDirective)this.arSortDirectives.get(0);
            if (tSortDirective.FieldIndex == n2) {
                if (tSortDirective.Direction == 1) {
                    tSortDirective.Direction = -1;
                } else {
                    this.arSortDirectives.clear();
                }
                this.sortList();
                return;
            }
            this.arSortDirectives.clear();
        }
        for (int i = 0; i < this.arSortDirectives.size(); ++i) {
            tSortDirective = (TSortDirective)this.arSortDirectives.get(i);
            if (tSortDirective.FieldIndex != n2) continue;
            if (tSortDirective.Direction == 1) {
                tSortDirective.Direction = -1;
            } else {
                this.arSortDirectives.remove(i);
            }
            this.sortList();
            return;
        }
        this.arSortDirectives.add(new TSortDirective(n2));
        this.sortList();
    }

    public void sortList() {
        if (this.ApplyFilter) {
            Collections.sort(this.FilteredList);
        }
    }

    public class TSortDirective {
        TDriverStructRecord DSRec;
        int FieldIndex;
        int Direction;
        boolean IsString;

        public TSortDirective(int n) {
            this.FieldIndex = n;
            this.Direction = 1;
            this.DSRec = (TDriverStructRecord)((TAspectDriverFilter)TAspectDriverFilter.this).DriverStruct.FieldColl.get(this.FieldIndex);
            this.IsString = TAbstractDriver.isString(this.DSRec.FieldType);
        }

        public TSortDirective(int n, int n2) {
            this.FieldIndex = n;
            this.Direction = n2;
            if (this.FieldIndex >= ((TAspectDriverFilter)TAspectDriverFilter.this).DriverStruct.FieldColl.size()) {
                System.out.println("TAspectDriverFilter TSortDirective FieldColl size=" + ((TAspectDriverFilter)TAspectDriverFilter.this).DriverStruct.FieldColl.size() + " FieldIndex=" + this.FieldIndex);
                System.out.println("TAspectDriverFilter TSortDirective setting FieldIndex to 0");
                new Throwable().printStackTrace();
                this.FieldIndex = 0;
            }
            this.DSRec = (TDriverStructRecord)((TAspectDriverFilter)TAspectDriverFilter.this).DriverStruct.FieldColl.get(this.FieldIndex);
            this.IsString = TAbstractDriver.isString(this.DSRec.FieldType);
        }
    }

    public class TAspectDriverObj
    implements Comparable {
        int RecordType;
        int AbsoluteDiskIndex;

        public TAspectDriverObj(int n, int n2) {
            this.RecordType = n;
            this.AbsoluteDiskIndex = n2;
        }

        public int compareTo(Object object) {
            boolean bl = false;
            if (bl) {
                System.out.println("----------------------------------------------------------------");
            }
            if (TAspectDriverFilter.this.AspectDriver.isGrandTotalAbsolute(this.AbsoluteDiskIndex)) {
                if (!TAspectDriverFilter.this.AspectDriver.isGrandTotalAbsolute(((TAspectDriverObj)object).AbsoluteDiskIndex)) {
                    return 1;
                }
            } else if (TAspectDriverFilter.this.AspectDriver.isGrandTotalAbsolute(((TAspectDriverObj)object).AbsoluteDiskIndex)) {
                return -1;
            }
            int n = 0;
            String string = "";
            if (TAspectDriverFilter.this.arSortDirectives != null) {
                for (int i = 0; n == 0 && i < TAspectDriverFilter.this.arSortDirectives.size(); ++i) {
                    boolean bl2;
                    boolean bl3;
                    Object object2;
                    Object object3;
                    int n2 = n;
                    TSortDirective tSortDirective = (TSortDirective)TAspectDriverFilter.this.arSortDirectives.get(i);
                    String string2 = tSortDirective.DSRec + Long.toString(this.AbsoluteDiskIndex);
                    if (TAspectDriverFilter.this.HashForSort.containsKey(string2)) {
                        object3 = TAspectDriverFilter.this.HashForSort.get(string2);
                    } else if (TAspectDriverFilter.this.HashForSortNull.containsKey(string2)) {
                        object3 = null;
                    } else {
                        object3 = TAspectDriverFilter.this.AspectDriver.getFieldAbsolute(tSortDirective.DSRec, this.AbsoluteDiskIndex);
                        if (object3 != null) {
                            TAspectDriverFilter.this.HashForSort.put(string2, object3);
                        } else {
                            TAspectDriverFilter.this.HashForSortNull.put(string2, "");
                        }
                    }
                    String string3 = tSortDirective.DSRec + Long.toString(((TAspectDriverObj)object).AbsoluteDiskIndex);
                    if (TAspectDriverFilter.this.HashForSort.containsKey(string3)) {
                        object2 = TAspectDriverFilter.this.HashForSort.get(string3);
                    } else if (TAspectDriverFilter.this.HashForSortNull.containsKey(string3)) {
                        object2 = null;
                    } else {
                        object2 = TAspectDriverFilter.this.AspectDriver.getFieldAbsolute(tSortDirective.DSRec, ((TAspectDriverObj)object).AbsoluteDiskIndex);
                        if (object2 != null) {
                            TAspectDriverFilter.this.HashForSort.put(string3, object2);
                        } else {
                            TAspectDriverFilter.this.HashForSortNull.put(string3, "");
                        }
                    }
                    int n3 = TAspectDriverFilter.this.AspectDriver.getSubtotalLevelAbsolute(this.AbsoluteDiskIndex);
                    int n4 = TAspectDriverFilter.this.AspectDriver.getSubtotalLevelAbsolute(((TAspectDriverObj)object).AbsoluteDiskIndex);
                    if (bl) {
                        System.out.print(string + "SortDirective=" + i + " Int1=" + n);
                        if (object3 == null) {
                            System.out.print(" Obj1=null");
                        } else {
                            System.out.print(" Obj1=" + object3.toString());
                        }
                        if (object2 == null) {
                            System.out.print(" Obj2=null");
                        } else {
                            System.out.print(" Obj2=" + object2.toString());
                        }
                        System.out.println(" level1=" + n3 + " level2=" + n4);
                    }
                    if (object3 == null && object2 != null) {
                        n = 1;
                    } else if (object2 == null && object3 != null) {
                        n = -1;
                    } else if (i == TAspectDriverFilter.this.arSortDirectives.size() - 1 && object3 == null && object2 == null) {
                        n = 1;
                        if (this.AbsoluteDiskIndex < ((TAspectDriverObj)object).AbsoluteDiskIndex) {
                            n = -1;
                        }
                        if (bl) {
                            System.out.println(string + "both are null.  Int1=" + n);
                        }
                        return n;
                    }
                    if (n == 0) {
                        if (tSortDirective.IsString) {
                            if (object3 instanceof String && object2 instanceof String) {
                                n = ((String)object3).compareToIgnoreCase((String)object2);
                            } else {
                                String string4 = object3 == null ? "" : object3.toString();
                                String string5 = object2 == null ? "" : object2.toString();
                                n = string4.compareToIgnoreCase(string5);
                                if (bl) {
                                    if (object3 == null) {
                                        System.out.println(string + "Obj1 is null");
                                    }
                                    if (object2 == null) {
                                        System.out.println(string + "Obj2 is null");
                                    }
                                }
                            }
                        } else if (object3 instanceof Boolean) {
                            bl3 = (Boolean)object3;
                            bl2 = (Boolean)object2;
                            if (bl3 && !bl2) {
                                n = -1;
                            } else if (!bl3 && bl2) {
                                n = 1;
                            }
                        } else {
                            try {
                                n = ((Comparable)object3).compareTo((Comparable)object2);
                            }
                            catch (Exception exception) {
                                String string6 = "Error in compare: Comparing ";
                                string6 = object3 == null ? string6 + "Obj1=null" : string6 + "Obj1=" + object3.getClass().getName();
                                string6 = string6 + " with ";
                                string6 = object2 == null ? string6 + "Obj2=null" : string6 + "Obj2=" + object2.getClass().getName();
                                string6 = string6 + " in driver " + ((TAspectDriverFilter)TAspectDriverFilter.this).AspectDriver.AppDriverObj.DriverID + " " + exception.toString();
                                TAspectDriverFilter.this.MainWin.appendToLog("TAspectDriverFilter", "applyDisplay", Thread.currentThread(), null, 4, string6);
                                n = 0;
                            }
                        }
                    }
                    if (bl) {
                        System.out.println(" Int1=" + n + " after sort by data type");
                    }
                    if (n != 0) {
                        if (n3 < 0 && n4 < 0) {
                            n *= tSortDirective.Direction;
                            if (bl) {
                                System.out.println(string + "Int1=" + n + " after set sort direction[1]");
                            }
                        } else if (n3 == n4) {
                            n *= tSortDirective.Direction;
                            if (bl) {
                                System.out.println(string + "Int1=" + n + " after set sort direction[2]");
                            }
                        } else if (n3 < 0 && n4 >= 0) {
                            n *= tSortDirective.Direction;
                            if (bl) {
                                System.out.println(string + "Int1=" + n + " after set sort direction[3]");
                            }
                        } else if (n3 >= 0 && n4 < 0) {
                            if (bl) {
                                System.out.println(string + "Int1=" + n + " after set sort direction[4]");
                            }
                        } else if (n3 >= 0 && n4 >= 0 && n3 > n4 && object3 != null) {
                            n *= tSortDirective.Direction;
                            if (bl) {
                                System.out.println(string + "Int1=" + n + " after set sort direction[5]");
                            }
                        }
                    }
                    bl3 = false;
                    bl2 = false;
                    if (object3 != null) {
                        if (object3 instanceof Date) {
                            if (((Date)object3).getTime() <= 0L) {
                                bl3 = true;
                            }
                            if (bl) {
                                System.out.println(string + "t1=" + ((Date)object3).getTime() + " IsEmptyField1=" + bl3);
                            }
                        } else if (object3.toString().length() == 0) {
                            bl3 = true;
                        }
                    }
                    if (object2 != null) {
                        if (object2 instanceof Date) {
                            if (((Date)object2).getTime() <= 0L) {
                                bl2 = true;
                            }
                            if (bl) {
                                System.out.println(string + "t2=" + ((Date)object2).getTime() + " IsEmptyField2=" + bl2);
                            }
                        } else if (object2.toString().length() == 0) {
                            bl2 = true;
                        }
                    }
                    if (object3 != null && bl3) {
                        if (n3 > n4) {
                            n = 1;
                        }
                        if (bl) {
                            System.out.println(string + "Int1=" + n + " after emptyfield1");
                        }
                    } else if (object2 != null && bl2) {
                        if (n4 > n3) {
                            n = -1;
                        }
                        if (bl) {
                            System.out.println(string + "Int1=" + n + " after emptyfield2");
                        }
                    }
                    if (n == 0 && i == TAspectDriverFilter.this.arSortDirectives.size() - 1) {
                        boolean bl4;
                        boolean bl5 = this.AbsoluteDiskIndex >= ((TAspectDriverFilter)TAspectDriverFilter.this).AspectDriver.F.getRecordCount();
                        boolean bl6 = bl4 = ((TAspectDriverObj)object).AbsoluteDiskIndex >= ((TAspectDriverFilter)TAspectDriverFilter.this).AspectDriver.F.getRecordCount();
                        if (bl5 && !bl4) {
                            n = 1;
                            if (bl) {
                                System.out.println(string + "Int1=" + n + " after adjust for subtotal[1]");
                            }
                        } else if (!bl5 && bl4) {
                            n = -1;
                            if (bl) {
                                System.out.println(string + "Int1=" + n + " after adjust for subtotal[2]");
                            }
                        } else if (bl5 && bl4) {
                            int n5;
                            int n6 = TAspectDriverFilter.this.AspectDriver.getSubtotalLevelAbsolute(this.AbsoluteDiskIndex);
                            if (n6 < (n5 = TAspectDriverFilter.this.AspectDriver.getSubtotalLevelAbsolute(((TAspectDriverObj)object).AbsoluteDiskIndex))) {
                                n = -1;
                                if (bl) {
                                    System.out.println(string + "Int1=" + n + " after adjust for subtotal[3]");
                                }
                            } else if (n6 > n5) {
                                n = 1;
                                if (bl) {
                                    System.out.println(string + "Int1=" + n + " after adjust for subtotal[4]");
                                }
                            }
                        }
                    }
                    string = string + "\t";
                }
            }
            if (n == 0) {
                n = this.AbsoluteDiskIndex < ((TAspectDriverObj)object).AbsoluteDiskIndex ? -1 : 1;
                if (bl) {
                    System.out.println(string + " Int1d=" + n);
                }
            }
            if (bl) {
                System.out.println(string + " Final Int1=" + n);
            }
            return n;
        }
    }
}

