/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TExecDialog;
import aspect.TMainWin;
import cache.TCacheDriver;
import cache.TDataCollection;
import collections.TComboBoxColl;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAsciiFileReader;
import drivers.aspect.TAspectDriverFilter;
import drivers.aspect.TDimensionalDriver;
import drivers.aspect.TDisplaysFile;
import drivers.aspect.TDriverDisplay;
import drivers.aspect.TDriverInspect;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.aspect.TEditDialogsDriver;
import drivers.aspect.TEditStructuresDriver;
import drivers.aspect.TFilespecDriver;
import drivers.aspect.TPackageDriver;
import drivers.aspect.TPivotTableDriver;
import drivers.aspect.TSocketDriver;
import drivers.aspect.TSubtotalsDriver;
import drivers.aspect.TTokenDriver;
import drivers.aspect.TTransposeDriver;
import drivers.consolidated.TConsolidatedHorzDriver;
import drivers.consolidated.TConsolidatedVertDriver;
import drivers.consolidated.TMashupDriver;
import drivers.external_data.TExternalDataDriver;
import drivers.files.TAsciiCsvFile;
import drivers.files.TAspectFile;
import drivers.files.TAspectFileBuffer;
import drivers.files.TBinaryBuffer;
import drivers.files.TBinaryFile;
import drivers.files.TBinaryFileBuffer;
import drivers.files.TDbaseDriver;
import drivers.files.TFixedWidthFile;
import drivers.files.TUnformattedText;
import drivers.other.THtmlDocumentDriver;
import drivers.other.TLiveData;
import drivers.other.TOdbcDatabase;
import drivers.other.TParagonDriver;
import drivers.other.TSocketConnectionTest;
import drivers.other.TSystemPropertiesDriver;
import drivers.serial.TSerialPort;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import resources.TAppActionObject;
import resources.TAppDisplaysObject;
import resources.TAppDriversObject;
import resources.TAppTablesObject;
import resources.TApplication;
import scripts.TExecScript;
import scrollwin.filtertree.TScrollFilterTree;
import scrollwin.subtotaltree.TScrollSubtotalTree;
import scrollwin.table.TScrollTable;
import utility.TDriverDependency;
import utility.TDriverDependencyQueue;
import utility.TFile;
import utility.TFormulaEvaluator;
import utility.THtmlTag;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.objectutil;
import utility.security.TPasswordService;
import utility.statistics;

public class TAspectDriver {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTAspectDriver");
    public TApplication Application;
    public TDriverStruct DriverStruct;
    public TAspectDriverFilter AspectDriverFilter = null;
    public TAppDriversObject AppDriverObj = null;
    public StringBuilder FileName = new StringBuilder();
    public TDriverInterface F = null;
    public TSubtotalsDriver SubtotalsDriver = null;
    public TAppTablesObject DefaultAppTablesObj = null;
    private TDriverStructRecord DSRecLastModified = null;
    private boolean IsValid = true;
    public boolean ApplyFilter = true;
    private boolean DisposeOnClose = true;
    private Hashtable hashDeleted = new Hashtable();
    private Hashtable hashRangeTotals = new Hashtable();
    public StringBuilder strDriverParams = new StringBuilder();
    private static Hashtable hashCoreDrivers = new Hashtable();
    private static String CounterName = null;
    private static TDriverDependencyQueue DependencyQueue = null;
    private Hashtable HashDriverStruct = new Hashtable();
    private static Hashtable hashProfileGetField = new Hashtable();
    private static String getFieldHashID = "";
    private static boolean bProfileGetField = true;
    private static int LLL = 0;
    Hashtable hashOffset = null;
    int HashOffsetRecordCount = -1;
    private Hashtable hashCorrelation = null;
    public static int RSSITEM_TITLE = 0;
    public static int RSSITEM_DESCRIPTION = 1;
    public static int RSSITEM_LINK = 2;
    public static int RSSITEM_MODIFIED = 3;
    Hashtable hashIndicators = null;

    public TAspectDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, TAbstractDriver tAbstractDriver, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.AppDriverObj = tAppDriversObject;
        if (this.AppDriverObj.Check_Dependencies) {
            this.checkDependencies(tAppDriversObject, "");
        }
        if (this.AppDriverObj.FileType == 27 && this.AppDriverObj.DriverID.toString().equalsIgnoreCase("Aspect_Common_Mashup")) {
            this.AppDriverObj = new TAppDriversObject(this.AppDriverObj);
        }
        if (this.AppDriverObj.DriverID.toString().equalsIgnoreCase("ConsDriverHorz") || this.AppDriverObj.DriverID.toString().equalsIgnoreCase("ConsDriverVert")) {
            this.AppDriverObj = new TAppDriversObject(this.AppDriverObj);
            this.AppDriverObj.VirtualIndexField = "";
        }
        if (this.AppDriverObj != null) {
            tApplication.parse_tokens(stringBuilder, this.AppDriverObj.FileName);
            this.FileName.append((CharSequence)stringBuilder);
        }
        this.Application = tApplication;
        this.ApplyFilter = bl;
        this.F = tAbstractDriver;
        this.DriverStruct = bl2 ? new TDriverStruct(this.Application, this.AppDriverObj.StructureIndex.toString(), this.AppDriverObj.DriverParams) : this.F.getDriverStruct();
        if (this.F != null) {
            this.F.setAspectDriver(this);
            this.DSRecLastModified = this.F.getDriverStructRecord("RecordLastModified");
        }
        if (this.AppDriverObj != null) {
            this.Application.parse_tokens(stringBuilder, this.AppDriverObj.TableID);
            this.DefaultAppTablesObj = (TAppTablesObject)this.Application.AppTables.getResourceElements(stringBuilder.toString()).get(0);
        }
        this.SubtotalsDriver = new TSubtotalsDriver(this);
        this.AspectDriverFilter = new TAspectDriverFilter(this);
        if (this.F.isFiltered()) {
            this.AspectDriverFilter.setForceFilterEvaluation(true);
        }
        this.AspectDriverFilter.loadDisplay("", true);
    }

    public TAspectDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl, String string) {
        Object object;
        String[] stringArray;
        Object object2;
        String string2;
        if (bl && tAppDriversObject.ResourceIndex < 0L) {
            System.out.println(" !!! ResourceIndex = " + tAppDriversObject.ResourceIndex);
        }
        TAspectDriver tAspectDriver = null;
        StringBuilder stringBuilder = new StringBuilder();
        this.AppDriverObj = tAppDriversObject;
        this.ApplyFilter = bl;
        this.Application = tApplication;
        this.FileName.append((CharSequence)tAppDriversObject.FileName);
        if (this.AppDriverObj.Check_Dependencies && string.toUpperCase().indexOf("NODEPEND") < 0) {
            this.checkDependencies(this.AppDriverObj, string);
        }
        if (this.AppDriverObj.FileType == 27 && this.AppDriverObj.DriverID.toString().equalsIgnoreCase("Aspect_Common_Mashup")) {
            this.AppDriverObj = new TAppDriversObject(this.AppDriverObj);
        }
        this.strDriverParams.append(string);
        if (this.ApplyFilter) {
            this.Application.parse_tokens(stringBuilder, this.AppDriverObj.TableID);
            this.DefaultAppTablesObj = (TAppTablesObject)this.Application.AppTables.getResourceElements(stringBuilder.toString()).get(0);
        }
        if ((string2 = this.AppDriverObj.FileName.toString()).toUpperCase().indexOf("SCRIPTDRIVER") >= 0) {
            object2 = new TFormulaEvaluator(tApplication);
            if (this.strDriverParams.length() > 0 && (stringArray = charutil.getSubStringArray(this.strDriverParams, '|', false)) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    object = charutil.getSubStringArray(stringArray[i], '=', false);
                    if (object == null || ((String[])object).length < 2) continue;
                    for (int j = 2; j < ((String[])object).length; ++j) {
                        object[1] = object[1] + "=" + object[j];
                    }
                    ((TFormulaEvaluator)object2).setConstant("#" + object[0], object[1]);
                }
            }
            string2 = TFormulaEvaluator.convertToString(((TFormulaEvaluator)object2).getFormulaValue(string2, 0, 0));
        }
        if (string2.toUpperCase().startsWith("SCRIPTDRIVER(")) {
            String string3 = string2.substring(13, string2.length() - 1);
            object2 = new TExecScript(string3, null, null);
            ((TExecScript)object2).setParameters(charutil.replaceChar(this.strDriverParams.toString(), '|', '&'));
            ((TExecScript)object2).executeScript();
            stringArray = ((TExecScript)object2).getScriptResult();
            string3 = objectutil.convertToString(stringArray);
            tAspectDriver = TFormulaEvaluator.getSystemDriver(string3);
            this.F = tAspectDriver.F;
            this.DisposeOnClose = tAspectDriver.DisposeOnClose;
        } else {
            this.F = TAspectDriver.openDriver(this.Application, this.AppDriverObj, n, false, string);
        }
        if (this.F != null) {
            if (this.F.isValid()) {
                try {
                    if (tAspectDriver == null) {
                        this.F.makeEditableFile();
                    }
                    this.DriverStruct = this.F.getDriverStruct();
                }
                catch (Exception exception) {
                    MainWin.appendToLog("TAspectDriver", "init", Thread.currentThread(), exception, 4, "Error initializing driver: " + this.AppDriverObj.Description + " with filename: " + this.F.getFileName());
                    exception.printStackTrace();
                    this.IsValid = false;
                }
                if (this.strDriverParams.toString().toUpperCase().indexOf("TRANSPOSE") >= 0) {
                    boolean bl2 = false;
                    stringArray = "";
                    String string4 = "";
                    object = "";
                    String[] stringArray2 = charutil.getSubStringArray(this.strDriverParams, '|', false);
                    if (stringArray2 != null) {
                        for (int i = 0; i < stringArray2.length; ++i) {
                            String[] stringArray3 = charutil.getSubStringArray(stringArray2[i], '=', false);
                            if (stringArray3 == null || stringArray3.length < 2) continue;
                            for (int j = 2; j < stringArray3.length; ++j) {
                                stringArray3[1] = stringArray3[1] + "=" + stringArray3[j];
                            }
                            if (stringArray3[0].equalsIgnoreCase("Transpose")) {
                                bl2 = charutil.boolval(stringArray3[1]);
                            }
                            if (stringArray3[0].equalsIgnoreCase("TransposeID")) {
                                stringArray = stringArray3[1];
                            }
                            if (stringArray3[0].equalsIgnoreCase("TransposeName")) {
                                string4 = stringArray3[1];
                            }
                            if (!stringArray3[0].equalsIgnoreCase("TransposeFields")) continue;
                            object = stringArray3[1];
                        }
                    }
                    if (bl2) {
                        System.out.println("TAspectDriver creating transposed driver1");
                        this.F = new TTransposeDriver(this.F, (String)stringArray, string4, (String)object);
                        this.DriverStruct = this.F.getDriverStruct();
                    }
                }
                if (this.AppDriverObj.ExternalDriverstruct.trim().length() > 0) {
                    this.addExternalDriverStruct(this.AppDriverObj.ExternalDriverstruct, string);
                }
                this.DSRecLastModified = this.F.getDriverStructRecord("RecordLastModified");
                if (this.AppDriverObj.MaxRecords > 0) {
                    this.F.setMaxRecords(this.AppDriverObj.MaxRecords);
                }
                if (this.getVirtualIndexField() != null) {
                    this.validateVirtualIndices();
                }
                this.F.setModified(false);
                this.F.setAspectDriver(this);
                this.SubtotalsDriver = new TSubtotalsDriver(this);
                this.AspectDriverFilter = new TAspectDriverFilter(this);
                if (this.F.isFiltered()) {
                    this.AspectDriverFilter.setForceFilterEvaluation(true);
                }
                if (tAspectDriver == null) {
                    this.AspectDriverFilter.loadDisplay("", true);
                } else {
                    this.AspectDriverFilter.loadDisplay("", false);
                    this.AspectDriverFilter.setActiveFilter(tAspectDriver.getActiveFilter(), false);
                    String string5 = tAspectDriver.getSortOptions();
                    if (string5.length() > 0 && (stringArray = charutil.getSubStringArray(string5, '|', true)) != null && stringArray.length > 0) {
                        this.AspectDriverFilter.setSortOptions(stringArray, false);
                    }
                    this.AspectDriverFilter.setFilteredList(tAspectDriver.getAspectDriverFilter().getFilteredList());
                }
                this.replaceTokensInFieldDescriptions();
            } else {
                this.IsValid = false;
            }
        } else {
            System.out.println("Invalid file error while opening driver:" + this.AppDriverObj.DriverID);
            this.IsValid = false;
        }
    }

    public TAspectDriver(String string, int n, boolean bl, boolean bl2, String string2) {
        this.Application = TMainWin.Application;
        this.AppDriverObj = this.Application.AppDrivers.getAppDriversObject(string);
        this.ApplyFilter = bl;
        this.strDriverParams.append(string2);
        if (this.AppDriverObj == null) {
            MainWin.appendToLog("TAspectDriver", "init", Thread.currentThread(), null, 4, "TAspectDriver: Invalid driver ID: " + string);
            this.IsValid = false;
        } else {
            Object object;
            int n2;
            int n3;
            Object object2;
            String[] stringArray;
            Object object3;
            String string3;
            if (this.AppDriverObj.Check_Dependencies && string2.toUpperCase().indexOf("NODEPEND") < 0) {
                this.checkDependencies(this.AppDriverObj, string2);
            }
            TAspectDriver tAspectDriver = null;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.AppDriverObj.FileType == 27 && this.AppDriverObj.DriverID.toString().equalsIgnoreCase("Aspect_Common_Mashup")) {
                this.AppDriverObj = new TAppDriversObject(this.AppDriverObj);
            }
            if (this.AppDriverObj.DriverID.toString().equalsIgnoreCase("ConsDriverHorz") || this.AppDriverObj.DriverID.toString().equalsIgnoreCase("ConsDriverVert")) {
                this.AppDriverObj = new TAppDriversObject(this.AppDriverObj);
                this.AppDriverObj.VirtualIndexField = "";
            }
            this.FileName.append((CharSequence)this.AppDriverObj.FileName);
            if (this.ApplyFilter) {
                this.Application.parse_tokens(stringBuilder, this.AppDriverObj.TableID);
                this.DefaultAppTablesObj = (TAppTablesObject)this.Application.AppTables.getResourceElements(stringBuilder.toString()).get(0);
            }
            if ((string3 = this.AppDriverObj.FileName.toString()).toUpperCase().indexOf("SCRIPTDRIVER") >= 0) {
                object3 = new TFormulaEvaluator(TMainWin.Application);
                if (this.strDriverParams.length() > 0 && (stringArray = charutil.getSubStringArray(this.strDriverParams, '|', false)) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        object2 = charutil.getSubStringArray(stringArray[i], '=', false);
                        if (object2 == null || ((String[])object2).length < 2) continue;
                        for (n3 = 2; n3 < ((String[])object2).length; ++n3) {
                            object2[1] = object2[1] + "=" + object2[n3];
                        }
                        ((TFormulaEvaluator)object3).setConstant("#" + object2[0], object2[1]);
                    }
                }
                string3 = TFormulaEvaluator.convertToString(((TFormulaEvaluator)object3).getFormulaValue(string3, 0, 0));
            }
            if (string3.toUpperCase().startsWith("SCRIPTDRIVER(")) {
                String string4 = string3.substring(13, string3.length() - 1);
                TFormulaEvaluator.waitForThreadCount();
                object3 = new TExecScript(string4, null, null);
                ((TExecScript)object3).setParameters(charutil.replaceChar(this.strDriverParams.toString(), '|', '&'));
                ((TExecScript)object3).executeScript();
                stringArray = ((TExecScript)object3).getScriptResult();
                string4 = objectutil.convertToString(stringArray);
                tAspectDriver = TFormulaEvaluator.getSystemDriver(string4);
                if (tAspectDriver != null) {
                    TFormulaEvaluator tFormulaEvaluator;
                    this.F = tAspectDriver.F;
                    this.DisposeOnClose = tAspectDriver.DisposeOnClose;
                    if (this.AppDriverObj.VirtualIndexField.trim().length() > 0 && this.F.getAspectDriver() != null) {
                        this.F.getAspectDriver().AppDriverObj.VirtualIndexField = this.AppDriverObj.VirtualIndexField;
                    }
                    if ((tFormulaEvaluator = this.F.getFormulaEvaluator()) != null && string2.length() > 0) {
                        tFormulaEvaluator.setConstant("DriverParams", string2);
                        object2 = charutil.getSubStringArray(string2, '|', false);
                        if (object2 != null) {
                            for (n3 = 0; n3 < ((String[])object2).length; ++n3) {
                                String[] stringArray2;
                                n2 = object2[n3].indexOf("=");
                                if (n2 <= 0 || n2 >= object2[n3].length()) continue;
                                object = object2[n3].substring(0, n2);
                                String string5 = object2[n3].substring(n2 + 1);
                                if (tFormulaEvaluator.getConstant("#" + (String)object) != null) continue;
                                tFormulaEvaluator.setConstant("#" + (String)object, string5);
                                if (!((String)object).equalsIgnoreCase("DimDriverParams") || (stringArray2 = charutil.getSubStringArray(string5, '^', false)) == null) continue;
                                for (int i = 0; i < stringArray2.length; ++i) {
                                    n2 = stringArray2[i].indexOf("=");
                                    if (n2 < 0 || n2 >= stringArray2[i].length()) continue;
                                    String string6 = stringArray2[i].substring(0, n2);
                                    String string7 = stringArray2[i].substring(n2 + 1);
                                    if (tFormulaEvaluator.getConstant("#" + string6) != null) continue;
                                    tFormulaEvaluator.setConstant("#" + string6, string7);
                                }
                            }
                        }
                    }
                } else {
                    MainWin.appendToLog("TAspectDriver", "init", Thread.currentThread(), null, 4, "Error opening script driver with ID " + string + " Driver Name=" + string4 + " Driver Params=" + this.strDriverParams.toString());
                }
            } else {
                this.F = TAspectDriver.openDriver(this.Application, this.AppDriverObj, n, false, string2);
            }
            if (this.F != null) {
                if (this.F.isValid()) {
                    try {
                        if (tAspectDriver == null) {
                            this.F.makeEditableFile();
                        }
                        if (this.F.isValid()) {
                            this.DriverStruct = this.F.getDriverStruct();
                        } else {
                            this.IsValid = false;
                        }
                    }
                    catch (Exception exception) {
                        MainWin.appendToLog("TAspectDriver", "init", Thread.currentThread(), exception, 4, "Error initializing driver1: " + this.AppDriverObj.Description + " with filename: " + this.F.getFileName());
                        this.IsValid = false;
                    }
                    if (this.strDriverParams.toString().toUpperCase().indexOf("TRANSPOSE") >= 0) {
                        boolean bl3 = false;
                        stringArray = "";
                        String string8 = "";
                        object2 = "";
                        String[] stringArray3 = charutil.getSubStringArray(this.strDriverParams, '|', false);
                        if (stringArray3 != null) {
                            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                                object = charutil.getSubStringArray(stringArray3[n2], '=', false);
                                if (object == null || ((String[])object).length < 2) continue;
                                for (int i = 2; i < ((String[])object).length; ++i) {
                                    object[1] = object[1] + "=" + object[i];
                                }
                                if (object[0].equalsIgnoreCase("Transpose")) {
                                    bl3 = charutil.boolval(object[1]);
                                }
                                if (object[0].equalsIgnoreCase("TransposeID")) {
                                    stringArray = object[1];
                                }
                                if (object[0].equalsIgnoreCase("TransposeName")) {
                                    string8 = object[1];
                                }
                                if (!object[0].equalsIgnoreCase("TransposeFields")) continue;
                                object2 = object[1];
                            }
                        }
                        if (bl3) {
                            this.F = new TTransposeDriver(this.F, (String)stringArray, string8, (String)object2);
                            this.DriverStruct = this.F.getDriverStruct();
                        }
                    }
                    if (this.AppDriverObj.ExternalDriverstruct.trim().length() > 0) {
                        this.addExternalDriverStruct(this.AppDriverObj.ExternalDriverstruct, string2);
                    }
                    if (this.IsValid) {
                        this.DSRecLastModified = this.F.getDriverStructRecord("RecordLastModified");
                        if (this.getVirtualIndexField() != null) {
                            this.validateVirtualIndices();
                        }
                        this.F.setModified(false);
                        this.F.setAspectDriver(this);
                        this.AspectDriverFilter = new TAspectDriverFilter(this);
                        if (this.F.isFiltered()) {
                            this.AspectDriverFilter.setForceFilterEvaluation(true);
                        }
                        if (tAspectDriver != null) {
                            this.AspectDriverFilter.loadDisplay("", false);
                            this.AspectDriverFilter.setActiveFilter(tAspectDriver.getActiveFilter(), false);
                            String string9 = tAspectDriver.getSortOptions();
                            if (string9.length() > 0 && (stringArray = charutil.getSubStringArray(string9, '|', true)) != null && stringArray.length > 0) {
                                this.AspectDriverFilter.setSortOptions(stringArray, false);
                            }
                            this.AspectDriverFilter.setFilteredList(tAspectDriver.getAspectDriverFilter().getFilteredList());
                        }
                    }
                } else {
                    this.IsValid = false;
                }
                this.replaceTokensInFieldDescriptions();
            } else {
                System.out.println("Invalid file error while opening driver:" + this.AppDriverObj.DriverID);
                this.IsValid = false;
            }
        }
    }

    public Date getTimeOpened() {
        return this.F.getTimeOpened();
    }

    public int getPhysicalRecordSize() {
        return ((TAbstractDriver)this.F).getPhysicalRecordSize();
    }

    public void replaceTokensInFieldDescriptions() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        TDriverStruct tDriverStruct = this.DriverStruct;
        if (tDriverStruct == null) {
            tDriverStruct = this.F.getDriverStruct();
        }
        if (tDriverStruct != null) {
            TDriverStructRecord tDriverStructRecord;
            int n;
            for (n = 0; n < tDriverStruct.FieldColl.size(); ++n) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n);
                if (tDriverStructRecord.Description.indexOf(123) >= 0) continue;
                hashtable.put(tDriverStructRecord.FullID.toUpperCase(), tDriverStructRecord.Description);
            }
            for (n = 0; n < tDriverStruct.FieldColl.size(); ++n) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n);
                if (tDriverStructRecord.Description.indexOf("{") < 0) continue;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (tDriverStructRecord.Description.toUpperCase().indexOf("{" + string + "}") < 0) continue;
                    String string2 = (String)hashtable.get(string);
                    tDriverStructRecord.Description = charutil.replaceAllSubstrings(tDriverStructRecord.Description, "{" + string + "}", string2);
                }
            }
        }
    }

    private void addExternalDriverStruct(String string, String string2) {
        String string3 = charutil.replaceAllSubstrings(string2, "nodepend", "");
        if ((string3 = charutil.replaceAllSubstrings(string3, "Transpose=true", "")).toUpperCase().indexOf("FILENAME=") >= 0) {
            MainWin.appendToLog("TAspectDriver", "addExternalDriverStruct", Thread.currentThread(), null, 4, "Warning: Passing Filename parameter to external structure driver.");
        }
        TAspectDriver tAspectDriver = new TAspectDriver(string, 1, true, false, string3);
        int n = tAspectDriver.getAbsoluteRecordCount();
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)tAspectDriver.getFieldAbsolute("Used", i)).booleanValue()) continue;
            String string4 = (String)tAspectDriver.getFieldAbsolute("FieldID", i);
            int n2 = (int)objectutil.convertToNumber(tAspectDriver.getFieldAbsolute("FieldType", i));
            if (string4.trim().length() <= 0 || n2 == 23) continue;
            TDriverStructRecord tDriverStructRecord = new TDriverStructRecord();
            tDriverStructRecord.ID = string4;
            tDriverStructRecord.FullID = string4;
            String string5 = (String)tAspectDriver.getFieldAbsolute("Description", i);
            if (string5.startsWith("=")) {
                string5 = objectutil.convertToString(TFormulaEvaluator.eval(string5));
            }
            tDriverStructRecord.Description = string5;
            tDriverStructRecord.Visible = (Boolean)tAspectDriver.getFieldAbsolute("Visible", i);
            tDriverStructRecord.IsCalculated = (Boolean)tAspectDriver.getFieldAbsolute("IsCalculated", i);
            tDriverStructRecord.IsVirtual = (Boolean)tAspectDriver.getFieldAbsolute("IsVirtual", i);
            tDriverStructRecord.FieldType = n2;
            tDriverStructRecord.ArraySize = (int)objectutil.convertToNumber(tAspectDriver.getFieldAbsolute("ArraySize", i));
            if (tAspectDriver.getDriverStruct().getField("Is_External") != null) {
                tDriverStructRecord.External_Data_Is_External = (Boolean)tAspectDriver.getFieldAbsolute("Is_External", i);
                tDriverStructRecord.External_Data_Filename = (String)tAspectDriver.getFieldAbsolute("External_Data_Filename", i);
                tDriverStructRecord.External_Data_Key = (String)tAspectDriver.getFieldAbsolute("External_Data_Key", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Fixed_Width_Length") != null) {
                tDriverStructRecord.Fixed_Width_Length = (int)objectutil.convertToNumber(tAspectDriver.getFieldAbsolute("Fixed_Width_Length", i));
                tDriverStructRecord.Fixed_Width_Padding_Direction = (int)objectutil.convertToNumber(tAspectDriver.getFieldAbsolute("Fixed_Width_Padding_Direction", i));
                tDriverStructRecord.Fixed_Width_Padding_Character = (int)objectutil.convertToNumber(tAspectDriver.getFieldAbsolute("Fixed_Width_Padding_Character", i));
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_IsFormula") != null) {
                tDriverStructRecord.Formula = (String)tAspectDriver.getFieldAbsolute("Aspect_Structures_IsFormula", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Html_Section_Header") != null) {
                tDriverStructRecord.HtmlSectionStart = (String)tAspectDriver.getFieldAbsolute("Aspect_Structures_Html_Section_Header", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Html_Allow_Editing") != null) {
                tDriverStructRecord.Html_Permit_Editing = (Boolean)tAspectDriver.getFieldAbsolute("Aspect_Structures_Html_Allow_Editing", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Enable_Html_Section_Breaks") != null) {
                tDriverStructRecord.Html_Enable_Sections = (Boolean)tAspectDriver.getFieldAbsolute("Enable_Html_Section_Breaks", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_CalcSubtotal") != null) {
                tDriverStructRecord.CalcSubtotal = (Boolean)tAspectDriver.getFieldAbsolute("Aspect_Structures_CalcSubtotal", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Subtotal_As_Formula") != null) {
                tDriverStructRecord.SubtotalAsFormula = (Boolean)tAspectDriver.getFieldAbsolute("Aspect_Structures_Subtotal_As_Formula", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Pattern") != null) {
                tDriverStructRecord.FormatPattern = (String)tAspectDriver.getFieldAbsolute("Aspect_Structures_Pattern", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Suppress_Zeros") != null) {
                tDriverStructRecord.SuppressZeros = (Boolean)tAspectDriver.getFieldAbsolute("Aspect_Structures_Suppress_Zeros", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_DefaultValueOnInsert") != null) {
                tDriverStructRecord.DefaultOnInsert = (String)tAspectDriver.getFieldAbsolute("Aspect_Structures_DefaultValueOnInsert", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Html") != null) {
                tDriverStructRecord.Html = (String)tAspectDriver.getFieldAbsolute("html", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_HtmlEdit_Attributes") != null) {
                tDriverStructRecord.HtmlEditAttributes = (String)tAspectDriver.getFieldAbsolute("Aspect_Structures_HtmlEdit_Attributes", i);
            }
            if (tAspectDriver.getDriverStruct().getField("TD_Class") != null) {
                tDriverStructRecord.TDClass = (String)tAspectDriver.getFieldAbsolute("TD_Class", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Tooltip") != null) {
                tDriverStructRecord.Tooltip = (String)tAspectDriver.getFieldAbsolute("Aspect_Structures_Tooltip", i);
            }
            tDriverStructRecord.DataSize = TAbstractDriver.getFieldSize(tDriverStructRecord.FieldType);
            tDriverStructRecord.IsExternalStructField = true;
            this.DriverStruct.FieldColl.add(tDriverStructRecord);
            this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.setLength(0);
            stringBuilder.append(tDriverStructRecord.Description.toUpperCase());
            charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
            this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
        }
        tAspectDriver.dispose();
        ((TAbstractDriver)this.F).RecordSize = this.DriverStruct.updateFieldIndices();
    }

    public void addExternalDriverStruct(TAspectDriver tAspectDriver) {
        int n = tAspectDriver.getRecordCount();
        TFormulaEvaluator tFormulaEvaluator = null;
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)tAspectDriver.getField("Used", i)).booleanValue()) continue;
            String string = (String)tAspectDriver.getField("FieldID", i);
            int n2 = (int)objectutil.convertToNumber(tAspectDriver.getField("FieldType", i));
            if (string.trim().length() <= 0) continue;
            TDriverStructRecord tDriverStructRecord = new TDriverStructRecord();
            tDriverStructRecord.ID = string;
            tDriverStructRecord.FullID = string;
            String string2 = (String)tAspectDriver.getField("Description", i);
            if (string2.startsWith("=")) {
                if (tFormulaEvaluator == null) {
                    tFormulaEvaluator = new TFormulaEvaluator();
                    tFormulaEvaluator.setAspectDriver(this);
                }
                string2 = objectutil.convertToString(tFormulaEvaluator.getFormulaValue(string2));
            }
            tDriverStructRecord.Description = string2;
            tDriverStructRecord.Visible = (Boolean)tAspectDriver.getField("Visible", i);
            tDriverStructRecord.IsCalculated = (Boolean)tAspectDriver.getField("IsCalculated", i);
            tDriverStructRecord.IsVirtual = (Boolean)tAspectDriver.getField("IsVirtual", i);
            tDriverStructRecord.FieldType = n2;
            tDriverStructRecord.ArraySize = (int)objectutil.convertToNumber(tAspectDriver.getField("ArraySize", i));
            if (tAspectDriver.getDriverStruct().getField("Is_External") != null) {
                tDriverStructRecord.External_Data_Is_External = (Boolean)tAspectDriver.getField("Is_External", i);
                tDriverStructRecord.External_Data_Filename = (String)tAspectDriver.getField("External_Data_Filename", i);
                tDriverStructRecord.External_Data_Key = (String)tAspectDriver.getField("External_Data_Key", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Fixed_Width_Length") != null) {
                tDriverStructRecord.Fixed_Width_Length = (int)objectutil.convertToNumber(tAspectDriver.getFieldAbsolute("Fixed_Width_Length", i));
                tDriverStructRecord.Fixed_Width_Padding_Direction = (int)objectutil.convertToNumber(tAspectDriver.getFieldAbsolute("Fixed_Width_Padding_Direction", i));
                tDriverStructRecord.Fixed_Width_Padding_Character = (int)objectutil.convertToNumber(tAspectDriver.getFieldAbsolute("Fixed_Width_Padding_Character", i));
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_IsFormula") != null) {
                tDriverStructRecord.Formula = (String)tAspectDriver.getField("Aspect_Structures_IsFormula", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Html_Section_Header") != null) {
                tDriverStructRecord.HtmlSectionStart = (String)tAspectDriver.getField("Aspect_Structures_Html_Section_Header", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Html_Allow_Editing") != null) {
                tDriverStructRecord.Html_Permit_Editing = (Boolean)tAspectDriver.getField("Aspect_Structures_Html_Allow_Editing", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Enable_Html_Section_Breaks") != null) {
                tDriverStructRecord.Html_Enable_Sections = (Boolean)tAspectDriver.getField("Enable_Html_Section_Breaks", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_CalcSubtotal") != null) {
                tDriverStructRecord.CalcSubtotal = (Boolean)tAspectDriver.getField("Aspect_Structures_CalcSubtotal", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Subtotal_As_Formula") != null) {
                tDriverStructRecord.SubtotalAsFormula = (Boolean)tAspectDriver.getField("Aspect_Structures_Subtotal_As_Formula", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Pattern") != null) {
                tDriverStructRecord.FormatPattern = (String)tAspectDriver.getField("Aspect_Structures_Pattern", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Suppress_Zeros") != null) {
                tDriverStructRecord.SuppressZeros = (Boolean)tAspectDriver.getField("Aspect_Structures_Suppress_Zeros", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_DefaultValueOnInsert") != null) {
                tDriverStructRecord.DefaultOnInsert = (String)tAspectDriver.getField("Aspect_Structures_DefaultValueOnInsert", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Html") != null) {
                tDriverStructRecord.Html = (String)tAspectDriver.getField("html", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_HtmlEdit_Attributes") != null) {
                tDriverStructRecord.HtmlEditAttributes = (String)tAspectDriver.getField("Aspect_Structures_HtmlEdit_Attributes", i);
            }
            if (tAspectDriver.getDriverStruct().getField("TD_Class") != null) {
                tDriverStructRecord.TDClass = (String)tAspectDriver.getField("TD_Class", i);
            }
            if (tAspectDriver.getDriverStruct().getField("Aspect_Structures_Tooltip") != null) {
                tDriverStructRecord.Tooltip = (String)tAspectDriver.getField("Aspect_Structures_Tooltip", i);
            }
            tDriverStructRecord.DataSize = TAbstractDriver.getFieldSize(tDriverStructRecord.FieldType);
            tDriverStructRecord.IsExternalStructField = true;
            this.DriverStruct.FieldColl.add(tDriverStructRecord);
            this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.setLength(0);
            stringBuilder.append(tDriverStructRecord.Description.toUpperCase());
            charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
            this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
        }
        ((TAbstractDriver)this.F).RecordSize = this.DriverStruct.updateFieldIndices();
    }

    public void addField(String string, String string2) {
        TDriverStructRecord tDriverStructRecord = new TDriverStructRecord();
        tDriverStructRecord.ID = string;
        tDriverStructRecord.FullID = string;
        tDriverStructRecord.DataSize = TAbstractDriver.getFieldSize(tDriverStructRecord.FieldType);
        tDriverStructRecord.IsExternalStructField = true;
        tDriverStructRecord.DataSize = TAbstractDriver.getFieldSize(tDriverStructRecord.FieldType);
        tDriverStructRecord.AbsoluteIndex = this.DriverStruct.FieldColl.size();
        tDriverStructRecord.Description = string;
        tDriverStructRecord.Visible = true;
        tDriverStructRecord.IsCalculated = true;
        tDriverStructRecord.IsVirtual = true;
        tDriverStructRecord.FieldType = 3;
        tDriverStructRecord.ArraySize = 1;
        this.DriverStruct.FieldColl.add(tDriverStructRecord);
        this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(0);
        stringBuilder.append(tDriverStructRecord.Description.toUpperCase());
        charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
        this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
        this.setFieldAttributes(string, string2);
        tDriverStructRecord = this.getDriverStructRecord(string);
        if (!tDriverStructRecord.IsVirtual) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.DriverStruct.FieldColl.size() - 1; ++i) {
                TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                if (tDriverStructRecord2.IsVirtual) continue;
                n += tDriverStructRecord2.DataSize * tDriverStructRecord2.ArraySize;
                ++n2;
            }
            tDriverStructRecord.Offset = n;
            tDriverStructRecord.PhysicalIndex = n2;
            this.DriverStruct.RecordSize += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
            ((TAbstractDriver)this.F).RecordSize = this.DriverStruct.RecordSize;
            if (this.F instanceof TBinaryFile) {
                ((TBinaryFile)this.F).initializeBuffer();
            }
        }
    }

    public void setFieldAttributes(String string, String string2) {
        TDriverStructRecord tDriverStructRecord = this.getDriverStructRecord(string);
        if (tDriverStructRecord != null) {
            String string3 = TPasswordService.generateSalt(4);
            String string4 = charutil.replaceAllSubstrings(string2, "\\,", string3);
            String[] stringArray = charutil.getSubStringArray(string4, ',', true);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string5;
                    stringArray[i] = charutil.replaceAllSubstrings(stringArray[i], string3, ",");
                    int n = stringArray[i].indexOf(61);
                    if (n < 0) {
                        System.out.println("Error: setFieldAttributes FieldID=" + string);
                        System.out.println(" _Attr=" + string2);
                    }
                    String string6 = stringArray[i].substring(0, n);
                    String string7 = string5 = n < stringArray[i].length() ? stringArray[i].substring(n + 1) : "";
                    if (string5.startsWith("\"") && string5.endsWith("\"")) {
                        string5 = charutil.removeQuotes(string5);
                    }
                    if (string6.equalsIgnoreCase("Description")) {
                        tDriverStructRecord.Description = string5;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("Visible")) {
                        tDriverStructRecord.Visible = charutil.boolval(string5);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("IsCalculated")) {
                        tDriverStructRecord.IsCalculated = charutil.boolval(string5);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("IsVirtual")) {
                        tDriverStructRecord.IsVirtual = charutil.boolval(string5);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("FieldType")) {
                        if (string5.equalsIgnoreCase("number") || string5.equalsIgnoreCase("double")) {
                            tDriverStructRecord.FieldType = 9;
                        } else if (string5.equalsIgnoreCase("int")) {
                            tDriverStructRecord.FieldType = 7;
                        } else if (string5.equalsIgnoreCase("date") || string5.equalsIgnoreCase("datetime") || string5.equalsIgnoreCase("time")) {
                            tDriverStructRecord.FieldType = 21;
                        } else if (string5.equalsIgnoreCase("boolean")) {
                            tDriverStructRecord.FieldType = 19;
                        } else if (string5.equalsIgnoreCase("char")) {
                            tDriverStructRecord.FieldType = 3;
                        } else {
                            MainWin.appendToLog("TAspectDriver", "setFieldAttributes", Thread.currentThread(), null, 4, "Error: setFieldAttributes: Invalid FieldType: " + stringArray[i]);
                        }
                        tDriverStructRecord.DataSize = TAbstractDriver.getFieldSize(tDriverStructRecord.FieldType);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("ArraySize")) {
                        tDriverStructRecord.ArraySize = charutil.ival(string5);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("Formula")) {
                        tDriverStructRecord.Formula = "=" + string5;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("CalcSubtotal")) {
                        tDriverStructRecord.CalcSubtotal = charutil.boolval(string5);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("SubtotalAsFormula")) {
                        tDriverStructRecord.SubtotalAsFormula = charutil.boolval(string5);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("FormatPattern")) {
                        tDriverStructRecord.FormatPattern = string5;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("SuppressZeros")) {
                        tDriverStructRecord.SuppressZeros = charutil.boolval(string5);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("TDClass")) {
                        tDriverStructRecord.TDClass = string5;
                        continue;
                    }
                    MainWin.appendToLog("TAspectDriver", "setFieldAttributes", Thread.currentThread(), null, 4, "Error: setFieldAttributes: Invalid attribute: " + stringArray[i]);
                }
            }
        } else {
            MainWin.appendToLog("TAspectDriver", "setFieldAttributes", Thread.currentThread(), null, 4, "Error: setFieldAttributes: FieldID does not exist: " + string);
        }
    }

    public void copyDriverStruct(TAspectDriver tAspectDriver) {
        TDriverStruct tDriverStruct = tAspectDriver.getDriverStruct();
        for (int i = 0; i < tDriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(i);
            TDriverStructRecord tDriverStructRecord2 = this.DriverStruct.getField(tDriverStructRecord.FullID);
            if (tDriverStructRecord2 == null) {
                tDriverStructRecord2 = new TDriverStructRecord(tDriverStructRecord);
                System.out.println("Adding field: " + tDriverStructRecord2.FullID);
                this.DriverStruct.FieldColl.add(tDriverStructRecord2);
                this.DriverStruct.HashFields.put(tDriverStructRecord2.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.setLength(0);
                stringBuilder.append(tDriverStructRecord2.Description.toUpperCase());
                charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
                this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
                if (tDriverStructRecord2.IsVirtual) continue;
                int n = 0;
                int n2 = 0;
                for (int j = 0; j < this.DriverStruct.FieldColl.size() - 1; ++j) {
                    TDriverStructRecord tDriverStructRecord3 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(j);
                    if (tDriverStructRecord3.IsVirtual) continue;
                    n += tDriverStructRecord3.DataSize * tDriverStructRecord3.ArraySize;
                    ++n2;
                }
                tDriverStructRecord2.Offset = n;
                tDriverStructRecord2.PhysicalIndex = n2;
                this.DriverStruct.RecordSize += tDriverStructRecord2.DataSize * tDriverStructRecord2.ArraySize;
                ((TAbstractDriver)this.F).RecordSize = this.DriverStruct.RecordSize;
                if (!(this.F instanceof TBinaryFile)) continue;
                ((TBinaryFile)this.F).initializeBuffer();
                continue;
            }
            System.out.println("Field already exists: " + tDriverStructRecord.FullID);
        }
    }

    public static TDriverDependencyQueue getDependencyQueue() {
        if (DependencyQueue == null) {
            DependencyQueue = new TDriverDependencyQueue();
        }
        return DependencyQueue;
    }

    private void checkDependencies(TAppDriversObject tAppDriversObject, String string) {
        if (string.toUpperCase().indexOf("NODEPEND") >= 0) {
            System.out.println("checkDependencies: aborting because nodepend set for " + this.AppDriverObj.DriverID.toString() + " " + string);
            return;
        }
        long l = new Date().getTime();
        String string2 = TDriverDependency.getDependencyID(this.AppDriverObj.DriverID.toString(), string);
        String string3 = TDriverDependency.getLastDependencyState(string2);
        String string4 = TDriverDependency.getLastDependencySourceState(string2);
        String string5 = TDriverDependency.getCurrentDependencyState(tAppDriversObject.DriverID.toString(), string);
        String string6 = TDriverDependency.getCurrentDependencySourceState(tAppDriversObject.DriverID.toString(), string, false);
        if (!string3.equals(string5) || !string4.equals(string6)) {
            if (DependencyQueue == null) {
                DependencyQueue = new TDriverDependencyQueue();
            }
            String string7 = DependencyQueue.addToQueue(string2);
            boolean bl = false;
            while (DependencyQueue.countPriorRunningUpdates(string7) > 0) {
                Thread.yield();
                if (Math.random() < 0.1) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bl = true;
            }
            boolean bl2 = true;
            if (bl) {
                String string8 = TDriverDependency.getLastDependencyState(string2);
                String string9 = TDriverDependency.getLastDependencySourceState(string2);
                String string10 = TDriverDependency.getCurrentDependencyState(tAppDriversObject.DriverID.toString(), string);
                String string11 = TDriverDependency.getCurrentDependencySourceState(tAppDriversObject.DriverID.toString(), string);
                if (string6.equals(string11)) {
                    bl2 = false;
                }
                System.out.println("Waited for prior call.  ExecuteUpdate=" + bl2);
            }
            if (bl2) {
                long l2 = TExecScript.getNewScriptInstance();
                MainWin.appendToLog("TAspectDriver", "checkDependencies", Thread.currentThread(), null, 24, "Update dependent driver: " + string2, tAppDriversObject.DriverID.toString(), string, 0L, l2, string5, string4, string6, string4);
                long l3 = new Date().getTime();
                String string12 = TDriverDependency.updateDriver(tAppDriversObject.DriverID.toString(), string);
                long l4 = new Date().getTime();
                if (string12.trim().toUpperCase().startsWith("OK")) {
                    string5 = TDriverDependency.getCurrentDependencyState(tAppDriversObject.DriverID.toString(), string);
                    MainWin.appendToLog("TAspectDriver", "checkDependencies", Thread.currentThread(), null, 25, "Updated dependent driver: " + string2, tAppDriversObject.DriverID.toString(), string, l4 - l3, l2, string5, "", "", "");
                } else {
                    string5 = "-1";
                    MainWin.appendToLog("TAspectDriver", "checkDependencies", Thread.currentThread(), null, 25, "Error: Update dependent driver failed: " + string2, tAppDriversObject.DriverID.toString(), string, l4 - l3, l2, "-1", "", "", "");
                    MainWin.appendToLog("TAspectDriver", "checkDependencies", Thread.currentThread(), null, 25, "Error: Update dependent driver result: " + string12, tAppDriversObject.DriverID.toString(), string, l4 - l3, l2, "-1", "", "", "");
                    if (string.toUpperCase().indexOf("__STOREID__") >= 0) {
                        System.out.println("Undefined StoreID in update dependent driver: " + tAppDriversObject.DriverID.toString());
                        System.out.println("Change update expression to return OK when store is not defined");
                    }
                }
                TAspectDriver.counterAddEvent("Update Dependent Driver", "DriverID=" + tAppDriversObject.DriverID.toString() + "&DriverParams=" + this.strDriverParams + "&ElapsedTime=" + (l4 - l3));
                TDriverDependency.recordDependencyState(tAppDriversObject.DriverID.toString(), string, string5, string6, string12, l4 - l3);
            } else {
                MainWin.appendToLog("TAspectDriver", "checkDependencies", Thread.currentThread(), null, 3, "Updated dependent driver updated by prior call: " + string2 + " Params: " + string);
            }
            DependencyQueue.removeFromQueue(string7);
        }
    }

    public static void counterAddEvent(String string, String string2) {
        if (CounterName == null) {
            CounterName = "ASPECTDRIVER";
            TFormulaEvaluator.counterCreate(CounterName, 3600000L);
        }
        TFormulaEvaluator.counterAddEvent(CounterName, string, string2);
    }

    public static TDriverInterface openDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        return TAspectDriver.openDriver(tApplication, tAppDriversObject, n, bl, "");
    }

    public static TDriverInterface openDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl, String string) {
        Object object;
        TDriverInterface tDriverInterface = null;
        TAppDriversObject tAppDriversObject2 = new TAppDriversObject(tAppDriversObject);
        tApplication.parse_tokens(tAppDriversObject2.StructureIndex, tAppDriversObject2.StructureIndex);
        tAppDriversObject2.RemoteDriverID = tApplication.parse_tokens(tAppDriversObject2.RemoteDriverID);
        TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator(tApplication);
        if (string.length() > 0) {
            tFormulaEvaluator.setConstant("Params", string);
            object = charutil.getSubStringArray(string, '|', false);
            if (object != null) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String[] stringArray = charutil.getSubStringArray(object[i], '=', false);
                    if (stringArray == null || stringArray.length < 2) continue;
                    for (int j = 2; j < stringArray.length; ++j) {
                        stringArray[1] = stringArray[1] + "=" + stringArray[j];
                    }
                    tFormulaEvaluator.setConstant("#" + stringArray[0], stringArray[1]);
                    if (!stringArray[0].equalsIgnoreCase("VirtualIndex")) continue;
                    System.out.println("Set virtual index field = " + stringArray[1]);
                    tAppDriversObject2.VirtualIndexField = stringArray[1];
                }
            }
        }
        String string2 = TFormulaEvaluator.convertToString(tFormulaEvaluator.getFormulaValue(tAppDriversObject2.FileName, 0, 0));
        tAppDriversObject2.FileName.setLength(0);
        tAppDriversObject2.FileName.append(TMainWin.Application.parse_tokens(string2));
        tAppDriversObject2.DriverParams = string;
        if (TMainWin.Application.getTokenValueAsBool("DebugTAspectDriver")) {
            MainWin.appendToLog("TAspectDriver", "openDriver", Thread.currentThread(), null, 10, "Opening Driver: " + tAppDriversObject.DriverID + " filename: " + tAppDriversObject2.FileName + " Params: " + string + " Original source name: " + tAppDriversObject.FileName);
        }
        try {
            switch (tAppDriversObject.FileType) {
                case 0: {
                    break;
                }
                case 1: {
                    tDriverInterface = new TBinaryFile(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 6: {
                    tDriverInterface = new TUnformattedText(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 7: {
                    tDriverInterface = new TTokenDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 2: {
                    tDriverInterface = new TAspectFile(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 4: {
                    tDriverInterface = new TAsciiCsvFile(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 5: {
                    tDriverInterface = new TFixedWidthFile(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 8: {
                    tDriverInterface = new TDisplaysFile(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 9: {
                    tDriverInterface = new TLiveData(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 26: {
                    tDriverInterface = new TSerialPort(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 10: {
                    string2 = tApplication.parse_tokens(tAppDriversObject2.RemoteDriverID);
                    tDriverInterface = new TSocketDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 12: {
                    tDriverInterface = new TSocketConnectionTest(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 13: {
                    tDriverInterface = new TEditDialogsDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 16: {
                    tDriverInterface = new TSystemPropertiesDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 17: {
                    tDriverInterface = new TAsciiFileReader(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 18: {
                    tDriverInterface = new TParagonDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 20: {
                    tDriverInterface = new TPackageDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 3: {
                    tDriverInterface = new TDbaseDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 21: {
                    tDriverInterface = new TEditStructuresDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 22: {
                    tDriverInterface = new TBinaryBuffer(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 23: {
                    tDriverInterface = new TConsolidatedHorzDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 24: {
                    tDriverInterface = new TConsolidatedVertDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 27: {
                    if (tAppDriversObject.DriverID.toString().equalsIgnoreCase("Aspect_Common_Mashup")) {
                        tAppDriversObject.DriverID.setLength(0);
                        tAppDriversObject.DriverID.append((CharSequence)tAppDriversObject2.FileName);
                        tAppDriversObject.UnparsedID = tAppDriversObject2.FileName.toString();
                        tAppDriversObject2.DriverID.setLength(0);
                        tAppDriversObject2.DriverID.append((CharSequence)tAppDriversObject2.FileName);
                        tAppDriversObject2.UnparsedID = tAppDriversObject2.FileName.toString();
                        if (TMainWin.Application.AppDrivers.getAppDriversObject(tAppDriversObject2.FileName) == null) {
                            TMainWin.Application.AppDrivers.ResourceColl.add(tAppDriversObject);
                        }
                    }
                    tDriverInterface = new TMashupDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 28: {
                    tDriverInterface = new THtmlDocumentDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 29: {
                    tDriverInterface = new TOdbcDatabase(tApplication, tAppDriversObject2, n, bl, tAppDriversObject.FileType);
                    break;
                }
                case 30: {
                    tDriverInterface = new TOdbcDatabase(tApplication, tAppDriversObject2, n, bl, tAppDriversObject.FileType);
                    break;
                }
                case 32: {
                    tDriverInterface = new TPivotTableDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 33: {
                    tDriverInterface = new TCacheDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 34: {
                    tDriverInterface = new TFilespecDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 35: {
                    tDriverInterface = new TBinaryFileBuffer(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 36: {
                    tDriverInterface = new TAspectFileBuffer(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 37: {
                    tDriverInterface = new TOdbcDatabase(tApplication, tAppDriversObject2, n, bl, tAppDriversObject.FileType);
                    break;
                }
                case 38: {
                    tDriverInterface = new TExternalDataDriver(tApplication, tAppDriversObject2, n, bl);
                    break;
                }
                case 39: {
                    tDriverInterface = new TDimensionalDriver(tApplication, tAppDriversObject2, n, bl);
                }
            }
        }
        catch (Exception exception) {
            MainWin.appendToLog("TAspectDriver", "openDriver", Thread.currentThread(), exception, 4, "Error opening driver.");
            exception.printStackTrace();
        }
        if (tDriverInterface != null) {
            object = tDriverInterface.getFormulaEvaluator();
            if (object != null && string.length() > 0) {
                ((TFormulaEvaluator)object).setConstant("DriverParams", string);
                String[] stringArray = charutil.getSubStringArray(string, '|', false);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', false);
                        if (stringArray2 == null || stringArray2.length != 2) continue;
                        ((TFormulaEvaluator)object).setConstant("#" + stringArray2[0], stringArray2[1]);
                    }
                }
            }
        } else {
            System.out.println("TAspectDriver Driver is null for " + tAppDriversObject.DriverID);
        }
        return tDriverInterface;
    }

    public void setDriver(TDriverInterface tDriverInterface) {
        this.F = tDriverInterface;
        this.DriverStruct = this.F.getDriverStruct();
        this.AspectDriverFilter = new TAspectDriverFilter(this);
        if (this.F.isFiltered()) {
            this.AspectDriverFilter.setForceFilterEvaluation(true);
        }
    }

    public void enableSubtotals() {
        if (this.AspectDriverFilter.ColumnList == null || this.AspectDriverFilter.ColumnList.size() == 0) {
            this.AspectDriverFilter.initializeDisplayFromStructure();
        }
        this.AspectDriverFilter.SubtotalsDriver = this.SubtotalsDriver = new TSubtotalsDriver(this);
    }

    public void setDisposeOnClose(boolean bl) {
        this.DisposeOnClose = bl;
    }

    public boolean getDisposeOnClose() {
        return this.DisposeOnClose;
    }

    public void dispose() {
        if (this.AspectDriverFilter != null) {
            this.AspectDriverFilter.dispose();
        }
        this.hashRangeTotals.clear();
        if (this.DisposeOnClose && this.F != null) {
            try {
                if (!TMainWin.IsClosing && this.F.isModified() && this.AppDriverObj.PackOnClose && this.AspectDriverFilter.DeleteFilter != null) {
                    this.F.packRecords(this.AspectDriverFilter.DeleteFilter);
                }
                this.F.dispose();
            }
            catch (Exception exception) {
                this.IsValid = false;
            }
        }
    }

    public void exportDriverStruct(String string) {
        if (string.equalsIgnoreCase("console")) {
            this.DriverStruct.outputFieldsForDebugging();
        } else {
            this.DriverStruct.write_to_file(string);
        }
    }

    public String getDriverID() {
        if (this.AppDriverObj != null) {
            return this.AppDriverObj.DriverID.toString();
        }
        return null;
    }

    public String getDriverParams() {
        return this.F.getDriverParams();
    }

    public String getDriverParams(int n) {
        if (this.F instanceof TConsolidatedVertDriver) {
            return ((TConsolidatedVertDriver)this.F).getDriverParams(n);
        }
        return this.F.getDriverParams();
    }

    public TFormulaEvaluator getFormulaEvaluator() {
        return this.F.getFormulaEvaluator();
    }

    public void setDriverParams(String string) {
        this.F.setDriverParams(string);
    }

    public TAspectDriverFilter getAspectDriverFilter() {
        return this.AspectDriverFilter;
    }

    public int updateSourceFile() {
        return this.F.updateSourceFile();
    }

    public boolean isModified() {
        return this.F.isModified();
    }

    public void setModified(boolean bl) {
        this.F.setModified(bl);
    }

    public Date getFileModified() {
        return this.F.getFileModified();
    }

    public boolean verifySaveChanges() {
        return this.F.verifySaveChanges();
    }

    public int executeTimerEvent(TScrollTable tScrollTable) {
        return this.F.executeTimerEvent(tScrollTable);
    }

    public boolean isValid() {
        return this.IsValid;
    }

    public boolean isWriteable() {
        return ((TAbstractDriver)this.F).isWriteable();
    }

    public int getMaxRecords() {
        return this.F.getMaxRecords();
    }

    public void createUndoManager() {
        this.F.createUndoManager();
    }

    public void f_create() {
        this.F.f_create();
        this.AspectDriverFilter.initializeFilteredList();
    }

    public void setScrollFilterTree(TScrollFilterTree tScrollFilterTree) {
        this.AspectDriverFilter.FilterTree = tScrollFilterTree;
    }

    public void setScrollSubtotalTree(TScrollSubtotalTree tScrollSubtotalTree) {
        this.AspectDriverFilter.SubtotalTree = tScrollSubtotalTree;
    }

    public Object convertFieldValueToComboboxString(TDriverStructRecord tDriverStructRecord, Object object, int n) {
        Object object2 = null;
        TComboBoxColl tComboBoxColl = this.getComboBoxColl(tDriverStructRecord.FullID, tDriverStructRecord.Formula, this.getFormulaEvaluator(), true, false, n);
        object2 = tComboBoxColl != null ? tComboBoxColl.getValueOfKey(object) : new String("");
        return object2;
    }

    public Object convertComboboxStringToFieldValue(String string, Object object, int n) {
        String string2;
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        TComboBoxColl tComboBoxColl = this.getComboBoxColl(string, tDriverStructRecord.Formula, this.getFormulaEvaluator(), false, false, n);
        if (tComboBoxColl != null && (string2 = tComboBoxColl.getKeyOfValue(object)) != null) {
            return objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string2, -1);
        }
        return null;
    }

    public TDriverStruct getDriverStruct() {
        return this.DriverStruct;
    }

    public int getFieldCount() {
        return this.AspectDriverFilter.getFieldCount();
    }

    public TAppTablesObject getAppTablesObject() {
        return this.AspectDriverFilter.ActiveAppTablesObj;
    }

    public String getDisplayName() {
        return this.AspectDriverFilter.DisplayName.toString();
    }

    public ArrayList getSupportedDriverCommands() {
        return this.F.getSupportedDriverCommands();
    }

    public boolean isDisplayOptionsFile() {
        return this.AppDriverObj.UnparsedID.equalsIgnoreCase("Driver_Displays_Columns") || this.AppDriverObj.UnparsedID.equalsIgnoreCase("Driver_Displays_Rows") || this.AppDriverObj.UnparsedID.equalsIgnoreCase("Driver_Displays_Subtotals");
    }

    public int mouseClickedOnTableHeader(int n, boolean bl) {
        int n2 = this.AspectDriverFilter.getAbsoluteFieldIndex(n);
        return this.F.mouseClickedOnTableHeader(n2, bl, this.DriverStruct);
    }

    public int getSortDirection(int n) {
        return this.AspectDriverFilter.getSortDirection(n);
    }

    public void addSortOption(int n, boolean bl) {
        this.AspectDriverFilter.addSortOption(n, bl);
    }

    public String getSortOptions() {
        return this.AspectDriverFilter.getSortOptions();
    }

    public void setSortOptions(String[] stringArray, boolean bl) {
        this.AspectDriverFilter.setSortOptions(stringArray, bl);
    }

    public void applySortAndFilter() {
        this.AspectDriverFilter.applySortAndFilter();
    }

    public void setDisplayColumns(String[] stringArray) {
        this.AspectDriverFilter.setDisplayColumns(stringArray);
    }

    public void loadDisplay(String string) {
        this.AspectDriverFilter.loadDisplay(string, true);
    }

    public void initializeFilteredList() {
        this.AspectDriverFilter.initializeFilteredList();
    }

    public synchronized boolean isDeleted(int n) {
        return this.isAbsoluteIndexDeleted(this.getAbsoluteDiskIndex(n));
    }

    public synchronized boolean isAbsoluteIndexDeleted(int n) {
        TAppDriversObject tAppDriversObject = this.F.getAppDriversObject();
        if (!(this.F instanceof TConsolidatedVertDriver) && tAppDriversObject.DeleteMask.length() == 0) {
            return false;
        }
        Integer n2 = new Integer(n);
        if (this.hashDeleted.containsKey(n2)) {
            return (Boolean)this.hashDeleted.get(n2);
        }
        boolean bl = this.F.isDeleted(n, tAppDriversObject.DeleteMask);
        this.hashDeleted.put(n2, new Boolean(bl));
        return bl;
    }

    public String getKeyValue(int n) {
        return this.F.getKeyValue(this.getAbsoluteDiskIndex(n));
    }

    public String getKeyValue(String string, int n) {
        return this.F.getKeyValue(string, this.getAbsoluteDiskIndex(n));
    }

    public String getKeyExpression() {
        return this.F.getKeyExpression();
    }

    public int getCheckSum(int n) {
        return this.F.getCheckSum(this.getAbsoluteDiskIndex(n));
    }

    public int getCheckSum(int n, String[] stringArray) {
        return this.F.getCheckSum(this.getAbsoluteDiskIndex(n), stringArray);
    }

    public void setActiveFilter(String string, boolean bl) {
        if (this.AspectDriverFilter == null) {
            MainWin.appendToLog("TAspectDriver", "setActiveFilter", Thread.currentThread(), null, 4, "AspectDriverFilter;is null in setActiveFilter for " + this.AppDriverObj.DriverID);
            return;
        }
        if (string == null) {
            MainWin.appendToLog("TAspectDriver", "setActiveFilter", Thread.currentThread(), null, 4, "AFilter;is null in setActiveFilter for " + this.AppDriverObj.DriverID);
            return;
        }
        if (!this.ApplyFilter) {
            MainWin.appendToLog("TAspectDriver", "setActiveFilter", Thread.currentThread(), null, 4, "ApplyFilter is false in setActiveFilter for " + this.AppDriverObj.DriverID);
            return;
        }
        this.AspectDriverFilter.setActiveFilter(string, bl);
    }

    public String getActiveFilter() {
        return this.AspectDriverFilter.getActiveFilter();
    }

    public synchronized boolean isInFilter(int n, StringBuilder stringBuilder) {
        if (stringBuilder.toString().equalsIgnoreCase("true")) {
            return true;
        }
        int n2 = this.getAbsoluteDiskIndex(n);
        int n3 = this.F.getRecordCount();
        if (n2 >= 0 && n2 < n3) {
            if (this.AppDriverObj.BaseFilter.trim().length() == 0) {
                return this.F.isInFilter(n2, stringBuilder);
            }
            if (this.F.isInFilter(n2, this.AppDriverObj.BaseFilter)) {
                return this.F.isInFilter(n2, stringBuilder);
            }
            return false;
        }
        if (this.SubtotalsDriver != null && n2 >= n3) {
            return this.SubtotalsDriver.isInFilter(n2, stringBuilder);
        }
        return false;
    }

    public synchronized boolean isInFilter(int n, String string) {
        return this.isInFilter(n, new StringBuilder(string));
    }

    public synchronized boolean isInFilterAbsolute(int n, StringBuilder stringBuilder) {
        int n2 = this.F.getRecordCount();
        if (n >= 0 && n < n2) {
            if (this.AppDriverObj.BaseFilter.trim().length() == 0) {
                return this.F.isInFilter(n, stringBuilder);
            }
            if (this.F.isInFilter(n, this.AppDriverObj.BaseFilter)) {
                return this.F.isInFilter(n, stringBuilder);
            }
            return false;
        }
        if (this.SubtotalsDriver != null && n >= n2) {
            return this.SubtotalsDriver.isInFilter(n, stringBuilder);
        }
        return false;
    }

    public synchronized int getMatchingRecordAbsolute(String string, int n) {
        return this.F.getMatchingRecord(string, n);
    }

    public int getMatchingRecord(String string) {
        return this.getMatchingRecord(string, 0);
    }

    public int getMatchingRecord(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = 0;
        if (n > n2) {
            n2 = n;
        }
        for (int i = n2; i < this.getRecordCount(); ++i) {
            if (this.isDeleted(i) || !this.isInFilter(i, stringBuilder)) continue;
            return i;
        }
        return -1;
    }

    public int addToFilterList(int n, int n2) {
        return this.AspectDriverFilter.addToFilterList(n, n2);
    }

    public int addToFilterList(int n) {
        return this.AspectDriverFilter.addToFilterList(n);
    }

    public int removeFromFilterList(int n) {
        return this.AspectDriverFilter.removeFromFilterList(n);
    }

    public int getFilteredIndex(int n) {
        return this.AspectDriverFilter.getFilteredIndex(n);
    }

    public int getAbsoluteDiskIndex(int n) {
        return this.AspectDriverFilter.getAbsoluteDiskIndex(n);
    }

    public int getAbsoluteFieldIndex(int n) {
        int n2 = this.AspectDriverFilter.getAbsoluteFieldIndex(n);
        return n2;
    }

    public boolean isFilterTreeNode(String string) {
        return this.DriverStruct.isFilterTreeNode(string);
    }

    public synchronized TDriverStructRecord getDriverStructRecord(int n) {
        return this.DriverStruct.getDriverStructRecord(this.getAbsoluteFieldIndex(n));
    }

    public synchronized TDriverStructRecord getDriverStructRecord(String string) {
        TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.HashDriverStruct.get(string);
        if (tDriverStructRecord != null) {
            return tDriverStructRecord;
        }
        tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            new Throwable().printStackTrace();
            MainWin.appendToLog("TAspectDriver", "getDriverStructRecord", Thread.currentThread(), null, 3, "Cannot locate field with ID=" + string + " in driver " + this.AppDriverObj.DriverID);
            System.out.println("Available fields are:");
            for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                System.out.println("Field " + i + ": [" + tDriverStructRecord2.ID + "]\t[" + tDriverStructRecord2.FullID + "]");
            }
        }
        this.HashDriverStruct.put(string, tDriverStructRecord);
        return tDriverStructRecord;
    }

    public synchronized TDriverStructRecord getDriverStructRecordFromDescription(String string) {
        return this.DriverStruct.getFieldFromDescription(string);
    }

    public String getFieldID(int n) {
        return this.DriverStruct.getFieldID(this.getAbsoluteFieldIndex(n));
    }

    public String getFieldDescription(int n) {
        int n2 = this.getAbsoluteFieldIndex(n);
        String string = this.F.getFieldDescription(n2, this.DriverStruct.getFieldDescription(n2));
        return string;
    }

    public String getFieldNotes(int n) {
        int n2 = this.getAbsoluteFieldIndex(n);
        String string = this.F.getFieldTooltip(n2, this.DriverStruct.getFieldTooltip(n2));
        return string;
    }

    public int getRecordCount() {
        return this.AspectDriverFilter.getRecordCount();
    }

    public synchronized int getAbsoluteRecordCount() {
        return this.F.getRecordCount();
    }

    public void clearBuffer() {
        this.F.clearBuffer();
        this.hashDeleted.clear();
        this.hashRangeTotals.clear();
    }

    public void clearWriteBuffer() {
        this.F.clearWriteBuffer();
    }

    public Integer getMinValue(TDriverStructRecord tDriverStructRecord, int n) {
        return this.F.getMinValue(tDriverStructRecord, this.AspectDriverFilter.getAbsoluteDiskIndex(n));
    }

    public Integer getMaxValue(TDriverStructRecord tDriverStructRecord, int n) {
        return this.F.getMaxValue(tDriverStructRecord, this.AspectDriverFilter.getAbsoluteDiskIndex(n));
    }

    public ArrayList makeCollectionOfValues(TDriverStructRecord tDriverStructRecord) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.F.getRecordCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            Object object;
            String string;
            if (this.AspectDriverFilter.DeleteFilter != null && this.isAbsoluteIndexDeleted(i) || (string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object = this.getFieldAbsolute(tDriverStructRecord, i))).length() <= 0 || (n2 = Collections.binarySearch(arrayList, string)) >= 0) continue;
            arrayList.add(Math.abs(n2 + 1), string);
        }
        return arrayList;
    }

    public boolean isSubtotalKeyDefined(TDriverStructRecord tDriverStructRecord, int n) {
        if (n < this.F.getRecordCount()) {
            return true;
        }
        if (this.SubtotalsDriver == null) {
            return true;
        }
        return this.SubtotalsDriver.isSubtotalKeyDefined(tDriverStructRecord, n - this.F.getRecordCount());
    }

    public boolean isDetail(int n) {
        return n < this.F.getRecordCount();
    }

    public boolean isSubtotal(int n) {
        return this.AspectDriverFilter.getAbsoluteDiskIndex(n) >= this.F.getRecordCount();
    }

    public int getSubtotalLevel(int n) {
        int n2;
        if (this.SubtotalsDriver == null) {
            return -1;
        }
        int n3 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        if (n3 < (n2 = this.F.getRecordCount())) {
            return -1;
        }
        return this.SubtotalsDriver.getSubtotalLevel(n3 - n2);
    }

    public int getSubtotalLevelAbsolute(int n) {
        if (this.SubtotalsDriver == null) {
            return -1;
        }
        int n2 = this.F.getRecordCount();
        if (n < n2) {
            return -1;
        }
        return this.SubtotalsDriver.getSubtotalLevel(n - n2);
    }

    public boolean isGrandTotalAbsolute(int n) {
        if (this.SubtotalsDriver == null) {
            return false;
        }
        int n2 = this.F.getRecordCount();
        if (n < n2) {
            return false;
        }
        return this.SubtotalsDriver.isGrandTotal(n - n2);
    }

    public boolean isFieldDefined(String string) {
        return this.F.isFieldDefined(string);
    }

    public synchronized Object getField(String string, int n) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            return null;
        }
        return this.getField(tDriverStructRecord, n);
    }

    public static void clearFieldProfileHashtable() {
        hashProfileGetField.clear();
    }

    public static void writeGetFieldProfile() {
        Object object;
        String string = TMainWin.Application.getTemporaryFiles() + "getFieldProfile.$$$";
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = hashProfileGetField.keys();
        while (enumeration.hasMoreElements()) {
            object = (TProfilegetFieldObj)hashProfileGetField.get(enumeration.nextElement());
            stringBuilder.append(((TProfilegetFieldObj)object).toString() + "\r\n");
        }
        object = new byte[stringBuilder.length()];
        for (int i = 0; i < stringBuilder.length(); ++i) {
            object[i] = (byte)stringBuilder.charAt(i);
        }
        try {
            TFile tFile = new TFile(string);
            tFile.validatePathToFile(true);
            if (tFile.exists()) {
                tFile.delete();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rwd");
            randomAccessFile.write((byte[])object);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println("TAspectDriver.writeGetFieldProfile: " + exception);
        }
    }

    public synchronized void recordFieldProfile(String string, String string2, boolean bl, long l) {
        TProfilegetFieldObj tProfilegetFieldObj;
        if (!bProfileGetField) {
            return;
        }
        if (this.F.getAppDriversObject() == null) {
            return;
        }
        String string3 = this.F.getAppDriversObject().DriverID.toString().toUpperCase() + "|" + string2 + "|" + bl + "|" + string.toUpperCase();
        if (hashProfileGetField.containsKey(string3)) {
            tProfilegetFieldObj = (TProfilegetFieldObj)hashProfileGetField.get(string3);
        } else {
            tProfilegetFieldObj = new TProfilegetFieldObj(this.F.getAppDriversObject().DriverID.toString(), string2, bl, string);
            hashProfileGetField.put(string3, tProfilegetFieldObj);
        }
        ++tProfilegetFieldObj.Count;
        tProfilegetFieldObj.Duration = (int)((long)tProfilegetFieldObj.Duration + l);
    }

    public synchronized Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        long l;
        Object object = null;
        int n2 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        int n3 = this.F.getRecordCount();
        long l2 = l = bProfileGetField ? new Date().getTime() : 0L;
        if (n2 >= 0 && n2 < n3) {
            object = tDriverStructRecord.External_Data_Is_External ? this.F.getExternalData(tDriverStructRecord, n2) : this.F.getField(tDriverStructRecord, n2);
        } else if (this.SubtotalsDriver != null && n2 >= n3) {
            object = this.SubtotalsDriver.getField(tDriverStructRecord, n2 - n3);
            if (object == null) {
                // empty if block
            }
            if (tDriverStructRecord.CalcSubtotal || object instanceof String) {
                // empty if block
            }
        }
        if (object instanceof String && tDriverStructRecord.FormatPattern.length() > 0) {
            if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("lowercase")) {
                object = ((String)object).toLowerCase();
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("uppercase")) {
                object = ((String)object).toUpperCase();
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("titlecase")) {
                object = charutil.toTitleCase((String)object);
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("sentencecase")) {
                object = charutil.toSentenceCase((String)object);
            }
        }
        if (bProfileGetField) {
            this.recordFieldProfile(tDriverStructRecord.FullID, "getField", false, new Date().getTime() - l);
        }
        return object;
    }

    public synchronized Object getField(int n, int n2) {
        Object object = null;
        int n3 = this.AspectDriverFilter.getAbsoluteFieldIndex(n2);
        if (n3 < 0 || n3 >= this.DriverStruct.FieldColl.size()) {
            System.out.println("FieldIndex=" + n3 + " ARecordIndex=" + n + " AFieldIndex=" + n2 + " Driverstruct size=" + this.DriverStruct.FieldColl.size());
        }
        TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n3);
        int n4 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        int n5 = this.F.getRecordCount();
        if (n4 >= 0 && n4 < n5) {
            object = this.F.getFieldForTable(tDriverStructRecord, n4);
            if (object == null) {
                return objectutil.getErrorValue(tDriverStructRecord.FieldType);
            }
        } else if (this.SubtotalsDriver != null && n4 >= n5) {
            object = this.SubtotalsDriver.getField(tDriverStructRecord, n4 - n5);
            if (object == null) {
                // empty if block
            }
            if (!tDriverStructRecord.CalcSubtotal && object instanceof String) {
                object = this.SubtotalsDriver.formatDisplayString(n4 - n5, (String)object);
            }
        }
        if (tDriverStructRecord.IsLookup) {
            if (this.getFormulaEvaluator() != null) {
                this.getFormulaEvaluator().setAltRecordNumber(n4);
            }
            Object object2 = object;
            if ((object = this.convertFieldValueToComboboxString(tDriverStructRecord, object, n)) == null) {
                object = object2 == null ? new String("") : object2.toString();
            }
        }
        if (object instanceof String && tDriverStructRecord.FormatPattern.length() > 0) {
            if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("lowercase")) {
                object = ((String)object).toLowerCase();
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("uppercase")) {
                object = ((String)object).toUpperCase();
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("titlecase")) {
                object = charutil.toTitleCase((String)object);
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("sentencecase")) {
                object = charutil.toSentenceCase((String)object);
            }
        }
        return object;
    }

    public synchronized Object getFieldAbsoluteWithLookup(TDriverStructRecord tDriverStructRecord, int n) {
        return this.getFieldAbsolute(tDriverStructRecord, n);
    }

    public synchronized Object getFieldForHtml(TDriverStructRecord tDriverStructRecord, int n) {
        return this.getFieldForHtml(tDriverStructRecord, n, false);
    }

    public synchronized Object getFieldForHtml(TDriverStructRecord tDriverStructRecord, int n, boolean bl) {
        Object object;
        long l;
        Object object2 = null;
        int n2 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        int n3 = this.F.getRecordCount();
        boolean bl2 = false;
        long l2 = l = bProfileGetField ? new Date().getTime() : 0L;
        if (tDriverStructRecord.Html.length() > 0 && !bl) {
            bl2 = true;
        }
        if (n2 >= 0 && n2 < n3) {
            if (bl2) {
                object = new Date();
                if (this.F instanceof TConsolidatedVertDriver) {
                    TFormulaEvaluator tFormulaEvaluator = ((TConsolidatedVertDriver)this.F).getFormulaEvaluator(n2);
                    int n4 = ((TConsolidatedVertDriver)this.F).geTEmbeddedDriverRecord(n2);
                    object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.Html, n4, n);
                } else if (this.F instanceof TConsolidatedHorzDriver) {
                    TFormulaEvaluator tFormulaEvaluator = ((TConsolidatedHorzDriver)this.F).getFormulaEvaluator(tDriverStructRecord, n2);
                    if (tFormulaEvaluator != null) {
                        int n5 = ((TConsolidatedHorzDriver)this.F).getEmbeddedDriverRecord(tDriverStructRecord, n2);
                        if (n5 >= 0) {
                            object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.Html, n5, n);
                        } else {
                            System.out.println("getEmbeddedDriverRecord from " + this.F.getAppDriversObject().DriverID.toString() + " for ID=" + tDriverStructRecord.FullID + " r=" + n2 + " returns " + n5);
                        }
                    } else {
                        tFormulaEvaluator = this.F.getFormulaEvaluator();
                        object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.Html, n2, n);
                    }
                } else if (this.F instanceof TDimensionalDriver) {
                    int[] nArray = ((TDimensionalDriver)this.F).getEmbeddedFieldIndex(tDriverStructRecord, n2);
                    if (nArray.length == 0) {
                        TFormulaEvaluator tFormulaEvaluator = this.F.getFormulaEvaluator();
                        object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.Html, n2, n);
                    } else if (nArray.length == 1) {
                        TFormulaEvaluator tFormulaEvaluator = ((TDimensionalDriver)this.F).dEmbed.getFormulaEvaluator();
                        object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.Html, nArray[0], n);
                    } else {
                        object2 = ((TDimensionalDriver)this.F).getConsolidatedValue(tDriverStructRecord, n2, nArray);
                    }
                } else {
                    TFormulaEvaluator tFormulaEvaluator = this.F.getFormulaEvaluator();
                    object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.Html, n2, n);
                }
                ++tDriverStructRecord.cFormatHtml;
                tDriverStructRecord.cFormatHtmlMs = (int)((long)tDriverStructRecord.cFormatHtmlMs + (new Date().getTime() - ((Date)object).getTime()));
            } else {
                object2 = tDriverStructRecord.External_Data_Is_External ? this.F.getExternalData(tDriverStructRecord, n2) : this.F.getField(tDriverStructRecord, n2);
            }
        } else if (this.SubtotalsDriver != null && n2 >= n3 && (object2 = this.SubtotalsDriver.getField(tDriverStructRecord, n2 - n3)) != null && bl2) {
            object = this.SubtotalsDriver.getFormulaEvaluator();
            object2 = ((TFormulaEvaluator)object).getFormulaValue(tDriverStructRecord.Html, n2 - n3, n2 - n3);
        }
        if (tDriverStructRecord.IsLookup && !bl2) {
            if (this.getFormulaEvaluator() != null) {
                this.getFormulaEvaluator().setAltRecordNumber(n2);
            }
            object = object2;
            if ((object2 = this.convertFieldValueToComboboxString(tDriverStructRecord, object2, n)) == null) {
                object2 = object == null ? new String("") : object.toString();
            }
        }
        Object object3 = object = this.F instanceof TTransposeDriver ? ((TTransposeDriver)this.F).getPattern(n2) : tDriverStructRecord.FormatPattern;
        if (((String)object).length() > 0) {
            object2 = objectutil.isNumberField(tDriverStructRecord.FieldType) && objectutil.isZero(object2) && tDriverStructRecord.SuppressZeros ? "" : objectutil.applyPattern(object2, (String)object);
        }
        if (bProfileGetField) {
            this.recordFieldProfile(tDriverStructRecord.FullID, "getFieldForHtml", n2 >= n3, new Date().getTime() - l);
        }
        return object2;
    }

    public synchronized Object getHtmlForSection(TDriverStructRecord tDriverStructRecord, int n, boolean bl) {
        Object object;
        Object object2 = null;
        int n2 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        int n3 = this.F.getRecordCount();
        boolean bl2 = false;
        String string = "";
        if (bl && tDriverStructRecord.HtmlSectionStart.length() > 0) {
            bl2 = true;
            string = tDriverStructRecord.HtmlSectionStart;
        }
        if (n2 >= 0 && n2 < n3) {
            if (bl2) {
                if (this.F instanceof TConsolidatedVertDriver) {
                    object = ((TConsolidatedVertDriver)this.F).getFormulaEvaluator(n2);
                    int n4 = ((TConsolidatedVertDriver)this.F).geTEmbeddedDriverRecord(n2);
                    object2 = ((TFormulaEvaluator)object).getFormulaValue(string, n4, n);
                } else if (this.F instanceof TConsolidatedHorzDriver) {
                    object = ((TConsolidatedHorzDriver)this.F).getFormulaEvaluator(tDriverStructRecord, n2);
                    if (object != null) {
                        int n5 = ((TConsolidatedHorzDriver)this.F).getEmbeddedDriverRecord(tDriverStructRecord, n2);
                        if (n5 >= 0) {
                            object2 = ((TFormulaEvaluator)object).getFormulaValue(string, n5, n);
                        } else {
                            System.out.println("getEmbeddedDriverRecord from " + this.F.getAppDriversObject().DriverID.toString() + " for ID=" + tDriverStructRecord.FullID + " r=" + n2 + " returns " + n5);
                        }
                    } else {
                        object = this.F.getFormulaEvaluator();
                        object2 = ((TFormulaEvaluator)object).getFormulaValue(string, n2, n);
                    }
                } else {
                    object = this.F.getFormulaEvaluator();
                    object2 = ((TFormulaEvaluator)object).getFormulaValue(string, n2, n);
                }
            } else {
                object2 = this.F.getField(tDriverStructRecord, n2);
            }
        } else if (this.SubtotalsDriver != null && n2 >= n3) {
            if (bl2) {
                object = this.SubtotalsDriver.getFormulaEvaluator();
                object2 = ((TFormulaEvaluator)object).getFormulaValue(string, n2 - n3, -1);
            } else {
                object2 = this.SubtotalsDriver.getField(tDriverStructRecord, n2 - n3);
            }
        }
        if (tDriverStructRecord.IsLookup && !bl2) {
            if (this.getFormulaEvaluator() != null) {
                this.getFormulaEvaluator().setAltRecordNumber(n2);
            }
            object = object2;
            if ((object2 = this.convertFieldValueToComboboxString(tDriverStructRecord, object2, n)) == null) {
                object2 = object == null ? new String("") : object.toString();
            }
        }
        if (tDriverStructRecord.FormatPattern.length() > 0) {
            object2 = objectutil.applyPattern(object2, tDriverStructRecord.FormatPattern);
        }
        return object2;
    }

    public synchronized Object getFieldForHtmlAbsolute(TDriverStructRecord tDriverStructRecord, int n) {
        Object object;
        long l;
        Object object2 = null;
        int n2 = n;
        int n3 = this.F.getRecordCount();
        boolean bl = false;
        long l2 = l = bProfileGetField ? new Date().getTime() : 0L;
        if (tDriverStructRecord.Html.length() > 0) {
            bl = true;
        }
        if (n2 >= 0 && n2 < n3) {
            if (bl) {
                object = this.F.getFormulaEvaluator();
                if (this.F instanceof TConsolidatedVertDriver) {
                    object = ((TConsolidatedVertDriver)this.F).getFormulaEvaluator(n2);
                }
                object2 = ((TFormulaEvaluator)object).getFormulaValue(tDriverStructRecord.Html, n2, n);
            } else {
                object2 = this.F.getField(tDriverStructRecord, n2);
            }
        } else if (this.SubtotalsDriver != null && n2 >= n3) {
            object2 = this.SubtotalsDriver.getField(tDriverStructRecord, n2 - n3);
            if (object2 == null) {
                // empty if block
            }
            if (tDriverStructRecord.CalcSubtotal || object2 instanceof String) {
                // empty if block
            }
        }
        if (tDriverStructRecord.IsLookup && !bl) {
            if (this.getFormulaEvaluator() != null) {
                this.getFormulaEvaluator().setAltRecordNumber(n2);
            }
            object = object2;
            if ((object2 = this.convertFieldValueToComboboxString(tDriverStructRecord, object2, n)) == null) {
                object2 = object == null ? new String("") : object.toString();
            }
        }
        if (tDriverStructRecord.FormatPattern.length() > 0) {
            object2 = objectutil.applyPattern(object2, tDriverStructRecord.FormatPattern);
        }
        if (bProfileGetField) {
            this.recordFieldProfile(tDriverStructRecord.FullID, "getFieldForHtmlAbsolute", n2 >= n3, new Date().getTime() - l);
        }
        return object2;
    }

    public synchronized Object getFieldAbsolute(String string, int n) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            return null;
        }
        return this.getFieldAbsolute(tDriverStructRecord, n);
    }

    public synchronized Object getFieldAbsolute(TDriverStructRecord tDriverStructRecord, int n) {
        long l;
        Object object = null;
        if (tDriverStructRecord == null) {
            return object;
        }
        long l2 = l = bProfileGetField ? new Date().getTime() : 0L;
        if (n < this.F.getRecordCount()) {
            object = tDriverStructRecord.External_Data_Is_External ? this.F.getExternalData(tDriverStructRecord, n) : this.F.getField(tDriverStructRecord, n);
        } else if (this.SubtotalsDriver != null) {
            object = this.SubtotalsDriver.getField(tDriverStructRecord, n - this.F.getRecordCount());
        }
        if (object instanceof String && tDriverStructRecord.FormatPattern.length() > 0) {
            if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("lowercase")) {
                object = ((String)object).toLowerCase();
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("uppercase")) {
                object = ((String)object).toUpperCase();
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("titlecase")) {
                object = charutil.toTitleCase((String)object);
            } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("sentencecase")) {
                object = charutil.toSentenceCase((String)object);
            }
        }
        if (bProfileGetField) {
            this.recordFieldProfile(tDriverStructRecord.FullID, "getFieldAbsolute", n < this.F.getRecordCount(), new Date().getTime() - l);
        }
        return object;
    }

    public synchronized int putField(String string, int n, Object object) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            MainWin.appendToLog("TAspectDriver", "putField", Thread.currentThread(), null, 4, "Attempt to write to an invalid field: " + string);
            return -1;
        }
        return this.putField(tDriverStructRecord, n, object);
    }

    public synchronized int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        int n2 = -1;
        if (tDriverStructRecord == null) {
            System.out.println("TAspectDriver.putField(TDriverStructRecord,int,Object) - attempting to put a field to an invalid field ID");
            return n2;
        }
        if (object != null) {
            int n3 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
            if (tDriverStructRecord.External_Data_Is_External) {
                System.out.println("TAspectDriver calling putExternalData for Field ID=" + tDriverStructRecord.FullID);
                n2 = this.F.putExternalData(tDriverStructRecord, n3, object) ? 1 : 0;
            } else {
                n2 = this.F.putField(tDriverStructRecord, n3, object);
            }
            if (this.DSRecLastModified != null) {
                this.F.putField(this.DSRecLastModified, n3, (Object)new Date());
            }
        }
        return n2;
    }

    public synchronized int putField(int n, int n2, Object object) {
        int n3 = -1;
        int n4 = -1;
        int n5 = this.AspectDriverFilter.getAbsoluteFieldIndex(n2);
        TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n5);
        n3 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        if (tDriverStructRecord == null) {
            System.out.println("TAspectDriver.putField(int,int,Object) - attempting to put a field to an invalid field ID");
            return n4;
        }
        if (n3 < 0) {
            return n4;
        }
        if (tDriverStructRecord.IsUniqueBoolean && !tDriverStructRecord.IsCalculated && !tDriverStructRecord.IsToken && object instanceof Boolean && ((Boolean)object).booleanValue()) {
            Boolean bl = new Boolean(false);
            int n6 = this.F.getRecordCount();
            for (int i = 0; i < n6; ++i) {
                this.F.putField(tDriverStructRecord, i, (Object)bl);
            }
            n4 = 1;
        }
        n4 = tDriverStructRecord.External_Data_Is_External ? (this.F.putExternalData(tDriverStructRecord, n3, object) ? 1 : 0) : this.F.putField(tDriverStructRecord, n3, object);
        this.hashDeleted.remove(new Integer(n3));
        this.hashRangeTotals.clear();
        if (this.DSRecLastModified != null) {
            this.F.putField(this.DSRecLastModified, n3, (Object)new Date());
        }
        return n4;
    }

    public synchronized int putFieldAbsolute(String string, int n, Object object) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            MainWin.appendToLog("TAspectDriver", "putFieldAbsolute", Thread.currentThread(), null, 4, "Error: Invalid field ID in putFieldAbsolute(): " + string + " in driver: " + this.AppDriverObj.DriverID);
            return -1;
        }
        int n2 = this.putFieldAbsolute(tDriverStructRecord, n, object);
        return n2;
    }

    public synchronized int putFieldAbsolute(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        int n2 = -1;
        if (object != null) {
            if (tDriverStructRecord.External_Data_Is_External) {
                System.out.println("TAspectDriver calling putExternalData for Field ID=" + tDriverStructRecord.FullID);
                n2 = this.F.putExternalData(tDriverStructRecord, n, object) ? 1 : 0;
            } else {
                n2 = this.F.putField(tDriverStructRecord, n, object);
            }
            this.hashDeleted.remove(new Integer(n));
            this.hashRangeTotals.clear();
            if (this.DSRecLastModified != null) {
                this.F.putField(this.DSRecLastModified, n, (Object)new Date());
            }
        }
        return n2;
    }

    public synchronized Object offset(int n, int n2, String string, boolean bl, int n3) {
        int n4;
        int n5;
        int n6;
        boolean bl2;
        int n7;
        int n8 = n7 = bl ? this.getAbsoluteRecordCount() : this.getRecordCount();
        if (n7 != this.HashOffsetRecordCount) {
            if (this.hashOffset != null) {
                Enumeration enumeration = this.hashOffset.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    ArrayList arrayList = (ArrayList)this.hashOffset.get(k);
                    arrayList.clear();
                    this.hashOffset.remove(k);
                }
            }
            this.HashOffsetRecordCount = n7;
        }
        if (bl2 = false) {
            System.out.println("offset(" + n + "," + n2 + "," + string + "," + bl + ") started");
        }
        if (bl) {
            n6 = n + n2;
            if (bl2) {
                System.out.println("TargetRecord=" + n6);
            }
        } else {
            int n9 = this.getFilteredIndex(n);
            if (n9 < 0 && n3 >= 0) {
                n9 = n3;
            }
            n6 = n9 + n2;
            if (bl2) {
                System.out.println("getFilteredIndex(Record)=" + this.getFilteredIndex(n) + " TargetRecord=" + n6);
            }
        }
        String string2 = string;
        if (bl) {
            string2 = string2 + "Absolute";
        }
        if (n2 < 0) {
            string2 = string2 + "Negative";
        }
        ArrayList arrayList = null;
        if (this.hashOffset == null) {
            this.hashOffset = new Hashtable();
            arrayList = new ArrayList();
            this.hashOffset.put(string2, arrayList);
        } else if (this.hashOffset.containsKey(string2)) {
            arrayList = (ArrayList)this.hashOffset.get(string2);
        } else {
            arrayList = new ArrayList();
            this.hashOffset.put(string2, arrayList);
        }
        if (n2 < 0) {
            n5 = n6 + 1;
            n4 = n6;
        } else {
            n5 = n7 - n6;
            n4 = n7 - n6 - 1;
        }
        TDriverStructRecord tDriverStructRecord = this.getDriverStructRecord(string.toUpperCase());
        if (tDriverStructRecord == null) {
            tDriverStructRecord = this.getDriverStructRecordFromDescription(string.toUpperCase());
        }
        if (tDriverStructRecord == null) {
            Object e = null;
            while (arrayList.size() <= n5) {
                arrayList.add(e);
            }
            System.out.println("offset cannot find field " + string);
            return e;
        }
        if (n6 < 0) {
            if (bl2) {
                System.out.println("offset(" + n + "," + n2 + "," + string + "," + bl + ") returns errorvalue1: " + objectutil.getErrorValue(tDriverStructRecord.FieldType));
            }
            return objectutil.getErrorValue(tDriverStructRecord.FieldType);
        }
        if (n6 >= n7) {
            if (bl2) {
                System.out.println("offset(" + n + "," + n2 + "," + string + "," + bl + ") returns errorvalue2: " + objectutil.getErrorValue(tDriverStructRecord.FieldType));
            }
            return objectutil.getErrorValue(tDriverStructRecord.FieldType);
        }
        if (arrayList.size() > n4) {
            if (bl2) {
                System.out.println("offset(" + n + "," + n2 + "," + string + "," + bl + ") returns cache value: " + arrayList.get(n4));
            }
            return arrayList.get(n4);
        }
        if (bl2) {
            System.out.println("***offset a.size=" + arrayList.size() + " RecordCount=" + n7 + " Record=" + n + " TargetRecord=" + n6 + " Absolute=" + bl + " RequiredElements=" + n5 + " TargetElement=" + n4);
        }
        Object object = null;
        while (arrayList.size() < n5) {
            int n10 = n2 < 0 ? arrayList.size() : n7 - arrayList.size() - 1;
            object = bl ? this.getFieldAbsolute(tDriverStructRecord, n10) : this.getField(tDriverStructRecord, n10);
            object = TFormulaEvaluator.convertFieldTypeToFormulaType(object);
            if (bl2) {
                System.out.println("add a.size=" + arrayList.size() + " Index=" + n10);
            }
            arrayList.add(object);
        }
        if (bl2) {
            System.out.println("offset(" + n + "," + n2 + "," + string + "," + bl + ") returns " + arrayList.get(n4));
        }
        return arrayList.get(n4);
    }

    public synchronized String copyDriver(TAspectDriver tAspectDriver) {
        return this.F.copyDriver(tAspectDriver.F, null, null);
    }

    public synchronized String copyDriver(TAspectDriver tAspectDriver, String[] stringArray, String[] stringArray2) {
        return this.F.copyDriver(tAspectDriver.F, stringArray, stringArray2);
    }

    public int copyRecordToDriver(int n, TAspectDriver tAspectDriver, int n2) {
        int n3 = n2;
        if (n3 < 0) {
            n3 = tAspectDriver.initializeNewRecord();
        }
        if ((this.F instanceof TBinaryBuffer || this.F instanceof TBinaryFile) && (tAspectDriver.F instanceof TBinaryBuffer || tAspectDriver.F instanceof TBinaryFile)) {
            if (this.F.getMode() == 1) {
                this.F.clearWriteBuffer();
            }
            tAspectDriver.F.putRecord(n3, this.F.getRecord(n));
            return n3;
        }
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            Object object;
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            TDriverStructRecord tDriverStructRecord2 = tAspectDriver.DriverStruct.getField(tDriverStructRecord.ID);
            if (tDriverStructRecord2 == null || tDriverStructRecord2.IsVirtual || tDriverStructRecord2.IsCalculated || tDriverStructRecord2.IsToken || (object = this.F.getField(tDriverStructRecord, n)) == null) continue;
            if (tDriverStructRecord.FieldType != tDriverStructRecord2.FieldType) {
                String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
                Object object2 = objectutil.convertStringToFieldType(tDriverStructRecord2.FieldType, string, n3);
                tAspectDriver.F.putField(tDriverStructRecord2, n3, object2);
                continue;
            }
            tAspectDriver.F.putField(tDriverStructRecord2, n3, object);
        }
        return n3;
    }

    public synchronized int initializeNewRecord() {
        if (this.AppDriverObj == null) {
            return this.initializeNewRecord(1, 0);
        }
        return this.initializeNewRecord(this.AppDriverObj.InsertMode, 0);
    }

    public synchronized int initializeNewRecord(int n, int n2) {
        if (this.F instanceof TTokenDriver) {
            return 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        n3 = this.F.initializeNewRecord(false);
        TFormulaEvaluator tFormulaEvaluator = this.F.getFormulaEvaluator();
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (tDriverStructRecord.IsVirtual || tDriverStructRecord.DefaultOnInsert.length() <= 0 || this.F instanceof TOdbcDatabase && tDriverStructRecord.KeyField) continue;
            stringBuilder.setLength(0);
            Object object = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.DefaultOnInsert, n3, n2);
            if (object != null) {
                stringBuilder.append(TFormulaEvaluator.convertToString(object));
            }
            Object object2 = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, stringBuilder.toString(), n3);
            this.F.putField(tDriverStructRecord, n3, object2);
        }
        return n3;
    }

    public int deleteRecord(int n) {
        int n2 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        return this.deleteRecordAbsolute(n2);
    }

    public int deleteRecordAbsolute(int n) {
        for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
            Object object;
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
            if (this.F instanceof TOdbcDatabase) {
                if (tDriverStructRecord.KeyField) continue;
                object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, tDriverStructRecord.DefaultOnDelete, n);
                this.F.putField(tDriverStructRecord, n, object);
                continue;
            }
            if (tDriverStructRecord.External_Data_Is_External) {
                System.out.println("TAspectDriver foundexternal data: " + tDriverStructRecord.FullID);
                if (tDriverStructRecord.External_Data_Filename.trim().length() != 0) continue;
                System.out.println("TAspectDriver deleting external data: " + tDriverStructRecord.FullID);
                this.F.deleteExternalData(tDriverStructRecord, n);
                continue;
            }
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, tDriverStructRecord.DefaultOnDelete, n);
            this.F.putField(tDriverStructRecord, n, object);
        }
        this.hashDeleted.remove(new Integer(n));
        this.hashRangeTotals.clear();
        this.F.notifyRecordDelete();
        return 1;
    }

    public int deleteActiveRecords() {
        int n = 0;
        int n2 = this.getRecordCount();
        for (int i = 0; i < n2; ++i) {
            this.deleteRecord(i);
            ++n;
        }
        return n;
    }

    public void swapRecords(int n, int n2) {
        int n3 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        int n4 = this.AspectDriverFilter.getAbsoluteDiskIndex(n2);
        this.F.swapRecords(n3, n4);
    }

    public void swapVirtualIndexField(int n, int n2) {
        TDriverStructRecord tDriverStructRecord = this.getVirtualIndexField();
        if (tDriverStructRecord != null) {
            int n3 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
            int n4 = this.AspectDriverFilter.getAbsoluteDiskIndex(n2);
            Integer n5 = (Integer)this.getFieldAbsolute(tDriverStructRecord, n3);
            Integer n6 = (Integer)this.getFieldAbsolute(tDriverStructRecord, n4);
            this.putFieldAbsolute(tDriverStructRecord, n3, (Object)n6);
            this.putFieldAbsolute(tDriverStructRecord, n4, (Object)n5);
        }
    }

    public String executeDriverCommand(JComponent jComponent, String string, String string2) {
        return this.F.executeDriverCommand(jComponent, string, string2);
    }

    public boolean isDriverCmdRunning(String string) {
        return this.F.isDriverCmdRunning(string);
    }

    public void sendDriverCmdMsg(String string, String string2) {
        this.F.sendDriverCmdMsg(string, string2);
    }

    public void beginNewUndoOperation(String string) {
        this.F.beginNewUndoOperation(string);
    }

    public void setUndoRecording(boolean bl) {
        this.F.setUndoRecording(bl);
    }

    public void removeLastUndo() {
        this.F.removeLastUndo();
    }

    public void undo() {
        this.F.undo();
        this.initializeFilteredList();
    }

    public void redo() {
        this.F.redo();
        this.initializeFilteredList();
    }

    public double[] calcRangeTotals(String string, boolean bl, String string2, int n, int n2) {
        return this.calcRangeTotals(new StringBuilder(string), bl, string2, n, n2);
    }

    public double[] calcRangeTotals(StringBuilder stringBuilder, boolean bl, String string, int n, int n2) {
        TDriverStructRecord tDriverStructRecord;
        double[] dArray = new double[10];
        boolean bl2 = true;
        StringBuilder stringBuilder2 = new StringBuilder(string);
        String string2 = stringBuilder + "|" + bl + "|" + string + "|" + n + "|" + n2;
        Object object = this.hashRangeTotals.get(string2);
        if (object != null) {
            return (double[])object;
        }
        if (string.trim().length() == 0) {
            bl2 = false;
        }
        if ((tDriverStructRecord = this.DriverStruct.getField(stringBuilder)) != null) {
            double d;
            int n3 = this.getRecordCount();
            if (bl) {
                n3 = this.F.getRecordCount();
            }
            int n4 = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double[] dArray2 = new double[n3];
            int n5 = n < 0 ? 0 : n;
            int n6 = n2 < 0 ? n3 : n2 + 1;
            boolean bl3 = false;
            for (int i = n5; i < n6; ++i) {
                int n7 = i;
                if (!bl) {
                    n7 = this.AspectDriverFilter.getAbsoluteDiskIndex(i);
                }
                if (bl2 && (!this.F.isInFilter(n7, stringBuilder2) || this.isAbsoluteIndexDeleted(n7))) continue;
                object = this.getFieldAbsolute(tDriverStructRecord, n7);
                dArray2[i - n5] = d = objectutil.convertToNumber(object);
                dArray[0] = dArray[0] + 1.0;
                dArray[1] = dArray[1] + d;
                if (i == 0) {
                    dArray[6] = d;
                }
                if (i == n3 - 1) {
                    dArray[7] = d;
                }
                if (!bl3) {
                    dArray[4] = d;
                    dArray[5] = d;
                    bl3 = true;
                } else {
                    dArray[4] = Math.min(dArray[4], d);
                    dArray[5] = Math.max(dArray[5], d);
                }
                d2 += d;
                d3 += (double)(++n4);
                d5 += (double)n4 * d;
                d4 += (double)(n4 * n4);
            }
            double d6 = (double)n4 * d5 - d3 * d2;
            d = (double)n4 * d4 - d3 * d3;
            double d7 = d == 0.0 ? 0.0 : d6 / d;
            double d8 = n4 == 0 ? 0.0 : (d2 - d7 * d3) / (double)n4;
            dArray[8] = d7;
            dArray[9] = d8;
            dArray[3] = statistics.stddev(dArray2, n4);
        } else {
            System.out.println("Invalid field ID in calcRangeTotals: " + stringBuilder);
        }
        dArray[2] = charutil.divby(dArray[1], dArray[0]);
        this.hashRangeTotals.put(string2, dArray);
        return dArray;
    }

    public double calcCorrelaiton(String string, String string2, boolean bl, String string3, int n, int n2, int n3) {
        Object object;
        boolean bl2 = string3.trim().length() != 0;
        StringBuilder stringBuilder = new StringBuilder(string3);
        String string4 = string + "|" + string2 + "|" + bl + "|" + string3 + "|" + n + "|" + n2;
        if (this.hashCorrelation != null && (object = this.hashCorrelation.get(string4)) != null) {
            return (Double)object;
        }
        object = this.DriverStruct.getField(string);
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string2);
        if (object != null && tDriverStructRecord != null) {
            int n4;
            int n5 = bl ? this.F.getRecordCount() : this.getRecordCount();
            int n6 = n < 0 ? 0 : n;
            int n7 = n2 < 0 ? n5 : n2 + 1;
            double[] dArray = new double[n7 - n6 + 1];
            double[] dArray2 = new double[n7 - n6 + 1];
            int n8 = 0;
            for (n4 = n6; n4 < n7; ++n4) {
                int n9;
                int n10 = n9 = bl ? n4 : this.AspectDriverFilter.getAbsoluteDiskIndex(n4);
                if (n3 != 0) {
                    n10 = bl ? (n10 += n3) : this.AspectDriverFilter.getAbsoluteDiskIndex(n4 + n3);
                }
                if (bl2 && (!this.F.isInFilter(n9, stringBuilder) || this.isAbsoluteIndexDeleted(n9))) continue;
                Object object2 = this.getFieldAbsolute((TDriverStructRecord)object, n9);
                Object object3 = this.getFieldAbsolute(tDriverStructRecord, n10);
                double d = objectutil.convertToNumber(object2);
                double d2 = objectutil.convertToNumber(object3);
                dArray[n8] = d;
                dArray2[n8] = d2;
                ++n8;
            }
            if (n7 - n6 < 5) {
                System.out.println("calcCorrelaiton FieldID1=" + string + " FiueldID2=" + string2 + " IsAbsolute=" + bl + " AFilter=" + string3 + " RecordStart=" + n + " RecordEnd=" + n2);
                for (n4 = 0; n4 < n8; ++n4) {
                    System.out.print("\tv1[" + n4 + "]=" + dArray[n4]);
                }
                System.out.println();
                for (n4 = 0; n4 < n8; ++n4) {
                    System.out.print("\tv2[" + n4 + "]=" + dArray2[n4]);
                }
                System.out.println();
            }
            double d = statistics.correlation(dArray, dArray2, n8);
            if (this.hashCorrelation == null) {
                this.hashCorrelation = new Hashtable();
            }
            this.hashCorrelation.put(string4, new Double(d));
            return d;
        }
        if (object == null) {
            System.out.println("Invalid field ID in calcCorrelaiton: " + string);
        }
        if (tDriverStructRecord == null) {
            System.out.println("Invalid field ID in calcCorrelaiton: " + string2);
        }
        return -1.0;
    }

    public synchronized double calculateLinearTrendForSubtotal(String string, int n, int n2, char c) {
        double d;
        if (this.SubtotalsDriver == null) {
            return 0.0;
        }
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            return 0.0;
        }
        int n3 = this.F.getRecordCount();
        int n4 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = 0;
        for (int i = 0; i < this.getRecordCount(); ++i) {
            int n6;
            Object object;
            if (this.getSubtotalLevel(i) != n || (object = this.SubtotalsDriver.getField(tDriverStructRecord, (n6 = this.AspectDriverFilter.getAbsoluteDiskIndex(i)) - n3)) == null) continue;
            double d6 = objectutil.convertToNumber(object);
            d2 += d6;
            d3 += (double)(++n4);
            d5 += (double)n4 * d6;
            d4 += (double)(n4 * n4);
            if (n6 - n3 != n2) continue;
            n5 = n4;
        }
        double d7 = (double)n4 * d5 - d3 * d2;
        double d8 = (double)n4 * d4 - d3 * d3;
        double d9 = d8 == 0.0 ? 0.0 : d7 / d8;
        double d10 = d = n4 == 0 ? 0.0 : (d2 - d9 * d3) / (double)n4;
        if (c == 'M') {
            return d9;
        }
        if (c == 'B') {
            return d;
        }
        double d11 = d9 * (double)n5 + d;
        return d11;
    }

    public Hashtable getHashComboBoxColl() {
        return this.F.getHashComboBoxColl();
    }

    public void setHashComboBoxColl(Hashtable hashtable) {
        this.F.setHashComboBoxColl(hashtable);
    }

    public void initCollections() {
        this.F.initCollections();
    }

    public TComboBoxColl getComboBoxColl(String string, String string2, TFormulaEvaluator tFormulaEvaluator, boolean bl, boolean bl2, int n) {
        int n2 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        return this.F.getComboBoxColl(string, new StringBuilder(string2), tFormulaEvaluator, bl, false, n2);
    }

    public TComboBoxColl getComboBoxColl(String string, StringBuilder stringBuilder, TFormulaEvaluator tFormulaEvaluator, boolean bl, boolean bl2, int n) {
        int n2 = this.AspectDriverFilter.getAbsoluteDiskIndex(n);
        return this.F.getComboBoxColl(string, stringBuilder, tFormulaEvaluator, bl, bl2, n2);
    }

    public TComboBoxColl getComboBoxColl(String string, String string2, TFormulaEvaluator tFormulaEvaluator, boolean bl, int n) {
        return this.F.getComboBoxColl(string, string2, tFormulaEvaluator, bl, n);
    }

    public void addConsolidatedDriver(String string, String string2, String string3, String string4, String string5) {
        if (this.F instanceof TConsolidatedHorzDriver) {
            ((TConsolidatedHorzDriver)this.F).addDriver(string, string2, string3, string4, string5);
            this.DriverStruct = this.F.getDriverStruct();
        } else if (this.F instanceof TConsolidatedVertDriver) {
            ((TConsolidatedVertDriver)this.F).addDriver(string, string2, string3, string4);
            this.DriverStruct = this.F.getDriverStruct();
        } else {
            MainWin.appendToLog("TAspectDriver", "addConsolidatedDriver", Thread.currentThread(), null, 4, "Attempting to add driver '" + string + "' to a driver that is " + "not a consolidated driver.");
        }
    }

    public String exportToAscii(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, boolean bl6) {
        if (bl5) {
            String string3 = this.exportToAsciiFiltered(string, string2, bl, bl2, bl3, bl4, n, bl6);
            return string3;
        }
        TDriverStruct tDriverStruct = null;
        if (string2.length() > 0) {
            tDriverStruct = new TDriverStruct(this.Application, string2);
        }
        String string4 = TAsciiCsvFile.exportFile(this.F, string, tDriverStruct, bl2, bl, bl3, bl4, n);
        return string4;
    }

    public String exportToAsciiFiltered(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5) {
        TDriverStructRecord tDriverStructRecord;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        char c = ',';
        String string3 = "ok";
        TDriverStruct tDriverStruct = null;
        if (string2.length() > 0) {
            tDriverStruct = new TDriverStruct(this.Application, string2);
        }
        switch (n) {
            case 0: {
                c = ',';
                break;
            }
            case 1: {
                c = '|';
                break;
            }
            case 2: {
                c = '\t';
                break;
            }
            case 3: {
                c = '=';
            }
        }
        TAsciiOutput tAsciiOutput = bl5 ? new TAsciiOutput(string, c, true) : new TAsciiOutput(string, c, false);
        TDriverStruct tDriverStruct2 = this.F.getDriverStruct();
        if (tDriverStruct == null) {
            tDriverStruct = tDriverStruct2;
        }
        if (bl2) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(tDriverStructRecord.Description, true);
            }
            tAsciiOutput.write_crlf();
        }
        if (bl) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(tDriverStructRecord.FullID, true);
            }
            tAsciiOutput.write_crlf();
        }
        if (bl3) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                tAsciiOutput.writeString(TAbstractDriver.getFieldTypeName(tDriverStructRecord.FieldType), false);
            }
            tAsciiOutput.write_crlf();
        }
        ArrayList arrayList = tDriverStruct.getAssociatedRecords(tDriverStruct2);
        int n3 = this.getRecordCount();
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < tDriverStruct.FieldColl.size(); ++n2) {
                tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n2);
                if (!bl4 && tDriverStructRecord.IsVirtual) continue;
                int n4 = (Integer)arrayList.get(n2);
                if (n4 >= 0) {
                    TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)tDriverStruct2.FieldColl.get(n4);
                    Object object = this.getField(tDriverStructRecord2, i);
                    String string4 = tDriverStructRecord.FormatPattern;
                    if (string4.length() == 0) {
                        string4 = objectutil.getDefaultPattern(tDriverStructRecord.FieldType);
                    }
                    String string5 = objectutil.applyPattern(object, string4);
                    tAsciiOutput.writeString(string5, false);
                    continue;
                }
                tAsciiOutput.writeString("", false);
            }
            tAsciiOutput.write_crlf();
        }
        tAsciiOutput.dispose();
        return string3;
    }

    public synchronized boolean addToViews() {
        boolean bl = false;
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Common_Views", 1, true, false, "");
        String string = this.F.getAppDriversObject().Description.toString() + " - " + this.AspectDriverFilter.DisplayName.toString();
        String string2 = "(View_Type=3) and (Target=\"" + this.F.getAppDriversObject().DriverID + "\") and (Display_Name=\"" + this.AspectDriverFilter.DisplayName.toString() + "\")";
        int n = tAspectDriver.getMatchingRecordAbsolute(string2, 0);
        boolean bl2 = false;
        if (n < 0) {
            n = tAspectDriver.initializeNewRecord();
            bl2 = true;
            tAspectDriver.putFieldAbsolute("View_Type", n, (Object)"3");
            tAspectDriver.putFieldAbsolute("Target", n, (Object)this.F.getAppDriversObject().DriverID.toString());
            tAspectDriver.putFieldAbsolute("Display_Name", n, (Object)this.AspectDriverFilter.DisplayName.toString());
            tAspectDriver.putFieldAbsolute("Description", n, (Object)string);
        }
        tAspectDriver.addToFilterList(n, 0);
        TExecDialog tExecDialog = new TExecDialog(tAspectDriver, n);
        String string3 = tExecDialog.executeDialog();
        if (string3.equalsIgnoreCase("ok")) {
            bl = true;
            MainWin.refreshViewTree();
        } else if (bl2) {
            tAspectDriver.deleteRecordAbsolute(n);
        }
        tAspectDriver.dispose();
        return bl;
    }

    public static String getDriverIncludeTag(String string, boolean bl) {
        String string2 = bl ? "driver_include_editable" : "driver_include";
        String string3 = "DocumentID=77NaWu0FhKDKXL7C70JpnKmy&Widget=Templates&Text=true&ContainerItemID=" + string2;
        String string4 = TFormulaEvaluator.getCache().getCachedContent(0, TMainWin.Application.getAspectHashID(), string3, false, "", "");
        string4 = charutil.replaceAllSubstrings(string4, "$DriverID$", string.toUpperCase());
        return string4;
    }

    public static String getDefaultDialog(TAspectDriver tAspectDriver) {
        String string;
        Object object;
        int n;
        System.out.println("TAspectDriver getDefaultDialog");
        String string2 = "DocumentID=77NaWu0FhKDKXL7C70JpnKmy&Widget=Templates&ContainerItemID=driver_include_dialog&Text=true";
        String string3 = TFormulaEvaluator.getCache().getCachedContent(0, TMainWin.Application.getAspectHashID(), string2, false, "", "");
        string3 = charutil.replaceAllSubstrings(string3, "$DriverID$", tAspectDriver.AppDriverObj.DriverID.toString().toUpperCase());
        String string4 = "\t\t\t\t\t<td><span onClick=\"showTab(this,'__salt__$TabID$')\">$TabDescription$</span></td>";
        String string5 = "\t\t<!-- $TabDescription$ -->\r\n\t\t<div ID=\"__salt__$TabID$\" class=\"DialogTabContent\">\r\n$tabcontent$\r\n\t\t</div>";
        String string6 = "";
        String string7 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < tAspectDriver.DriverStruct.FieldColl.size(); ++n) {
            object = (TDriverStructRecord)tAspectDriver.DriverStruct.FieldColl.get(n);
            string = ((TDriverStructRecord)object).DialogTab.trim();
            if (string.length() <= 0 || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Object object2;
            object = (String)arrayList.get(n);
            string = charutil.replaceAllSubstrings((String)object, " ", "_");
            String string8 = charutil.replaceAllSubstrings(string4, "$TabID$", string);
            string8 = charutil.replaceAllSubstrings(string8, "$TabDescription$", (String)object);
            string6 = string6 + string8;
            if (n < arrayList.size() - 1) {
                string6 = string6 + "\r\n";
            }
            THtmlTag tHtmlTag = new THtmlTag("table");
            tHtmlTag.setProperty("style", "width:100%");
            for (int i = 0; i < tAspectDriver.DriverStruct.FieldColl.size(); ++i) {
                Object object3;
                object2 = (TDriverStructRecord)tAspectDriver.DriverStruct.FieldColl.get(i);
                if (!((TDriverStructRecord)object2).DialogTab.trim().equalsIgnoreCase((String)object)) continue;
                THtmlTag tHtmlTag2 = new THtmlTag("tr");
                THtmlTag tHtmlTag3 = new THtmlTag("td");
                tHtmlTag3.setProperty("content", ((TDriverStructRecord)object2).Description);
                THtmlTag tHtmlTag4 = new THtmlTag("td");
                if (((TDriverStructRecord)object2).IsCalculated || !((TDriverStructRecord)object2).IsEditable) {
                    object3 = new THtmlTag("span");
                    ((THtmlTag)object3).setProperty("name", ((TDriverStructRecord)object2).FullID);
                    tHtmlTag4.addContent((THtmlTag)object3);
                } else if (((TDriverStructRecord)object2).IsLookup) {
                    object3 = "<!include type:expression; expression:htmlSelect(\"$CollectionID$\",\"$FieldID$\",\"\",\"style=\"+quote(\"width:100%;max-width:__TextFieldWidth__\")+\" onChange=\"+quote(\"submitDialogCell(this)\"))>";
                    object3 = charutil.replaceAllSubstrings((String)object3, "$CollectionID$", ((TDriverStructRecord)object2).CollectionID);
                    object3 = charutil.replaceAllSubstrings((String)object3, "$FieldID$", ((TDriverStructRecord)object2).FullID);
                    tHtmlTag4.addContent((String)object3);
                } else {
                    object3 = tAspectDriver.getFieldForHtml((TDriverStructRecord)object2, 0);
                    THtmlTag tHtmlTag5 = tAspectDriver.formatHtmlValue((TDriverStructRecord)object2, object3, 0, i, -1, -1, true);
                    tHtmlTag5.setProperty("onChange", "submitDialogCell(this)");
                    tHtmlTag5.setProperty("name", ((TDriverStructRecord)object2).FullID);
                    if (!objectutil.isBooleanField(((TDriverStructRecord)object2).FieldType)) {
                        if (objectutil.isNumberField(((TDriverStructRecord)object2).FieldType)) {
                            tHtmlTag5.setProperty("style", "width:100%;max-width:__NumberFieldWidth__");
                        } else {
                            tHtmlTag5.setProperty("style", "width:100%;max-width:__TextFieldWidth__");
                        }
                    }
                    tHtmlTag4.addContent(tHtmlTag5);
                }
                if (objectutil.isBooleanField(((TDriverStructRecord)object2).FieldType)) {
                    tHtmlTag4.addContent(" " + tHtmlTag3.getContent());
                    tHtmlTag4.setProperty("colspan", "2");
                    tHtmlTag2.addContent("\t\t\t\t\t" + tHtmlTag4.toString());
                } else {
                    tHtmlTag2.addContent(tHtmlTag3.toString());
                    tHtmlTag2.addContent(tHtmlTag4.toString());
                }
                tHtmlTag.addContent(tHtmlTag2.toString());
            }
            string8 = charutil.replaceAllSubstrings(string5, "$TabDescription$", (String)object);
            string8 = charutil.replaceAllSubstrings(string8, "$TabID$", string);
            String string9 = tHtmlTag.toString();
            object2 = "%^%";
            string9 = charutil.replaceAllSubstrings(string9, "<table style=\"width:100%\">", (String)object2);
            string9 = charutil.replaceAllSubstrings(string9, (String)object2, "\t\t\t<table style=\"width:100%\">\r\n");
            string9 = charutil.replaceAllSubstrings(string9, "</table>", (String)object2);
            string9 = charutil.replaceAllSubstrings(string9, (String)object2, "\t\t\t</table>");
            string9 = charutil.replaceAllSubstrings(string9, "<tr>", (String)object2);
            string9 = charutil.replaceAllSubstrings(string9, (String)object2, "\t\t\t\t<tr>\r\n");
            string9 = charutil.replaceAllSubstrings(string9, "</tr>", (String)object2);
            string9 = charutil.replaceAllSubstrings(string9, (String)object2, "\t\t\t\t</tr>\r\n");
            string9 = charutil.replaceAllSubstrings(string9, "<td>", (String)object2);
            string9 = charutil.replaceAllSubstrings(string9, (String)object2, "\t\t\t\t\t<td>");
            string9 = charutil.replaceAllSubstrings(string9, "</td>", (String)object2);
            string9 = charutil.replaceAllSubstrings(string9, (String)object2, "</td>\r\n");
            string8 = charutil.replaceAllSubstrings(string8, "$tabcontent$", string9);
            string7 = string7 + string8 + "\r\n";
            if (n >= arrayList.size() - 1) continue;
            string7 = string7 + "\r\n";
        }
        String string10 = charutil.replaceAllSubstrings(string3, "$Tabs$", string6);
        string10 = charutil.replaceAllSubstrings(string10, "$TabsContent$", string7);
        return string10;
    }

    public THtmlTag formatHtmlValue(TDriverStructRecord tDriverStructRecord, Object object, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        Object object2;
        String string = tDriverStructRecord.FormatPattern;
        if (string.length() == 0) {
            string = objectutil.getDefaultPattern(tDriverStructRecord.FieldType);
        }
        String string2 = objectutil.applyPattern(object, string);
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (tDriverStructRecord.HtmlEditAttributes.length() > 0) {
            object2 = tDriverStructRecord.HtmlEditAttributes;
            if (((String)object2).startsWith("=")) {
                object2 = charutil.replaceAllSubstrings((String)object2, "{FieldID}", tDriverStructRecord.FullID);
                object2 = objectutil.convertToString(this.F.getFormulaEvaluator().getFormulaValue((String)object2, this.getAbsoluteDiskIndex(n), -1));
            }
            if ((stringArray = charutil.getSubStringArray((String)object2, ' ', true)) != null && stringArray.length > 0) {
                stringArray2 = new String[stringArray.length];
                stringArray3 = new String[stringArray.length];
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    int n6 = stringArray[n5].indexOf(61);
                    if (n6 <= 0) continue;
                    stringArray2[n5] = stringArray[n5].substring(0, n6);
                    stringArray3[n5] = charutil.removeQuotes(stringArray[n5].substring(n6 + 1));
                    if (stringArray2[n5].equalsIgnoreCase("width") || stringArray3[n5].toUpperCase().indexOf("WIDTH") >= 0) {
                        bl2 = true;
                    }
                    if (stringArray3[n5].toUpperCase().indexOf("TEXT-ALIGN") >= 0) {
                        bl3 = true;
                    }
                    if (!stringArray2[n5].equalsIgnoreCase("style")) continue;
                    bl4 = true;
                }
            }
        }
        if (!bl) {
            if (objectutil.isNumberField(tDriverStructRecord.FieldType) && objectutil.isZero(object) && tDriverStructRecord.SuppressZeros) {
                string2 = "&nbsp;";
            }
            if (string2.length() == 0) {
                string2 = "&nbsp;";
            }
            if (string2.toUpperCase().indexOf("<INPUT") >= 0 || string2.toUpperCase().indexOf("<TEXTAREA") >= 0) {
                object2 = new THtmlTag("text");
                ((THtmlTag)object2).addContent(string2);
                if (stringArray2 != null) {
                    for (n5 = 0; n5 < stringArray2.length; ++n5) {
                        ((THtmlTag)object2).setProperty(stringArray2[n5], stringArray3[n5]);
                    }
                }
                return object2;
            }
            object2 = new THtmlTag("text");
            ((THtmlTag)object2).addContent(string2);
            if (stringArray2 != null) {
                for (n5 = 0; n5 < stringArray2.length; ++n5) {
                    ((THtmlTag)object2).setProperty(stringArray2[n5], stringArray3[n5]);
                }
            }
            return object2;
        }
        if (objectutil.isBooleanField(tDriverStructRecord.FieldType)) {
            object2 = new THtmlTag("input");
            ((THtmlTag)object2).setProperty("name", tDriverStructRecord.FullID);
            ((THtmlTag)object2).setProperty("type", "checkbox");
            ((THtmlTag)object2).setProperty("value", string2);
            if (stringArray2 != null) {
                for (n5 = 0; n5 < stringArray2.length; ++n5) {
                    ((THtmlTag)object2).setProperty(stringArray2[n5], stringArray3[n5]);
                }
            }
            if ((n5 = (int)((object instanceof Boolean ? (Boolean)object : charutil.boolval(objectutil.convertToString(object))) ? 1 : 0)) != 0) {
                ((THtmlTag)object2).setProperty("checked", "checked");
            }
            return object2;
        }
        if (tDriverStructRecord.IsLookup) {
            TComboBoxColl tComboBoxColl;
            object2 = new THtmlTag("select");
            ((THtmlTag)object2).setProperty("name", tDriverStructRecord.FullID);
            if (stringArray2 != null) {
                for (n5 = 0; n5 < stringArray2.length; ++n5) {
                    ((THtmlTag)object2).setProperty(stringArray2[n5], stringArray3[n5]);
                }
            }
            if ((tComboBoxColl = this.getComboBoxColl(tDriverStructRecord.FullID, new StringBuilder(tDriverStructRecord.Formula), this.getFormulaEvaluator(), false, false, n)) != null) {
                ((THtmlTag)object2).setProperty("content", tComboBoxColl.toHtmlSelect(string2));
            }
            return object2;
        }
        if (tDriverStructRecord.ArraySize > 128) {
            object2 = new THtmlTag("textarea");
            if (stringArray2 != null) {
                for (n5 = 0; n5 < stringArray2.length; ++n5) {
                    ((THtmlTag)object2).setProperty(stringArray2[n5], stringArray3[n5]);
                }
            }
            ((THtmlTag)object2).addContent(string2);
            return object2;
        }
        object2 = new THtmlTag("input");
        ((THtmlTag)object2).setProperty("name", tDriverStructRecord.FullID);
        if (tDriverStructRecord.FieldType == 26) {
            ((THtmlTag)object2).setProperty("type", "password");
        } else if (objectutil.isNumberField(tDriverStructRecord.FieldType)) {
            ((THtmlTag)object2).setProperty("type", "number");
            ((THtmlTag)object2).setProperty("ID", TPasswordService.generateSalt(4).toString());
        } else if (objectutil.isDateField(tDriverStructRecord.FieldType)) {
            if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("MM-dd-yyyy HH:mm")) {
                ((THtmlTag)object2).setProperty("type", "text");
            } else {
                ((THtmlTag)object2).setProperty("type", "text");
            }
            if (object instanceof Date) {
                if (((Date)object).getTime() == 0L) {
                    string2 = "";
                }
            } else if (object instanceof String && ((String)object).endsWith("1969")) {
                string2 = "";
            }
        } else {
            ((THtmlTag)object2).setProperty("type", "text");
        }
        ((THtmlTag)object2).setProperty("onkeydown", "return keyDown(event,this);");
        if (stringArray2 != null) {
            for (n5 = 0; n5 < stringArray2.length; ++n5) {
                ((THtmlTag)object2).setProperty(stringArray2[n5], stringArray3[n5]);
            }
        }
        if (objectutil.isNumberField(tDriverStructRecord.FieldType)) {
            ((THtmlTag)object2).setProperty("class", "DefaultNumberInput");
            if (charutil.dval(string2) == 0.0) {
                string2 = "";
            }
            string2 = charutil.removeChar(string2, ',');
        } else if (objectutil.isDateField(tDriverStructRecord.FieldType)) {
            if (!bl2) {
                if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("MM-dd-yyyy")) {
                    ((THtmlTag)object2).setProperty("class", "DefaultDateInput");
                } else if (tDriverStructRecord.FormatPattern.equalsIgnoreCase("HH:mm:ss")) {
                    ((THtmlTag)object2).setProperty("class", "DefaultTimeInput");
                } else {
                    ((THtmlTag)object2).setProperty("class", "DefaultDateTimeInput");
                }
            }
        } else {
            String string3;
            String string4 = string3 = ((THtmlTag)object2).getProperty("style") == null ? "width:150px" : ((THtmlTag)object2).getProperty("style") + ";width:150px";
            if (!bl2) {
                ((THtmlTag)object2).setProperty("style", string3);
            }
        }
        if (!objectutil.isNumberField(tDriverStructRecord.FieldType) && !objectutil.isDateField(tDriverStructRecord.FieldType) && n4 > 0) {
            ((THtmlTag)object2).setProperty("maxlength", n4);
        }
        ((THtmlTag)object2).setProperty("value", string2);
        return object2;
    }

    public String getEmbeddedFieldInfo(int n, int n2, String[] stringArray, Hashtable hashtable) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < stringArray.length; ++i) {
            TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(stringArray[i]);
            if (tDriverStructRecord == null) continue;
            switch (n2) {
                case 0: {
                    stringBuilder.append("," + charutil.replaceAllSubstrings(tDriverStructRecord.FullID, ",", "//comma//"));
                    continue block6;
                }
                case 1: {
                    stringBuilder.append("," + Integer.toString(tDriverStructRecord.FieldType));
                    continue block6;
                }
                case 2: 
                case 4: 
                case 5: {
                    Object object = null;
                    String string = "";
                    if (n2 == 2) {
                        if (hashtable != null) {
                            object = hashtable.get(tDriverStructRecord.FullID);
                            if (object == null) {
                                object = "";
                            }
                        } else {
                            object = this.getField(tDriverStructRecord, n);
                        }
                        string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
                    } else if (n2 == 4) {
                        object = this.getFieldForHtml(tDriverStructRecord, n);
                        string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
                    } else {
                        int n3 = this.getSubtotalLevel(n);
                        object = n3 < 0 && tDriverStructRecord.Html_Permit_Editing && tDriverStructRecord.IsLookup ? this.getField(tDriverStructRecord, n) : this.getFieldForHtml(tDriverStructRecord, n);
                        boolean bl = tDriverStructRecord.Html_Permit_Editing;
                        THtmlTag tHtmlTag = this.formatHtmlValue(tDriverStructRecord, object, n, tDriverStructRecord.AbsoluteIndex, 0, tDriverStructRecord.ArraySize, bl);
                        if (bl) {
                            tHtmlTag.setProperty("onChange", "submitTableCell(this)");
                        }
                        string = tHtmlTag.toString();
                    }
                    string = charutil.replaceAllSubstrings(string, ",", "%%comma%%");
                    string = charutil.replaceAllSubstrings(string, "\r\n", "%%crlf%%");
                    string = charutil.replaceAllSubstrings(string, "\r", "%%crlf%%");
                    string = charutil.replaceAllSubstrings(string, "\n", "%%crlf%%");
                    string = charutil.replaceAllSubstrings(string, "\"", "%%quot%%");
                    string = charutil.replaceAllSubstrings(string, "'", "%%apos%%");
                    string = charutil.replaceAllSubstrings(string, "<", "%%lt%%");
                    string = charutil.replaceAllSubstrings(string, ">", "%%gt%%");
                    string = charutil.replaceAllSubstrings(string, "{", "%%leftbrace%%");
                    string = charutil.replaceAllSubstrings(string, "}", "%%rightbrace%%");
                    stringBuilder.append("," + string);
                    continue block6;
                }
                case 3: {
                    if (tDriverStructRecord.FormatPattern.startsWith("=")) {
                        stringBuilder.append(",");
                        continue block6;
                    }
                    stringBuilder.append("," + charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(tDriverStructRecord.FormatPattern.trim(), ",", "|"), "#", "9"));
                }
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(0);
        }
        return stringBuilder.toString();
    }

    public String getNewRecordDefaults(String[] stringArray, Hashtable hashtable) {
        Object object;
        TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator();
        for (int i = 0; i < this.F.getDriverStruct().FieldColl.size(); ++i) {
            Object object2;
            object = (TDriverStructRecord)this.F.getDriverStruct().FieldColl.get(i);
            if (!((TDriverStructRecord)object).IsCalculated && !((TDriverStructRecord)object).IsVirtual && ((TDriverStructRecord)object).DefaultOnInsert.trim().length() > 0) {
                object2 = this.F.getFormulaEvaluator().getFormulaValue(((TDriverStructRecord)object).DefaultOnInsert, this.F.getRecordCount(), -1);
                object2 = objectutil.convertToString(object2);
                object2 = objectutil.convertStringToFieldType(((TDriverStructRecord)object).FieldType, (String)object2, -1);
                tFormulaEvaluator.setConstant(((TDriverStructRecord)object).FullID, object2);
                hashtable.put(((TDriverStructRecord)object).FullID, object2);
                continue;
            }
            object2 = objectutil.getErrorValue(((TDriverStructRecord)object).FieldType);
            hashtable.put(((TDriverStructRecord)object).FullID, object2);
        }
        String string = TFormulaEvaluator.convertToString(tFormulaEvaluator.getFormulaValue(this.getKeyExpression(), this.F.getRecordCount(), -1));
        object = "|DISKINDEX|ID_RESERVED_DISKINDEX|ID_RESERVED_EMBEDDED_DISKINDEX|";
        if (((String)object).indexOf("|" + this.getKeyExpression().toUpperCase() + "|") >= 0) {
            string = "DISKINDEX^" + this.AppDriverObj.DriverID.toString() + "^" + TPasswordService.generateSalt(6);
        }
        string = charutil.replaceAllSubstrings(string, "|", "//pipe//");
        object = this.getEmbeddedFieldInfo(-1, 2, stringArray, hashtable);
        return string + "|" + ((String)object).toString();
    }

    public int getAbsoluteRecordFromKeyvalue(String string) {
        int n = -1;
        if (string.toUpperCase().startsWith("DISKINDEX^")) {
            n = TDataCollection.getDiskIndex(string);
            if (n < 0) {
                MainWin.appendToLog("TAspectDriver", "getAbsoluteRecordFromKeyvalue", Thread.currentThread(), null, 4, "Cannot locate record with keyvalue=" + string);
            }
        } else {
            String string2 = "(" + this.getKeyExpression() + ")=" + "\"" + string + "\"";
            n = this.getMatchingRecordAbsolute(string2, 0);
            if (n < 0) {
                MainWin.appendToLog("TAspectDriver", "getAbsoluteRecordFromKeyvalue", Thread.currentThread(), null, 4, "Cannot locate record with keyvalue=" + string + " Filter=" + string2);
            }
        }
        return n;
    }

    public String getRecordValues(String[] stringArray, String[] stringArray2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2;
            int n = -1;
            if (stringArray2[i].toUpperCase().startsWith("DISKINDEX^")) {
                n = TDataCollection.getDiskIndex(stringArray2[i]);
                if (n < 0) {
                    MainWin.appendToLog("TAspectDriver", "getRecordValues", Thread.currentThread(), null, 4, "Cannot locate record with keyvalue=" + stringArray2[i]);
                }
            } else {
                string2 = "(" + this.getKeyExpression() + ")=" + "\"" + stringArray2[i] + "\"";
                n = this.getMatchingRecordAbsolute(string2, 0);
                if (n < 0) {
                    MainWin.appendToLog("TAspectDriver", "getRecordValues", Thread.currentThread(), null, 4, "Cannot locate record with keyvalue=" + stringArray2[i] + " Filter=" + string2);
                }
            }
            if (n < 0) continue;
            string2 = this.getEmbeddedFieldInfo(n, 2, stringArray, null);
            String string3 = this.getEmbeddedFieldInfo(n, 5, stringArray, null);
            string2 = charutil.replaceAllSubstrings(string2, "|", "%%pipe%%");
            string2 = charutil.replaceAllSubstrings(string2, "\n", "%%linefeed%%");
            stringBuilder.append("\n" + stringArray2[i] + "|" + string2);
            if (tDriverStructRecord != null) {
                Object object = this.getFieldAbsolute(tDriverStructRecord, n);
                String string4 = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
                string4 = charutil.replaceAllSubstrings(string4, "\"", "%%quot%%");
                stringBuilder.append("|" + string4);
            } else {
                stringBuilder.append("|");
            }
            string3 = charutil.replaceAllSubstrings(string3, "|", "%%pipe%%");
            string3 = charutil.replaceAllSubstrings(string3, "\n", "%%linefeed%%");
            stringBuilder.append("|" + string3);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(0);
        }
        System.out.println("TAspectDriver.getRecordValues=" + stringBuilder.toString());
        return stringBuilder.toString();
    }

    public THtmlTag getSelectDisplayControl(String string, TDriverDisplay tDriverDisplay, Hashtable hashtable) {
        THtmlTag tHtmlTag = new THtmlTag("li");
        tHtmlTag.setProperty("class", "TableHeaderSelectDisplay");
        boolean bl = hashtable.containsKey("SELECTDISPLAY") ? charutil.boolval(charutil.removeQuotes((String)hashtable.get("SELECTDISPLAY"))) : true;
        boolean bl2 = hashtable.containsKey("EDITDISPLAY") ? charutil.boolval(charutil.removeQuotes((String)hashtable.get("EDITDISPLAY"))) : true;
        THtmlTag tHtmlTag2 = new THtmlTag("select");
        tHtmlTag2.setProperty("content", tDriverDisplay.toHtmlSelect());
        tHtmlTag2.setProperty("id", "SelectDisplay1" + string.toLowerCase());
        tHtmlTag2.setProperty("onChange", "displaySelected1(this,'" + string.toLowerCase() + "',false)");
        if (bl) {
            tHtmlTag2.setProperty("style", "width:300px");
            tHtmlTag.append(tHtmlTag2);
        } else {
            tHtmlTag2.setProperty("style", "display:none");
            tHtmlTag.append(tHtmlTag2);
        }
        if (bl && bl2) {
            THtmlTag tHtmlTag3 = new THtmlTag("div");
            tHtmlTag3.setProperty("id", "display_" + string.toLowerCase());
            tHtmlTag3.setProperty("onClick", "openDisplayDialog('" + string.toLowerCase() + "',this)");
            tHtmlTag3.setProperty("class", "DisplayDialogIconEditDisplay");
            tHtmlTag.append(tHtmlTag3);
        }
        return tHtmlTag;
    }

    public THtmlTag getTableMenu(String string, TDriverDisplay tDriverDisplay, Hashtable hashtable) {
        String[] stringArray;
        String[] stringArray2;
        String string2;
        String string3;
        String string4;
        Object object;
        int n;
        String string5;
        Object object2;
        boolean bl;
        THtmlTag tHtmlTag = new THtmlTag("ul");
        THtmlTag tHtmlTag2 = new THtmlTag("li");
        tHtmlTag2.setProperty("onclick", "tableMenuitemSelected('refreshTable','" + string.toLowerCase() + "')");
        tHtmlTag2.addContent("Refresh");
        tHtmlTag.append(tHtmlTag2);
        boolean bl2 = bl = hashtable.containsKey("EDITDISPLAY") ? charutil.boolval(charutil.removeQuotes((String)hashtable.get("EDITDISPLAY"))) : true;
        if (bl) {
            tHtmlTag2 = new THtmlTag("li");
            tHtmlTag2.setProperty("onclick", "tableMenuitemSelected('openDisplayDialog','" + string.toLowerCase() + "')");
            tHtmlTag2.addContent("Customize");
            tHtmlTag.append(tHtmlTag2);
        }
        tHtmlTag2 = new THtmlTag("li");
        tHtmlTag2.addContent("<hr>");
        tHtmlTag.append(tHtmlTag2);
        tHtmlTag2 = new THtmlTag("li");
        tHtmlTag2.setProperty("onclick", "tableMenuitemSelected('printTable','" + string.toLowerCase() + "')");
        tHtmlTag2.addContent("Print");
        tHtmlTag.append(tHtmlTag2);
        tHtmlTag2 = new THtmlTag("li");
        tHtmlTag2.setProperty("onclick", "tableMenuitemSelected('exportTable','" + string.toLowerCase() + "')");
        tHtmlTag2.addContent("Export");
        tHtmlTag.append(tHtmlTag2);
        tHtmlTag2 = new THtmlTag("li");
        tHtmlTag2.setProperty("onclick", "tableMenuitemSelected('debugAttributes','" + string.toLowerCase() + "')");
        tHtmlTag2.addContent("Info");
        tHtmlTag.append(tHtmlTag2);
        if (hashtable.containsKey("MENU") && (object2 = charutil.getSubStringArray(string5 = charutil.removeQuotes((String)hashtable.get("MENU")), ',', true)) != null && ((String[])object2).length > 0) {
            tHtmlTag2 = new THtmlTag("li");
            tHtmlTag2.addContent("<hr>");
            tHtmlTag.append(tHtmlTag2);
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = charutil.getSubStringArray((String)object2[n], '|', true);
                if (object == null || ((String[])object).length <= 0) continue;
                if (((String[])object).length == 1 && object[0].equalsIgnoreCase("separator")) {
                    tHtmlTag2 = new THtmlTag("li");
                    tHtmlTag2.addContent("<hr>");
                    tHtmlTag.append(tHtmlTag2);
                    continue;
                }
                if (((String[])object).length != 2) continue;
                tHtmlTag2 = new THtmlTag("li");
                tHtmlTag2.setProperty("onclick", "tableMenuitemSelected('" + object[1] + "','" + string.toLowerCase() + "')");
                tHtmlTag2.addContent(object[0]);
                tHtmlTag.append(tHtmlTag2);
            }
        }
        string5 = "";
        if (hashtable.containsKey("FAQ")) {
            string5 = charutil.removeQuotes((String)hashtable.get("FAQ"));
        } else if (this.getFormulaEvaluator().getConstant("#Faq") != null) {
            string5 = objectutil.convertToString(this.getFormulaEvaluator().getConstant("#Faq"));
        }
        if (string5.length() > 0 && (object2 = charutil.getSubStringArray(string5, ',', true)) != null && ((String[])object2).length > 0) {
            tHtmlTag2 = new THtmlTag("li");
            tHtmlTag2.addContent("<hr>");
            tHtmlTag.append(tHtmlTag2);
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = TFormulaEvaluator.getSupportTaskInfo((String)object2[n]);
                string4 = charutil.getElement((String)object, 0, '^');
                string3 = charutil.getElement((String)object, 1, '^');
                string2 = "FAQ: " + charutil.replaceAllSubstrings(charutil.getElement((String)object, 2, '^'), "&", "&amp;");
                tHtmlTag2 = new THtmlTag("li");
                tHtmlTag2.setProperty("onclick", "inspectFAQ('" + (String)object2[n] + "','" + string4 + "','" + string3 + "','" + string2 + "')");
                tHtmlTag2.addContent(string2);
                tHtmlTag.append(tHtmlTag2);
            }
        }
        object2 = "";
        if (hashtable.containsKey("PROCEDURE")) {
            object2 = charutil.removeQuotes((String)hashtable.get("PROCEDURE"));
        } else if (this.getFormulaEvaluator().getConstant("#Procedure") != null) {
            object2 = objectutil.convertToString(this.getFormulaEvaluator().getConstant("#Procedure"));
        }
        if (((String)object2).length() > 0 && (stringArray2 = charutil.getSubStringArray((String)object2, ',', true)) != null && stringArray2.length > 0) {
            tHtmlTag2 = new THtmlTag("li");
            tHtmlTag2.addContent("<hr>");
            tHtmlTag.append(tHtmlTag2);
            for (int i = 0; i < stringArray2.length; ++i) {
                string4 = TFormulaEvaluator.getSupportTaskInfo(stringArray2[i]);
                string3 = charutil.getElement(string4, 0, '^');
                string2 = charutil.getElement(string4, 1, '^');
                String string6 = "How To: " + charutil.getElement(string4, 2, '^');
                tHtmlTag2 = new THtmlTag("li");
                tHtmlTag2.setProperty("onclick", "inspectProcedure('" + stringArray2[i] + "','" + string3 + "','" + string2 + "','" + string6 + "')");
                tHtmlTag2.addContent(string6);
                tHtmlTag.append(tHtmlTag2);
            }
        }
        String string7 = "";
        if (hashtable.containsKey("VIDEO")) {
            string7 = charutil.removeQuotes((String)hashtable.get("VIDEO"));
        } else if (this.getFormulaEvaluator().getConstant("#Video") != null) {
            string7 = objectutil.convertToString(this.getFormulaEvaluator().getConstant("#Video"));
        }
        if (string7.length() > 0 && (stringArray = charutil.getSubStringArray(string7, ',', true)) != null && stringArray.length > 0) {
            tHtmlTag2 = new THtmlTag("li");
            tHtmlTag2.addContent("<hr>");
            tHtmlTag.append(tHtmlTag2);
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = "Video: " + TFormulaEvaluator.getVideoTitle(stringArray[i]);
                tHtmlTag2 = new THtmlTag("li");
                tHtmlTag2.setProperty("onclick", "openVideoView('','" + stringArray[i] + "','" + string3 + "')");
                tHtmlTag2.addContent(string3);
                tHtmlTag.append(tHtmlTag2);
            }
        }
        return tHtmlTag;
    }

    public THtmlTag oldgetTableMenu(String string, TDriverDisplay tDriverDisplay, Hashtable hashtable) {
        String string2;
        String[] stringArray;
        THtmlTag tHtmlTag = new THtmlTag("li");
        tHtmlTag.setProperty("class", "TableHeaderMenu");
        if (hashtable.containsKey("MENU") && (stringArray = charutil.getSubStringArray(string2 = charutil.removeQuotes((String)hashtable.get("MENU")), ',', true)) != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<ul class='dmenu' style='display:inline-block'>");
            stringBuilder.append("\t<li class='dmenu'>");
            stringBuilder.append("\t\t<span class='dmenu' onclick=\"javascript:menuOpen('menu" + string.toLowerCase() + "')\" _onmouseover=\"menuOpen('menu458074')\" onmouseout=\"menuSetTimeout()\">Options</span>");
            stringBuilder.append("\t\t<div class='dmenu' id='menu" + string.toLowerCase() + "' onmouseover=\"menuCancelTimeout()\" onmouseout=\"menuSetTimeout()\" isMenu='true'>");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '|', true);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                if (stringArray2.length == 1 && stringArray2[0].equalsIgnoreCase("separator")) {
                    stringBuilder.append("\t\t\t<span class='dmenuitem'>--------------------</span>");
                    continue;
                }
                if (stringArray2.length != 2) continue;
                stringBuilder.append("\t\t\t<span class='dmenuitem' onclick=\"" + stringArray2[1] + "('" + string.toLowerCase() + "')\">" + stringArray2[0] + "</span>");
            }
            stringBuilder.append("\t\t</div>");
            stringBuilder.append("\t</li>");
            stringBuilder.append("</ul>");
            THtmlTag tHtmlTag2 = new THtmlTag("text");
            tHtmlTag2.setProperty("content", stringBuilder.toString());
            tHtmlTag.append(tHtmlTag2);
        }
        tHtmlTag.addContent("&nbsp;");
        return tHtmlTag;
    }

    public THtmlTag getTableRecordCount(String string, TDriverDisplay tDriverDisplay, Hashtable hashtable, int n, int n2, boolean bl) {
        THtmlTag tHtmlTag = new THtmlTag("li");
        tHtmlTag.setProperty("class", "TableRecordCount");
        THtmlTag tHtmlTag2 = new THtmlTag("span");
        tHtmlTag2.setProperty("class", "TableRecordCountSpan");
        tHtmlTag2.setProperty("content", Integer.toString(n + 1) + " - " + Integer.toString(n2) + " of " + this.getRecordCount());
        if (!bl) {
            tHtmlTag.setProperty("style", "display:none");
        }
        tHtmlTag.append(tHtmlTag2);
        return tHtmlTag;
    }

    public THtmlTag getTableTimestamp(String string, TDriverDisplay tDriverDisplay, Hashtable hashtable, boolean bl, boolean bl2) {
        THtmlTag tHtmlTag = new THtmlTag("li");
        tHtmlTag.setProperty("class", "TableTimestampContainer");
        THtmlTag tHtmlTag2 = new THtmlTag("span");
        tHtmlTag2.setProperty("ID", "table_updated_" + string.toLowerCase());
        if (bl) {
            tHtmlTag2.setProperty("class", "TableTimestamp");
        } else {
            tHtmlTag2.setProperty("class", "TableTimestampHidden");
        }
        tHtmlTag2.setProperty("content", "");
        if (!bl2) {
            tHtmlTag.setProperty("style", "display:none");
        }
        tHtmlTag.append(tHtmlTag2);
        return tHtmlTag;
    }

    public THtmlTag getTableControlIcons(String string, TDriverDisplay tDriverDisplay, Hashtable hashtable, String string2, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        THtmlTag tHtmlTag;
        THtmlTag tHtmlTag2;
        THtmlTag tHtmlTag3 = new THtmlTag("li");
        tHtmlTag3.setProperty("class", "TableControls");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(0);
        THtmlTag tHtmlTag4 = new THtmlTag("ul");
        tHtmlTag4.setProperty("class", "TableControlsUL");
        if (bl) {
            tHtmlTag2 = new THtmlTag("li");
            tHtmlTag2.setProperty("class", "TableIconAdd");
            tHtmlTag2.setProperty("onclick", "insertTableRecord('" + string.toLowerCase() + "')");
            tHtmlTag4.append(tHtmlTag2);
        }
        if (bl2 && bl3) {
            tHtmlTag2 = new THtmlTag("li");
            tHtmlTag2.setProperty("class", "TableIconDelete");
            tHtmlTag2.setProperty("onclick", "deleteTableRecords('" + string.toLowerCase() + "')");
            tHtmlTag4.append(tHtmlTag2);
        }
        if (string2.length() > 0 && !string2.equalsIgnoreCase("0")) {
            tHtmlTag = new THtmlTag("li");
            tHtmlTag.setProperty("onClick", "displayChart1('" + string.toLowerCase() + "',this)");
            tHtmlTag.setProperty("class", "TableIconGraph");
            tHtmlTag4.append(tHtmlTag);
        }
        if (n2 > 0 && n > n2) {
            tHtmlTag = new THtmlTag("li");
            tHtmlTag.setProperty("onClick", "refreshTable('" + string.toLowerCase() + "','first','','true')");
            tHtmlTag.setProperty("class", "TableIconFirst");
            tHtmlTag4.append(tHtmlTag);
            tHtmlTag = new THtmlTag("li");
            tHtmlTag.setProperty("onClick", "refreshTable('" + string.toLowerCase() + "','prev','','true')");
            tHtmlTag.setProperty("class", "TableIconPrev");
            tHtmlTag4.append(tHtmlTag);
            tHtmlTag = new THtmlTag("li");
            tHtmlTag.setProperty("onClick", "refreshTable('" + string.toLowerCase() + "','next','','true')");
            tHtmlTag.setProperty("class", "TableIconNext");
            tHtmlTag4.append(tHtmlTag);
            tHtmlTag = new THtmlTag("li");
            tHtmlTag.setProperty("onClick", "refreshTable('" + string.toLowerCase() + "','last','','true')");
            tHtmlTag.setProperty("class", "TableIconLast");
            tHtmlTag4.append(tHtmlTag);
        }
        tHtmlTag = new THtmlTag("li");
        tHtmlTag.setProperty("onClick", "refreshTable('" + string.toLowerCase() + "','refresh','','true')");
        tHtmlTag.setProperty("class", "TableIconRefresh");
        tHtmlTag4.append(tHtmlTag);
        tHtmlTag = new THtmlTag("li");
        tHtmlTag.setProperty("onClick", "showTableMenu(this,'" + string.toLowerCase() + "')");
        tHtmlTag.setProperty("class", "TableIconMenu");
        tHtmlTag4.append(tHtmlTag);
        tHtmlTag3.append(tHtmlTag4);
        return tHtmlTag3;
    }

    public synchronized String exportToHtml(String string, boolean bl, String string2, String string3, boolean bl2, boolean bl3, String string4, int n, int n2, String string5, Hashtable hashtable, String string6, String string7, String string8, TDriverDisplay tDriverDisplay, String string9) {
        boolean bl4;
        Object object;
        THtmlTag tHtmlTag;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        Object object14;
        int n3;
        Object object15;
        Object object16;
        Object object17;
        String[] stringArray;
        Object object18;
        boolean bl5;
        String string10;
        boolean bl6;
        boolean bl7;
        Object object19;
        int n4;
        Object object20;
        int n5;
        if (this.AspectDriverFilter.ColumnList == null) {
            if (this.AspectDriverFilter.FilteredList.size() == 0) {
                this.AspectDriverFilter.loadDisplay("", true);
            }
            if (this.AspectDriverFilter.ColumnList == null) {
                this.AspectDriverFilter.initializeDisplayFromStructure();
            }
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Object var21_18 = null;
        String string11 = string2.toLowerCase();
        String string12 = string3.toLowerCase();
        String string13 = string2.toLowerCase();
        String string14 = string2.toLowerCase();
        String string15 = "";
        int n6 = this.getRecordCount();
        int n7 = n2 > 0 ? Math.min(n6, n + n2) : n6;
        int n8 = this.AspectDriverFilter.ColumnList.size();
        int n9 = 0;
        Date date = new Date();
        String string16 = this.Application.getTokenValue("ImageHostUrl");
        TDriverStructRecord[] tDriverStructRecordArray = new TDriverStructRecord[this.AspectDriverFilter.ColumnList.size()];
        for (n5 = 0; n5 < n8; ++n5) {
            TAppDisplaysObject tAppDisplaysObject = (TAppDisplaysObject)this.AspectDriverFilter.ColumnList.get(n5);
            tDriverStructRecordArray[n5] = this.DriverStruct.getField(tAppDisplaysObject.StructureFieldID);
        }
        for (n5 = 0; n5 < this.DriverStruct.FieldColl.size(); ++n5) {
            object20 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n5);
            if (!object20.ID.toUpperCase().startsWith("__TABLEROW")) continue;
            arrayList.add((String[])object20);
        }
        object20 = this.AspectDriverFilter.getSortFields();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (object20 != null) {
            for (n4 = 0; n4 < ((String[])object20).length; ++n4) {
                object19 = this.DriverStruct.getField(object20[n4]);
                if (!((TDriverStructRecord)object19).Html_Enable_Sections) continue;
                arrayList2.add(object19);
            }
        } else {
            System.out.println("no sort fields defined for driver: " + this.AppDriverObj.DriverID);
        }
        n4 = tDriverDisplay.subtotalsOnly() ? 1 : 0;
        object19 = "";
        if (n4 != 0) {
            String[] stringArray2 = tDriverDisplay.getSubtotalFields();
            if (stringArray2 != null) {
                for (bl7 = false; bl7 < stringArray2.length; bl7 += 1) {
                    object19 = (String)object19 + "|" + stringArray2[bl7] + "|";
                }
            }
            object19 = ((String)object19).toUpperCase();
        }
        boolean bl8 = hashtable.containsKey("CANSELECT") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("CANSELECT")));
        boolean bl9 = bl7 = hashtable.containsKey("CANADD") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("CANADD")));
        if (tDriverDisplay.subtotalsOnly()) {
            bl7 = false;
        }
        boolean bl10 = hashtable.containsKey("CANDELETE") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("CANDELETE")));
        boolean bl11 = hashtable.containsKey("CANEDIT") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("CANEDIT")));
        boolean bl12 = hashtable.containsKey("DIALOGONLY") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("DIALOGONLY")));
        String string17 = hashtable.containsKey("INSERTPOSITION") ? charutil.removeQuotes((String)hashtable.get("INSERTPOSITION")) : "TOP";
        boolean bl13 = bl6 = string9.toUpperCase().indexOf("PREPAREEMAIL=TRUE") >= 0;
        if (bl6) {
            bl11 = false;
            bl10 = false;
            bl7 = false;
            bl8 = false;
        }
        boolean bl14 = true;
        if (hashtable.containsKey("STYLE") && (string10 = (String)hashtable.get("STYLE")).toUpperCase().indexOf("DISPLAY:NONE") >= 0) {
            bl14 = false;
        }
        boolean bl15 = false;
        TDriverInspect tDriverInspect = null;
        if (!bl6) {
            String string18 = "";
            if (hashtable.containsKey("INSPECTMENU")) {
                boolean bl16 = bl15 = charutil.removeQuotes((String)hashtable.get("INSPECTMENU")).trim().length() > 0;
                if (bl15) {
                    string18 = charutil.removeQuotes((String)hashtable.get("INSPECTMENU")).trim();
                    tDriverInspect = new TDriverInspect(string18);
                }
            }
            if (!bl15 && this.getFormulaEvaluator().getConstant("#InspectMenu") != null && (string18 = objectutil.convertToString(this.getFormulaEvaluator().getConstant("#InspectMenu"))).length() > 0) {
                tDriverInspect = new TDriverInspect(string18);
                bl15 = true;
            }
        }
        if (tDriverDisplay.subtotalsOnly()) {
            bl11 = false;
        }
        boolean bl17 = hashtable.containsKey("CANCLOSEDIALOG") ? charutil.boolval(charutil.removeQuotes((String)hashtable.get("CANCLOSEDIALOG"))) : true;
        boolean bl18 = hashtable.containsKey("READONLY") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("READONLY")));
        boolean bl19 = hashtable.containsKey("ALLFIELDSVISIBLE") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("ALLFIELDSVISIBLE")));
        boolean bl20 = hashtable.containsKey("ISMOBILEDOC") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("ISMOBILEDOC")));
        boolean bl21 = hashtable.containsKey("REFRESHONINTERVAL") && charutil.boolval(charutil.removeQuotes((String)hashtable.get("REFRESHONINTERVAL")));
        boolean bl22 = hashtable.containsKey("TIMESTAMP") ? charutil.boolval(charutil.removeQuotes((String)hashtable.get("TIMESTAMP"))) : true;
        boolean bl23 = bl5 = hashtable.containsKey("DISPLAYDIALOG") ? charutil.boolval(charutil.removeQuotes((String)hashtable.get("DISPLAYDIALOG"))) : true;
        if (bl6) {
            bl22 = false;
            bl5 = false;
        }
        String string19 = "ID";
        if (hashtable.containsKey("KEYDESCRIPTION")) {
            string19 = charutil.removeQuotes((String)hashtable.get("KEYDESCRIPTION"));
        }
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string19);
        int n10 = n8;
        if (bl8) {
            ++n10;
        }
        if (bl11) {
            ++n10;
        }
        if (bl15) {
            ++n10;
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        String string20 = this.Application.getTokenValue("packageurl_greenlight");
        TExportHtmlOutput tExportHtmlOutput = new TExportHtmlOutput();
        if (hashtable.containsKey("VER")) {
            double d = charutil.dval(charutil.removeQuotes((String)hashtable.get("VER")));
            if (d == 2.0) {
                tExportHtmlOutput.writeString("<div ID='div" + string5.toLowerCase() + "' class='OuterTableDiv' ' style='display:block;position:initial'>", false);
            } else {
                tExportHtmlOutput.writeString("<div ID='div" + string5.toLowerCase() + "' class='OuterTableDiv' ' style='display:block'>", false);
            }
            tExportHtmlOutput.write_crlf();
        } else {
            System.out.println("Ver not specified");
        }
        if (bl15) {
            tExportHtmlOutput.writeString(tDriverInspect.getInspectMenuHtml(this, string5.toLowerCase()));
        }
        if (!bl6 && bl5) {
            tExportHtmlOutput.writeString("<div ID='div" + string5.toLowerCase() + "pageargs' style='display:none'>__PageArgs__</div>", false);
            tExportHtmlOutput.write_crlf();
        }
        boolean bl24 = true;
        if (hashtable.containsKey("TABLEMENU")) {
            bl24 = charutil.boolval(charutil.removeQuotes((String)hashtable.get("TABLEMENU")));
        }
        if (!bl6 && bl24) {
            object18 = new THtmlTag("div");
            ((THtmlTag)object18).setProperty("ID", "TableMenu" + string5.toLowerCase());
            ((THtmlTag)object18).setProperty("class", "TableMenu");
            ((THtmlTag)object18).setProperty("style", "display:none");
            ((THtmlTag)object18).append(this.getTableMenu(string5, tDriverDisplay, hashtable));
            tExportHtmlOutput.writeString(((THtmlTag)object18).toString());
            tExportHtmlOutput.write_crlf();
        }
        object18 = "GenericEdit" + string5.toLowerCase();
        Object object21 = "";
        Object object22 = "";
        if (hashtable.containsKey("ORIGINALEDITDIALOGID")) {
            object22 = object21 = charutil.removeQuotes((String)hashtable.get("ORIGINALEDITDIALOGID"));
        } else if (hashtable.containsKey("EDITDIALOGID")) {
            object22 = object21 = charutil.removeQuotes((String)hashtable.get("EDITDIALOGID"));
        }
        String string21 = "";
        if ((bl11 || bl12) && !bl21 && !((String)object21).equalsIgnoreCase("none")) {
            Object object23;
            if (((String)object21).length() > 0 && !((String)object21).toUpperCase().startsWith("GENERIC")) {
                object23 = charutil.getSubStringArray((String)object21, '|', true);
                if (object23 != null && ((String[])object23).length >= 4) {
                    stringArray = "DocumentID=" + (String)object23[0] + "&Widget=" + (String)object23[1] + "&ContainerItemID=" + (String)object23[2] + "&text=true";
                    string21 = TFormulaEvaluator.getCache().getCachedContent(0, this.Application.getAspectHashID(), (String)stringArray, false, "", "");
                    if (((Object)object23).length == 5) {
                        string21 = charutil.replaceAllSubstrings(string21, "__DialogID__", (String)object23[4]);
                        object21 = (String)object23[3] + (String)object23[4];
                    } else {
                        string21 = charutil.replaceAllSubstrings(string21, "__DialogID__", (String)object23[3]);
                        object21 = object23[3];
                    }
                    tExportHtmlOutput.writeString(string21);
                    tExportHtmlOutput.write_crlf();
                }
            } else {
                object22 = object21 = object18;
                hashtable.put("EDITDIALOGID", object21);
                object23 = new THtmlTag("div");
                ((THtmlTag)object23).setProperty("ID", (String)object21);
                ((THtmlTag)object23).setProperty("class", "default_table_dialog");
                ((THtmlTag)object23).setProperty("style", "height:auto; width:100%; max-width:500px; display:none; padding:5px");
                stringArray = new THtmlTag("div");
                stringArray.setProperty("class", "EditDialogCloseIcon");
                stringArray.setProperty("onClick", "setVisible('" + (String)object21 + "',false)");
                ((THtmlTag)object23).addContent((THtmlTag)stringArray);
                object17 = new THtmlTag("table");
                ((THtmlTag)object17).setProperty("style", "width:100%");
                object16 = new THtmlTag("tr");
                object15 = new THtmlTag("td");
                ((THtmlTag)object15).setProperty("content", "<b>Edit Record</b>");
                ((THtmlTag)object16).addContent(((THtmlTag)object15).toString());
                object17 = new THtmlTag("table");
                for (n3 = 0; n3 < this.DriverStruct.FieldColl.size(); ++n3) {
                    TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n3);
                    if (!tDriverStructRecord2.IsEditable || tDriverStructRecord2.IsCalculated) continue;
                    object16 = new THtmlTag("tr");
                    object15 = new THtmlTag("td");
                    ((THtmlTag)object15).setProperty("content", tDriverStructRecord2.Description);
                    ((THtmlTag)object16).addContent(((THtmlTag)object15).toString());
                    object15 = new THtmlTag("td");
                    object14 = this.getFieldForHtml(tDriverStructRecord2, 0);
                    object13 = this.formatHtmlValue(tDriverStructRecord2, object14, 0, n5, -1, -1, true);
                    ((THtmlTag)object13).setProperty("onChange", "submitDialogCell(this)");
                    ((THtmlTag)object13).setProperty("name", tDriverStructRecord2.FullID);
                    ((THtmlTag)object15).addContent((THtmlTag)object13);
                    ((THtmlTag)object16).addContent(((THtmlTag)object15).toString());
                    ((THtmlTag)object17).addContent(((THtmlTag)object16).toString());
                }
                ((THtmlTag)object23).addContent(((THtmlTag)object17).toString());
                tExportHtmlOutput.writeString(((THtmlTag)object23).toString());
                tExportHtmlOutput.write_crlf();
            }
        }
        boolean bl25 = false;
        stringArray = null;
        object17 = "";
        if (hashtable.containsKey("EMBEDVALUES")) {
            object17 = charutil.removeQuotes((String)hashtable.get("EMBEDVALUES")).trim();
        }
        if (bl11 || bl7 || ((String)object17).length() > 0 || bl12) {
            object16 = new StringBuilder();
            if (hashtable.containsKey("EMBEDVALUES")) {
                ((StringBuilder)object16).append((String)object17);
            } else {
                System.out.println("No EmbedValues parameter specified");
            }
            if (string21.length() > 0) {
                object15 = string21.toUpperCase();
                n3 = -1;
                do {
                    int n11;
                    if ((n3 = ((String)object15).indexOf("NAME=\"", n3 + 1)) < 0 || (n11 = ((String)object15).indexOf("\"", n3 + 6)) < 0 || ((String)(object13 = ((String)object15).substring(n3 + 6, n11))).startsWith("_")) continue;
                    object12 = this.DriverStruct.getField((String)object13);
                    if (object12 != null) {
                        if (!((String)object13).equalsIgnoreCase(((TDriverStructRecord)object12).FullID)) {
                            string15 = string15 + "Use full ID - " + ((TDriverStructRecord)object12).FullID + " in dialog<br>";
                            MainWin.appendToLog("TAspectDriver", "exportToHtml", Thread.currentThread(), null, 4, "Use full ID - " + ((TDriverStructRecord)object12).FullID + " in dialog");
                        }
                        if ((((StringBuilder)object16).toString().toUpperCase() + ",").indexOf("," + ((TDriverStructRecord)object12).FullID.toUpperCase() + ",") >= 0) continue;
                        ((StringBuilder)object16).append("," + ((TDriverStructRecord)object12).FullID);
                        continue;
                    }
                    string15 = string15 + "Invalid field in dialog.  Begin name with an underscore to suppress this message. " + (String)object13 + "<br>";
                    MainWin.appendToLog("TAspectDriver", "exportToHtml", Thread.currentThread(), null, 4, "Invalid field in dialog: " + (String)object13);
                } while (n3 > 0);
                n3 = -1;
                do {
                    int n12;
                    if ((n3 = ((String)object15).indexOf("NAME='", n3 + 1)) < 0 || (n12 = ((String)object15).indexOf("'", n3 + 6)) < 0 || (object12 = this.DriverStruct.getField((String)(object13 = ((String)object15).substring(n3 + 6, n12)))) == null) continue;
                    if (!((String)object13).equalsIgnoreCase(((TDriverStructRecord)object12).FullID)) {
                        string15 = string15 + "Use full ID - " + ((TDriverStructRecord)object12).FullID + " in dialog<br>";
                        MainWin.appendToLog("TAspectDriver", "exportToHtml", Thread.currentThread(), null, 4, "Use full ID - " + ((TDriverStructRecord)object12).FullID + " in dialog");
                    }
                    if ((((StringBuilder)object16).toString().toUpperCase() + ",").indexOf("," + ((TDriverStructRecord)object12).FullID.toUpperCase() + ",") >= 0) continue;
                    ((StringBuilder)object16).append("," + ((TDriverStructRecord)object12).FullID);
                } while (n3 > 0);
                n3 = -1;
                do {
                    int n13;
                    if ((n3 = ((String)object15).indexOf("EXPRESSION:HTMLSELECT(", n3 + 1)) < 0 || (n3 = ((String)object15).indexOf(",\"", n3 + 1)) <= 0 || (n13 = ((String)object15).indexOf("\"", n3 + 2)) < 0 || (object12 = this.DriverStruct.getField((String)(object13 = ((String)object15).substring(n3 + 2, n13)))) == null) continue;
                    if (!((String)object13).equalsIgnoreCase(((TDriverStructRecord)object12).FullID)) {
                        string15 = string15 + "Use full ID - " + ((TDriverStructRecord)object12).FullID + " in dialog<br>";
                        MainWin.appendToLog("TAspectDriver", "exportToHtml", Thread.currentThread(), null, 4, "Use full ID - " + ((TDriverStructRecord)object12).FullID + " in dialog");
                    }
                    if ((((StringBuilder)object16).toString().toUpperCase() + ",").indexOf("," + ((TDriverStructRecord)object12).FullID.toUpperCase() + ",") >= 0) continue;
                    ((StringBuilder)object16).append("," + ((TDriverStructRecord)object12).FullID);
                } while (n3 > 0);
            }
            for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                TDriverStructRecord tDriverStructRecord3 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                if (((StringBuilder)object16).indexOf("," + tDriverStructRecord3.ID) >= 0) continue;
                if (tDriverStructRecord3.IsExternalStructField && !tDriverStructRecord3.IsCalculated) {
                    ((StringBuilder)object16).append("," + tDriverStructRecord3.ID);
                    continue;
                }
                if (tDriverStructRecord3.IsCalculated || !tDriverStructRecord3.Html_Permit_Editing && !tDriverStructRecord3.IsEditable) continue;
                ((StringBuilder)object16).append("," + tDriverStructRecord3.ID);
            }
            object15 = this.getFormulaEvaluator().getFieldIDsInExpression(this.F.getKeyExpression());
            if (object15 != null && ((String[])object15).length > 0) {
                String string22 = ((StringBuilder)object16).toString().toUpperCase() + ",";
                for (int i = 0; i < ((String[])object15).length; ++i) {
                    if (string22.indexOf("," + ((String)object15[i]).toUpperCase() + ",") >= 0) continue;
                    ((StringBuilder)object16).append("," + (String)object15[i]);
                    string22 = ((StringBuilder)object16).toString().toUpperCase() + ",";
                }
            } else {
                if (string15.length() > 0) {
                    string15 = string15 + "<br>";
                }
                string15 = string15 + "No fields in key: " + this.F.getKeyExpression();
            }
            for (n3 = 0; n3 < this.DriverStruct.FieldColl.size(); ++n3) {
                TDriverStructRecord tDriverStructRecord4 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n3);
                if (tDriverStructRecord4.DefaultOnDelete.length() <= 0 || tDriverStructRecord4.External_Data_Is_External && tDriverStructRecord4.External_Data_Filename.trim().length() != 0 || ((String)(object13 = ((StringBuilder)object16).toString().toUpperCase() + ",")).indexOf("," + tDriverStructRecord4.ID.toUpperCase() + ",") >= 0) continue;
                ((StringBuilder)object16).append("," + tDriverStructRecord4.ID);
            }
            if (((StringBuilder)object16).length() > 0) {
                bl25 = true;
                if (((StringBuilder)object16).charAt(0) == ',') {
                    ((StringBuilder)object16).deleteCharAt(0);
                }
                stringArray = charutil.getSubStringArray(((StringBuilder)object16).toString(), ',', true);
            }
        }
        if (this.F.getKeyExpression().trim().length() == 0) {
            string15 = string15 + "Missing key expression";
            MainWin.appendToLog("TAspectDriver", "exportToHtml", Thread.currentThread(), null, 4, "Missing key expression in driver " + this.F.getAppDriversObject().DriverID.toString());
        }
        object16 = "";
        if (bl5 && hashtable.containsKey("VER")) {
            String string23;
            String[] stringArray3;
            String string24;
            String[] stringArray4;
            object15 = null;
            if (hashtable.containsKey("INCLUDEFIELDS") && (stringArray4 = charutil.getSubStringArray(string24 = charutil.removeQuotes((String)hashtable.get("INCLUDEFIELDS")).toUpperCase(), ',', true)) != null && stringArray4.length > 0) {
                object15 = new ArrayList();
                for (int i = 0; i < stringArray4.length; ++i) {
                    ((ArrayList)object15).add(stringArray4[i]);
                }
            }
            ArrayList<String> arrayList3 = null;
            if (hashtable.containsKey("EXCLUDEFIELDS") && (stringArray3 = charutil.getSubStringArray(string23 = charutil.removeQuotes((String)hashtable.get("EXCLUDEFIELDS")).toUpperCase(), ',', true)) != null && stringArray3.length > 0) {
                arrayList3 = new ArrayList<String>();
                for (int i = 0; i < stringArray3.length; ++i) {
                    arrayList3.add(stringArray3[i]);
                }
            }
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                TDriverStructRecord tDriverStructRecord5 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                if (tDriverStructRecord5.Visible) {
                    if (object15 == null) {
                        if (arrayList3 == null) {
                            arrayList4.add(tDriverStructRecord5.Description.trim() + "^" + tDriverStructRecord5.FullID);
                            continue;
                        }
                        if (arrayList3.contains(tDriverStructRecord5.ID.toUpperCase())) continue;
                        arrayList4.add(tDriverStructRecord5.Description.trim() + "^" + tDriverStructRecord5.FullID);
                        continue;
                    }
                    if (!((ArrayList)object15).contains(tDriverStructRecord5.ID.toUpperCase())) continue;
                    arrayList4.add(tDriverStructRecord5.Description.trim() + "^" + tDriverStructRecord5.FullID);
                    continue;
                }
                if (!bl19) continue;
                arrayList4.add(tDriverStructRecord5.Description.trim() + " [hidden]^" + tDriverStructRecord5.FullID);
            }
            object13 = new String[arrayList4.size()];
            for (int i = 0; i < arrayList4.size(); ++i) {
                object13[i] = (String)arrayList4.get(i);
            }
            object12 = new ArrayList();
            object11 = new ArrayList<String>();
            for (n5 = 0; n5 < this.DriverStruct.FieldColl.size(); ++n5) {
                object10 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n5);
                if (((TDriverStructRecord)object10).IsPivotNameField || ((TDriverStructRecord)object10).IsPivotTotal) {
                    ((ArrayList)object12).add(((TDriverStructRecord)object10).FullID);
                    continue;
                }
                if (((TDriverStructRecord)object10).IsLookup || !objectutil.isNumberField(((TDriverStructRecord)object10).FieldType)) continue;
                ((ArrayList)object11).add(((TDriverStructRecord)object10).FullID);
            }
            object10 = new String[((ArrayList)object12).size()];
            for (int i = 0; i < ((ArrayList)object12).size(); ++i) {
                object10[i] = (String)((ArrayList)object12).get(i);
            }
            object9 = new String[((ArrayList)object11).size()];
            for (int i = 0; i < ((ArrayList)object11).size(); ++i) {
                object9[i] = (String)((ArrayList)object11).get(i);
            }
            String string25 = tDriverDisplay.toHtmlDialog(string5.toLowerCase(), (String[])object13, (String[])object10, (String[])object9);
            if (tDriverStructRecord != null) {
                object8 = new TComboBoxColl(true, n7 - n + 1);
                for (n9 = n; n9 < n7; ++n9) {
                    object7 = this.getField(tDriverStructRecord, n9);
                    if (object7 == null) continue;
                    if (tDriverStructRecord.IsLookup) {
                        object7 = this.convertFieldValueToComboboxString(tDriverStructRecord, object7, n9);
                    }
                    if (object7 == null) continue;
                    ((TComboBoxColl)object8).add(this.getKeyValue(n9), object7);
                }
                string25 = charutil.replaceAllSubstrings(string25, "$SelectRecord$", ((TComboBoxColl)object8).toHtmlSelect(""));
                string25 = bl17 ? charutil.replaceAllSubstrings(string25, "$CanCloseDialog$", "inline") : charutil.replaceAllSubstrings(string25, "$CanCloseDialog$", "none");
            } else {
                string25 = charutil.replaceAllSubstrings(string25, "$SelectRecord$", "");
            }
            object16 = charutil.crc(string25);
            if (!bl21) {
                tExportHtmlOutput.writeString(string25, false);
                tExportHtmlOutput.write_crlf();
            }
        }
        if (hashtable.containsKey("TITLE")) {
            object15 = new StringBuilder();
            ((StringBuilder)object15).setLength(0);
            ((StringBuilder)object15).append(charutil.removeQuotes((String)hashtable.get("TITLE")));
            tExportHtmlOutput.writeString(((StringBuilder)object15).toString(), false);
            tExportHtmlOutput.write_crlf();
        }
        if (bl5) {
            object15 = new StringBuilder();
            ((StringBuilder)object15).append("<div ID='TableError" + string5.toLowerCase() + "' class='errortextbold' style='width:auto;height:auto'>");
            ((StringBuilder)object15).append(string15);
            ((StringBuilder)object15).append("</div>");
            tExportHtmlOutput.writeString(((StringBuilder)object15).toString(), false);
            tExportHtmlOutput.write_crlf();
        }
        object15 = new THtmlTag("table");
        if (!bl6) {
            ((THtmlTag)object15).setProperty("class", string11);
        }
        ((THtmlTag)object15).setProperty("aspectclass", string11);
        ((THtmlTag)object15).setProperty("id", string5.toLowerCase());
        ((THtmlTag)object15).setProperty("aspectid", string5.toLowerCase());
        ((THtmlTag)object15).setProperty("style", string12);
        ((THtmlTag)object15).setProperty("aspectstyle", string12);
        ((THtmlTag)object15).setProperty("aspectdisplay_metadata", tDriverDisplay.getMetadata());
        ((THtmlTag)object15).setProperty("aspectDisplayOptionsCRC", (String)object16);
        if (bl3) {
            ((THtmlTag)object15).setProperty("border", "1");
        } else {
            ((THtmlTag)object15).setProperty("border", "0");
        }
        if (!bl6) {
            if (hashtable.containsKey("VER")) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string26 = (String)enumeration.nextElement();
                    if (string26.equalsIgnoreCase("fields") || string26.equalsIgnoreCase("ID") || string26.equalsIgnoreCase("StartRecord") || string26.toUpperCase().startsWith("XDISPLAY") || string26.toUpperCase().startsWith("XEXTERNAL")) continue;
                    object13 = charutil.removeQuotes((String)hashtable.get(string26));
                    if (string26.equalsIgnoreCase("EditDialogID")) {
                        ((THtmlTag)object15).setProperty("EditDialogID", (String)object21);
                        ((THtmlTag)object15).setProperty("aspectEditDialogID", (String)object21);
                        ((THtmlTag)object15).setProperty("aspectOriginalEditDialogID", (String)object22);
                        continue;
                    }
                    if (string26.equalsIgnoreCase("Filter")) {
                        ((THtmlTag)object15).setProperty(string26, (String)object13);
                        ((THtmlTag)object15).setProperty("aspect" + string26, (String)object13);
                        ((THtmlTag)object15).setProperty("aspectFilterActive", charutil.replaceAllSubstrings(tDriverDisplay.getFilter(), "\"", "'"));
                        continue;
                    }
                    if (string26.equalsIgnoreCase("Params")) {
                        object13 = charutil.setElementValue((String)object13, "metadata", tDriverDisplay.getMetadata(), '|');
                        ((THtmlTag)object15).setProperty(string26, (String)object13);
                        ((THtmlTag)object15).setProperty("aspect" + string26, (String)object13);
                        object12 = this.getDriverParams();
                        if (this.F instanceof TDimensionalDriver) {
                            object12 = charutil.replaceAllSubstrings((String)object12, "opening=true", "");
                        }
                        ((THtmlTag)object15).setProperty("aspectParamsActive", (String)object12);
                        ((THtmlTag)object15).setProperty("ParamsActive", (String)object12);
                        continue;
                    }
                    if (string26.equalsIgnoreCase("State")) {
                        if (this.AppDriverObj.State_Expression.trim().length() > 0) {
                            object12 = charutil.replaceChar(this.AppDriverObj.Source_State_Expression, '\"', '\'');
                            object12 = ((String)object12).startsWith("=") ? ((String)object12).substring(1) : object12;
                            object11 = charutil.replaceChar(this.AppDriverObj.State_Expression, '\"', '\'');
                            object11 = ((String)object11).startsWith("=") ? ((String)object11).substring(1) : object11;
                            object13 = "crc(" + (String)object12 + "+" + (String)object11 + ")";
                        }
                        object13 = charutil.replaceAllSubstrings((String)object13, "+", "%2B");
                        ((THtmlTag)object15).setProperty(string26, (String)object13);
                        ((THtmlTag)object15).setProperty("aspect" + string26, (String)object13);
                        continue;
                    }
                    if (string26.equalsIgnoreCase("AspectParamsActive") || string26.equalsIgnoreCase("ParamsActive")) {
                        object12 = this.getDriverParams();
                        if (this.F instanceof TDimensionalDriver) {
                            object12 = charutil.replaceAllSubstrings((String)object12, "opening=true", "");
                        }
                        ((THtmlTag)object15).setProperty("ParamsActive", (String)object12);
                        ((THtmlTag)object15).setProperty("aspectParamsActive", (String)object12);
                        continue;
                    }
                    if (bl25 && string26.equalsIgnoreCase("EMBEDVALUES")) {
                        object12 = "";
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (((String)object12).length() > 0) {
                                object12 = (String)object12 + ",";
                            }
                            object12 = (String)object12 + stringArray[i];
                        }
                        ((THtmlTag)object15).setProperty("EMBEDVALUES", (String)object12);
                        ((THtmlTag)object15).setProperty("aspectEMBEDVALUES", (String)object12);
                        continue;
                    }
                    if (string26.equalsIgnoreCase("Display_Metadata")) {
                        ((THtmlTag)object15).setProperty("DISPLAY_METADATA", tDriverDisplay.getMetadata());
                        continue;
                    }
                    if (string26.equalsIgnoreCase("ChartType")) {
                        ((THtmlTag)object15).setProperty("aspectChartType", tDriverDisplay.getChartType());
                        continue;
                    }
                    ((THtmlTag)object15).setProperty(string26, (String)object13);
                    ((THtmlTag)object15).setProperty("aspect" + string26, (String)object13);
                }
                if (this.AppDriverObj.Check_Dependencies && !hashtable.containsKey("STATE")) {
                    ((THtmlTag)object15).setProperty("STATE", charutil.replaceChar(this.AppDriverObj.Source_State_Expression, '\"', '\''));
                    ((THtmlTag)object15).setProperty("aspectSTATE", charutil.replaceChar(this.AppDriverObj.Source_State_Expression, '\"', '\''));
                }
                ((THtmlTag)object15).setProperty("aspectDocumentID", string6);
                ((THtmlTag)object15).setProperty("aspectWidget", string7);
                ((THtmlTag)object15).setProperty("aspectContainerItemID", string8);
                ((THtmlTag)object15).setProperty("aspectKeyExpression", this.F.getKeyExpression());
                ((THtmlTag)object15).setProperty("aspectStartRecord", Integer.toString(n));
                ((THtmlTag)object15).setProperty("aspectDriverStructID", this.F.getAppDriversObject().DriverID.toString());
                StringBuilder stringBuilder = new StringBuilder();
                for (n5 = 0; n5 < n8; ++n5) {
                    stringBuilder.append("," + tDriverStructRecordArray[n5].FullID);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.deleteCharAt(0);
                }
                ((THtmlTag)object15).setProperty("aspectFields", stringBuilder.toString());
                object13 = new StringBuilder();
                for (n5 = 0; n5 < n8; ++n5) {
                    ((StringBuilder)object13).append("," + Integer.toString(tDriverStructRecordArray[n5].FieldType));
                }
                if (((StringBuilder)object13).length() > 0) {
                    ((StringBuilder)object13).deleteCharAt(0);
                }
                ((THtmlTag)object15).setProperty("aspectFieldType", ((StringBuilder)object13).toString());
                object12 = new StringBuilder();
                object11 = new StringBuilder();
                for (n5 = 0; n5 < this.DriverStruct.FieldColl.size(); ++n5) {
                    object10 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n5);
                    if (((TDriverStructRecord)object10).IsPivotNameField || ((TDriverStructRecord)object10).IsPivotTotal) {
                        ((StringBuilder)object12).append("," + ((TDriverStructRecord)object10).FullID);
                        continue;
                    }
                    if (((TDriverStructRecord)object10).IsLookup || !objectutil.isNumberField(((TDriverStructRecord)object10).FieldType)) continue;
                    ((StringBuilder)object11).append("," + ((TDriverStructRecord)object10).FullID);
                }
                if (((StringBuilder)object12).length() > 0) {
                    ((StringBuilder)object12).deleteCharAt(0);
                }
                ((THtmlTag)object15).setProperty("aspectPivotFields", ((StringBuilder)object12).toString());
                if (((StringBuilder)object11).length() > 0) {
                    ((StringBuilder)object11).deleteCharAt(0);
                }
                ((THtmlTag)object15).setProperty("aspectPossiblePivotValues", ((StringBuilder)object11).toString());
                object10 = new StringBuilder();
                for (n5 = 0; n5 < n8; ++n5) {
                    if (tDriverStructRecordArray[n5].FormatPattern.startsWith("=")) {
                        ((StringBuilder)object10).append(",");
                        continue;
                    }
                    ((StringBuilder)object10).append("," + charutil.replaceAllSubstrings(tDriverStructRecordArray[n5].FormatPattern, ",", "|"));
                }
                if (((StringBuilder)object10).length() > 0) {
                    ((StringBuilder)object10).deleteCharAt(0);
                }
                object9 = new StringBuilder();
                for (int i = 0; i < this.DriverStruct.FieldColl.size(); ++i) {
                    object8 = (TDriverStructRecord)this.DriverStruct.FieldColl.get(i);
                    if (((TDriverStructRecord)object8).DefaultOnDelete.length() <= 0 || ((TDriverStructRecord)object8).External_Data_Is_External && ((TDriverStructRecord)object8).External_Data_Filename.trim().length() != 0) continue;
                    object7 = this.F.getFormulaEvaluator().getFormulaValue(((TDriverStructRecord)object8).DefaultOnDelete, 0, -1);
                    object6 = objectutil.convertToString(object7);
                    ((StringBuilder)object9).append("|" + ((TDriverStructRecord)object8).ID + "^" + Integer.toString(((TDriverStructRecord)object8).FieldType) + "^" + (String)object6);
                }
                if (((StringBuilder)object9).length() > 0) {
                    ((StringBuilder)object9).deleteCharAt(0);
                }
                ((THtmlTag)object15).setProperty("aspectOnDelete", ((StringBuilder)object9).toString());
            }
        } else {
            if (hashtable.containsKey("STYLE")) {
                String string27 = charutil.removeQuotes((String)hashtable.get("STYLE")) + ";border-collapse:collapse;border-top:none;border-right:none;border-bottom:none;border-left:none";
                if (string27.startsWith("=")) {
                    string27 = string27.substring(1);
                }
                System.out.println("=============== sStyle=" + string27);
                ((THtmlTag)object15).setProperty("style", string27);
            }
            ((THtmlTag)object15).setProperty("aspectChartType", tDriverDisplay.getChartType());
        }
        TDriverStructRecord tDriverStructRecord6 = this.getVirtualIndexField();
        if (!bl6) {
            ((THtmlTag)object15).setProperty("aspectAllFieldPattern", this.getEmbeddedFieldInfo(-1, 3, stringArray, null));
            if (bl25) {
                ((THtmlTag)object15).setProperty("aspectAllFieldID", this.getEmbeddedFieldInfo(-1, 0, stringArray, null));
            }
            if (bl25) {
                ((THtmlTag)object15).setProperty("aspectAllFieldType", this.getEmbeddedFieldInfo(-1, 1, stringArray, null));
            }
            if (tDriverStructRecord6 != null) {
                ((THtmlTag)object15).setProperty("aspectVirtualIndex", tDriverStructRecord6.FullID);
            }
        }
        tExportHtmlOutput.writeString(((THtmlTag)object15).getOpeningTag(), false);
        tExportHtmlOutput.write_crlf();
        if (!bl6) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl26 = true;
            if (hashtable.containsKey("TABLECONTROLS")) {
                bl26 = charutil.boolval(charutil.removeQuotes((String)hashtable.get("TABLECONTROLS")));
            }
            boolean bl27 = true;
            if (hashtable.containsKey("RECORDCOUNT")) {
                bl27 = charutil.boolval(charutil.removeQuotes((String)hashtable.get("RECORDCOUNT")));
            }
            boolean bl28 = true;
            if (hashtable.containsKey("TIMESTAMP")) {
                bl28 = charutil.boolval(charutil.removeQuotes((String)hashtable.get("TIMESTAMP")));
            }
            if (bl26 && hashtable.containsKey("VER")) {
                object10 = new THtmlTag("thead");
                ((THtmlTag)object10).setProperty("print", "false");
                object9 = new THtmlTag("tr");
                THtmlTag tHtmlTag2 = new THtmlTag("th");
                tHtmlTag2.setProperty("colspan", Integer.toString(n10));
                tHtmlTag2.setProperty("style", "margin:0px;padding:0px;border:none");
                object8 = new THtmlTag("table");
                ((THtmlTag)object8).setProperty("border", "0");
                ((THtmlTag)object8).setProperty("cellspacing", "0");
                ((THtmlTag)object8).setProperty("cellpadding", "0");
                ((THtmlTag)object8).setProperty("class", "table_controls");
                object7 = this.getSelectDisplayControl(string5, tDriverDisplay, hashtable);
                object6 = this.oldgetTableMenu(string5, tDriverDisplay, hashtable);
                object5 = this.getTableRecordCount(string5, tDriverDisplay, hashtable, n, n7, bl27);
                object4 = this.getTableTimestamp(string5, tDriverDisplay, hashtable, bl22, bl28);
                object3 = this.getTableControlIcons(string5, tDriverDisplay, hashtable, tDriverDisplay.getChartType(), n6, n2, bl7, bl10, bl8);
                if (bl20) {
                    object2 = new THtmlTag("tr");
                    ((THtmlTag)object2).append((THtmlTag)object7);
                    ((THtmlTag)object8).append((THtmlTag)object2);
                    object2 = new THtmlTag("tr");
                    ((THtmlTag)object2).append((THtmlTag)object6);
                    ((THtmlTag)object8).append((THtmlTag)object2);
                    object2 = new THtmlTag("tr");
                    ((THtmlTag)object2).append((THtmlTag)object3);
                    ((THtmlTag)object8).append((THtmlTag)object2);
                } else {
                    object2 = new THtmlTag("tr");
                    tHtmlTag = new THtmlTag("td");
                    tHtmlTag.setProperty("class", "TableHeaderTD");
                    tHtmlTag.setProperty("style", "padding:0px;margin:0px;border:none");
                    object = new THtmlTag("ul");
                    ((THtmlTag)object).setProperty("class", "TableHeaderUL");
                    ((THtmlTag)object).append((THtmlTag)object7);
                    THtmlTag tHtmlTag3 = new THtmlTag("li");
                    tHtmlTag3.setProperty("class", "TableHeaderLISub1");
                    THtmlTag tHtmlTag4 = new THtmlTag("ul");
                    tHtmlTag4.setProperty("class", "TableHeaderULSub1");
                    tHtmlTag4.append((THtmlTag)object5);
                    tHtmlTag4.append((THtmlTag)object4);
                    tHtmlTag3.append(tHtmlTag4);
                    ((THtmlTag)object).append(tHtmlTag3);
                    ((THtmlTag)object).append((THtmlTag)object3);
                    tHtmlTag.append((THtmlTag)object);
                    ((THtmlTag)object2).append(tHtmlTag);
                    ((THtmlTag)object8).append((THtmlTag)object2);
                }
                tHtmlTag2.append((THtmlTag)object8);
                ((THtmlTag)object9).append(tHtmlTag2);
                ((THtmlTag)object10).append((THtmlTag)object9);
                stringBuilder.append(((THtmlTag)object10).toString() + "\r\n");
                tExportHtmlOutput.writeString(stringBuilder.toString(), false);
                tExportHtmlOutput.write_crlf();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl29 = bl4 = bl6 && !bl14 && !bl11;
        if (!bl4 && bl2) {
            THtmlTag tHtmlTag5 = new THtmlTag("thead");
            tHtmlTag5.setProperty("class", string13);
            tHtmlTag5.setProperty("valign", "bottom");
            if (arrayList2.size() == 0) {
                stringBuilder.append(tHtmlTag5.getOpeningTag() + "\r\n");
            }
            THtmlTag tHtmlTag6 = new THtmlTag("TR");
            tHtmlTag6.setProperty("class", string13);
            tHtmlTag6.setProperty("valign", "bottom");
            if (!bl6) {
                tHtmlTag6.setProperty("headerid", "~headerid~");
            }
            if (!bl6) {
                tHtmlTag6.setProperty("IsTableHeader", "true");
            }
            tHtmlTag6.setProperty("style", "~headerstyle~");
            stringBuilder.append(tHtmlTag6.getOpeningTag() + "\r\n");
            if (bl8) {
                object10 = new THtmlTag("TH");
                ((THtmlTag)object10).setProperty("content", "<input ID='SelectRecords" + string5.toLowerCase() + "' type='checkbox' onClick=\"selectTableRecords('" + string5.toLowerCase() + "',this,'~headerid~')\">");
                ((THtmlTag)object10).setProperty("align", "center");
                ((THtmlTag)object10).setProperty("style", "text-align:center");
                ((THtmlTag)object10).setProperty("name", "selectrecord");
                ((THtmlTag)object10).setProperty("class", "selectRecordTH");
                stringBuilder.append(((THtmlTag)object10).toString());
            }
            if (bl15) {
                object10 = new THtmlTag("TH");
                ((THtmlTag)object10).setProperty("name", "inspectrecord");
                ((THtmlTag)object10).setProperty("class", "inspectRecordTH");
                ((THtmlTag)object10).setProperty("valign", "bottom");
                object9 = new THtmlTag("div");
                ((THtmlTag)object9).setProperty("class", "inspectRecordTHDiv");
                ((THtmlTag)object10).append((THtmlTag)object9);
                stringBuilder.append(((THtmlTag)object10).toString());
            }
            if (bl11 && !((String)object21).equalsIgnoreCase("none") && !bl20) {
                object10 = new THtmlTag("TH");
                ((THtmlTag)object10).setProperty("name", "editrecord");
                ((THtmlTag)object10).setProperty("class", "OpenEditDialogTH");
                ((THtmlTag)object10).setProperty("valign", "bottom");
                object9 = new THtmlTag("div");
                ((THtmlTag)object9).setProperty("class", "OpenEditDialogTHDiv");
                ((THtmlTag)object10).append((THtmlTag)object9);
                stringBuilder.append(((THtmlTag)object10).toString());
            }
            for (n5 = 0; n5 < n8; ++n5) {
                boolean bl30;
                if (n4 != 0 && !tDriverStructRecordArray[n5].CalcSubtotal && !tDriverStructRecordArray[n5].SubtotalAsFormula && ((String)object19).indexOf("|" + tDriverStructRecordArray[n5].ID.toUpperCase() + "|") < 0) continue;
                String string28 = charutil.replaceAllSubstrings(tDriverStructRecordArray[n5].Description, "\\", " ");
                if (tDriverStructRecordArray[n5].Tooltip.length() > 0) {
                    object10 = tDriverStructRecordArray[n5].Tooltip;
                    object10 = charutil.replaceAllSubstrings((String)object10, "\n", "<br>");
                    object10 = charutil.replaceAllSubstrings((String)object10, "\r", "");
                    object10 = charutil.replaceAllSubstrings((String)object10, "&#33;", "||quot||");
                    object10 = charutil.replaceAllSubstrings((String)object10, "\"", "||quot||");
                    object10 = charutil.replaceAllSubstrings((String)object10, "&#39;", "||apos||");
                    object10 = charutil.replaceAllSubstrings((String)object10, "'", "||apos||");
                    string28 = "<span onMouseOver=\"javascript:showTooltip(event,'" + (String)object10 + "',10,10);\" onMouseOut=\"javascript:showTooltip(event,'',0,0);\"" + ">" + string28 + "</span>";
                }
                object10 = new THtmlTag("TH");
                boolean bl31 = bl30 = tDriverStructRecordArray[n5].TDClass.length() > 0;
                if (bl30) {
                    String string29 = charutil.replaceAllSubstrings(tDriverStructRecordArray[n5].TDClass, "{FieldID}", tDriverStructRecordArray[n5].ID);
                    object8 = this.F.getFormulaEvaluator().getFormulaValue(string29, this.getAbsoluteDiskIndex(n9), -1);
                    object7 = "";
                    if (object8 != null) {
                        object7 = objectutil.convertToString(object8);
                    }
                    ((THtmlTag)object10).setProperty("class", (String)object7);
                } else if (bl) {
                    ((THtmlTag)object10).setProperty("class", string14 + "_" + tDriverStructRecordArray[n5].ID.toLowerCase());
                }
                if (!bl) {
                    switch (tDriverStructRecordArray[n5].RendererHorzLabelPosition) {
                        case 0: {
                            if (objectutil.isNumberField(tDriverStructRecordArray[n5].FieldType)) {
                                ((THtmlTag)object10).setProperty("align", "center");
                                break;
                            }
                            ((THtmlTag)object10).setProperty("align", "left");
                            break;
                        }
                        case 1: 
                        case 4: {
                            ((THtmlTag)object10).setProperty("align", "left");
                            break;
                        }
                        case 3: {
                            ((THtmlTag)object10).setProperty("align", "center");
                            break;
                        }
                        case 2: 
                        case 5: {
                            ((THtmlTag)object10).setProperty("align", "right");
                        }
                    }
                    ((THtmlTag)object10).setProperty("valign", "bottom");
                    ((THtmlTag)object10).setProperty("style", "vertical-align:bottom");
                } else {
                    ((THtmlTag)object10).setProperty("valign", "bottom");
                    ((THtmlTag)object10).setProperty("style", "vertical-align:bottom");
                }
                if (bl6) {
                    ((THtmlTag)object10).setProperty("style", ((THtmlTag)object10).getProperty("style") + ";background-color:white; vertical-align:bottom; border:none; padding:2px 10px 2px 3px;");
                }
                ((THtmlTag)object10).setProperty("content", string28);
                stringBuilder.append(((THtmlTag)object10).toString());
            }
            stringBuilder.append(tHtmlTag6.getClosingTag());
            if (arrayList2.size() == 0) {
                stringBuilder.append(tHtmlTag5.getClosingTag() + "\r\n");
            }
        }
        if (arrayList2.size() == 0) {
            tExportHtmlOutput.writeString(charutil.replaceAllSubstrings(stringBuilder.toString(), "~headerid~", "NoHeaders"), false);
            tExportHtmlOutput.write_crlf();
        } else if (n6 == 0) {
            tExportHtmlOutput.writeString(stringBuilder.toString(), false);
            tExportHtmlOutput.write_crlf();
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        boolean bl32 = false;
        tExportHtmlOutput.writeString("<tbody class=\"" + string13 + "\">", false);
        if (!bl6 && bl7 && !bl18 && n4 == 0) {
            int n14;
            object10 = new THtmlTag("tr");
            ((THtmlTag)object10).setProperty("ID", "InsertTemplate" + string5.toLowerCase());
            ((THtmlTag)object10).setProperty("istemplate", "true");
            ((THtmlTag)object10).setProperty("style", "display:none");
            Hashtable hashtable3 = new Hashtable();
            String string30 = this.getNewRecordDefaults(stringArray, hashtable3);
            int n15 = string30.indexOf("|");
            ((THtmlTag)object10).setProperty("KeyValue", string30.substring(0, n15));
            ((THtmlTag)object10).setProperty("aspectAllValues", string30.substring(n15 + 1));
            ((THtmlTag)object10).setProperty("aspectsubtotallevel", -1);
            ((THtmlTag)object10).setProperty("IsInitialized", "true");
            for (n14 = 0; n14 < arrayList.size(); ++n14) {
                object6 = (TDriverStructRecord)arrayList.get(n14);
                object5 = ((TDriverStructRecord)object6).ID.substring(10);
                object4 = objectutil.convertToString(this.getField((TDriverStructRecord)object6, n9));
                if (((String)object5).trim().length() <= 0 || ((String)object4).trim().length() <= 0) continue;
                ((THtmlTag)object10).setProperty((String)object5, (String)object4);
            }
            if (tDriverStructRecord6 != null) {
                n14 = 0;
                if (string17.equalsIgnoreCase("bottom")) {
                    n14 = this.getNextVirtualIndex();
                }
                ((THtmlTag)object10).setProperty("VirtualIndex", Integer.toString(n14));
            }
            if (bl8) {
                THtmlTag tHtmlTag7 = new THtmlTag("TD");
                tHtmlTag7.setProperty("name", "selectrecord");
                tHtmlTag7.setProperty("content", "<input type='checkbox' align='center'>");
                tHtmlTag7.setProperty("valign", "center");
                tHtmlTag7.setProperty("align", "center");
                tHtmlTag7.setProperty("style", "text-align:center");
                tHtmlTag7.setProperty("class", "selectRecordTD");
                ((THtmlTag)object10).addContent(tHtmlTag7);
            }
            if (bl15) {
                THtmlTag tHtmlTag8 = new THtmlTag("TD");
                tHtmlTag8.setProperty("name", "inspectrecord");
                tHtmlTag8.setProperty("class", "inspectRecordTD");
                object6 = TPasswordService.generateSalt(8);
                tHtmlTag8.setProperty("ID", (String)object6);
                object5 = new THtmlTag("div");
                ((THtmlTag)object5).setProperty("class", "inspectRecordTDDiv");
                ((THtmlTag)object5).setProperty("onClick", "showInspectMenu('" + (String)object6 + "','" + string5.toLowerCase() + "')");
                tHtmlTag8.append((THtmlTag)object5);
                ((THtmlTag)object10).addContent(tHtmlTag8);
            }
            if (bl11 && !((String)object21).equalsIgnoreCase("none") && !bl20) {
                THtmlTag tHtmlTag9 = new THtmlTag("TD");
                tHtmlTag9.setProperty("name", "editrecord");
                tHtmlTag9.setProperty("class", "OpenEditDialogTD");
                object6 = new THtmlTag("div");
                ((THtmlTag)object6).setProperty("class", "OpenEditDialogTDDiv");
                ((THtmlTag)object6).setProperty("onClick", "showTableEditDialog(this)");
                tHtmlTag9.append((THtmlTag)object6);
                ((THtmlTag)object10).addContent(tHtmlTag9);
            }
            for (n5 = 0; n5 < n8; ++n5) {
                boolean bl33;
                THtmlTag tHtmlTag10 = new THtmlTag("TD");
                object6 = string14;
                if (bl) {
                    object6 = (String)object6 + "_" + tDriverStructRecordArray[n5].ID.toLowerCase();
                }
                boolean bl34 = bl33 = tDriverStructRecordArray[n5].TDClass.length() > 0;
                if (bl33) {
                    object4 = charutil.replaceAllSubstrings(tDriverStructRecordArray[n5].TDClass, "{FieldID}", tDriverStructRecordArray[n5].ID);
                    object3 = this.F.getFormulaEvaluator().getFormulaValue((String)object4, this.getAbsoluteDiskIndex(n9), -1);
                    if (object3 != null) {
                        object6 = objectutil.convertToString(object3);
                    }
                }
                if (!bl) {
                    switch (tDriverStructRecordArray[n5].RendererHorzLabelPosition) {
                        case 0: {
                            if (objectutil.isNumberField(tDriverStructRecordArray[n5].FieldType)) {
                                tHtmlTag10.setProperty("align", "center");
                                break;
                            }
                            tHtmlTag10.setProperty("align", "left");
                            break;
                        }
                        case 1: 
                        case 4: {
                            tHtmlTag10.setProperty("align", "left");
                            break;
                        }
                        case 3: {
                            tHtmlTag10.setProperty("align", "center");
                            break;
                        }
                        case 2: 
                        case 5: {
                            tHtmlTag10.setProperty("align", "right");
                        }
                    }
                    switch (tDriverStructRecordArray[n5].RendererVertLabelPosition) {
                        case 3: {
                            tHtmlTag10.setProperty("valign", "center");
                            break;
                        }
                        case 2: {
                            tHtmlTag10.setProperty("valign", "bottom");
                        }
                    }
                } else {
                    tHtmlTag10.setProperty("valign", "top");
                }
                object4 = tDriverStructRecordArray[n5];
                if (this.F instanceof TDimensionalDriver && !tDriverStructRecordArray[n5].IsExternalStructField) {
                    object4 = ((TDimensionalDriver)this.F).getEmbeddedDSRec(tDriverStructRecordArray[n5]);
                }
                boolean bl35 = ((TDriverStructRecord)object4).Html_Permit_Editing && bl11;
                object14 = hashtable3.get(((TDriverStructRecord)object4).FullID);
                object2 = null;
                object2 = ((TDriverStructRecord)object4).IsLookup ? new THtmlTag("text") : this.formatHtmlValue((TDriverStructRecord)object4, object14, 0, n5, -1, ((TDriverStructRecord)object4).ArraySize, bl35);
                if (bl35) {
                    if (objectutil.isDateField(((TDriverStructRecord)object4).FieldType)) {
                        ((THtmlTag)object2).setProperty("onChange", "validateDateInput(this);submitTableCell(this);");
                    } else {
                        ((THtmlTag)object2).setProperty("onChange", "submitTableCell(this)");
                    }
                    ((THtmlTag)object2).setProperty("onkeydown", "return keyDown(event,this);");
                }
                tHtmlTag10.addContent((THtmlTag)object2);
                if (tDriverStructRecordArray[n5].FormatPattern.trim().length() > 0 && !tDriverStructRecordArray[n5].FormatPattern.startsWith("=") && !bl6) {
                    tHtmlTag10.setProperty("pattern", tDriverStructRecordArray[n5].FormatPattern);
                }
                if (!bl6) {
                    tHtmlTag10.setProperty("CellIndex", Integer.toString(n5));
                }
                if (!tDriverStructRecordArray[n5].IsLookup && objectutil.isNumberField(tDriverStructRecordArray[n5].FieldType)) {
                    tHtmlTag10.setProperty("style", "text-align:right;");
                    tHtmlTag10.setProperty("align", "right");
                } else if (tDriverStructRecordArray[n5].RendererHorzLabelPosition == 0) {
                    tHtmlTag10.setProperty("style", "text-align:left;");
                    tHtmlTag10.setProperty("align", "left");
                }
                ((THtmlTag)object10).addContent(tHtmlTag10);
            }
            tExportHtmlOutput.writeString(((THtmlTag)object10).toString(), false);
            tExportHtmlOutput.write_crlf();
        }
        object10 = "";
        boolean bl36 = false;
        String string31 = "";
        boolean bl37 = bl4 = bl6 && !bl14 && !bl11;
        for (n9 = n; !bl4 && n9 < n7; ++n9) {
            int n16;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string32 = ((TDriverStructRecord)arrayList2.get((int)i)).FullID;
                object6 = (TDriverStructRecord)arrayList2.get(i);
                object5 = objectutil.convertFieldTypeToString(((TDriverStructRecord)object6).FieldType, this.getFieldForHtml((TDriverStructRecord)object6, n9));
                object4 = (String)hashtable2.get(string32);
                if (object4 != null && object5 != null && ((String)object5).equalsIgnoreCase((String)object4)) continue;
                if (object5 != null) {
                    hashtable2.put(string32, (String)object5);
                }
                object10 = string32 + "|TableHeader|" + this.getKeyValue(n9);
                object10 = charutil.removeChar(charutil.removeChar((String)object10, '\\'), '/');
                bl36 = ((TDriverStructRecord)arrayList2.get((int)i)).HtmlCollapseSection;
                object14 = this.getHtmlForSection((TDriverStructRecord)object6, n9, true);
                object3 = ((TDriverStructRecord)object6).FormatPattern;
                if (((String)object3).length() == 0) {
                    object3 = objectutil.getDefaultPattern(((TDriverStructRecord)object6).FieldType);
                }
                object5 = objectutil.applyPattern(object14, (String)object3);
                object5 = "<span class=\"hyperlink\" style=\"text-decoration:none\" onClick=\"toggleTableRows('" + string5.toLowerCase() + "','" + (String)object10 + "')\">" + (String)object5 + "</span>";
                object2 = new THtmlTag("tr");
                ((THtmlTag)object2).setProperty("class", "section");
                if (!bl6) {
                    ((THtmlTag)object2).setProperty("issectionheader", "true");
                }
                if (!bl6) {
                    ((THtmlTag)object2).setProperty("headerid", (String)object10);
                }
                ((THtmlTag)object2).setProperty("headerkey", string32 + "|" + this.getKeyValue(n9));
                ((THtmlTag)object2).setProperty("style", "border:none;");
                tHtmlTag = new THtmlTag("TD");
                tHtmlTag.setProperty("colspan", n10);
                tHtmlTag.setProperty("style", "padding-left:0px; border:none;");
                tHtmlTag.setProperty("content", (String)object5);
                ((THtmlTag)object2).addContent(tHtmlTag);
                tExportHtmlOutput.writeString(((THtmlTag)object2).toString(), false);
                tExportHtmlOutput.write_crlf();
                if (i != arrayList2.size() - 1) continue;
                object = charutil.replaceAllSubstrings(stringBuilder.toString(), "~headerid~", (String)object10);
                object = bl36 ? charutil.replaceAllSubstrings((String)object, "~headerstyle~", "display:none") : charutil.replaceAllSubstrings((String)object, "~headerstyle~", "");
                tExportHtmlOutput.writeString((String)object, false);
                tExportHtmlOutput.write_crlf();
            }
            THtmlTag tHtmlTag11 = new THtmlTag("tr");
            if (!bl6) {
                if (this.isSubtotal(n9)) {
                    tHtmlTag11.setProperty("KeyValue", this.SubtotalsDriver.getKeyValue(this.AspectDriverFilter.getAbsoluteDiskIndex(n9) - this.F.getRecordCount()));
                } else {
                    tHtmlTag11.setProperty("KeyValue", this.getKeyValue(n9));
                    tHtmlTag11.setProperty("onclick", "tableRowClicked(this)");
                }
            }
            if (tDriverStructRecord6 != null) {
                Object object24 = this.getField(tDriverStructRecord6, n9);
                tHtmlTag11.setProperty("VirtualIndex", objectutil.convertFieldTypeToString(tDriverStructRecord6.FieldType, object24));
            }
            if (arrayList2.size() == 0) {
                if (!bl6) {
                    tHtmlTag11.setProperty("headerid", "NoHeaders");
                }
            } else if (!bl6) {
                tHtmlTag11.setProperty("headerid", (String)object10);
            }
            for (n16 = 0; n16 < arrayList.size(); ++n16) {
                object6 = (TDriverStructRecord)arrayList.get(n16);
                object5 = ((TDriverStructRecord)object6).ID.substring(10);
                object4 = objectutil.convertToString(this.getField((TDriverStructRecord)object6, n9));
                if (((String)object5).trim().length() <= 0 || ((String)object4).trim().length() <= 0) continue;
                tHtmlTag11.setProperty((String)object5, (String)object4);
            }
            if (bl36) {
                tHtmlTag11.setProperty("style", tHtmlTag11.getProperty("style") + ";display:none");
            }
            n16 = this.getSubtotalLevel(n9);
            if (!bl6) {
                tHtmlTag11.setProperty("AspectSubtotalLevel", n16);
                if (this.isSubtotal(n9)) {
                    tHtmlTag11.setProperty("IsGrandTotal", Boolean.toString(this.isGrandTotalAbsolute(this.AspectDriverFilter.getAbsoluteDiskIndex(n9))));
                    tHtmlTag11.setProperty("SubtotalIndex", Integer.toString(this.AspectDriverFilter.getAbsoluteDiskIndex(n9) - this.F.getRecordCount()));
                }
                if (tDriverStructRecord != null) {
                    object6 = this.getField(tDriverStructRecord, n9);
                    if (object6 != null) {
                        if (tDriverStructRecord.IsLookup) {
                            object6 = this.convertFieldValueToComboboxString(tDriverStructRecord, object6, n9);
                        }
                        if (object6 != null) {
                            tHtmlTag11.setProperty("keydescription", objectutil.convertToString(object6));
                        } else {
                            tHtmlTag11.setProperty("keydescription", "Record " + Integer.toString(n9));
                        }
                    }
                } else {
                    tHtmlTag11.setProperty("keydescription", "Record " + Integer.toString(n9));
                }
            }
            if (bl8) {
                object6 = new THtmlTag("TD");
                if (n16 < 0) {
                    ((THtmlTag)object6).setProperty("name", "selectrecord");
                    ((THtmlTag)object6).setProperty("valign", "center");
                    ((THtmlTag)object6).setProperty("align", "center");
                    ((THtmlTag)object6).setProperty("style", "text-align:center");
                    ((THtmlTag)object6).setProperty("class", "selectRecordTD");
                    ((THtmlTag)object6).setProperty("content", "<input type='checkbox'>");
                } else {
                    ((THtmlTag)object6).setProperty("name", "selectrecord");
                    ((THtmlTag)object6).setProperty("content", "&nbsp;");
                }
                tHtmlTag11.addContent((THtmlTag)object6);
            }
            if (bl15) {
                object6 = new THtmlTag("TD");
                ((THtmlTag)object6).setProperty("name", "inspectrecord");
                ((THtmlTag)object6).setProperty("class", "inspectRecordTD");
                object5 = TPasswordService.generateSalt(8);
                ((THtmlTag)object6).setProperty("ID", (String)object5);
                int n17 = 0;
                for (int i = 0; i < tDriverInspect.menuItemCount(); ++i) {
                    int n18 = this.AspectDriverFilter.getAbsoluteDiskIndex(n9);
                    boolean bl38 = tDriverInspect.isEnabled(this, n18, i);
                    boolean bl39 = tDriverInspect.hideWhenDisabled(i);
                    if (!bl38 && bl39) continue;
                    ((THtmlTag)object6).setProperty("InspectParams" + tDriverInspect.getMenuItemID(i), tDriverInspect.getMenuItemParams(this, n18, i));
                    ((THtmlTag)object6).setProperty("InspectTitle" + tDriverInspect.getMenuItemID(i), tDriverInspect.getMenuItemViewTitle(this, n18, i));
                    ((THtmlTag)object6).setProperty("InspectDescription" + tDriverInspect.getMenuItemID(i), tDriverInspect.getMenuItemDescription(this, n18, i));
                    if (bl38) {
                        ((THtmlTag)object6).setProperty("InspectEnabled" + tDriverInspect.getMenuItemID(i), "true");
                    } else {
                        ((THtmlTag)object6).setProperty("InspectEnabled" + tDriverInspect.getMenuItemID(i), "false");
                    }
                    ++n17;
                }
                if (n17 > 0) {
                    THtmlTag tHtmlTag12 = new THtmlTag("div");
                    tHtmlTag12.setProperty("class", "inspectRecordTDDiv");
                    tHtmlTag12.setProperty("onClick", "showInspectMenu('" + (String)object5 + "','" + string5.toLowerCase() + "')");
                    ((THtmlTag)object6).append(tHtmlTag12);
                }
                tHtmlTag11.addContent((THtmlTag)object6);
            }
            if (bl11 && !((String)object21).equalsIgnoreCase("none") && !bl20) {
                object6 = new THtmlTag("TD");
                if (n16 < 0) {
                    ((THtmlTag)object6).setProperty("name", "editrecord");
                    ((THtmlTag)object6).setProperty("class", "OpenEditDialogTD");
                    object5 = new THtmlTag("div");
                    ((THtmlTag)object5).setProperty("class", "OpenEditDialogTDDiv");
                    ((THtmlTag)object5).setProperty("onClick", "showTableEditDialog(this)");
                    ((THtmlTag)object6).append((THtmlTag)object5);
                } else {
                    ((THtmlTag)object6).setProperty("name", "editrecord");
                    ((THtmlTag)object6).addContent("&nbsp;");
                }
                tHtmlTag11.addContent((THtmlTag)object6);
            }
            if (n16 < 0 && bl25) {
                tHtmlTag11.setProperty("aspectAllValues", charutil.replaceAllSubstrings(this.getEmbeddedFieldInfo(n9, 2, stringArray, null), "\"", "//quote//"));
            }
            for (n5 = 0; n5 < n8; ++n5) {
                boolean bl40;
                if (n4 != 0 && !tDriverStructRecordArray[n5].CalcSubtotal && !tDriverStructRecordArray[n5].SubtotalAsFormula && ((String)object19).indexOf("|" + tDriverStructRecordArray[n5].ID.toUpperCase() + "|") < 0) continue;
                object6 = new THtmlTag("TD");
                object5 = string14;
                if (bl) {
                    object5 = (String)object5 + "_" + tDriverStructRecordArray[n5].ID.toLowerCase();
                }
                boolean bl41 = bl40 = tDriverStructRecordArray[n5].TDClass.length() > 0;
                if (bl40) {
                    object3 = charutil.replaceAllSubstrings(tDriverStructRecordArray[n5].TDClass, "{FieldID}", tDriverStructRecordArray[n5].ID);
                    object2 = this.F.getFormulaEvaluator().getFormulaValue((String)object3, this.getAbsoluteDiskIndex(n9), -1);
                    if (object2 != null) {
                        object5 = objectutil.convertToString(object2);
                    }
                }
                if (this.isSubtotal(n9)) {
                    object5 = (String)object5 + "_subtotal";
                }
                if (n16 >= 0) {
                    object5 = (String)object5 + Integer.toString(n16);
                }
                if (bl || bl40 || this.isSubtotal(n9)) {
                    ((THtmlTag)object6).setProperty("class", (String)object5);
                }
                if (!bl) {
                    switch (tDriverStructRecordArray[n5].RendererHorzLabelPosition) {
                        case 0: {
                            if (objectutil.isNumberField(tDriverStructRecordArray[n5].FieldType)) {
                                ((THtmlTag)object6).setProperty("align", "center");
                                break;
                            }
                            ((THtmlTag)object6).setProperty("align", "left");
                            break;
                        }
                        case 1: 
                        case 4: {
                            ((THtmlTag)object6).setProperty("align", "left");
                            break;
                        }
                        case 3: {
                            ((THtmlTag)object6).setProperty("align", "center");
                            break;
                        }
                        case 2: 
                        case 5: {
                            ((THtmlTag)object6).setProperty("align", "right");
                        }
                    }
                    switch (tDriverStructRecordArray[n5].RendererVertLabelPosition) {
                        case 3: {
                            ((THtmlTag)object6).setProperty("valign", "center");
                            break;
                        }
                        case 2: {
                            ((THtmlTag)object6).setProperty("valign", "bottom");
                        }
                    }
                } else {
                    ((THtmlTag)object6).setProperty("valign", "top");
                }
                if (tDriverStructRecordArray[n5].TDAttributes.length() > 0 && (object3 = this.F.getFormulaEvaluator().getFormulaValue(tDriverStructRecordArray[n5].TDAttributes, this.getAbsoluteDiskIndex(n9), -1)) != null) {
                    ((THtmlTag)object6).setProperties(charutil.getSubStringArray(objectutil.convertToString(object3), ' ', false));
                }
                if ((object14 = n16 < 0 && tDriverStructRecordArray[n5].Html_Permit_Editing && bl11 && tDriverStructRecordArray[n5].IsLookup ? this.getField(tDriverStructRecordArray[n5], n9) : (tDriverStructRecordArray[n5].FormatPattern.startsWith("=") ? this.getField(tDriverStructRecordArray[n5], n9) : this.getFieldForHtml(tDriverStructRecordArray[n5], n9))) != null) {
                    object3 = tDriverStructRecordArray[n5];
                    if (this.F instanceof TDimensionalDriver && !tDriverStructRecordArray[n5].IsExternalStructField && !tDriverStructRecordArray[n5].IsCalculated && (object3 = ((TDimensionalDriver)this.F).getEmbeddedDSRec(tDriverStructRecordArray[n5])) == null) {
                        object3 = tDriverStructRecordArray[n5];
                    }
                    boolean bl42 = ((TDriverStructRecord)object3).Html_Permit_Editing && bl11 && n16 < 0 && !bl18;
                    tHtmlTag = this.formatHtmlValue((TDriverStructRecord)object3, object14, n9, n5, -1, ((TDriverStructRecord)object3).ArraySize, bl42);
                    if (bl42) {
                        if (objectutil.isDateField(((TDriverStructRecord)object3).FieldType)) {
                            tHtmlTag.setProperty("onChange", "validateDateInput(this);submitTableCell(this)");
                        } else {
                            tHtmlTag.setProperty("onChange", "submitTableCell(this)");
                        }
                        tHtmlTag.setProperty("onkeydown", "return keyDown(event,this);");
                    }
                    ((THtmlTag)object6).addContent(tHtmlTag);
                }
                if (tDriverStructRecordArray[n5].FormatPattern.trim().length() > 0 && !tDriverStructRecordArray[n5].FormatPattern.startsWith("=") && !bl6) {
                    ((THtmlTag)object6).setProperty("pattern", tDriverStructRecordArray[n5].FormatPattern);
                }
                if (!bl6) {
                    ((THtmlTag)object6).setProperty("CellIndex", Integer.toString(n5));
                }
                if (!tDriverStructRecordArray[n5].IsLookup && objectutil.isNumberField(tDriverStructRecordArray[n5].FieldType)) {
                    ((THtmlTag)object6).setProperty("style", "text-align:right;");
                    ((THtmlTag)object6).setProperty("align", "right");
                } else if (tDriverStructRecordArray[n5].RendererHorzLabelPosition == 0) {
                    ((THtmlTag)object6).setProperty("style", "text-align:left;");
                    ((THtmlTag)object6).setProperty("align", "left");
                }
                if (bl6) {
                    ((THtmlTag)object6).setProperty("style", ((THtmlTag)object6).getProperty("style") + ";vertical-align:top; border-width:1px; border-style:solid; border-color:#b8b8b8; padding:2px 10px 2px 3px;");
                }
                tHtmlTag11.addContent((THtmlTag)object6);
            }
            object6 = tHtmlTag11.getCRC();
            if (!bl6) {
                tHtmlTag11.setProperty("crc", (String)object6);
            }
            string31 = string31 + (String)object6;
            tExportHtmlOutput.writeString(tHtmlTag11.toString(), false);
            tExportHtmlOutput.write_crlf();
        }
        tExportHtmlOutput.writeString("</tbody>", false);
        tExportHtmlOutput.write_crlf();
        tExportHtmlOutput.writeString("</table>", false);
        tExportHtmlOutput.write_crlf();
        if (hashtable.containsKey("VER")) {
            tExportHtmlOutput.writeString("</div>", false);
            tExportHtmlOutput.write_crlf();
        }
        String string33 = "<span style=\"display:none\" ID=\"" + string5 + "CRC" + "\">" + charutil.crc(string31) + "</span>";
        tExportHtmlOutput.writeString(string33, false);
        tExportHtmlOutput.write_crlf();
        string33 = "<constant name:ContainsTextFields" + string5 + "; value:\"";
        for (n5 = 0; n5 < n8; ++n5) {
            if (n5 > 0) {
                string33 = string33 + "+";
            }
            string33 = string33 + tDriverStructRecordArray[n5].ID;
        }
        string33 = string33 + "\">";
        tExportHtmlOutput.writeString(string33, false);
        tExportHtmlOutput.write_crlf();
        return tExportHtmlOutput.getContent();
    }

    public synchronized String exportHtmlToCsv(String string, boolean bl, String string2, String string3, boolean bl2, boolean bl3, String string4, int n, int n2, String string5, Hashtable hashtable, String string6, String string7, String string8, TDriverDisplay tDriverDisplay) {
        String string9;
        Object object;
        int n3;
        int n4;
        int n5 = n4 = this.getRecordCount();
        int n6 = this.AspectDriverFilter.ColumnList.size();
        int n7 = 0;
        Date date = new Date();
        TDriverStructRecord[] tDriverStructRecordArray = new TDriverStructRecord[this.AspectDriverFilter.ColumnList.size()];
        for (n3 = 0; n3 < n6; ++n3) {
            object = (TAppDisplaysObject)this.AspectDriverFilter.ColumnList.get(n3);
            tDriverStructRecordArray[n3] = this.DriverStruct.getField(((TAppDisplaysObject)object).StructureFieldID);
        }
        TAsciiOutput tAsciiOutput = new TAsciiOutput(string, ',', false);
        n3 = 1;
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            String string10;
            String string11;
            String string12 = (String)object.nextElement();
            if (!string12.equalsIgnoreCase("Params") || (string11 = charutil.getElementValue(charutil.removeQuotes(string9 = (String)hashtable.get(string12)), "DimDriverParams", '|')).length() <= 0 || (string10 = charutil.getElementValue(string11, "ExportHeader", '^')).length() <= 0) continue;
            n3 = charutil.boolval(string10) ? 1 : 0;
        }
        if (n3 != 0) {
            for (int i = 0; i < n6; ++i) {
                System.out.println("field=" + i + " DSRec.ID=" + tDriverStructRecordArray[i].FullID + " Description=" + tDriverStructRecordArray[i].Description);
                string9 = charutil.replaceAllSubstrings(tDriverStructRecordArray[i].Description, "\\", " ");
                tAsciiOutput.writeString(string9, true);
            }
            tAsciiOutput.write_crlf();
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        boolean bl4 = false;
        for (n7 = 0; n7 < n4; ++n7) {
            int n8 = this.getSubtotalLevel(n7);
            for (int i = 0; i < n6; ++i) {
                Object object2 = null;
                object2 = n8 < 0 && tDriverStructRecordArray[i].Html_Permit_Editing && tDriverStructRecordArray[i].IsLookup ? this.getField(tDriverStructRecordArray[i], n7) : this.getField(tDriverStructRecordArray[i], n7);
                String string13 = tDriverStructRecordArray[i].FormatPattern;
                if (string13.length() == 0) {
                    string13 = objectutil.getDefaultPattern(tDriverStructRecordArray[i].FieldType);
                }
                String string14 = objectutil.applyPattern(object2, string13);
                String string15 = TPasswordService.generateSalt(4);
                string14 = charutil.replaceAllSubstrings(string14, ",|", string15);
                string14 = charutil.removeHtmlTags(string14);
                string14 = charutil.removeChar(string14, '\"');
                string14 = charutil.removeChar(string14, ',');
                boolean bl5 = false;
                if (objectutil.isCharField(tDriverStructRecordArray[i].FieldType) && string14.indexOf(44) > 0) {
                    bl5 = true;
                }
                if ((string14 = charutil.replaceAllSubstrings(string14, string15, ",")).endsWith("\r\n")) {
                    tAsciiOutput.writeString(string14.substring(0, string14.length() - 2), bl5);
                    tAsciiOutput.write_crlf();
                    continue;
                }
                tAsciiOutput.writeString(string14, bl5);
            }
            tAsciiOutput.write_crlf();
        }
        tAsciiOutput.dispose();
        System.out.println("exportHtmlToCsv complete");
        return "ok";
    }

    public synchronized String getRSSFeed(String string) {
        TDriverStructRecord[] tDriverStructRecordArray = new TDriverStructRecord[4];
        tDriverStructRecordArray[TAspectDriver.RSSITEM_TITLE] = this.getDriverStructRecord("RSSTitle");
        tDriverStructRecordArray[TAspectDriver.RSSITEM_DESCRIPTION] = this.getDriverStructRecord("RSSDescription");
        tDriverStructRecordArray[TAspectDriver.RSSITEM_LINK] = this.getDriverStructRecord("RSSLink");
        tDriverStructRecordArray[TAspectDriver.RSSITEM_MODIFIED] = this.getDriverStructRecord("RSSModified");
        if (tDriverStructRecordArray[RSSITEM_TITLE] == null || tDriverStructRecordArray[RSSITEM_DESCRIPTION] == null || tDriverStructRecordArray[RSSITEM_LINK] == null || tDriverStructRecordArray[RSSITEM_MODIFIED] == null) {
            return "Error: Cannot locate RSS fields.  Required fields are: RSSTitle, RSSDescription, RSSLink and RSSModified";
        }
        String string2 = TMainWin.Application.getTokenValue("packageurl_aspect_software_net_core");
        string2 = string2 + "core/doc/rss_template.txt";
        String string3 = TAsciiInput.getContent(string2);
        String[] stringArray = charutil.getSubStringArray(string, '&', true);
        String string4 = "<![CDATA[" + charutil.getParamValue(stringArray, "title") + "]]>";
        String string5 = "<![CDATA[" + charutil.getParamValue(stringArray, "description") + "]]>";
        String string6 = "<![CDATA[" + charutil.getParamValue(stringArray, "link") + "]]>";
        String string7 = "<![CDATA[" + charutil.getParamValue(stringArray, "imagelink") + "]]>";
        string3 = charutil.replaceAllSubstrings(string3, "$channel_title$", string4);
        string3 = charutil.replaceAllSubstrings(string3, "$channel_description$", string5);
        string3 = charutil.replaceAllSubstrings(string3, "$channel_link$", string6);
        string3 = charutil.replaceAllSubstrings(string3, "$channel_image_url$", string7);
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getRecordCount();
        for (int i = 0; i < n; ++i) {
            THtmlTag tHtmlTag = new THtmlTag("item");
            THtmlTag tHtmlTag2 = new THtmlTag("title");
            tHtmlTag2.setProperty("content", "<![CDATA[" + objectutil.convertFieldTypeToString(tDriverStructRecordArray[TAspectDriver.RSSITEM_TITLE].FieldType, this.getFieldForHtml(tDriverStructRecordArray[RSSITEM_TITLE], i)) + "]]>");
            THtmlTag tHtmlTag3 = new THtmlTag("description");
            tHtmlTag3.setProperty("content", "<![CDATA[" + objectutil.convertFieldTypeToString(tDriverStructRecordArray[TAspectDriver.RSSITEM_DESCRIPTION].FieldType, this.getFieldForHtml(tDriverStructRecordArray[RSSITEM_DESCRIPTION], i)) + "]]>");
            THtmlTag tHtmlTag4 = new THtmlTag("link");
            tHtmlTag4.setProperty("content", "<![CDATA[" + objectutil.convertFieldTypeToString(tDriverStructRecordArray[TAspectDriver.RSSITEM_LINK].FieldType, this.getFieldForHtml(tDriverStructRecordArray[RSSITEM_LINK], i)) + "]]>");
            THtmlTag tHtmlTag5 = new THtmlTag("pubDate");
            tHtmlTag5.setProperty("content", "<![CDATA[" + objectutil.convertFieldTypeToString(tDriverStructRecordArray[TAspectDriver.RSSITEM_MODIFIED].FieldType, this.getFieldForHtml(tDriverStructRecordArray[RSSITEM_MODIFIED], i)) + "]]>");
            tHtmlTag.addContent("\r\n" + tHtmlTag2.toString());
            tHtmlTag.addContent("\r\n" + tHtmlTag3.toString());
            tHtmlTag.addContent("\r\n" + tHtmlTag4.toString());
            tHtmlTag.addContent("\r\n" + tHtmlTag5.toString() + "\r\n");
            stringBuilder.append(tHtmlTag.toString() + "\r\n\r\n");
        }
        string3 = charutil.replaceAllSubstrings(string3, "$rss_items$", stringBuilder.toString());
        return string3;
    }

    public void export_to_binary(StringBuilder stringBuilder, String string) {
    }

    public synchronized TDriverStructRecord getVirtualIndexField() {
        return this.F.getVirtualIndexField();
    }

    public int getNextVirtualIndex() {
        return this.F.getNextVirtualIndex();
    }

    public synchronized void createUnusedVirtualIndex(int n) {
        TDriverStructRecord tDriverStructRecord = this.getVirtualIndexField();
        if (tDriverStructRecord == null) {
            return;
        }
        for (int i = 0; i < this.F.getRecordCount(); ++i) {
            Integer n2 = (Integer)this.F.getField(tDriverStructRecord, i);
            if (n2 < n) continue;
            this.F.putField(tDriverStructRecord, i, (Object)new Integer(n2 + 1));
        }
    }

    public synchronized void validateVirtualIndices() {
        TVirtualIndexSortObj tVirtualIndexSortObj;
        int n;
        if (!this.isWriteable()) {
            return;
        }
        TDriverStructRecord tDriverStructRecord = this.getVirtualIndexField();
        if (tDriverStructRecord == null) {
            return;
        }
        if (this.AppDriverObj.DriverID.toString().toUpperCase().indexOf("GREENLIGHT") >= 0) {
            MainWin.appendToLog("TAspectDriver", "validateVirtualIndices", Thread.currentThread(), null, 3, "validateVirtualIndices for " + this.AppDriverObj.DriverID.toString() + " Virtual Index:" + tDriverStructRecord.FullID + " Params: " + this.getDriverParams());
        }
        boolean bl = this.F.getUndoRecording();
        this.F.setUndoRecording(false);
        ArrayList<TVirtualIndexSortObj> arrayList = new ArrayList<TVirtualIndexSortObj>(this.F.getRecordCount());
        for (n = 0; n < this.F.getRecordCount(); ++n) {
            Integer n2 = (Integer)this.F.getField(tDriverStructRecord, n);
            tVirtualIndexSortObj = new TVirtualIndexSortObj(n, n2);
            int n3 = Collections.binarySearch(arrayList, tVirtualIndexSortObj);
            arrayList.add(Math.abs(n3 + 1), tVirtualIndexSortObj);
        }
        int n4 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            tVirtualIndexSortObj = (TVirtualIndexSortObj)arrayList.get(n);
            this.F.putField(tDriverStructRecord, tVirtualIndexSortObj.DiskIndex, (Object)new Integer(n4));
            ++n4;
        }
        this.F.setUndoRecording(bl);
    }

    public void showMaxRecordsReachedMessage() {
        JOptionPane.showMessageDialog(null, "The maximum number of records allowed is " + this.F.getMaxRecords() + ".", "Information...", 1);
    }

    public static void executeDriverPreActions(TAppDriversObject tAppDriversObject) {
        Object object;
        int n;
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (tAppDriversObject.ExecuteOnOpenMethod.length() > 0) {
            TMainWin.Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenMethod);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (n = 0; !bl && n < stringArray.length; ++n) {
                    object = TMainWin.execClassMethod(stringArray[n]);
                    if (object == null || !(object instanceof Boolean) || ((Boolean)object).booleanValue()) continue;
                    bl = true;
                }
            }
        }
        if (!bl && tAppDriversObject.ExecuteOnOpenAction.length() > 0) {
            TMainWin.Application.parse_tokens(stringBuilder, tAppDriversObject.ExecuteOnOpenAction);
            stringArray = charutil.getSubStringArray(stringBuilder, '|', true);
            if (stringArray != null) {
                for (n = 0; !bl && n < stringArray.length; ++n) {
                    object = TMainWin.Application.AppAction.getAppActionObject(stringArray[n]);
                    if (object == null || MainWin.executeActionObject(((TAppActionObject)object).ActionObject, null)) continue;
                    bl = true;
                }
            }
        }
        if (!bl && tAppDriversObject.ExecuteOnOpenScript.length() > 0) {
            object = new TExecScript(tAppDriversObject.ExecuteOnOpenScript, null, null);
            ((Thread)object).start();
            if (tAppDriversObject.WaitForScript) {
                while (((Thread)object).isAlive()) {
                    Thread.yield();
                    if (!(Math.random() < 0.1)) continue;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public double getSma(String string, int n, int n2, boolean bl) {
        String string2 = ("sma" + string + Integer.toString(n2) + Boolean.toString(bl)).toUpperCase();
        if (this.hashIndicators == null) {
            this.hashIndicators = new Hashtable();
        } else if (this.hashIndicators.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.hashIndicators.get(string2);
            if (arrayList.size() > n) {
                return (Double)arrayList.get(n);
            }
            return -1.0;
        }
        ArrayList arrayList = this.calculateSimpleMovingAverage(string, n2, bl);
        this.hashIndicators.put(string2, arrayList);
        if (arrayList.size() > n) {
            return (Double)arrayList.get(n);
        }
        return -1.0;
    }

    public ArrayList calculateSimpleMovingAverage(String string, int n, boolean bl) {
        double[] dArray = new double[n];
        ArrayList<Double> arrayList = new ArrayList<Double>();
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        int n2 = bl ? this.getAbsoluteRecordCount() : this.getRecordCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                dArray[j] = dArray[j + 1];
            }
            Object object = bl ? this.getFieldAbsolute(string, i) : this.getField(string, i);
            dArray[n - 1] = objectutil.convertToNumber(object);
            if (n3 < n) {
                ++n3;
            }
            double d = 0.0;
            for (int j = 0; j < n3; ++j) {
                d += dArray[n - 1 - j];
            }
            arrayList.add(new Double(d / (double)n3));
        }
        return arrayList;
    }

    public double getRSI(String string, int n, int n2, boolean bl) {
        String string2 = ("rsi" + string + Integer.toString(n2) + Boolean.toString(bl)).toUpperCase();
        if (this.hashIndicators == null) {
            this.hashIndicators = new Hashtable();
        } else if (this.hashIndicators.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.hashIndicators.get(string2);
            if (arrayList.size() > n) {
                return (Double)arrayList.get(n);
            }
            return -1.0;
        }
        ArrayList arrayList = this.calculateRelativeStrengthIndex(string, n2, bl);
        this.hashIndicators.put(string2, arrayList);
        if (arrayList.size() > n) {
            return (Double)arrayList.get(n);
        }
        return -1.0;
    }

    public ArrayList calculateRelativeStrengthIndex(String string, int n, boolean bl) {
        double[] dArray = new double[n];
        ArrayList<Double> arrayList = new ArrayList<Double>();
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        int n2 = bl ? this.getAbsoluteRecordCount() : this.getRecordCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                dArray[j] = dArray[j + 1];
            }
            Object object = bl ? this.getFieldAbsolute(string, i) : this.getField(string, i);
            dArray[n - 1] = objectutil.convertToNumber(object);
            if (n3 < n) {
                ++n3;
            }
            int n4 = 0;
            double d = 0.0;
            int n5 = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int j = 0; j < n3 - 1; ++j) {
                double d4 = dArray[n - 1 - j];
                double d5 = dArray[n - 1 - j - 1];
                double d6 = 0.0;
                if (d5 == 0.0) continue;
                d6 = (d4 - d5) / d5;
                if (d6 > 0.0) {
                    ++n4;
                    d += d6;
                    continue;
                }
                if (!(d6 < 0.0)) continue;
                ++n5;
                d2 += Math.abs(d6);
            }
            double d7 = n4 == 0 ? 0.0 : d / (double)n4;
            double d8 = n5 == 0 ? 0.0 : d2 / (double)n5;
            double d9 = d8 == 0.0 ? 0.0 : d7 / d8;
            d3 = 100.0 - 100.0 / (1.0 + d9);
            arrayList.add(new Double(d3));
        }
        return arrayList;
    }

    public double getStd(String string, int n, int n2, boolean bl) {
        String string2 = ("std" + string + Integer.toString(n2) + Boolean.toString(bl)).toUpperCase();
        if (this.hashIndicators == null) {
            this.hashIndicators = new Hashtable();
        } else if (this.hashIndicators.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.hashIndicators.get(string2);
            if (arrayList.size() > n) {
                return (Double)arrayList.get(n);
            }
            return -1.0;
        }
        ArrayList arrayList = this.calculateStandardDeviation(string, n2, bl);
        this.hashIndicators.put(string2, arrayList);
        if (arrayList.size() > n) {
            return (Double)arrayList.get(n);
        }
        return -1.0;
    }

    public ArrayList calculateStandardDeviation(String string, int n, boolean bl) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        ArrayList<Double> arrayList = new ArrayList<Double>();
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        int n2 = bl ? this.getAbsoluteRecordCount() : this.getRecordCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                dArray[j] = dArray[j + 1];
            }
            Object object = bl ? this.getFieldAbsolute(string, i) : this.getField(string, i);
            dArray[n - 1] = objectutil.convertToNumber(object);
            if (n3 < n) {
                ++n3;
            }
            for (int j = 0; j < n3; ++j) {
                dArray2[j] = dArray[n - 1 - j];
                if (j != 5) continue;
            }
            arrayList.add(new Double(statistics.stddev(dArray2, n3)));
        }
        return arrayList;
    }

    public double getEma(String string, int n, int n2, boolean bl) {
        if (n < 0) {
            System.out.println("getEma FieldID=" + string + " Record=" + n + " Periods=" + n2 + " Absolute=" + bl);
            return -1.0;
        }
        String string2 = ("ema" + string + Integer.toString(n2) + Boolean.toString(bl)).toUpperCase();
        if (this.hashIndicators == null) {
            this.hashIndicators = new Hashtable();
        } else if (this.hashIndicators.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.hashIndicators.get(string2);
            if (arrayList.size() > n) {
                return (Double)arrayList.get(n);
            }
            return -1.0;
        }
        ArrayList arrayList = this.calculateExponentialMovingAverage(string, n2, bl);
        this.hashIndicators.put(string2, arrayList);
        if (arrayList.size() > n) {
            return (Double)arrayList.get(n);
        }
        return -1.0;
    }

    public ArrayList calculateExponentialMovingAverage(String string, int n, boolean bl) {
        double[] dArray = new double[n];
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = 2.0 / (double)(n + 1);
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        int n2 = bl ? this.getAbsoluteRecordCount() : this.getRecordCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            double d2;
            for (int j = 0; j < n - 1; ++j) {
                dArray[j] = dArray[j + 1];
            }
            Object object = bl ? this.getFieldAbsolute(string, i) : this.getField(string, i);
            dArray[n - 1] = objectutil.convertToNumber(object);
            if (n3 < n) {
                ++n3;
                d2 = 0.0;
                for (int j = 0; j < n3; ++j) {
                    d2 += dArray[n - 1 - j];
                }
                arrayList.add(new Double(d2 / (double)n3));
                continue;
            }
            d2 = (Double)arrayList.get(arrayList.size() - 1);
            double d3 = (dArray[n - 1] - d2) * d + d2;
            arrayList.add(new Double(d3));
        }
        return arrayList;
    }

    public double getMacd(String string, int n, int n2, int n3, boolean bl) {
        String string2 = ("macd" + string + Integer.toString(n2) + Integer.toString(n3) + Boolean.toString(bl)).toUpperCase();
        if (this.hashIndicators == null) {
            this.hashIndicators = new Hashtable();
        } else if (this.hashIndicators.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.hashIndicators.get(string2);
            if (arrayList.size() > n) {
                return (Double)arrayList.get(n);
            }
            return -1.0;
        }
        ArrayList arrayList = this.calculateMacd(string, n2, n3, bl);
        this.hashIndicators.put(string2, arrayList);
        if (arrayList.size() > n) {
            return (Double)arrayList.get(n);
        }
        return -1.0;
    }

    public ArrayList calculateMacd(String string, int n, int n2, boolean bl) {
        ArrayList arrayList = this.calculateSimpleMovingAverage(string, n, bl);
        ArrayList arrayList2 = this.calculateSimpleMovingAverage(string, n2, bl);
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (int i = 0; i < arrayList.size(); ++i) {
            double d = (Double)arrayList.get(i);
            double d2 = (Double)arrayList2.get(i);
            arrayList3.add(new Double(d - d2));
        }
        return arrayList3;
    }

    public double getRana(String string, int n, int n2, boolean bl) {
        if (n < 0) {
            System.out.println("getRana FieldID=" + string + " Record=" + n + " Periods=" + n2 + " Absolute=" + bl);
            return -1.0;
        }
        String string2 = ("rana" + string + Integer.toString(n2) + Boolean.toString(bl)).toUpperCase();
        if (this.hashIndicators == null) {
            this.hashIndicators = new Hashtable();
        } else if (this.hashIndicators.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.hashIndicators.get(string2);
            if (arrayList.size() > n) {
                return (Double)arrayList.get(n);
            }
            return -1.0;
        }
        ArrayList arrayList = this.calculateRana(string, n2, bl);
        this.hashIndicators.put(string2, arrayList);
        if (arrayList.size() > n) {
            return (Double)arrayList.get(n);
        }
        return -1.0;
    }

    public ArrayList calculateRana(String string, int n, boolean bl) {
        double[] dArray = new double[n];
        ArrayList<Double> arrayList = new ArrayList<Double>();
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        int n2 = bl ? this.getAbsoluteRecordCount() : this.getRecordCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                dArray[j] = dArray[j + 1];
            }
            Object object = bl ? this.getFieldAbsolute(string, i) : this.getField(string, i);
            dArray[n - 1] = objectutil.convertToNumber(object);
            if (n3 < n) {
                ++n3;
            }
            if (n3 >= n) {
                double d = 0.0;
                double d2 = 0.0;
                for (int j = 0; j < n3 - 1; ++j) {
                    double d3 = dArray[n - 1 - j];
                    double d4 = dArray[n - 1 - j - 1];
                    double d5 = d3 - d4;
                    if (d5 > 0.0) {
                        d += d5;
                        continue;
                    }
                    d2 += Math.abs(d5);
                }
                double d6 = d + d2 != 0.0 ? (d - d2) / (d + d2) : 0.0;
                arrayList.add(new Double(d6));
                continue;
            }
            arrayList.add(new Double(0.0));
        }
        return arrayList;
    }

    public double getMcClellan(String string, int n, int n2, int n3, boolean bl) {
        String string2 = ("McLellan" + string + Integer.toString(n2) + Integer.toString(n3) + Boolean.toString(bl)).toUpperCase();
        if (this.hashIndicators == null) {
            this.hashIndicators = new Hashtable();
        } else if (this.hashIndicators.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.hashIndicators.get(string2);
            if (arrayList.size() > n) {
                return (Double)arrayList.get(n);
            }
            return -1.0;
        }
        ArrayList arrayList = this.calculateMcLellan(string, n2, n3, bl);
        this.hashIndicators.put(string2, arrayList);
        if (arrayList.size() > n) {
            return (Double)arrayList.get(n);
        }
        return -1.0;
    }

    public ArrayList calculateMcLellan(String string, int n, int n2, boolean bl) {
        ArrayList arrayList = this.calculateExponentialMovingAverage(string, n, bl);
        ArrayList arrayList2 = this.calculateExponentialMovingAverage(string, n2, bl);
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (int i = 0; i < arrayList.size(); ++i) {
            double d = (Double)arrayList.get(i);
            double d2 = (Double)arrayList2.get(i);
            arrayList3.add(new Double(d - d2));
        }
        return arrayList3;
    }

    public ArrayList getMonteCarlo(String string, int n, int n2, int n3, boolean bl) {
        String string2 = ("montecarlo" + string + Integer.toString(n2) + Integer.toString(n3) + Boolean.toString(bl)).toUpperCase();
        if (this.hashIndicators == null) {
            this.hashIndicators = new Hashtable();
        } else if (this.hashIndicators.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.hashIndicators.get(string2);
            if (arrayList.size() > n) {
                return (ArrayList)arrayList.get(n);
            }
            return null;
        }
        ArrayList arrayList = this.calculateMonteCarlo(string, n2, n3, bl);
        this.hashIndicators.put(string2, arrayList);
        if (arrayList.size() > n) {
            return (ArrayList)arrayList.get(n);
        }
        return null;
    }

    public ArrayList calculateMonteCarlo(String string, int n, int n2, boolean bl) {
        double[] dArray = new double[n];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        int n3 = bl ? this.getAbsoluteRecordCount() : this.getRecordCount();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            Object object;
            for (int j = 0; j < n - 1; ++j) {
                dArray[j] = dArray[j + 1];
            }
            Object object2 = bl ? this.getFieldAbsolute(string, i) : this.getField(string, i);
            dArray[n - 1] = objectutil.convertToNumber(object2);
            if (n4 < n) {
                ++n4;
            }
            if (n4 >= n) {
                object = new double[dArray.length - 1];
                for (int j = 0; j < ((Object)object).length; ++j) {
                    object[j] = dArray[j + 1] - dArray[j];
                }
                double d = statistics.stddev((double[])object);
                double d2 = statistics.mean((double[])object);
                double[] dArray2 = statistics.montecarlo(d2, d, n2, 1000);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(dArray2[0]));
                arrayList2.add(new Double(dArray2[1]));
                arrayList.add(arrayList2);
                continue;
            }
            object = new ArrayList<Double>();
            ((ArrayList)object).add(new Double(0.0));
            ((ArrayList)object).add(new Double(0.0));
            arrayList.add(object);
        }
        return arrayList;
    }

    public class TProfilegetFieldObj {
        String DriverID = "";
        String FieldID = "";
        String Method = "";
        boolean IsSubtotal = false;
        int Count = 0;
        int Duration = 0;

        TProfilegetFieldObj(String string, String string2, boolean bl, String string3) {
            this.DriverID = string;
            this.FieldID = string3;
            this.Method = string2;
            this.IsSubtotal = bl;
        }

        public String toString() {
            return this.DriverID + "," + this.Method + "," + this.IsSubtotal + "," + this.FieldID + "," + Integer.toString(this.Count) + "," + Integer.toString(this.Duration);
        }
    }

    public class TExportHtmlOutput {
        StringBuilder sContent = new StringBuilder();

        public void writeString(String string) {
            if (string.trim().length() > 0) {
                this.sContent.append(string);
            }
        }

        public void writeString(String string, boolean bl) {
            if (string.trim().length() > 0) {
                if (bl) {
                    this.sContent.append("\"" + string + "\"");
                } else {
                    this.sContent.append(string);
                }
            }
        }

        public void write_crlf() {
            this.sContent.append("\r\n");
        }

        public String getContent() {
            return this.sContent.toString();
        }
    }

    public class TVirtualIndexSortObj
    implements Comparable {
        int DiskIndex;
        int VirtualIndex;

        public TVirtualIndexSortObj(int n, int n2) {
            this.DiskIndex = n;
            this.VirtualIndex = n2;
        }

        public int compareTo(Object object) {
            if (this.VirtualIndex == ((TVirtualIndexSortObj)object).VirtualIndex) {
                if (this.DiskIndex < ((TVirtualIndexSortObj)object).DiskIndex) {
                    return -1;
                }
                return 1;
            }
            if (this.VirtualIndex < ((TVirtualIndexSortObj)object).VirtualIndex) {
                return -1;
            }
            return 1;
        }
    }
}

