/*
 * Decompiled with CFR 0.152.
 */
package drivercmd.core;

import aspect.TMainWin;
import controls.TProgressBar;
import drivercmd.TAbstractDriverCmd;
import drivercmd.TDriverCmdInterface;
import drivers.aspect.TDriverStructRecord;
import java.io.File;
import java.util.Hashtable;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dosutil;

public class TDriverCmdAddFiles
extends TAbstractDriverCmd
implements TDriverCmdInterface {
    private TProgressBar ProgressBar;
    private TDriverStructRecord DSRecFileName;
    private Hashtable hashFileNames;
    private String[] arExtensions;

    public TDriverCmdAddFiles(String string, String string2) {
        super(string, "FileName", "", "", "", string2);
    }

    @Override
    public String getDriverCommandName() {
        return this.getClass().getName();
    }

    @Override
    public boolean getMultipleInstancesAllowed() {
        return false;
    }

    public void addFilesInDirectory(File file) {
        File[] fileArray = file.listFiles();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.Debug) {
            // empty if block
        }
        for (int i = 0; !this.TerminateDriverCmd && i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.addFilesInDirectory(fileArray[i]);
            } else {
                String string = fileArray[i].getPath();
                String string2 = "";
                int n = string.lastIndexOf(46);
                if (n >= 0) {
                    string2 = string.substring(n);
                }
                boolean bl = false;
                for (int j = 0; !bl && j < this.arExtensions.length; ++j) {
                    if (!string2.equalsIgnoreCase(this.arExtensions[j]) && !this.arExtensions[j].equals(".*")) continue;
                    bl = true;
                }
                if (bl) {
                    if (string2.equalsIgnoreCase(".url")) {
                        bl = false;
                        TAsciiInput tAsciiInput = new TAsciiInput(dosutil.formatURL(string), ',');
                        if (tAsciiInput.isValid()) {
                            while (!bl && tAsciiInput.get_string(stringBuilder) > 0) {
                                if (!stringBuilder.toString().equalsIgnoreCase("[InternetShortcut]") || tAsciiInput.get_string(stringBuilder) <= 0 || stringBuilder.length() <= 4) continue;
                                string = stringBuilder.substring(4);
                                bl = true;
                            }
                        }
                        tAsciiInput.dispose();
                    }
                    if (bl && this.hashFileNames.containsValue(string)) {
                        bl = false;
                    }
                    if (bl) {
                        if (this.Debug) {
                            this.MainWin.appendToLog("TDriverCmdAddFiles", "addFilesInDirectory", Thread.currentThread(), null, 10, "Adding file: " + fileArray[i].getPath());
                        }
                        n = this.AspectDriver.initializeNewRecord(this.AspectDriver.AppDriverObj.InsertMode, 0);
                        this.AspectDriver.putFieldAbsolute(this.DSRecFileName, n, (Object)string);
                        this.hashFileNames.put(string, string);
                    }
                }
            }
            this.ProgressBar.increment();
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void run() {
        int n;
        String string = TMainWin.executeDialog("Playlist - Add Files");
        if (!string.equalsIgnoreCase("ok")) {
            return;
        }
        this.DSRecFileName = this.DriverInterface.getDriverStructRecord("FileName");
        this.ProgressBar = new TProgressBar("Adding files...");
        String string2 = this.Application.getTokenValue("$PlaylistDirectory");
        String string3 = this.Application.getTokenValue("$PlaylistExtensions");
        this.arExtensions = charutil.getSubStringArray(string3, ',', true);
        for (n = 0; n < this.arExtensions.length; ++n) {
            if (this.arExtensions.length <= 0 || this.arExtensions[n].charAt(0) == '.') continue;
            this.arExtensions[n] = "." + this.arExtensions[n];
        }
        this.hashFileNames = new Hashtable();
        for (n = 0; n < this.ScrollTable.AspectDriver.getAbsoluteRecordCount(); ++n) {
            Object object = this.ScrollTable.AspectDriver.getFieldAbsolute(this.DSRecFileName, n);
            this.hashFileNames.put(object, object);
        }
        this.addFilesInDirectory(new File(string2));
        this.ProgressBar.dispose();
        this.ScrollTable.refreshTable();
    }

    @Override
    public boolean cancel() {
        this.TerminateDriverCmd = true;
        return true;
    }
}

