/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TCheckBox;
import controls.TTextField;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.aspect.TPackage;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import scrollwin.dialogpanel.TDialogTablePanel;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.dialogpanel.TScrollDialogPanelAbstractListener;
import scrollwin.dialogpanel.TScrollDialogPanelControl;
import scrollwin.dialogpanel.TScrollDialogPanelEvent;
import scrollwin.table.TScrollTable;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dosutil;
import utility.objectutil;

public class TResourceIdentifiersDialogListener
extends TScrollDialogPanelAbstractListener {
    private TMainWin MainWin = Aspect.MainWin;
    private TAspectDriver ResultsDriver = null;
    private TScrollTable ResultsTable = null;
    private TTextField SearchInputBox = null;
    private TTextField ReplaceInputBox = null;
    private TCheckBox CkWholeWordsOnly = null;
    private TCheckBox CkCaseSensitive = null;
    private boolean IsInitialized = false;

    @Override
    public void scrollDialogPanelEventOccurred(TScrollDialogPanelEvent tScrollDialogPanelEvent) {
        if (!this.IsInitialized) {
            TScrollDialogPanel tScrollDialogPanel = tScrollDialogPanelEvent.getScrollDialogPanel();
            if (tScrollDialogPanel != null) {
                TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("ResultsTable");
                if (tScrollDialogPanelControl != null) {
                    this.ResultsTable = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel.Table;
                    this.ResultsDriver = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).AspectDriver;
                }
                if ((tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$Identifier")) != null) {
                    this.SearchInputBox = (TTextField)tScrollDialogPanelControl.ControlObj;
                }
                if ((tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$Replacement")) != null) {
                    this.ReplaceInputBox = (TTextField)tScrollDialogPanelControl.ControlObj;
                }
                if ((tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$WholeWordsOnly")) != null) {
                    this.CkWholeWordsOnly = (TCheckBox)tScrollDialogPanelControl.ControlObj;
                }
                if ((tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$CaseSensitive")) != null) {
                    this.CkCaseSensitive = (TCheckBox)tScrollDialogPanelControl.ControlObj;
                }
            }
            this.IsInitialized = true;
        }
        switch (tScrollDialogPanelEvent.getEventType()) {
            case 0: {
                this.handleActionPerformedEvent(tScrollDialogPanelEvent);
            }
        }
    }

    public void handleActionPerformedEvent(TScrollDialogPanelEvent tScrollDialogPanelEvent) {
        if (this.ResultsDriver == null || this.SearchInputBox == null || this.ReplaceInputBox == null || this.CkWholeWordsOnly == null || this.CkCaseSensitive == null) {
            return;
        }
        String string = tScrollDialogPanelEvent.getScrollDialogPanelControlID();
        String string2 = this.SearchInputBox.getText();
        String string3 = this.ReplaceInputBox.getText();
        boolean bl = this.CkWholeWordsOnly.isChecked();
        boolean bl2 = this.CkCaseSensitive.isChecked();
        if (string.equalsIgnoreCase("FINDBUTTON")) {
            if (tScrollDialogPanelEvent.getEventType() == 0) {
                this.findIdentifierInPackages(string2, bl, bl2);
            }
        } else if (string.equalsIgnoreCase("REPLACEBUTTON") && tScrollDialogPanelEvent.getEventType() == 0) {
            this.replaceIdentifier(string2, string3, bl2);
        }
    }

    private void findIdentifierInPackages(String string, boolean bl, boolean bl2) {
        this.ResultsDriver.f_create();
        this.ResultsTable.refreshTable();
        TAspectDriver tAspectDriver = new TAspectDriver("PackageWrapper", 1, false, true, "");
        if (tAspectDriver == null) {
            return;
        }
        for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
            TPackage tPackage = new TPackage(tAspectDriver, i);
            String string2 = tPackage.getLocalLocation();
            String string3 = tPackage.getPackageName();
            if (string2.trim().length() <= 0) continue;
            String string4 = dosutil.addTrailingSlash(string2);
            string4 = charutil.replaceChar(string4, '\\', '/');
            this.findIdentifierInFile(tPackage, 0, string4 + "main.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 3, string4 + "tokens.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 1, string4 + "actions.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 2, string4 + "menu.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 4, string4 + "struct.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 5, string4 + "drivers.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 6, string4 + "collctn.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 7, string4 + "displays.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 8, string4 + "filters.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 9, string4 + "dialogs.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 13, string4 + "tables.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 15, string4 + "reports.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 10, string4 + "scripts.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 11, string4 + "toolbar.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 12, string4 + "function.asp", string, bl, bl2);
            this.findIdentifierInFile(tPackage, 14, string4 + "drivercmd.asp", string, bl, bl2);
        }
        tAspectDriver.dispose();
    }

    private void findIdentifierInFile(TPackage tPackage, int n, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        TAsciiInput tAsciiInput = new TAsciiInput(string, ',', true);
        if (!tAsciiInput.isValid()) {
            tAsciiInput.dispose();
            return;
        }
        TDriverStruct tDriverStruct = TMainWin.Application.getResourceStructure(n);
        while (tAsciiInput.get_string(stringBuilder) > 0) {
            String[] stringArray = charutil.getSubStringArray(stringBuilder, ',', true);
            for (int i = 0; i < stringArray.length; ++i) {
                int n3 = bl2 ? stringArray[i].indexOf(string2) : stringArray[i].toUpperCase().indexOf(string2.toUpperCase());
                if (n3 < 0) continue;
                boolean bl3 = true;
                if (bl) {
                    char c;
                    if (n3 > 0) {
                        c = stringArray[i].charAt(n3 - 1);
                        if (c >= 'A' && c <= 'z') {
                            bl3 = false;
                        }
                        if (c >= '0' && c <= '9') {
                            bl3 = false;
                        }
                    }
                    if (bl3 && n3 + string2.length() < stringArray[i].length()) {
                        c = stringArray[i].charAt(n3 + string2.length());
                        if (c >= 'A' && c <= 'z') {
                            bl3 = false;
                        }
                        if (c >= '0' && c <= '9') {
                            bl3 = false;
                        }
                    }
                }
                if (!bl3) continue;
                n3 = this.ResultsDriver.initializeNewRecord();
                this.ResultsDriver.putField("Selected", n3, (Object)Boolean.FALSE);
                this.ResultsDriver.putField("Package_Name", n3, (Object)tPackage.getPackageName());
                this.ResultsDriver.putField("Package_ID", n3, (Object)tPackage.getPackageID());
                this.ResultsDriver.putField("Package_Location", n3, (Object)tPackage.getLocalLocation());
                this.ResultsDriver.putField("ReadOnlyPackage", n3, (Object)new Boolean(tPackage.isReadOnly()));
                this.ResultsDriver.putField("Resource_Type", n3, (Object)new Integer(n));
                this.ResultsDriver.putField("Filename", n3, (Object)string);
                this.ResultsDriver.putField("Line_Number", n3, (Object)new Integer(n2 + 1));
                this.ResultsDriver.putField("Field_Index", n3, (Object)new Integer(i));
                this.ResultsDriver.putField("Field_ID", n3, (Object)tDriverStruct.getFieldID(i, false));
                this.ResultsDriver.putField("Field_Description", n3, (Object)tDriverStruct.getFieldDescription(i, false));
                this.ResultsDriver.putField("Field_Contents", n3, (Object)stringArray[i]);
                this.ResultsDriver.addToFilterList(n3);
                this.ResultsTable.getTableModel().fireTableDataChanged();
            }
            ++n2;
        }
        tAsciiInput.dispose();
    }

    private void replaceIdentifier(String string, String string2, boolean bl) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        for (n = 0; n2 == 0 && n < this.ResultsDriver.getRecordCount(); ++n) {
            if (!((Boolean)this.ResultsDriver.getField("Selected", n)).booleanValue()) continue;
            ++n2;
        }
        if (n2 == 0) {
            JOptionPane.showMessageDialog(null, "No records are selected for replacement.", "Nothing to do.", 1);
        }
        String string3 = TMainWin.Application.getTokenValue("$PackageLocation");
        TAspectDriver tAspectDriver = new TAspectDriver("PackageWrapper", 1, false, true, "");
        if (tAspectDriver == null) {
            return;
        }
        for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
            TPackage tPackage = new TPackage(tAspectDriver, i);
            for (int j = 0; j < 14; ++j) {
                arrayList.clear();
                for (n = 0; n < this.ResultsDriver.getRecordCount(); ++n) {
                    if (!((Boolean)this.ResultsDriver.getField("Selected", n)).booleanValue() || !((String)this.ResultsDriver.getField("Package_ID", n)).equalsIgnoreCase(tPackage.getPackageID()) || (Integer)this.ResultsDriver.getField("Resource_Type", n) != j) continue;
                    arrayList.add(new Integer(n));
                }
                if (arrayList.size() <= 0) continue;
                String string4 = tPackage.getLocalLocation();
                string4 = dosutil.addTrailingSlash(string4);
                string4 = charutil.replaceChar(string4, '\\', '/');
                TMainWin.Application.setTokenValue("$PackageLocation", string4);
                string4 = TMainWin.Application.parse_tokens(TMainWin.Application.getResourceDriverID(j));
                if (string4 == null) continue;
                TAspectDriver tAspectDriver2 = new TAspectDriver(string4, 1, false, true, "");
                for (n = 0; n < arrayList.size(); ++n) {
                    int n3 = (Integer)arrayList.get(n);
                    String string5 = (String)this.ResultsDriver.getField("Field_ID", n3);
                    TDriverStructRecord tDriverStructRecord = tAspectDriver2.DriverStruct.getField(string5);
                    int n4 = (Integer)this.ResultsDriver.getField("Line_Number", n3) - 1;
                    Object object = tAspectDriver2.getField(tDriverStructRecord, n4);
                    string4 = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
                    String string6 = "__%__^";
                    while (string4.toUpperCase().indexOf(string.toUpperCase()) >= 0) {
                        string4 = charutil.replaceSubstring(string4, string, string6);
                    }
                    while (string4.indexOf(string6) >= 0) {
                        string4 = charutil.replaceSubstring(string4, string6, string2);
                    }
                    object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string4, n4);
                    tAspectDriver2.putField(tDriverStructRecord, n4, object);
                    this.ResultsDriver.putField("Field_Contents", n3, (Object)string4);
                }
                tAspectDriver2.dispose();
            }
        }
        tAspectDriver.dispose();
        TMainWin.Application.setTokenValue("$PackageLocation", string3);
        this.ResultsTable.refreshTable();
    }
}

