/*
 * Decompiled with CFR 0.152.
 */
package controls.renderers;

import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.awt.Component;
import java.awt.Image;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import scrollwin.table.TScrollTable;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.imageutil;

public class TLabelRenderer
implements TableCellRenderer {
    JLabel label;
    TAspectDriver AspectDriver;
    Hashtable hashImages = null;
    boolean isBordered;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    static int cPaints = 0;
    boolean IsHtml = false;

    public TLabelRenderer(boolean bl, TAspectDriver tAspectDriver, boolean bl2) {
        this.isBordered = bl;
        this.AspectDriver = tAspectDriver;
        this.IsHtml = bl2;
        this.label = new JLabel();
        this.label.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        TFormulaEvaluator tFormulaEvaluator = null;
        Border border = null;
        StringBuilder stringBuilder = new StringBuilder();
        this.label.setText("");
        this.label.setHorizontalAlignment(2);
        this.label.setVerticalAlignment(0);
        this.label.setOpaque(true);
        if (bl) {
            this.label.setBackground(((TScrollTable)jTable).colorSelectionBackground);
        } else {
            this.label.setBackground(((TScrollTable)jTable).colorTableBackground);
        }
        this.label.setIcon(null);
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.getDriverStructRecord(n2);
        if (tDriverStructRecord != null) {
            Object object2;
            tFormulaEvaluator = this.AspectDriver.getFormulaEvaluator();
            if (object instanceof String) {
                if (this.IsHtml) {
                    this.label.setText("<html>" + (String)object);
                } else {
                    this.label.setText((String)object);
                }
            }
            switch (tDriverStructRecord.RendererHorzLabelPosition) {
                case 0: 
                case 1: {
                    this.label.setHorizontalAlignment(2);
                    break;
                }
                case 3: {
                    this.label.setHorizontalAlignment(0);
                    break;
                }
                case 2: {
                    this.label.setHorizontalAlignment(4);
                    break;
                }
                case 4: {
                    this.label.setHorizontalAlignment(10);
                    break;
                }
                case 5: {
                    this.label.setHorizontalAlignment(11);
                }
            }
            switch (tDriverStructRecord.RendererVertLabelPosition) {
                case 0: 
                case 3: {
                    this.label.setVerticalAlignment(0);
                    break;
                }
                case 1: {
                    this.label.setVerticalAlignment(1);
                    break;
                }
                case 2: {
                    this.label.setVerticalAlignment(3);
                }
            }
            if (tDriverStructRecord != null && tDriverStructRecord.RendererParams.length() > 0) {
                String[] stringArray = charutil.getSubStringArray(charutil.removeQuotes(tDriverStructRecord.RendererParams), '|', true);
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', true);
                    if (stringArray2.length <= 1 || !stringArray2[0].equalsIgnoreCase("Indent")) continue;
                    object2 = tFormulaEvaluator.getFormulaValue(stringArray2[1], this.AspectDriver.getAbsoluteDiskIndex(n), n);
                    int n3 = (int)TFormulaEvaluator.convertToNumber(object2);
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    border = BorderFactory.createEmptyBorder(0, n3, 0, 0);
                }
            }
            if (tDriverStructRecord.RendererIcon != null && tDriverStructRecord.RendererIcon.length() > 0) {
                object2 = tFormulaEvaluator.getFormulaValue(tDriverStructRecord.RendererIcon, this.AspectDriver.getAbsoluteDiskIndex(n), n);
                if (object2 != null) {
                    String string = TMainWin.Application.parse_tokens(TFormulaEvaluator.convertToString(object2));
                    Image image = imageutil.getScaledImage(this.getClass(), string, -1, (int)((double)jTable.getRowHeight() * 0.95));
                    if (image != null) {
                        this.label.setIcon(new ImageIcon(image));
                    }
                }
                switch (tDriverStructRecord.RendererHorzIconPosition) {
                    case 0: 
                    case 1: {
                        this.label.setHorizontalTextPosition(4);
                        break;
                    }
                    case 3: {
                        this.label.setHorizontalTextPosition(0);
                        break;
                    }
                    case 2: {
                        this.label.setHorizontalTextPosition(2);
                        break;
                    }
                    case 4: {
                        this.label.setHorizontalTextPosition(11);
                        break;
                    }
                    case 5: {
                        this.label.setHorizontalTextPosition(10);
                    }
                }
                switch (tDriverStructRecord.RendererVertIconPosition) {
                    case 0: 
                    case 3: {
                        this.label.setVerticalTextPosition(0);
                        break;
                    }
                    case 1: {
                        this.label.setVerticalTextPosition(3);
                        break;
                    }
                    case 2: {
                        this.label.setVerticalTextPosition(1);
                    }
                }
            }
        }
        if (this.isBordered) {
            if (bl && !bl2) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getSelectionBackground());
                }
                this.label.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getBackground());
                }
                this.label.setBorder(this.unselectedBorder);
            }
        }
        if (border != null) {
            this.label.setBorder(BorderFactory.createCompoundBorder(this.label.getBorder(), border));
        }
        return this.label;
    }
}

