/*
 * Decompiled with CFR 0.152.
 */
package controls.renderers;

import drivers.aspect.TDriverStructRecord;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.View;
import utility.charutil;
import utility.dateutil;

public class TDateSpinnerCellRenderer
implements TableCellRenderer {
    private JFormattedTextField formattedTextField;
    private Border unselectedBorder = null;
    private Border selectedBorder = null;
    private boolean isBordered = true;
    private TDriverStructRecord DSRec;

    public TDateSpinnerCellRenderer(boolean bl, TDriverStructRecord tDriverStructRecord) {
        SimpleDateFormat simpleDateFormat = null;
        this.DSRec = tDriverStructRecord;
        if (this.DSRec.FormatPattern.length() > 0) {
            simpleDateFormat = new SimpleDateFormat(charutil.removeQuotes(this.DSRec.FormatPattern));
        } else {
            switch (this.DSRec.FieldType) {
                case 10: {
                    simpleDateFormat = dateutil.getDateTimeFormat(0);
                    break;
                }
                case 18: {
                    simpleDateFormat = dateutil.getDateTimeFormat(1);
                    break;
                }
                case 13: {
                    simpleDateFormat = dateutil.getDateTimeFormat(2);
                    break;
                }
                case 21: {
                    simpleDateFormat = dateutil.getDateTimeFormat(3);
                }
            }
        }
        this.formattedTextField = new JFormattedTextField(simpleDateFormat);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        try {
            this.formattedTextField.setValue((Date)object);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        switch (this.DSRec.RendererHorzLabelPosition) {
            case 0: 
            case 2: {
                this.formattedTextField.setHorizontalAlignment(4);
                break;
            }
            case 1: {
                this.formattedTextField.setHorizontalAlignment(2);
                break;
            }
            case 3: {
                this.formattedTextField.setHorizontalAlignment(0);
                break;
            }
            case 4: {
                this.formattedTextField.setHorizontalAlignment(10);
                break;
            }
            case 5: {
                this.formattedTextField.setHorizontalAlignment(11);
            }
        }
        try {
            this.formattedTextField.setUI(new BasicTextFieldUI(){

                @Override
                public View create(Element element) {
                    return new FieldView(element){

                        @Override
                        protected Shape adjustAllocation(Shape shape) {
                            if (shape == null) {
                                return (Rectangle)super.adjustAllocation(shape);
                            }
                            Rectangle rectangle = shape.getBounds();
                            int n = rectangle.height;
                            int n2 = rectangle.y;
                            int n3 = (int)this.getPreferredSpan(1);
                            int n4 = (int)this.getPreferredSpan(0);
                            rectangle = (Rectangle)super.adjustAllocation(shape);
                            int n5 = rectangle.height - n3;
                            switch (((TDateSpinnerCellRenderer)TDateSpinnerCellRenderer.this).DSRec.RendererVertLabelPosition) {
                                case 0: 
                                case 3: {
                                    break;
                                }
                                case 1: {
                                    rectangle.y = n2;
                                    rectangle.height -= n5;
                                    break;
                                }
                                case 2: {
                                    rectangle.y += rectangle.height;
                                    rectangle.height = n3;
                                }
                            }
                            return rectangle;
                        }
                    };
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isBordered) {
            if (bl && !bl2) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getSelectionBackground());
                }
                this.formattedTextField.setBorder(this.selectedBorder);
                this.formattedTextField.setBackground(jTable.getSelectionBackground());
                this.formattedTextField.setForeground(jTable.getSelectionForeground());
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, jTable.getBackground());
                }
                this.formattedTextField.setBorder(this.unselectedBorder);
                this.formattedTextField.setBackground(jTable.getBackground());
                this.formattedTextField.setForeground(jTable.getForeground());
            }
        }
        return this.formattedTextField;
    }
}

