/*
 * Decompiled with CFR 0.152.
 */
package controls.editors;

import aspect.TMainWin;
import controls.TTextFieldLimitLength;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import scrollwin.table.TScrollTable;

public class TStringCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    TStringEditor StringEditor;
    boolean IgnoreFirstKeypress = false;

    public TStringCellEditor(int n, Font font) {
        this.StringEditor = new TStringEditor(n, font);
        this.StringEditor.setText("");
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.StringEditor.KeyCount = 0;
        if (this.IgnoreFirstKeypress) {
            this.StringEditor.KeyCount = 1;
            this.IgnoreFirstKeypress = false;
        }
        this.StringEditor.setTable((TScrollTable)jTable);
        this.StringEditor.setOriginalText((String)object);
        if (object == null) {
            this.StringEditor.setText("");
        } else {
            this.StringEditor.setText((String)object);
        }
        return this.StringEditor;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            if (((MouseEvent)eventObject).getClickCount() >= TMainWin.Application.getTokenValueAsInt("$EditClickCount")) {
                this.IgnoreFirstKeypress = true;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.StringEditor.getText();
    }

    public class TStringEditor
    extends JTextField
    implements ActionListener {
        private TScrollTable table = null;
        private Font font;
        private StringBuilder OriginalText = new StringBuilder();
        private int KeyCount = 0;

        public TStringEditor(int n, Font font) {
            this.font = font;
            if (this.font != null) {
                this.setFont(this.font);
            }
            this.setDocument(new TTextFieldLimitLength(n));
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, false);
            this.registerKeyboardAction(this, "StopEditing", keyStroke, 0);
            this.registerKeyboardAction(this, "CancelEditing", keyStroke2, 0);
        }

        public void setTable(TScrollTable tScrollTable) {
            this.table = tScrollTable;
        }

        @Override
        public void setFont(Font font) {
            if (this.font != null) {
                super.setFont(this.font);
            } else {
                super.setFont(font);
            }
        }

        public void setOriginalText(String string) {
            this.OriginalText.setLength(0);
            this.OriginalText.append(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equalsIgnoreCase("StopEditing")) {
                TStringCellEditor.this.stopCellEditing();
                if (this.table != null) {
                    this.table.advanceRow();
                }
            } else if (actionEvent.getActionCommand().equalsIgnoreCase("CancelEditing")) {
                this.setText(this.OriginalText.toString());
                TStringCellEditor.this.cancelCellEditing();
            }
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            char c;
            ++this.KeyCount;
            if (this.KeyCount == 1 && (c = keyEvent.getKeyChar()) >= ' ' && c <= 'z') {
                this.setText("");
                this.setCaretPosition(0);
                return true;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
    }
}

