/*
 * Decompiled with CFR 0.152.
 */
package controls;

import collections.TComboBoxColl;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.metal.MetalComboBoxButton;
import utility.objectutil;

public class TComboBox
extends JComboBox {
    public TComboBoxColl ComboBoxColl = null;
    private TComboBoxListener ComboBoxListener;
    public String ControlID;
    public boolean ReturnKey = false;
    public int FieldType;

    public TComboBox(TComboBoxColl tComboBoxColl, int n) {
        this.ComboBoxColl = tComboBoxColl;
        this.FieldType = n;
        this.ComboBoxListener = new TComboBoxListener();
        this.addActionListener(this.ComboBoxListener);
        this.addItemListener(this.ComboBoxListener);
        this.setModel(new TComboBoxModel());
        this.initializeItems();
    }

    public TComboBox(StringBuilder stringBuilder, TComboBoxColl tComboBoxColl, int n) {
        this.ComboBoxColl = tComboBoxColl;
        this.FieldType = n;
        this.ComboBoxListener = new TComboBoxListener();
        this.addActionListener(this.ComboBoxListener);
        this.addItemListener(this.ComboBoxListener);
        this.setModel(new TComboBoxModel());
        this.ControlID = stringBuilder.toString();
        this.initializeItems();
    }

    public static void makeTransparent(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof MetalComboBoxButton) {
                ((MetalComboBoxButton)componentArray[i]).setOpaque(false);
                ((MetalComboBoxButton)componentArray[i]).setBorder(null);
                continue;
            }
            if (!(componentArray[i] instanceof JTextField)) continue;
            ((JTextField)componentArray[i]).setOpaque(false);
            ((JTextField)componentArray[i]).setBorder(null);
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        Component component;
        super.setOpaque(bl);
        if (this.getEditor() != null && (component = this.getEditor().getEditorComponent()) != null && component instanceof JComponent) {
            ((JComponent)component).setOpaque(bl);
        }
        if (bl) {
            TComboBox.makeTransparent(this.getComponents());
        }
    }

    @Override
    public void setBackground(Color color) {
        Component component;
        super.setBackground(color);
        if (this.getEditor() != null && (component = this.getEditor().getEditorComponent()) != null && component instanceof JComponent) {
            ((JComponent)component).setBackground(color);
        }
    }

    @Override
    public int getSelectedIndex() {
        return super.getSelectedIndex();
    }

    public Object getSelectedKey() {
        return ((TComboBoxModel)this.getModel()).getSelectedKey();
    }

    @Override
    public Object getSelectedItem() {
        return super.getSelectedItem();
    }

    @Override
    public Object[] getSelectedObjects() {
        return super.getSelectedObjects();
    }

    public void initializeItems() {
        this.removeAllItems();
        if (this.ComboBoxColl != null) {
            for (int i = 0; i < this.ComboBoxColl.size(); ++i) {
                TComboBoxColl.TComboBoxCollObj tComboBoxCollObj = (TComboBoxColl.TComboBoxCollObj)this.ComboBoxColl.get(i);
                this.addItem(tComboBoxCollObj.Value);
            }
        }
    }

    public void setReturnKey(boolean bl) {
        this.ReturnKey = bl;
    }

    public void setText(String string) {
        this.setComboBoxColl(this.ComboBoxColl, string);
    }

    public void setComboBoxSelection(Object object) {
        if (object != null) {
            int n = this.ComboBoxColl.getArrayIndexOfKey(object);
            if (n >= 0) {
                this.setSelectedIndex(n);
            } else if (this.isEditable() && object instanceof String) {
                this.setSelectedItem(object);
            }
        }
    }

    public void setComboBoxColl(TComboBoxColl tComboBoxColl, Object object) {
        this.ComboBoxColl = tComboBoxColl;
        this.initializeItems();
        if (object != null) {
            int n = this.ComboBoxColl.getArrayIndexOfKey(object);
            if (n >= 0) {
                this.setSelectedIndex(n);
            } else if (this.isEditable()) {
                if (object instanceof String) {
                    this.setSelectedItem(object);
                } else {
                    this.setSelectedItem(objectutil.convertToString(object));
                }
            }
        }
    }

    public class TComboBoxListener
    implements ActionListener,
    ItemListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    public class TComboBoxModel
    extends DefaultComboBoxModel {
        @Override
        public void addElement(Object object) {
            super.addElement(object);
        }

        @Override
        public Object getElementAt(int n) {
            return super.getElementAt(n);
        }

        @Override
        public int getIndexOf(Object object) {
            return super.getIndexOf(object);
        }

        public Object getSelectedKey() {
            Object object = super.getSelectedItem();
            if (object == null) {
                return object;
            }
            if ((object = TComboBox.this.ComboBoxColl.getKeyOfValue(object)) == null && TComboBox.this.isEditable()) {
                object = super.getSelectedItem();
            }
            object = objectutil.convertStringToFieldType(TComboBox.this.FieldType, (String)object, -1);
            return object;
        }

        @Override
        public Object getSelectedItem() {
            Object object = super.getSelectedItem();
            if (object == null) {
                return object;
            }
            if (TComboBox.this.ReturnKey) {
                if ((object = TComboBox.this.ComboBoxColl.getKeyOfValue(object)) == null && TComboBox.this.isEditable()) {
                    object = super.getSelectedItem();
                }
                object = objectutil.convertStringToFieldType(TComboBox.this.FieldType, (String)object, -1);
            }
            return object;
        }

        @Override
        public int getSize() {
            return super.getSize();
        }

        @Override
        public void insertElementAt(Object object, int n) {
            super.insertElementAt(object, n);
        }

        @Override
        public void removeAllElements() {
            super.removeAllElements();
        }

        @Override
        public void removeElement(Object object) {
            super.removeElement(object);
        }

        @Override
        public void removeElementAt(int n) {
            super.removeElementAt(n);
        }

        @Override
        public void setSelectedItem(Object object) {
            super.setSelectedItem(object);
        }
    }
}

