/*
 * Decompiled with CFR 0.152.
 */
package cache;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCacheObj;
import cache.TDataCollection;
import cache.TDataObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.notifications.TNotification;
import utility.security.TPasswordService;

public class TCacheWriteBuffer {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private boolean addingData = false;
    private Hashtable hDataCollection = new Hashtable();

    public synchronized boolean addData(TCacheObj tCacheObj, String string, String[] stringArray, String[] stringArray2, int[] nArray, Object[] objectArray) {
        Object object;
        this.addingData = true;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheWriteBuffer", "addData", Thread.currentThread(), null, 3, "\tTCacheWriteBuffer addData Keys=" + charutil.arrayToString(stringArray));
        }
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheWriteBuffer", "addData", Thread.currentThread(), null, 3, "\tTCacheWriteBuffer addData FieldIDs=" + charutil.arrayToString(stringArray2));
        }
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheWriteBuffer", "addData", Thread.currentThread(), null, 3, "\tTCacheWriteBuffer addData Values=" + charutil.arrayToString(objectArray));
        }
        Object object2 = null;
        Enumeration enumeration = this.hDataCollection.keys();
        while (object2 == null && enumeration.hasMoreElements()) {
            object = (TCacheObj)enumeration.nextElement();
            if (!((TCacheObj)object).ID.equals(tCacheObj.ID)) continue;
            object2 = object;
        }
        if (object2 == null) {
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheWriteBuffer", "addData", Thread.currentThread(), null, 3, "\tTCacheWriteBuffer addData adding new driver to hashtable");
            }
            object = charutil.getParamValue(tCacheObj.Params, "KeyExpression", '&');
            object2 = tCacheObj;
            this.hDataCollection.put(object2, new TDataCollection((String)object, string));
        } else if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheWriteBuffer", "addData", Thread.currentThread(), null, 3, "\tTCacheWriteBuffer addData found existing driver in hashtable");
        }
        object = (TDataCollection)this.hDataCollection.get(object2);
        for (int i = 0; i < stringArray.length; ++i) {
            ((TDataCollection)object).addField(stringArray[i], stringArray2[i], nArray[i], objectArray[i]);
        }
        if (((TCacheObj)object2).HashID.equalsIgnoreCase(Application.getAspectHashID())) {
            String[] stringArray3 = charutil.getSubStringArray(((TCacheObj)object2).Params, '&', true);
            String string2 = charutil.getParamValue(stringArray3, "DriverID");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray3.length; ++i) {
                stringBuilder.append("|" + stringArray3[i]);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(0);
            }
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheWriteBuffer", "addData", Thread.currentThread(), null, 3, "\tTCacheWriteBuffer addData calling DataCollection.writeToDriver for local driver");
            }
            ((TDataCollection)object).writeToDriver(string2, stringBuilder.toString(), true);
        }
        this.addingData = false;
        return true;
    }

    public TDataCollection getDataCollection(TCacheObj tCacheObj) {
        Object var2_2 = null;
        Enumeration enumeration = this.hDataCollection.keys();
        while (var2_2 == null && enumeration.hasMoreElements()) {
            TCacheObj tCacheObj2 = (TCacheObj)enumeration.nextElement();
            if (!tCacheObj2.ID.equals(tCacheObj.ID)) continue;
            return (TDataCollection)this.hDataCollection.get(tCacheObj2);
        }
        return null;
    }

    public boolean containsData() {
        Enumeration enumeration = this.hDataCollection.keys();
        while (enumeration.hasMoreElements()) {
            TDataCollection tDataCollection = (TDataCollection)this.hDataCollection.get(enumeration.nextElement());
            if (tDataCollection.getRecordCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public void sendData() {
        Object object;
        Object object2;
        Object object3;
        Comparable<StringBuilder> comparable;
        Object object4;
        if (this.addingData) {
            return;
        }
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData started");
        }
        Hashtable<TCacheObj, Date> hashtable = new Hashtable<TCacheObj, Date>();
        Enumeration enumeration = this.hDataCollection.keys();
        while (enumeration.hasMoreElements()) {
            TCacheObj tCacheObj = (TCacheObj)enumeration.nextElement();
            object4 = (TDataCollection)this.hDataCollection.get(tCacheObj);
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData got CacheObj ID=" + tCacheObj.ID);
            }
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData got DataCollection Records=" + ((TDataCollection)object4).getRecordCount());
            }
            if (((TDataCollection)object4).getRecordCount() <= 0) continue;
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("1.0\n");
            ((StringBuilder)comparable).append(tCacheObj.getParameter("DriverID") + "\n");
            ((StringBuilder)comparable).append(tCacheObj.getParamString('|') + "\n");
            ((StringBuilder)comparable).append(((TDataCollection)object4).toString());
            tCacheObj.LastSend = new Date();
            object3 = TPasswordService.generateSalt(16);
            object2 = new TNotification((String)object3, Application.getAspectHashID(), tCacheObj.HashID, TNotification.NOTIFICATION_UPDATEDRIVERDATA, ((StringBuilder)comparable).toString(), -1, "", "", new Date(), TNotification.encryptPassword(), 5);
            TFormulaEvaluator.getNotificationClient().addProxyRequest(tCacheObj, (TNotification)object2, "");
            hashtable.put(tCacheObj, tCacheObj.Updated);
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData sent notification to " + tCacheObj.HashID);
            }
            if (Application.getDevelopmentMode() != 0) continue;
            object = Application.getHomeDir() + "cachedata\\cachedriver_senddata" + dateutil.formatDate(new Date(), "MM-dd-yyyy HHmmss") + ".txt";
            MainWin.appendToLog("TCacheDriver", "updateCache", Thread.currentThread(), null, 10, "TCacheDriver:sendData notification request written to " + (String)object);
            TAsciiOutput.writeContent((String)object, ((StringBuilder)comparable).toString());
        }
        if (hashtable.size() > 0) {
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData waiting for response");
            }
            for (int i = 0; hashtable.size() > 0 && i < 180; ++i) {
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    object4 = (TCacheObj)enumeration.nextElement();
                    comparable = (Date)hashtable.get(object4);
                    if (((TCacheObj)object4).Updated.getTime() <= ((Date)comparable).getTime()) continue;
                    if (TCacheObj.DebugCache) {
                        MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData got response");
                    }
                    hashtable.remove(object4);
                    object3 = (TDataCollection)this.hDataCollection.get(object4);
                    object2 = ((TDataCollection)object3).getRecords();
                    object = ((Hashtable)object2).keys();
                    while (object.hasMoreElements()) {
                        String string = (String)object.nextElement();
                        ArrayList arrayList = (ArrayList)((Hashtable)object2).get(string);
                        int n = 0;
                        while (n < arrayList.size()) {
                            TDataObject tDataObject = (TDataObject)arrayList.get(n);
                            if (tDataObject.Added.getTime() < ((TCacheObj)object4).LastSend.getTime()) {
                                if (TCacheObj.DebugCache) {
                                    MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData removed data: " + tDataObject.toString());
                                }
                                arrayList.remove(tDataObject);
                                continue;
                            }
                            if (TCacheObj.DebugCache) {
                                MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData did not remove data: " + tDataObject.toString());
                            }
                            ++n;
                        }
                        if (arrayList.size() != 0) continue;
                        if (TCacheObj.DebugCache) {
                            MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData removing record that no longer contains data");
                        }
                        ((Hashtable)object2).remove(string);
                    }
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (TCacheObj.DebugCache) {
                if (hashtable.size() == 0) {
                    MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData received response for all notifications");
                } else {
                    MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData did not receive response for " + hashtable.size() + " notifications");
                }
            }
            hashtable.clear();
        } else if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheWriteBuffer", "sendData", Thread.currentThread(), null, 3, "TCacheWriteBuffer sendData no notfications were sent");
        }
    }
}

