/*
 * Decompiled with CFR 0.152.
 */
package cache;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCache;
import cache.TCacheObj;
import cache.TCacheServerInfo;
import cache.TCacheWidget;
import controls.htmlviewer.THtmlContent;
import java.util.Date;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.notifications.TNotification;
import utility.security.TPasswordService;
import utility.session.TSessionObj;

public class TCacheProcessItem {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    TCacheObj CacheObj;

    public TCacheProcessItem(TCacheObj tCacheObj) {
        this.CacheObj = tCacheObj;
    }

    public boolean update(TSessionObj tSessionObj, String string, String string2) {
        if (this.CacheObj.HashID.equalsIgnoreCase(Application.getAspectHashID())) {
            return this.updateLocal(tSessionObj, string, string2);
        }
        return this.updateByNotification(tSessionObj, string, string2);
    }

    public boolean updateByNotification(TSessionObj tSessionObj, String string, String string2) {
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheProcessItem", "updateByNotification", Thread.currentThread(), null, 10, "TCacheProcessItem:updateByNotification Updating by notification");
        }
        String string3 = TPasswordService.generateSalt(16);
        String string4 = this.CacheObj.Params;
        string4 = string4 + "&user-agent=" + string2 + "&remoteIP=" + string;
        TNotification tNotification = new TNotification(string3, Application.getAspectHashID(), this.CacheObj.HashID, TNotification.NOTIFICATION_PROCESSITEM, string4, -1, "", "", new Date(), tSessionObj.getPassword(), 5);
        TFormulaEvaluator.getNotificationClient().addProxyRequest(this.CacheObj, tNotification, string);
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem: Waiting for response");
        }
        Date date = this.CacheObj.Updated;
        int n = 0;
        boolean bl = false;
        while (n < TCache.CacheTimeoutSeconds && !bl) {
            if (this.CacheObj.Updated.getTime() == date.getTime()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            bl = true;
        }
        if (TCacheObj.DebugCache) {
            if (bl) {
                MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem:update got response");
            } else {
                MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem:update timed out");
            }
        }
        return bl;
    }

    public boolean updateLocal(TSessionObj tSessionObj, String string, String string2) {
        Object object;
        Object object2;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update RemoteIP=" + string + " UserAgent=" + string2);
        }
        String[] stringArray = charutil.getSubStringArray(this.CacheObj.Params, '&', true);
        String string3 = charutil.getParamValue(stringArray, "content");
        boolean bl = charutil.boolval(charutil.getParamValue(stringArray, "nowrap"));
        String string4 = charutil.getParamValue(stringArray, "WidgetID");
        boolean bl2 = charutil.boolval(charutil.getParamValue(stringArray, "isProxyRequest"));
        if (string4.trim().length() == 0) {
            string4 = "w" + TPasswordService.generateSalt(8);
        }
        string3 = TCacheWidget.replaceTokens(string3);
        String string5 = "Undefined";
        String string6 = "";
        int n = string3.toUpperCase().indexOf("<STATE>");
        if (n >= 0) {
            int n2 = string3.toUpperCase().indexOf("</STATE>");
            if (n2 > n) {
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update evaluating state tag");
                }
                string5 = string3.substring(n + 7, n2);
                object2 = new THtmlContent(string5, false);
                object = charutil.removeControlChars(((THtmlContent)object2).getProcessedContent(this.CacheObj.Params + "&user-agent=" + string2 + "&LastState=" + this.CacheObj.State, true).trim());
                string6 = Integer.toString(charutil.getHashCode((String)object, false));
                if (string5.toUpperCase().indexOf("DEBUG=TRUE") >= 0) {
                    System.out.println("Debug State: TCacheProcessItem");
                    System.out.println("TCacheObj.ID: " + this.CacheObj.ID);
                    System.out.println("State=" + string5);
                    System.out.println("sStateContent=" + (String)object);
                    System.out.println("StateValue=" + string6);
                    System.out.println("Previous State=" + this.CacheObj.State);
                    if (string6.equalsIgnoreCase(this.CacheObj.State)) {
                        System.out.println("state has not changed");
                    } else {
                        System.out.println("state has changed");
                    }
                }
                if ((((String)object).equalsIgnoreCase(this.CacheObj.State) || string6.equalsIgnoreCase(this.CacheObj.State)) && this.CacheObj.contentExists()) {
                    if (TCacheObj.DebugCache) {
                        MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update state has not changed");
                    }
                    return false;
                }
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update Previous state: " + this.CacheObj.State);
                }
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update Current state: " + string6);
                }
            } else if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update: invalid state tag");
            }
        } else if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update: no state tag found");
        }
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update processing content");
        }
        StringBuilder stringBuilder = new StringBuilder(this.CacheObj.Params);
        object2 = new TCacheServerInfo(string);
        stringBuilder.append("&SourceServerID=" + ((TCacheServerInfo)object2).getServerID());
        stringBuilder.append("&SourceServer=" + ((TCacheServerInfo)object2).getServer());
        stringBuilder.append("&SourceServerProtocol=" + ((TCacheServerInfo)object2).getServerProtocol());
        stringBuilder.append("&SourceServerHost=" + ((TCacheServerInfo)object2).getServerHost());
        stringBuilder.append("&SourceServerHostName=" + ((TCacheServerInfo)object2).getServerHostName());
        stringBuilder.append("&SourceServerPort=" + ((TCacheServerInfo)object2).getServerPort());
        stringBuilder.append("&user-agent=" + string2);
        stringBuilder.append("&remoteIP=" + string);
        object = new THtmlContent(string3, false);
        String string7 = ((THtmlContent)object).getProcessedContent(stringBuilder.toString(), true).trim();
        if (!bl2 && string.length() > 0) {
            string7 = charutil.replaceAllSubstrings(string7, "__RequestServer__", ((TCacheServerInfo)object2).getServer());
        }
        string7 = charutil.replaceAllSubstrings(string7, "__ProcessItemHashID__", Application.getAspectHashID());
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCacheProcessItem", "update", Thread.currentThread(), null, 10, "TCacheProcessItem.update got processed content: " + string7.length() + " bytes.  Writing to " + this.CacheObj.getContentFilename());
        }
        this.CacheObj.setContent(string7, string6);
        return true;
    }
}

