/*
 * Decompiled with CFR 0.152.
 */
package cache;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCacheCollection;
import cache.TCacheDriver;
import cache.TCacheObj;
import cache.TCacheProcessItem;
import cache.TCacheWidget;
import cache.TCacheWriteBuffer;
import cache.TDataCollection;
import collections.TComboBoxColl;
import drivers.aspect.TAspectDriver;
import drivers.files.TBinaryFile;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Timer;
import performance.TPerformanceCacheMark;
import resources.TAppCollectionsObject;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dosutil;
import utility.objectutil;
import utility.session.TSession;
import utility.session.TSessionObj;
import utility.taskscheduler.TTaskScheduler;

public class TCache
extends Thread {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private static Timer CallbackTimer = null;
    Hashtable hashObjects = new Hashtable();
    private TTaskScheduler CacheTaskScheduler = null;
    public static TBinaryFile drvCache = null;
    boolean Terminate = false;
    public static int CacheTimeoutSeconds = 300;
    private static TCacheWriteBuffer CacheWriteBuffer = new TCacheWriteBuffer();
    public static Hashtable hashCachedViewState = new Hashtable();
    private static Hashtable hWidgetType = new Hashtable();
    private static long DebugCacheInstance = 0L;
    public static long tLastDataSubmission = 0L;
    public static String LastDataSubmissionDriverID = "";

    public TCache() {
        super("TCache");
        this.setPriority(1);
        this.CacheTaskScheduler = TFormulaEvaluator.enableTaskScheduler("GreenLight_Cache", false);
        drvCache = (TBinaryFile)this.CacheTaskScheduler.AspectDriver.F;
        int n = drvCache.getRecordCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = (Boolean)drvCache.getField("used", i);
            if (!bl) continue;
            String string = (String)drvCache.getField("ID", i);
            this.hashObjects.put(string, new Integer(i));
        }
    }

    public TCacheObj getCacheObj(int n, String string, String string2) {
        String string3 = TCacheObj.getID(n, string, string2);
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCacheObj looking for ID=" + string3);
        }
        if (this.hashObjects.containsKey(string3)) {
            TCacheObj tCacheObj = new TCacheObj(string3, (Integer)this.hashObjects.get(string3));
            tCacheObj.readFromDriver(drvCache);
            tCacheObj.Params = string2;
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCacheObj returns  " + tCacheObj.toString());
            }
            return tCacheObj;
        }
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache: getCacheObj returns null for " + TCacheObj.toString(n, string, string2));
        }
        return null;
    }

    public TCacheObj addCacheObj(int n, String string, String string2) {
        int n2 = drvCache.initializeNewRecord(true);
        TCacheObj tCacheObj = new TCacheObj(n, string, string2, n2);
        tCacheObj.Last_Access = new Date();
        tCacheObj.writeToDriver(drvCache, false);
        this.hashObjects.put(tCacheObj.ID, new Integer(n2));
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:addCacheObj returns " + tCacheObj.toString());
        }
        return tCacheObj;
    }

    public String[] getNotificationIDs(int n, String string, String string2) {
        TCacheObj tCacheObj = this.getCacheObj(n, string, string2);
        String[] stringArray = new String[2];
        if (tCacheObj != null) {
            stringArray[0] = tCacheObj.NotificationID;
            stringArray[1] = tCacheObj.NotificationParentID;
        }
        return stringArray;
    }

    public boolean collectionStateChanged(String string, String string2, String string3, String string4) {
        String string5 = "CollectionID=" + string + "&Filter=" + string2 + "&DriverParams=" + string3;
        String string6 = TCacheObj.getID(5, string4, string5);
        if (this.hashObjects.containsKey(string6)) {
            TAppCollectionsObject tAppCollectionsObject = TCache.Application.AppCollections.getAppCollectionsObject(string);
            if (tAppCollectionsObject != null) {
                if (tAppCollectionsObject.StateExpression.length() > 0) {
                    TCacheObj tCacheObj = this.getCacheObj(5, string4, string5);
                    TCacheCollection tCacheCollection = new TCacheCollection(tCacheObj);
                    boolean bl = tCacheCollection.collectionStateChanged(tAppCollectionsObject.StateExpression, string3);
                    return bl;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    public String updateCollectionState(String string, String string2, String string3, String string4) {
        String string5 = "CollectionID=" + string + "&Filter=" + string2 + "&DriverParams=" + string3;
        String string6 = TCacheObj.getID(5, string4, string5);
        if (this.hashObjects.containsKey(string6)) {
            TCacheObj tCacheObj = new TCacheObj(string6, (Integer)this.hashObjects.get(string6));
            TAppCollectionsObject tAppCollectionsObject = TCache.Application.AppCollections.getAppCollectionsObject(string);
            if (tAppCollectionsObject != null) {
                if (tAppCollectionsObject.StateExpression.trim().length() > 0) {
                    String string7 = new TCacheCollection(tCacheObj).getState(tAppCollectionsObject.StateExpression, string3);
                    tCacheObj.setState(string7);
                    MainWin.appendToLog("TCache", "updateCollectionState", Thread.currentThread(), null, 3, "TCache: updateCollectionState CollectionID: " + string + " DriverParams: " + string3 + " Filter: " + string2);
                    return "Ok";
                }
                String string8 = "Error: No state expression defined for collection: " + string;
                MainWin.appendToLog("TCache", "updateCollectionState", Thread.currentThread(), null, 4, string8);
                return string8;
            }
            String string9 = "Error: Invalid collectionID: " + string;
            MainWin.appendToLog("TCache", "updateCollectionState", Thread.currentThread(), null, 4, string9);
            return string9;
        }
        String string10 = "Warning: Could not locate cached collection: " + string + " Filter=" + string2 + " DriverParams=" + string3 + " CacheID=" + string6;
        MainWin.appendToLog("TCache", "updateCollectionState", Thread.currentThread(), null, 4, string10);
        return string10;
    }

    public String getCachedContent(int n, String string, String string2, boolean bl, String string3, String string4) {
        return this.getCachedContent(n, string, string2, bl, string3, string4, TSession.getLocalSession(string4), "", "", null);
    }

    public String getCachedContent(int n, String string, String string2, boolean bl, String string3, String string4, TSessionObj tSessionObj, String string5, String string6, TFormulaEvaluator tFormulaEvaluator) {
        Object object;
        Object object2;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCachedContent[No ID Yet] RemoteIP=" + string3 + " Obj=" + TCacheObj.toString(n, string, string2));
        }
        TPerformanceCacheMark tPerformanceCacheMark = new TPerformanceCacheMark(n, string2);
        TFormulaEvaluator.Performance.addMark(tPerformanceCacheMark);
        ++tPerformanceCacheMark.cRead;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCachedContent[No ID Yet] RemoteIP=" + string3 + " Obj=" + TCacheObj.toString(n, string, string2));
        }
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCachedContent[No ID Yet] UserAgent=" + string4);
        }
        String string7 = string2;
        String string8 = null;
        if (("&" + string7.toUpperCase()).indexOf("&DOCUMENTID=") < 0 && ("&" + string7.toUpperCase()).indexOf("&VIEWID=") >= 0) {
            string8 = charutil.getElementValue(string7, "ViewID", '&');
            object2 = TCache.Application.AppCollections.getCollection("Greenlight_UI_View_Params_by_ID");
            String string9 = (String)((TComboBoxColl)object2).getValueOfKey(string8);
            if (string9 != null) {
                string7 = string9 + "&" + string7;
            }
        }
        if ((object2 = this.getCacheObj(n, string, string7)) != null && (((TCacheObj)object2).Type < 0 || ((TCacheObj)object2).Type >= TCacheObj.TypeName.length)) {
            object2 = null;
        }
        boolean bl2 = TMainWin.Application.getTokenValue("Aspect_BackOffice_Pref_CompanyPollingID").trim().length() > 0;
        boolean bl3 = true;
        if (object2 != null) {
            bl3 = ((TCacheObj)object2).isExpired();
        }
        if (bl) {
            bl3 = true;
        }
        if (object2 != null && !bl3 && bl2 && TFormulaEvaluator.getSessionManager().isSessionValid(tSessionObj, string3)) {
            if (((TCacheObj)object2).debugCache()) {
                MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCachedContent[" + ((TCacheObj)object2).ID + "] returning current content without updating");
            }
            ++((TCacheObj)object2).Access_Count;
            ((TCacheObj)object2).Last_Access = new Date();
            ((TCacheObj)object2).writeToDriver(drvCache, true);
            ++tPerformanceCacheMark.cCached;
            tPerformanceCacheMark.destroy();
            return ((TCacheObj)object2).getContent();
        }
        if (object2 == null && ((TCacheObj)(object2 = this.addCacheObj(n, string, string7))).debugCache()) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCachedContent[" + ((TCacheObj)object2).ID + "] adding new object");
        }
        String[] stringArray = charutil.getSubStringArray(((TCacheObj)object2).Params, '&', true);
        String string10 = charutil.getParamValue(stringArray, "DocumentID");
        String string11 = charutil.getParamValue(stringArray, "Widget");
        String string12 = charutil.getParamValue(stringArray, "ContainerItemID");
        if (bl3) {
            if (((TCacheObj)object2).debugCache()) {
                MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCachedContent[" + ((TCacheObj)object2).ID + "] updating content");
            }
            object = new Date();
            ++((TCacheObj)object2).Access_Count;
            ((TCacheObj)object2).Last_Access = new Date();
            ++((TCacheObj)object2).Update_Called_Count;
            if (this.updateContent((TCacheObj)object2, string3, string4, tSessionObj, tFormulaEvaluator)) {
                ((TCacheObj)object2).Processing_Time += (double)(new Date().getTime() - ((Date)object).getTime());
                ++((TCacheObj)object2).Update_Count;
                ((TCacheObj)object2).Updated = new Date();
            }
            ((TCacheObj)object2).writeToDriver(drvCache, true);
        } else {
            ++((TCacheObj)object2).Access_Count;
            ((TCacheObj)object2).Last_Access = new Date();
            ((TCacheObj)object2).writeToDriver(drvCache, true);
            if (((TCacheObj)object2).debugCache()) {
                MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCachedContent[" + ((TCacheObj)object2).ID + "] content is up to date");
            }
        }
        if (((TCacheObj)object2).debugCache()) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getCachedContent[" + ((TCacheObj)object2).ID + "] getting content");
        }
        object = this.getContent((TCacheObj)object2, tSessionObj, string3, string4);
        if (((TCacheObj)object2).debugCache()) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache: getCachedContent[" + ((TCacheObj)object2).ID + "] returning " + ((String)object).length() + " bytes");
        }
        ++tPerformanceCacheMark.cUpdated;
        tPerformanceCacheMark.destroy();
        return object;
    }

    private String getContent(TCacheObj tCacheObj, TSessionObj tSessionObj, String string, String string2) {
        if (tCacheObj.debugCache()) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:getContent[" + tCacheObj.ID + "] UserAgent=" + string2);
        }
        if (tCacheObj.Type == 0) {
            return TCacheWidget.getContent(tCacheObj, tSessionObj, string, string2, false);
        }
        if (tCacheObj.Type == 4) {
            return TCacheWidget.getContent(tCacheObj, tSessionObj, string, string2, true);
        }
        return tCacheObj.getContent();
    }

    public TAspectDriver openCacheDriver(String string, String string2, int n, String string3) {
        int n2;
        TCacheObj tCacheObj;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "openCacheDriver", Thread.currentThread(), null, 10, "TCache:openCacheDriver HashID=" + string + " DriverID=" + string2 + " Mode=" + n + " Params=" + string3);
        }
        if (string.equalsIgnoreCase(Application.getAspectHashID())) {
            TAppDriversObject tAppDriversObject = TCache.Application.AppDrivers.getAppDriversObject(string2);
            TAspectDriver.executeDriverPreActions(tAppDriversObject);
            return new TAspectDriver(string2, n, true, false, string3);
        }
        if (("|" + string3.toUpperCase()).indexOf("|HASHID") < 0) {
            string3 = string3 + "|HashID=" + string;
        }
        String string4 = "DriverID=" + string2;
        if (string3.trim().length() > 0) {
            string4 = string4 + "&" + charutil.replaceChar(string3, '|', '&');
        }
        if ((tCacheObj = this.getCacheObj(3, string, string4)) == null) {
            tCacheObj = this.addCacheObj(3, string, string4);
        }
        if (tCacheObj.TimeToLive != (n2 = charutil.ival(charutil.getParamValue(string3, "CacheTtl", '|')))) {
            if (TCacheObj.DebugCache) {
                MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:openCacheDriver set TTL = " + n2);
            }
            tCacheObj.TimeToLive = n2;
            tCacheObj.writeToDriver(drvCache, true);
        } else if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:openCacheDriver TTL = " + n2);
        }
        return this.openCacheDriver(tCacheObj);
    }

    public TAspectDriver openCacheDriver(TCacheObj tCacheObj) {
        TAspectDriver tAspectDriver;
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "openCacheDriver", Thread.currentThread(), null, 10, "TCache:openCacheDriver CacheObj Filename=" + tCacheObj.getContentFilename() + " CacheObj.Params=" + tCacheObj.Params);
        }
        String[] stringArray = charutil.getSubStringArray(tCacheObj.Params, '&', true);
        String string = charutil.getParamValue(stringArray, "DriverID");
        int n = charutil.ival(charutil.getParamValue(stringArray, "Mode"));
        TAppDriversObject tAppDriversObject = TCache.Application.AppDrivers.getAppDriversObject(string);
        if (tAppDriversObject == null) {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 4, "TCache:openCacheDriver Invalid DriverID: " + string);
            return null;
        }
        tAppDriversObject = new TAppDriversObject(tAppDriversObject);
        tAppDriversObject.FileType = 33;
        tAppDriversObject.FileName.setLength(0);
        tAppDriversObject.FileName.append("\"" + tCacheObj.getContentFilename() + ".dta\"");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("|" + stringArray[i]);
        }
        stringBuilder.append("|HashID=" + tCacheObj.HashID);
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(0);
        }
        if ((tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 1, true, stringBuilder.toString())).isValid()) {
            ((TCacheDriver)tAspectDriver.F).CacheObj = tCacheObj;
            if (tCacheObj.isExpired()) {
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:openCacheDriver updating content");
                }
                Date date = new Date();
                ((TCacheDriver)tAspectDriver.F).updateCache();
                tCacheObj.Processing_Time += (double)(new Date().getTime() - date.getTime());
                ++tCacheObj.Access_Count;
                tCacheObj.Updated = new Date();
                tCacheObj.writeToDriver(drvCache, true);
            } else {
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 10, "TCache:openCacheDriver content is up to date");
                }
                ++tCacheObj.Access_Count;
                tCacheObj.writeToDriver(drvCache, true);
            }
        } else {
            MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 4, "TCache:openCacheDriver Could not open driver: " + string);
        }
        return tAspectDriver;
    }

    public boolean updateContent(TCacheObj tCacheObj, String string, String string2, TSessionObj tSessionObj, TFormulaEvaluator tFormulaEvaluator) {
        boolean bl = false;
        switch (tCacheObj.Type) {
            case 0: {
                bl = new TCacheWidget(tCacheObj).update(tSessionObj, string, string2, false);
                break;
            }
            case 1: {
                bl = new TCacheProcessItem(tCacheObj).update(tSessionObj, string, string2);
                break;
            }
            case 3: {
                bl = false;
                TAspectDriver tAspectDriver = this.openCacheDriver(tCacheObj);
                if (tAspectDriver == null || !(tAspectDriver.F instanceof TCacheDriver)) break;
                bl = ((TCacheDriver)tAspectDriver.F).updateCache();
                tAspectDriver.dispose();
                break;
            }
            case 4: {
                bl = new TCacheWidget(tCacheObj).update(tSessionObj, string, string2, true);
                break;
            }
            case 5: {
                bl = new TCacheCollection(tCacheObj).update(tSessionObj, tFormulaEvaluator);
                break;
            }
            default: {
                System.out.println("Unknown type in TCache.updateContent.  o=" + tCacheObj.toString());
                new Throwable().printStackTrace();
            }
        }
        if (bl) {
            drvCache.putField("State", tCacheObj.Index, (Object)tCacheObj.State);
        }
        return bl;
    }

    public boolean addData(String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        int[] nArray = new int[1];
        Object[] objectArray = new Object[1];
        stringArray[0] = string5;
        stringArray2[0] = string6;
        nArray[0] = n;
        objectArray[0] = object;
        return this.addData(string, string2, string3, string4, stringArray, stringArray2, nArray, objectArray);
    }

    public boolean addData(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, int[] nArray, Object[] objectArray) {
        int n;
        TCacheObj tCacheObj;
        tLastDataSubmission = new Date().getTime();
        LastDataSubmissionDriverID = string3;
        String string5 = "DriverID=" + string3 + "&TableID=" + string2;
        if (string4.trim().length() > 0) {
            string5 = string5 + "&" + charutil.replaceChar(string4, '|', '&');
        }
        if ((tCacheObj = this.getCacheObj(3, string, string5)) == null) {
            tCacheObj = this.addCacheObj(3, string, string5);
        }
        if (tCacheObj.debugCache()) {
            MainWin.appendToLog("TCache", "addData", Thread.currentThread(), null, 3, "TCache:addData HashID=" + string + " DriverID=" + string3 + " Params=" + string4);
            String string6 = "";
            for (n = 0; n < stringArray2.length; ++n) {
                System.out.println("ArValue[" + n + "]=" + objectArray[n]);
                string6 = string6 + stringArray[n] + ":" + stringArray2[n] + "=" + objectutil.convertToString(objectArray[n] + " ");
            }
            MainWin.appendToLog("TCache", "addData", Thread.currentThread(), null, 3, "TCache:addData Fields=" + string6);
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            string5 = string5 + "&" + stringArray2[i] + "=" + objectArray[i];
        }
        TPerformanceCacheMark tPerformanceCacheMark = new TPerformanceCacheMark(3, string5);
        TFormulaEvaluator.Performance.addMark(tPerformanceCacheMark);
        n = CacheWriteBuffer.addData(tCacheObj, string2, stringArray, stringArray2, nArray, objectArray);
        tPerformanceCacheMark.destroy();
        return n != 0;
    }

    public TDataCollection getDataCollection(String string, String string2, String string3, String string4) {
        TCacheObj tCacheObj;
        String string5 = "DriverID=" + string3 + "&TableID=" + string2;
        if (string4.trim().length() > 0) {
            string5 = string5 + "&" + charutil.replaceChar(string4, '|', '&');
        }
        if ((tCacheObj = this.getCacheObj(3, string, string5)) == null) {
            MainWin.appendToLog("TCache", "getPendingDataSubmissions", Thread.currentThread(), null, 4, "TCache:getPendingDataSubmissions could not find CacheObj for Driver=" + string3 + " Params=" + string4);
            return null;
        }
        TDataCollection tDataCollection = CacheWriteBuffer.getDataCollection(tCacheObj);
        if (tDataCollection == null) {
            MainWin.appendToLog("TCache", "getPendingDataSubmissions", Thread.currentThread(), null, 4, "TCache:getPendingDataSubmissions could not find data collection for Driver=" + string3 + " Params=" + string4);
        }
        return tDataCollection;
    }

    public void purgeExpiredObjects(boolean bl) {
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TCache", "purgeExpiredObjects", Thread.currentThread(), null, 10, "TCache:purgeExpiredObjects started.  " + this.hashObjects.size() + " objects in collection");
        }
        int n = 0;
        long l = new Date().getTime();
        long l2 = l - 2592000000L;
        int n2 = drvCache.getRecordCount();
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            if (!((Boolean)drvCache.getField("Used", i)).booleanValue() || ((Boolean)drvCache.getField("Task.TaskEnabled", i)).booleanValue()) continue;
            Date date = (Date)drvCache.getField("Last_Access", i);
            boolean bl3 = bl2 = bl || date.getTime() < l2;
            if (!bl2) continue;
            String string = (String)drvCache.getField("ID", i);
            TCacheObj tCacheObj = new TCacheObj(string, i);
            String string2 = tCacheObj.getContentFilename();
            dosutil.deleteFile(string2);
            dosutil.deleteFile(string2 + ".txt");
            dosutil.deleteFile(string2 + "+");
            dosutil.deleteFile(string2 + "_param.txt");
            drvCache.putField("Used", i, (Object)Boolean.FALSE);
            this.hashObjects.remove(string);
            ++n;
        }
        drvCache.clearBuffer();
        MainWin.appendToLog("TCache", "purgeExpiredObjects", Thread.currentThread(), null, 10, "TCache:purgeExpiredObjects removed " + n + " objects");
    }

    @Override
    public void run() {
        while (!this.Terminate) {
            if (CacheWriteBuffer.containsData()) {
                if (TCacheObj.DebugCache) {
                    MainWin.appendToLog("TCache", "run", Thread.currentThread(), null, 3, "TCache:run sending data");
                }
                CacheWriteBuffer.sendData();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }
}

