/*
 * Decompiled with CFR 0.152.
 */
package backoffice.payroll_interfaces;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.net.Socket;
import java.net.URL;
import java.security.Key;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import utility.TScriptSocket;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.ziputil;

public class TimeWorks {
    public static String execAPI(String string, String string2, String string3, int n) {
        String string4 = "twpapi.payrollservers.us";
        String string5 = string2;
        String string6 = string3;
        System.out.println("Page: " + string5);
        System.out.println("Args: " + string6);
        String string7 = "";
        try {
            URL uRL = dosutil.makeURL(string4);
            if (uRL == null) {
                return "MalformedURLException: " + string4;
            }
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            String string8 = string4;
            Socket socket = new Socket(string8, 443);
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string8, 443, true);
            TScriptSocket tScriptSocket = new TScriptSocket(sSLSocket);
            tScriptSocket.setTimeout(60000);
            tScriptSocket.setRequestArguments(string6);
            tScriptSocket.setRequestMethod(n);
            tScriptSocket.setRequestHeaderValue("Host", string4);
            tScriptSocket.setRequestURI(string5);
            tScriptSocket.setRequestHeaderValue("Authorization", "Bearer " + string);
            tScriptSocket.setRequestHeaderValue("Content-Type", "application/json");
            System.out.println("sending request");
            tScriptSocket.sendRequest();
            System.out.println("sent request");
            tScriptSocket.getResponse();
            System.out.println("got response");
            int n2 = tScriptSocket.getResponseCode();
            System.out.println("response code: " + n2);
            if (n2 > 299) {
                return "Error: " + n2;
            }
            string7 = tScriptSocket.getResponseHeaderValue("content-encoding").equalsIgnoreCase("gzip") ? ziputil.gunzipString(tScriptSocket.getResponseContentBytes()) : tScriptSocket.getResponseContent();
            tScriptSocket.dispose();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return string7;
    }

    public static String formatPunch(String string, String string2, Date date, Date date2, double d, double d2) {
        String string3 = dateutil.formatDate(date, "HH:mma");
        string3 = charutil.replaceSubstring(string3, "AM", "a");
        string3 = charutil.replaceSubstring(string3, "PM", "");
        String string4 = dateutil.formatDate(date2, "HH:mma");
        string4 = charutil.replaceSubstring(string4, "AM", "a");
        string4 = charutil.replaceSubstring(string4, "PM", "");
        String string5 = "";
        string5 = string5 + "\t\t{\r\n";
        string5 = string5 + "\t\t\t'Date': '" + dateutil.formatDate(date, "yyyy-MM-dd") + "',\r\n";
        string5 = string5 + "\t\t\t'Time': '" + string3 + "',\r\n";
        string5 = string5 + "\t\t\t'Type': 'in',\r\n";
        string5 = string5 + "\t\t\t'Category': 'Regular',\r\n";
        string5 = string5 + "\t\t\t'Comment': 'Aspect',\r\n";
        string5 = string5 + "\t\t\t'Prompts': {\r\n";
        string5 = string5 + "\t\t\t\t'LOC': '" + string + "',\r\n";
        string5 = string5 + "\t\t\t\t'Department': '" + string2 + "'\r\n";
        string5 = string5 + "\t\t\t}\r\n";
        string5 = string5 + "\t\t},\r\n";
        string5 = string5 + "\t\t{\r\n";
        string5 = string5 + "\t\t\t'Date': '" + dateutil.formatDate(date2, "yyyy-MM-dd") + "',\r\n";
        string5 = string5 + "\t\t\t'Time': '" + string4 + "',\r\n";
        string5 = string5 + "\t\t\t'Type': 'out',\r\n";
        string5 = string5 + "\t\t\t'Category': 'Regular',\r\n";
        string5 = string5 + "\t\t\t'Prompts': {\r\n";
        string5 = string5 + "\t\t\t\t'CashTip': '" + charutil.formatNumber(d, "0.00") + "',\r\n";
        string5 = string5 + "\t\t\t\t'CreditTip': '" + charutil.formatNumber(d2, "0.00") + "'\r\n";
        string5 = string5 + "\t\t\t}\r\n";
        string5 = string5 + "\t\t},\r\n";
        string5 = charutil.replaceChar(string5, '\'', '\"');
        return string5;
    }

    public static String addPunch(String string, String string2, String string3, String string4, Date date, Date date2, double d, double d2) {
        String string5 = "/api/" + string2 + "/timecards/punch";
        String string6 = "";
        String string7 = dateutil.formatDate(date, "HH:mma");
        string7 = charutil.replaceSubstring(string7, "AM", "a");
        string7 = charutil.replaceSubstring(string7, "PM", "");
        String string8 = dateutil.formatDate(date2, "HH:mma");
        string8 = charutil.replaceSubstring(string8, "AM", "a");
        string8 = charutil.replaceSubstring(string8, "PM", "");
        string6 = string6 + "{\r\n";
        string6 = string6 + "\t'NewPunches': [\r\n";
        string6 = string6 + "\t\t{\r\n";
        string6 = string6 + "\t\t\t'Date': '" + dateutil.formatDate(date, "yyyy-MM-dd") + "',\r\n";
        string6 = string6 + "\t\t\t'Time': '" + string7 + "',\r\n";
        string6 = string6 + "\t\t\t'Type': 'in',\r\n";
        string6 = string6 + "\t\t\t'Category': 'Regular',\r\n";
        string6 = string6 + "\t\t\t'Prompts': {\r\n";
        string6 = string6 + "\t\t\t\t'Job': '" + string4 + "'\r\n";
        string6 = string6 + "\t\t\t}\r\n";
        string6 = string6 + "\t\t},\r\n";
        string6 = string6 + "\t\t{\r\n";
        string6 = string6 + "\t\t\t'Date': '" + dateutil.formatDate(date2, "yyyy-MM-dd") + "',\r\n";
        string6 = string6 + "\t\t\t'Time': '" + string8 + "',\r\n";
        string6 = string6 + "\t\t\t'Type': 'out',\r\n";
        string6 = string6 + "\t\t\t'Category': 'Regular',\r\n";
        string6 = string6 + "\t\t\t'Prompts': {\r\n";
        string6 = string6 + "\t\t\t\t'CashTip': '" + charutil.formatNumber(d, "0.00") + "',\r\n";
        string6 = string6 + "\t\t\t\t'CreditTip': '" + charutil.formatNumber(d2, "0.00") + "'\r\n";
        string6 = string6 + "\t\t\t}\r\n";
        string6 = string6 + "\t\t}\r\n";
        string6 = string6 + "\t],\r\n";
        string6 = string6 + "\t'EmployeeId': '" + string3 + "',\r\n";
        string6 = string6 + "\t'EmployeeIdType': 'employeecode'\r\n";
        string6 = string6 + "}\r\n";
        string6 = charutil.replaceChar(string6, '\'', '\"');
        String string9 = TimeWorks.execAPI(string, string5, string6, 2);
        string9 = charutil.removeChar(string9, '\"');
        string9 = charutil.removeChar(string9, '[');
        string9 = charutil.removeChar(string9, ']');
        string9 = charutil.removeChar(string9, '{');
        string9 = charutil.removeChar(string9, '}');
        string9 = charutil.replaceChar(string9, ':', '=');
        System.out.println("s=" + string9);
        string9 = charutil.getElementValue(string9, "Message", ',');
        string9 = string9.length() == 0 ? "ok" : "Error: " + string9;
        return string9;
    }

    public static String getWebToken(String string, String string2) {
        String string3 = "clock.payrollservers.us";
        String string4 = "/AuthenticationService/oauth2/usertoken";
        String string5 = "";
        String string6 = "";
        try {
            URL uRL = dosutil.makeURL(string3);
            if (uRL == null) {
                return "MalformedURLException: " + string3;
            }
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            String string7 = string3;
            Socket socket = new Socket(string7, 443);
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string7, 443, true);
            TScriptSocket tScriptSocket = new TScriptSocket(sSLSocket);
            tScriptSocket.setTimeout(60000);
            tScriptSocket.setRequestMethod(2);
            tScriptSocket.setRequestHeaderValue("Host", string3);
            tScriptSocket.setRequestURI(string4);
            tScriptSocket.setRequestHeaderValue("Authorization", "Bearer " + string);
            tScriptSocket.setRequestHeaderValue("Content-Type", "application/json");
            tScriptSocket.sendRequest();
            tScriptSocket.getResponse();
            int n = tScriptSocket.getResponseCode();
            System.out.println("response code: " + n);
            if (n > 299) {
                return "Error: " + n;
            }
            string6 = tScriptSocket.getResponseHeaderValue("content-encoding").equalsIgnoreCase("gzip") ? ziputil.gunzipString(tScriptSocket.getResponseContentBytes()) : tScriptSocket.getResponseContent();
            tScriptSocket.dispose();
            System.out.println("Result1=" + string6);
            string6 = string6.substring(10);
            string6 = string6.substring(0, string6.length() - 2);
            System.out.println("Result2=" + string6);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return string6;
    }

    public static String createJWT(String string, String string2, String string3, String string4, String string5) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long l = System.currentTimeMillis();
        JwtBuilder jwtBuilder = Jwts.builder();
        byte[] byArray = string5.getBytes();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, signatureAlgorithm.getJcaName());
        jwtBuilder.signWith(signatureAlgorithm, (Key)secretKeySpec);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "id");
        hashMap.put("id", string4);
        jwtBuilder.setExpiration(new Date(System.currentTimeMillis() + 60000L));
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("iss", string);
        hashMap2.put("sub", string3);
        hashMap2.put("product", string2);
        hashMap2.put("siteInfo", hashMap);
        jwtBuilder.setClaims(hashMap2);
        return jwtBuilder.compact();
    }

    public static Claims decodeJWT(String string, String string2) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(string2.getBytes()).parseClaimsJws(string).getBody();
        return claims;
    }
}

