/*
 * Decompiled with CFR 0.152.
 */
package net.AspectSoftware;

import java.util.ArrayList;
import java.util.Date;
import net.AspectSoftware.AspectLaunch;
import net.AspectSoftware.TInstallProgressItem;
import net.AspectSoftware.utils;

public class TInstallProgress {
    TInstallProgressItem[] arProgressItem = new TInstallProgressItem[9];
    private static String LogFilename = null;
    public static String LastLogDate = "";
    public static int ITEM_ASPECTLAUNCH = 0;
    public static int ITEM_INSTALL_SERVICE = 1;
    public static int ITEM_ASPECT7 = 2;
    public static int ITEM_WIDGETS = 3;
    public static int ITEM_PACKAGES = 4;
    public static int ITEM_THIRDPARTYLIBRARIES = 5;
    public static int ITEM_LAUNCH_ASPECT7 = 6;
    public static int ITEM_ASPECT7OUTPUT = 7;
    public static int ITEM_INFO = 8;

    public TInstallProgress() {
        this.arProgressItem[TInstallProgress.ITEM_ASPECTLAUNCH] = new TInstallProgressItem(ITEM_ASPECTLAUNCH, "Install Aspect Launch");
        this.arProgressItem[TInstallProgress.ITEM_INSTALL_SERVICE] = new TInstallProgressItem(ITEM_INSTALL_SERVICE, "Install Service");
        this.arProgressItem[TInstallProgress.ITEM_ASPECT7] = new TInstallProgressItem(ITEM_ASPECT7, "Install Aspect7");
        this.arProgressItem[TInstallProgress.ITEM_WIDGETS] = new TInstallProgressItem(ITEM_WIDGETS, "Install Libraries");
        this.arProgressItem[TInstallProgress.ITEM_PACKAGES] = new TInstallProgressItem(ITEM_PACKAGES, "Install Packages");
        this.arProgressItem[TInstallProgress.ITEM_THIRDPARTYLIBRARIES] = new TInstallProgressItem(ITEM_THIRDPARTYLIBRARIES, "Install Supporting Libraries");
        this.arProgressItem[TInstallProgress.ITEM_LAUNCH_ASPECT7] = new TInstallProgressItem(ITEM_LAUNCH_ASPECT7, "Launch Aspect7");
        this.arProgressItem[TInstallProgress.ITEM_ASPECT7OUTPUT] = new TInstallProgressItem(ITEM_ASPECT7OUTPUT, "Aspect Log");
        this.arProgressItem[TInstallProgress.ITEM_INFO] = new TInstallProgressItem(ITEM_INFO, "Information");
    }

    public static String getLogFilename() {
        String string = utils.formatDate(new Date(), "MM-dd-yyyy");
        if (!string.equalsIgnoreCase(LastLogDate)) {
            LastLogDate = string;
            LogFilename = utils.addTrailingSlash(AspectLaunch.HomeDir) + "bin\\service\\Launchlog_" + string + ".txt";
        }
        return LogFilename;
    }

    public static String appendToFileLog(String string) {
        String string2 = utils.formatDate(new Date(), "MM-dd-yyyy HH:mm:ss:SSS");
        System.out.println(string2 + " " + string);
        String string3 = string2 + ",\"" + string + "\"\r\n";
        utils.writeFile(TInstallProgress.getLogFilename(), utils.stringToByte(string3), true);
        return string3;
    }

    public void appendToLog(int n, String string) {
        if (n >= 0 && n < this.arProgressItem.length) {
            this.arProgressItem[n].appendToLog(string);
            TInstallProgress.appendToFileLog(string);
        }
    }

    public void setStatus(int n, String string) {
        if (n >= 0 && n < this.arProgressItem.length) {
            this.arProgressItem[n].setStatus(string);
            TInstallProgress.appendToFileLog(string);
        }
    }

    public String toHTMLTable(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\r\n<table class='status_table'>\r\n");
        for (int i = 0; i < this.arProgressItem.length; ++i) {
            String string = "Table" + Integer.toString(i);
            if (bl) {
                string = string + "Update";
            }
            String string2 = "status" + Integer.toString(i);
            if (bl) {
                string2 = string2 + "Update";
            }
            stringBuilder.append("\t<tr class='status_table_row' onclick=\"util_toggleVisible('" + string + "',true)\">\r\n");
            stringBuilder.append("\t\t<td class='item_description'>" + this.arProgressItem[i].getDescription() + "</td>\r\n");
            stringBuilder.append("\t\t<td ID=\"" + string2 + "\" class='item_status'>" + this.arProgressItem[i].getStatus() + "</td>\r\n");
            stringBuilder.append("\t</tr>\r\n");
            stringBuilder.append("\t<tr>\r\n");
            stringBuilder.append("\t\t<td class='item_log_outertd' colspan='2'>\r\n");
            ArrayList arrayList = this.arProgressItem[i].getTimeLog();
            ArrayList arrayList2 = this.arProgressItem[i].getMsgLog();
            stringBuilder.append("\t\t\t<div class='log_div' ID=\"" + string + "\" style=\"display:none\">\r\n");
            stringBuilder.append("\t\t\t\t<table class='log_table'>\r\n");
            int n = Math.min(arrayList.size(), arrayList2.size());
            for (int j = 0; j < n; ++j) {
                stringBuilder.append("\t\t\t\t\t<tr class='log_table_row'>\r\n");
                stringBuilder.append("\t\t\t\t\t\t<td class='log'>" + utils.formatDate((Date)arrayList.get(j), "MM-dd-yyyy HH:mm:ss:SSS") + " " + (String)arrayList2.get(j) + "</td>\r\n");
                stringBuilder.append("\t\t\t\t\t</tr>\r\n");
            }
            stringBuilder.append("\t\t\t\t</table>\r\n");
            stringBuilder.append("\t\t\t</div>\r\n");
            stringBuilder.append("\t\t</td>\r\n");
            stringBuilder.append("\t</tr>\r\n");
        }
        stringBuilder.append("</table>\r\n");
        return stringBuilder.toString();
    }
}

