/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.DeleteObjectsResponse;
import com.amazonaws.services.s3.internal.ObjectExpirationResult;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.RedirectRule;
import com.amazonaws.services.s3.model.RequestPaymentConfiguration;
import com.amazonaws.services.s3.model.RoutingRule;
import com.amazonaws.services.s3.model.RoutingRuleCondition;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.TagSet;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.s3.model.transform.AbstractHandler;
import com.amazonaws.services.s3.model.transform.AbstractSSEHandler;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog(XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private boolean sanitizeXmlDocument = true;

    public XmlResponsesSaxParser() throws AmazonClientException {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new AmazonClientException("Couldn't initialize a SAX driver to create an XMLReader", e);
        }
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing XML response document with handler: " + handler.getClass()));
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            block6: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new AmazonClientException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler handler, InputStream inputStream) throws IOException {
        if (!this.sanitizeXmlDocument) {
            return inputStream;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sanitizing XML document destined for handler " + handler.getClass()));
        }
        ByteArrayInputStream sanitizedInputStream = null;
        try {
            StringBuilder listingDocBuffer = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            br.close();
            String listingDoc = listingDocBuffer.toString().replaceAll("\r", "&#013;");
            sanitizedInputStream = new ByteArrayInputStream(listingDoc.getBytes(StringUtils.UTF8));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            block8: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)"Unable to close response InputStream after failure sanitizing XML document", (Throwable)e);
                }
            }
            throw new AmazonClientException("Failed to sanitize XML document destined for handler " + handler.getClass(), t);
        }
        return sanitizedInputStream;
    }

    private static String checkForEmptyString(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Unable to parse integer value '" + s + "'"), (Throwable)nfe);
            return -1;
        }
    }

    private static long parseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Unable to parse long value '" + s + "'"), (Throwable)nfe);
            return -1L;
        }
    }

    public ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream) throws IOException {
        ListBucketHandler handler = new ListBucketHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListVersionsHandler parseListVersionsResponse(InputStream inputStream) throws IOException {
        ListVersionsHandler handler = new ListVersionsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) throws IOException {
        ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) throws IOException {
        AccessControlListHandler handler = new AccessControlListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLoggingConfigurationHandler parseLoggingStatusResponse(InputStream inputStream) throws IOException {
        BucketLoggingConfigurationHandler handler = new BucketLoggingConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLifecycleConfigurationHandler parseBucketLifecycleConfigurationResponse(InputStream inputStream) throws IOException {
        BucketLifecycleConfigurationHandler handler = new BucketLifecycleConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketCrossOriginConfigurationHandler parseBucketCrossOriginConfigurationResponse(InputStream inputStream) throws IOException {
        BucketCrossOriginConfigurationHandler handler = new BucketCrossOriginConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public String parseBucketLocationResponse(InputStream inputStream) throws IOException {
        BucketLocationHandler handler = new BucketLocationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getLocation();
    }

    public BucketVersioningConfigurationHandler parseVersioningConfigurationResponse(InputStream inputStream) throws IOException {
        BucketVersioningConfigurationHandler handler = new BucketVersioningConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketWebsiteConfigurationHandler parseWebsiteConfigurationResponse(InputStream inputStream) throws IOException {
        BucketWebsiteConfigurationHandler handler = new BucketWebsiteConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketNotificationConfigurationHandler parseNotificationConfigurationResponse(InputStream inputStream) throws IOException {
        BucketNotificationConfigurationHandler handler = new BucketNotificationConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketTaggingConfigurationHandler parseTaggingConfigurationResponse(InputStream inputStream) throws IOException {
        BucketTaggingConfigurationHandler handler = new BucketTaggingConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DeleteObjectsHandler parseDeletedObjectsResult(InputStream inputStream) throws IOException {
        DeleteObjectsHandler handler = new DeleteObjectsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream) throws IOException {
        CopyObjectResultHandler handler = new CopyObjectResultHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public CompleteMultipartUploadHandler parseCompleteMultipartUploadResponse(InputStream inputStream) throws IOException {
        CompleteMultipartUploadHandler handler = new CompleteMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public InitiateMultipartUploadHandler parseInitiateMultipartUploadResponse(InputStream inputStream) throws IOException {
        InitiateMultipartUploadHandler handler = new InitiateMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListMultipartUploadsHandler parseListMultipartUploadsResponse(InputStream inputStream) throws IOException {
        ListMultipartUploadsHandler handler = new ListMultipartUploadsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListPartsHandler parseListPartsResponse(InputStream inputStream) throws IOException {
        ListPartsHandler handler = new ListPartsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public RequestPaymentConfigurationHandler parseRequestPaymentConfigurationResponse(InputStream inputStream) throws IOException {
        RequestPaymentConfigurationHandler handler = new RequestPaymentConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    private static String findAttributeValue(String qnameToFind, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            if (!qname.trim().equalsIgnoreCase(qnameToFind.trim())) continue;
            return attrs.getValue(i);
        }
        return null;
    }

    public static class BucketCrossOriginConfigurationHandler
    extends AbstractHandler {
        private final BucketCrossOriginConfiguration configuration = new BucketCrossOriginConfiguration(new ArrayList<CORSRule>());
        private CORSRule currentRule;
        private List<CORSRule.AllowedMethods> allowedMethods = null;
        private List<String> allowedOrigins = null;
        private List<String> exposedHeaders = null;
        private List<String> allowedHeaders = null;

        public BucketCrossOriginConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("CORSConfiguration")) {
                if (name.equals("CORSRule")) {
                    this.currentRule = new CORSRule();
                }
            } else if (this.in("CORSConfiguration", "CORSRule")) {
                if (name.equals("AllowedOrigin")) {
                    if (this.allowedOrigins == null) {
                        this.allowedOrigins = new ArrayList<String>();
                    }
                } else if (name.equals("AllowedMethod")) {
                    if (this.allowedMethods == null) {
                        this.allowedMethods = new ArrayList<CORSRule.AllowedMethods>();
                    }
                } else if (name.equals("ExposeHeader")) {
                    if (this.exposedHeaders == null) {
                        this.exposedHeaders = new ArrayList<String>();
                    }
                } else if (name.equals("AllowedHeader") && this.allowedHeaders == null) {
                    this.allowedHeaders = new LinkedList<String>();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("CORSConfiguration")) {
                if (name.equals("CORSRule")) {
                    this.currentRule.setAllowedHeaders(this.allowedHeaders);
                    this.currentRule.setAllowedMethods(this.allowedMethods);
                    this.currentRule.setAllowedOrigins(this.allowedOrigins);
                    this.currentRule.setExposedHeaders(this.exposedHeaders);
                    this.allowedHeaders = null;
                    this.allowedMethods = null;
                    this.allowedOrigins = null;
                    this.exposedHeaders = null;
                    this.configuration.getRules().add(this.currentRule);
                    this.currentRule = null;
                }
            } else if (this.in("CORSConfiguration", "CORSRule")) {
                if (name.equals("ID")) {
                    this.currentRule.setId(this.getText());
                } else if (name.equals("AllowedOrigin")) {
                    this.allowedOrigins.add(this.getText());
                } else if (name.equals("AllowedMethod")) {
                    this.allowedMethods.add(CORSRule.AllowedMethods.fromValue(this.getText()));
                } else if (name.equals("MaxAgeSeconds")) {
                    this.currentRule.setMaxAgeSeconds(Integer.parseInt(this.getText()));
                } else if (name.equals("ExposeHeader")) {
                    this.exposedHeaders.add(this.getText());
                } else if (name.equals("AllowedHeader")) {
                    this.allowedHeaders.add(this.getText());
                }
            }
        }
    }

    public static class BucketLifecycleConfigurationHandler
    extends AbstractHandler {
        private final BucketLifecycleConfiguration configuration = new BucketLifecycleConfiguration(new ArrayList<BucketLifecycleConfiguration.Rule>());
        private BucketLifecycleConfiguration.Rule currentRule;
        private BucketLifecycleConfiguration.Transition currentTransition;
        private BucketLifecycleConfiguration.NoncurrentVersionTransition currentNcvTransition;

        public BucketLifecycleConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("LifecycleConfiguration")) {
                if (name.equals("Rule")) {
                    this.currentRule = new BucketLifecycleConfiguration.Rule();
                }
            } else if (this.in("LifecycleConfiguration", "Rule")) {
                if (name.equals("Transition")) {
                    this.currentTransition = new BucketLifecycleConfiguration.Transition();
                } else if (name.equals("NoncurrentVersionTransition")) {
                    this.currentNcvTransition = new BucketLifecycleConfiguration.NoncurrentVersionTransition();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("LifecycleConfiguration")) {
                if (name.equals("Rule")) {
                    this.configuration.getRules().add(this.currentRule);
                    this.currentRule = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule")) {
                if (name.equals("ID")) {
                    this.currentRule.setId(this.getText());
                } else if (name.equals("Prefix")) {
                    this.currentRule.setPrefix(this.getText());
                } else if (name.equals("Status")) {
                    this.currentRule.setStatus(this.getText());
                } else if (name.equals("Transition")) {
                    this.currentRule.setTransition(this.currentTransition);
                    this.currentTransition = null;
                } else if (name.equals("NoncurrentVersionTransition")) {
                    this.currentRule.setNoncurrentVersionTransition(this.currentNcvTransition);
                    this.currentNcvTransition = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Expiration")) {
                if (name.equals("Date")) {
                    this.currentRule.setExpirationDate(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (name.equals("Days")) {
                    this.currentRule.setExpirationInDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Transition")) {
                if (name.equals("StorageClass")) {
                    this.currentTransition.setStorageClass(StorageClass.fromValue(this.getText()));
                } else if (name.equals("Date")) {
                    this.currentTransition.setDate(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (name.equals("Days")) {
                    this.currentTransition.setDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionExpiration")) {
                if (name.equals("NoncurrentDays")) {
                    this.currentRule.setNoncurrentVersionExpirationInDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionTransition")) {
                if (name.equals("StorageClass")) {
                    this.currentNcvTransition.setStorageClass(StorageClass.fromValue(this.getText()));
                } else if (name.equals("NoncurrentDays")) {
                    this.currentNcvTransition.setDays(Integer.parseInt(this.getText()));
                }
            }
        }
    }

    public static class DeleteObjectsHandler
    extends AbstractHandler {
        private final DeleteObjectsResponse response = new DeleteObjectsResponse();
        private DeleteObjectsResult.DeletedObject currentDeletedObject = null;
        private MultiObjectDeleteException.DeleteError currentError = null;

        public DeleteObjectsResponse getDeleteObjectResult() {
            return this.response;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("DeleteResult")) {
                if (name.equals("Deleted")) {
                    this.currentDeletedObject = new DeleteObjectsResult.DeletedObject();
                } else if (name.equals("Error")) {
                    this.currentError = new MultiObjectDeleteException.DeleteError();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("DeleteResult")) {
                if (name.equals("Deleted")) {
                    this.response.getDeletedObjects().add(this.currentDeletedObject);
                    this.currentDeletedObject = null;
                } else if (name.equals("Error")) {
                    this.response.getErrors().add(this.currentError);
                    this.currentError = null;
                }
            } else if (this.in("DeleteResult", "Deleted")) {
                if (name.equals("Key")) {
                    this.currentDeletedObject.setKey(this.getText());
                } else if (name.equals("VersionId")) {
                    this.currentDeletedObject.setVersionId(this.getText());
                } else if (name.equals("DeleteMarker")) {
                    this.currentDeletedObject.setDeleteMarker(this.getText().equals("true"));
                } else if (name.equals("DeleteMarkerVersionId")) {
                    this.currentDeletedObject.setDeleteMarkerVersionId(this.getText());
                }
            } else if (this.in("DeleteResult", "Error")) {
                if (name.equals("Key")) {
                    this.currentError.setKey(this.getText());
                } else if (name.equals("VersionId")) {
                    this.currentError.setVersionId(this.getText());
                } else if (name.equals("Code")) {
                    this.currentError.setCode(this.getText());
                } else if (name.equals("Message")) {
                    this.currentError.setMessage(this.getText());
                }
            }
        }
    }

    public static class BucketTaggingConfigurationHandler
    extends AbstractHandler {
        private final BucketTaggingConfiguration configuration = new BucketTaggingConfiguration();
        private Map<String, String> currentTagSet;
        private String currentTagKey;
        private String currentTagValue;

        public BucketTaggingConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("Tagging") && name.equals("TagSet")) {
                this.currentTagSet = new HashMap<String, String>();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Tagging")) {
                if (name.equals("TagSet")) {
                    this.configuration.getAllTagSets().add(new TagSet(this.currentTagSet));
                    this.currentTagSet = null;
                }
            } else if (this.in("Tagging", "TagSet")) {
                if (name.equals("Tag")) {
                    if (this.currentTagKey != null && this.currentTagValue != null) {
                        this.currentTagSet.put(this.currentTagKey, this.currentTagValue);
                    }
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                }
            } else if (this.in("Tagging", "TagSet", "Tag")) {
                if (name.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (name.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            }
        }
    }

    public static class BucketNotificationConfigurationHandler
    extends AbstractHandler {
        private final BucketNotificationConfiguration configuration = new BucketNotificationConfiguration();
        private String topic;
        private String event;

        public BucketNotificationConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("NotificationConfiguration", "TopicConfiguration")) {
                if (name.equals("Topic")) {
                    this.topic = this.getText();
                } else if (name.equals("Event")) {
                    this.event = this.getText();
                }
            } else if (this.in("NotificationConfiguration") && name.equals("TopicConfiguration")) {
                if (this.topic != null && this.event != null) {
                    this.configuration.getTopicConfigurations().add(new BucketNotificationConfiguration.TopicConfiguration(this.topic, this.event));
                }
                this.topic = null;
                this.event = null;
            }
        }
    }

    public static class ListPartsHandler
    extends AbstractHandler {
        private final PartListing result = new PartListing();
        private PartSummary currentPart;
        private Owner currentOwner;

        public PartListing getListPartsResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListPartsResult")) {
                if (name.equals("Part")) {
                    this.currentPart = new PartSummary();
                } else if (name.equals("Owner") || name.equals("Initiator")) {
                    this.currentOwner = new Owner();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListPartsResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (name.equals("UploadId")) {
                    this.result.setUploadId(this.getText());
                } else if (name.equals("Owner")) {
                    this.result.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiator")) {
                    this.result.setInitiator(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("StorageClass")) {
                    this.result.setStorageClass(this.getText());
                } else if (name.equals("PartNumberMarker")) {
                    this.result.setPartNumberMarker(this.parseInteger(this.getText()));
                } else if (name.equals("NextPartNumberMarker")) {
                    this.result.setNextPartNumberMarker(this.parseInteger(this.getText()));
                } else if (name.equals("MaxParts")) {
                    this.result.setMaxParts(this.parseInteger(this.getText()));
                } else if (name.equals("EncodingType")) {
                    this.result.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.getText()));
                } else if (name.equals("Part")) {
                    this.result.getParts().add(this.currentPart);
                    this.currentPart = null;
                }
            } else if (this.in("ListPartsResult", "Part")) {
                if (name.equals("PartNumber")) {
                    this.currentPart.setPartNumber(Integer.parseInt(this.getText()));
                } else if (name.equals("LastModified")) {
                    this.currentPart.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (name.equals("ETag")) {
                    this.currentPart.setETag(ServiceUtils.removeQuotes(this.getText()));
                } else if (name.equals("Size")) {
                    this.currentPart.setSize(Long.parseLong(this.getText()));
                }
            } else if (this.in("ListPartsResult", "Owner") || this.in("ListPartsResult", "Initiator")) {
                if (name.equals("ID")) {
                    this.currentOwner.setId(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            }
        }

        private Integer parseInteger(String text) {
            text = XmlResponsesSaxParser.checkForEmptyString(this.getText());
            if (text == null) {
                return null;
            }
            return Integer.parseInt(text);
        }
    }

    public static class ListMultipartUploadsHandler
    extends AbstractHandler {
        private final MultipartUploadListing result = new MultipartUploadListing();
        private MultipartUpload currentMultipartUpload;
        private Owner currentOwner;

        public MultipartUploadListing getListMultipartUploadsResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListMultipartUploadsResult")) {
                if (name.equals("Upload")) {
                    this.currentMultipartUpload = new MultipartUpload();
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload") && (name.equals("Owner") || name.equals("Initiator"))) {
                this.currentOwner = new Owner();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListMultipartUploadsResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (name.equals("KeyMarker")) {
                    this.result.setKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("Delimiter")) {
                    this.result.setDelimiter(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("Prefix")) {
                    this.result.setPrefix(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("UploadIdMarker")) {
                    this.result.setUploadIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("NextKeyMarker")) {
                    this.result.setNextKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("NextUploadIdMarker")) {
                    this.result.setNextUploadIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("MaxUploads")) {
                    this.result.setMaxUploads(Integer.parseInt(this.getText()));
                } else if (name.equals("EncodingType")) {
                    this.result.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.getText()));
                } else if (name.equals("Upload")) {
                    this.result.getMultipartUploads().add(this.currentMultipartUpload);
                    this.currentMultipartUpload = null;
                }
            } else if (this.in("ListMultipartUploadsResult", "CommonPrefixes")) {
                if (name.equals("Prefix")) {
                    this.result.getCommonPrefixes().add(this.getText());
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload")) {
                if (name.equals("Key")) {
                    this.currentMultipartUpload.setKey(this.getText());
                } else if (name.equals("UploadId")) {
                    this.currentMultipartUpload.setUploadId(this.getText());
                } else if (name.equals("Owner")) {
                    this.currentMultipartUpload.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiator")) {
                    this.currentMultipartUpload.setInitiator(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("StorageClass")) {
                    this.currentMultipartUpload.setStorageClass(this.getText());
                } else if (name.equals("Initiated")) {
                    this.currentMultipartUpload.setInitiated(ServiceUtils.parseIso8601Date(this.getText()));
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload", "Owner") || this.in("ListMultipartUploadsResult", "Upload", "Initiator")) {
                if (name.equals("ID")) {
                    this.currentOwner.setId(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            }
        }
    }

    public static class InitiateMultipartUploadHandler
    extends AbstractHandler {
        private final InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();

        public InitiateMultipartUploadResult getInitiateMultipartUploadResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("InitiateMultipartUploadResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (name.equals("UploadId")) {
                    this.result.setUploadId(this.getText());
                }
            }
        }
    }

    public static class CompleteMultipartUploadHandler
    extends AbstractSSEHandler
    implements ObjectExpirationResult {
        private CompleteMultipartUploadResult result;
        private AmazonS3Exception ase;
        private String hostId;
        private String requestId;
        private String errorCode;

        @Override
        protected ServerSideEncryptionResult sseResult() {
            return this.result;
        }

        @Override
        public Date getExpirationTime() {
            return this.result == null ? null : this.result.getExpirationTime();
        }

        @Override
        public void setExpirationTime(Date expirationTime) {
            if (this.result != null) {
                this.result.setExpirationTime(expirationTime);
            }
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.result == null ? null : this.result.getExpirationTimeRuleId();
        }

        @Override
        public void setExpirationTimeRuleId(String expirationTimeRuleId) {
            if (this.result != null) {
                this.result.setExpirationTimeRuleId(expirationTimeRuleId);
            }
        }

        public CompleteMultipartUploadResult getCompleteMultipartUploadResult() {
            return this.result;
        }

        public AmazonS3Exception getAmazonS3Exception() {
            return this.ase;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.atTopLevel() && name.equals("CompleteMultipartUploadResult")) {
                this.result = new CompleteMultipartUploadResult();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.atTopLevel()) {
                if (name.equals("Error") && this.ase != null) {
                    this.ase.setErrorCode(this.errorCode);
                    this.ase.setRequestId(this.requestId);
                    this.ase.setExtendedRequestId(this.hostId);
                }
            } else if (this.in("CompleteMultipartUploadResult")) {
                if (name.equals("Location")) {
                    this.result.setLocation(this.getText());
                } else if (name.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (name.equals("ETag")) {
                    this.result.setETag(ServiceUtils.removeQuotes(this.getText()));
                }
            } else if (this.in("Error")) {
                if (name.equals("Code")) {
                    this.errorCode = this.getText();
                } else if (name.equals("Message")) {
                    this.ase = new AmazonS3Exception(this.getText());
                } else if (name.equals("RequestId")) {
                    this.requestId = this.getText();
                } else if (name.equals("HostId")) {
                    this.hostId = this.getText();
                }
            }
        }
    }

    public static class BucketVersioningConfigurationHandler
    extends AbstractHandler {
        private final BucketVersioningConfiguration configuration = new BucketVersioningConfiguration();

        public BucketVersioningConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("VersioningConfiguration")) {
                if (name.equals("Status")) {
                    this.configuration.setStatus(this.getText());
                } else if (name.equals("MfaDelete")) {
                    String mfaDeleteStatus = this.getText();
                    if (mfaDeleteStatus.equals("Disabled")) {
                        this.configuration.setMfaDeleteEnabled(false);
                    } else if (mfaDeleteStatus.equals("Enabled")) {
                        this.configuration.setMfaDeleteEnabled(true);
                    } else {
                        this.configuration.setMfaDeleteEnabled(null);
                    }
                }
            }
        }
    }

    public static class BucketWebsiteConfigurationHandler
    extends AbstractHandler {
        private final BucketWebsiteConfiguration configuration = new BucketWebsiteConfiguration(null);
        private RoutingRuleCondition currentCondition = null;
        private RedirectRule currentRedirectRule = null;
        private RoutingRule currentRoutingRule = null;

        public BucketWebsiteConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("WebsiteConfiguration")) {
                if (name.equals("RedirectAllRequestsTo")) {
                    this.currentRedirectRule = new RedirectRule();
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules")) {
                if (name.equals("RoutingRule")) {
                    this.currentRoutingRule = new RoutingRule();
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule")) {
                if (name.equals("Condition")) {
                    this.currentCondition = new RoutingRuleCondition();
                } else if (name.equals("Redirect")) {
                    this.currentRedirectRule = new RedirectRule();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("WebsiteConfiguration")) {
                if (name.equals("RedirectAllRequestsTo")) {
                    this.configuration.setRedirectAllRequestsTo(this.currentRedirectRule);
                    this.currentRedirectRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "IndexDocument")) {
                if (name.equals("Suffix")) {
                    this.configuration.setIndexDocumentSuffix(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "ErrorDocument")) {
                if (name.equals("Key")) {
                    this.configuration.setErrorDocument(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules")) {
                if (name.equals("RoutingRule")) {
                    this.configuration.getRoutingRules().add(this.currentRoutingRule);
                    this.currentRoutingRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule")) {
                if (name.equals("Condition")) {
                    this.currentRoutingRule.setCondition(this.currentCondition);
                    this.currentCondition = null;
                } else if (name.equals("Redirect")) {
                    this.currentRoutingRule.setRedirect(this.currentRedirectRule);
                    this.currentRedirectRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule", "Condition")) {
                if (name.equals("KeyPrefixEquals")) {
                    this.currentCondition.setKeyPrefixEquals(this.getText());
                } else if (name.equals("HttpErrorCodeReturnedEquals")) {
                    this.currentCondition.setHttpErrorCodeReturnedEquals(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "RedirectAllRequestsTo") || this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule", "Redirect")) {
                if (name.equals("Protocol")) {
                    this.currentRedirectRule.setProtocol(this.getText());
                } else if (name.equals("HostName")) {
                    this.currentRedirectRule.setHostName(this.getText());
                } else if (name.equals("ReplaceKeyPrefixWith")) {
                    this.currentRedirectRule.setReplaceKeyPrefixWith(this.getText());
                } else if (name.equals("ReplaceKeyWith")) {
                    this.currentRedirectRule.setReplaceKeyWith(this.getText());
                } else if (name.equals("HttpRedirectCode")) {
                    this.currentRedirectRule.setHttpRedirectCode(this.getText());
                }
            }
        }
    }

    public static class ListVersionsHandler
    extends AbstractHandler {
        private final VersionListing versionListing = new VersionListing();
        private S3VersionSummary currentVersionSummary;
        private Owner currentOwner;

        public VersionListing getListing() {
            return this.versionListing;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListVersionsResult")) {
                if (name.equals("Version")) {
                    this.currentVersionSummary = new S3VersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                } else if (name.equals("DeleteMarker")) {
                    this.currentVersionSummary = new S3VersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                    this.currentVersionSummary.setIsDeleteMarker(true);
                }
            } else if ((this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) && name.equals("Owner")) {
                this.currentOwner = new Owner();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListVersionsResult")) {
                if (name.equals("Name")) {
                    this.versionListing.setBucketName(this.getText());
                } else if (name.equals("Prefix")) {
                    this.versionListing.setPrefix(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("KeyMarker")) {
                    this.versionListing.setKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("VersionIdMarker")) {
                    this.versionListing.setVersionIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("MaxKeys")) {
                    this.versionListing.setMaxKeys(Integer.parseInt(this.getText()));
                } else if (name.equals("Delimiter")) {
                    this.versionListing.setDelimiter(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("EncodingType")) {
                    this.versionListing.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("NextKeyMarker")) {
                    this.versionListing.setNextKeyMarker(this.getText());
                } else if (name.equals("NextVersionIdMarker")) {
                    this.versionListing.setNextVersionIdMarker(this.getText());
                } else if (name.equals("IsTruncated")) {
                    this.versionListing.setTruncated("true".equals(this.getText()));
                } else if (name.equals("Version") || name.equals("DeleteMarker")) {
                    this.versionListing.getVersionSummaries().add(this.currentVersionSummary);
                    this.currentVersionSummary = null;
                }
            } else if (this.in("ListVersionsResult", "CommonPrefixes")) {
                if (name.equals("Prefix")) {
                    this.versionListing.getCommonPrefixes().add(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            } else if (this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) {
                if (name.equals("Key")) {
                    this.currentVersionSummary.setKey(this.getText());
                } else if (name.equals("VersionId")) {
                    this.currentVersionSummary.setVersionId(this.getText());
                } else if (name.equals("IsLatest")) {
                    this.currentVersionSummary.setIsLatest("true".equals(this.getText()));
                } else if (name.equals("LastModified")) {
                    this.currentVersionSummary.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (name.equals("ETag")) {
                    this.currentVersionSummary.setETag(ServiceUtils.removeQuotes(this.getText()));
                } else if (name.equals("Size")) {
                    this.currentVersionSummary.setSize(Long.parseLong(this.getText()));
                } else if (name.equals("Owner")) {
                    this.currentVersionSummary.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("StorageClass")) {
                    this.currentVersionSummary.setStorageClass(this.getText());
                }
            } else if (this.in("ListVersionsResult", "Version", "Owner") || this.in("ListVersionsResult", "DeleteMarker", "Owner")) {
                if (name.equals("ID")) {
                    this.currentOwner.setId(this.getText());
                } else if (name.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(this.getText());
                }
            }
        }
    }

    public static class RequestPaymentConfigurationHandler
    extends AbstractHandler {
        private String payer = null;

        public RequestPaymentConfiguration getConfiguration() {
            return new RequestPaymentConfiguration(RequestPaymentConfiguration.Payer.valueOf(this.payer));
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("RequestPaymentConfiguration") && name.equals("Payer")) {
                this.payer = this.getText();
            }
        }
    }

    public static class CopyObjectResultHandler
    extends AbstractSSEHandler
    implements ObjectExpirationResult {
        private final CopyObjectResult result = new CopyObjectResult();
        private String errorCode = null;
        private String errorMessage = null;
        private String errorRequestId = null;
        private String errorHostId = null;
        private boolean receivedErrorResponse = false;

        @Override
        protected ServerSideEncryptionResult sseResult() {
            return this.result;
        }

        public Date getLastModified() {
            return this.result.getLastModifiedDate();
        }

        public String getVersionId() {
            return this.result.getVersionId();
        }

        public void setVersionId(String versionId) {
            this.result.setVersionId(versionId);
        }

        @Override
        public Date getExpirationTime() {
            return this.result.getExpirationTime();
        }

        @Override
        public void setExpirationTime(Date expirationTime) {
            this.result.setExpirationTime(expirationTime);
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.result.getExpirationTimeRuleId();
        }

        @Override
        public void setExpirationTimeRuleId(String expirationTimeRuleId) {
            this.result.setExpirationTimeRuleId(expirationTimeRuleId);
        }

        public String getETag() {
            return this.result.getETag();
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorHostId() {
            return this.errorHostId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorRequestId() {
            return this.errorRequestId;
        }

        public boolean isErrorResponse() {
            return this.receivedErrorResponse;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.atTopLevel()) {
                if (name.equals("CopyObjectResult") || name.equals("CopyPartResult")) {
                    this.receivedErrorResponse = false;
                } else if (name.equals("Error")) {
                    this.receivedErrorResponse = true;
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("CopyObjectResult") || this.in("CopyPartResult")) {
                if (name.equals("LastModified")) {
                    this.result.setLastModifiedDate(ServiceUtils.parseIso8601Date(this.getText()));
                } else if (name.equals("ETag")) {
                    this.result.setETag(ServiceUtils.removeQuotes(this.getText()));
                }
            } else if (this.in("Error")) {
                if (name.equals("Code")) {
                    this.errorCode = this.getText();
                } else if (name.equals("Message")) {
                    this.errorMessage = this.getText();
                } else if (name.equals("RequestId")) {
                    this.errorRequestId = this.getText();
                } else if (name.equals("HostId")) {
                    this.errorHostId = this.getText();
                }
            }
        }
    }

    public static class BucketLocationHandler
    extends AbstractHandler {
        private String location = null;

        public String getLocation() {
            return this.location;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.atTopLevel() && name.equals("LocationConstraint")) {
                String elementText = this.getText();
                this.location = elementText.length() == 0 ? null : elementText;
            }
        }
    }

    public static class BucketLoggingConfigurationHandler
    extends AbstractHandler {
        private final BucketLoggingConfiguration bucketLoggingConfiguration = new BucketLoggingConfiguration();

        public BucketLoggingConfiguration getBucketLoggingConfiguration() {
            return this.bucketLoggingConfiguration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("BucketLoggingStatus", "LoggingEnabled")) {
                if (name.equals("TargetBucket")) {
                    this.bucketLoggingConfiguration.setDestinationBucketName(this.getText());
                } else if (name.equals("TargetPrefix")) {
                    this.bucketLoggingConfiguration.setLogFilePrefix(this.getText());
                }
            }
        }
    }

    public static class AccessControlListHandler
    extends AbstractHandler {
        private final AccessControlList accessControlList = new AccessControlList();
        private Grantee currentGrantee = null;
        private Permission currentPermission = null;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("AccessControlPolicy")) {
                if (name.equals("Owner")) {
                    this.accessControlList.setOwner(new Owner());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant") && name.equals("Grantee")) {
                String type = XmlResponsesSaxParser.findAttributeValue("xsi:type", attrs);
                if ("AmazonCustomerByEmail".equals(type)) {
                    this.currentGrantee = new EmailAddressGrantee(null);
                } else if ("CanonicalUser".equals(type)) {
                    this.currentGrantee = new CanonicalGrantee(null);
                } else if ("Group".equals(type)) {
                    // empty if block
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("AccessControlPolicy", "Owner")) {
                if (name.equals("ID")) {
                    this.accessControlList.getOwner().setId(this.getText());
                } else if (name.equals("DisplayName")) {
                    this.accessControlList.getOwner().setDisplayName(this.getText());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList")) {
                if (name.equals("Grant")) {
                    this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
                    this.currentGrantee = null;
                    this.currentPermission = null;
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant")) {
                if (name.equals("Permission")) {
                    this.currentPermission = Permission.parsePermission(this.getText());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant", "Grantee")) {
                if (name.equals("ID")) {
                    this.currentGrantee.setIdentifier(this.getText());
                } else if (name.equals("EmailAddress")) {
                    this.currentGrantee.setIdentifier(this.getText());
                } else if (name.equals("URI")) {
                    this.currentGrantee = GroupGrantee.parseGroupGrantee(this.getText());
                } else if (name.equals("DisplayName")) {
                    ((CanonicalGrantee)this.currentGrantee).setDisplayName(this.getText());
                }
            }
        }
    }

    public static class ListAllMyBucketsHandler
    extends AbstractHandler {
        private final List<Bucket> buckets = new ArrayList<Bucket>();
        private Owner bucketsOwner = null;
        private Bucket currentBucket = null;

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        public Owner getOwner() {
            return this.bucketsOwner;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListAllMyBucketsResult")) {
                if (name.equals("Owner")) {
                    this.bucketsOwner = new Owner();
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets") && name.equals("Bucket")) {
                this.currentBucket = new Bucket();
                this.currentBucket.setOwner(this.bucketsOwner);
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListAllMyBucketsResult", "Owner")) {
                if (name.equals("ID")) {
                    this.bucketsOwner.setId(this.getText());
                } else if (name.equals("DisplayName")) {
                    this.bucketsOwner.setDisplayName(this.getText());
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets")) {
                if (name.equals("Bucket")) {
                    this.buckets.add(this.currentBucket);
                    this.currentBucket = null;
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets", "Bucket")) {
                if (name.equals("Name")) {
                    this.currentBucket.setName(this.getText());
                } else if (name.equals("CreationDate")) {
                    Date creationDate = DateUtils.parseISO8601Date(this.getText());
                    this.currentBucket.setCreationDate(creationDate);
                }
            }
        }
    }

    public static class ListBucketHandler
    extends AbstractHandler {
        private final ObjectListing objectListing = new ObjectListing();
        private S3ObjectSummary currentObject = null;
        private Owner currentOwner = null;
        private String lastKey = null;

        public ObjectListing getObjectListing() {
            return this.objectListing;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListBucketResult")) {
                if (name.equals("Contents")) {
                    this.currentObject = new S3ObjectSummary();
                    this.currentObject.setBucketName(this.objectListing.getBucketName());
                }
            } else if (this.in("ListBucketResult", "Contents") && name.equals("Owner")) {
                this.currentOwner = new Owner();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.atTopLevel()) {
                if (!name.equals("ListBucketResult") || !this.objectListing.isTruncated() || this.objectListing.getNextMarker() != null) return;
                String nextMarker = null;
                if (!this.objectListing.getObjectSummaries().isEmpty()) {
                    nextMarker = this.objectListing.getObjectSummaries().get(this.objectListing.getObjectSummaries().size() - 1).getKey();
                } else if (!this.objectListing.getCommonPrefixes().isEmpty()) {
                    nextMarker = this.objectListing.getCommonPrefixes().get(this.objectListing.getCommonPrefixes().size() - 1);
                } else {
                    log.error((Object)"S3 response indicates truncated results, but contains no object summaries or common prefixes.");
                }
                this.objectListing.setNextMarker(nextMarker);
                return;
            } else if (this.in("ListBucketResult")) {
                if (name.equals("Name")) {
                    this.objectListing.setBucketName(this.getText());
                    if (!log.isDebugEnabled()) return;
                    log.debug((Object)("Examining listing for bucket: " + this.objectListing.getBucketName()));
                    return;
                } else if (name.equals("Prefix")) {
                    this.objectListing.setPrefix(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (name.equals("Marker")) {
                    this.objectListing.setMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (name.equals("NextMarker")) {
                    this.objectListing.setNextMarker(this.getText());
                    return;
                } else if (name.equals("MaxKeys")) {
                    this.objectListing.setMaxKeys(XmlResponsesSaxParser.parseInt(this.getText()));
                    return;
                } else if (name.equals("Delimiter")) {
                    this.objectListing.setDelimiter(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (name.equals("EncodingType")) {
                    this.objectListing.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (name.equals("IsTruncated")) {
                    String isTruncatedStr = this.getText().toLowerCase(Locale.getDefault());
                    if (isTruncatedStr.startsWith("false")) {
                        this.objectListing.setTruncated(false);
                        return;
                    } else {
                        if (!isTruncatedStr.startsWith("true")) throw new IllegalStateException("Invalid value for IsTruncated field: " + isTruncatedStr);
                        this.objectListing.setTruncated(true);
                    }
                    return;
                } else {
                    if (!name.equals("Contents")) return;
                    this.objectListing.getObjectSummaries().add(this.currentObject);
                    this.currentObject = null;
                }
                return;
            } else if (this.in("ListBucketResult", "Contents")) {
                if (name.equals("Key")) {
                    this.lastKey = this.getText();
                    this.currentObject.setKey(this.lastKey);
                    return;
                } else if (name.equals("LastModified")) {
                    this.currentObject.setLastModified(ServiceUtils.parseIso8601Date(this.getText()));
                    return;
                } else if (name.equals("ETag")) {
                    this.currentObject.setETag(ServiceUtils.removeQuotes(this.getText()));
                    return;
                } else if (name.equals("Size")) {
                    this.currentObject.setSize(XmlResponsesSaxParser.parseLong(this.getText()));
                    return;
                } else if (name.equals("StorageClass")) {
                    this.currentObject.setStorageClass(this.getText());
                    return;
                } else {
                    if (!name.equals("Owner")) return;
                    this.currentObject.setOwner(this.currentOwner);
                    this.currentOwner = null;
                }
                return;
            } else if (this.in("ListBucketResult", "Contents", "Owner")) {
                if (name.equals("ID")) {
                    this.currentOwner.setId(this.getText());
                    return;
                } else {
                    if (!name.equals("DisplayName")) return;
                    this.currentOwner.setDisplayName(this.getText());
                }
                return;
            } else {
                if (!this.in("ListBucketResult", "CommonPrefixes") || !name.equals("Prefix")) return;
                this.objectListing.getCommonPrefixes().add(this.getText());
            }
        }
    }
}

