/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListJobsRequestMarshaller
implements Marshaller<Request<ListJobsRequest>, ListJobsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<ListJobsRequest> marshall(ListJobsRequest listJobsRequest) {
        String value;
        String name;
        if (listJobsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListJobsRequest> request = new DefaultRequest<ListJobsRequest>(listJobsRequest, "AmazonGlacier");
        String target = "Glacier.ListJobs";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string = value = listJobsRequest.getAccountId() == null ? null : StringUtils.fromString(listJobsRequest.getAccountId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", listJobsRequest.getAccountId() == null ? "" : StringUtils.fromString(listJobsRequest.getAccountId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("vaultName")) {
            name = DYNAMIC_QUERY_PARAMS.get("vaultName");
            String string = value = listJobsRequest.getVaultName() == null ? null : StringUtils.fromString(listJobsRequest.getVaultName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{vaultName}", listJobsRequest.getVaultName() == null ? "" : StringUtils.fromString(listJobsRequest.getVaultName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("limit")) {
            name = DYNAMIC_QUERY_PARAMS.get("limit");
            String string = value = listJobsRequest.getLimit() == null ? null : StringUtils.fromString(listJobsRequest.getLimit());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{limit}", listJobsRequest.getLimit() == null ? "" : StringUtils.fromString(listJobsRequest.getLimit()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("marker")) {
            name = DYNAMIC_QUERY_PARAMS.get("marker");
            String string = value = listJobsRequest.getMarker() == null ? null : StringUtils.fromString(listJobsRequest.getMarker());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{marker}", listJobsRequest.getMarker() == null ? "" : StringUtils.fromString(listJobsRequest.getMarker()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("statuscode")) {
            name = DYNAMIC_QUERY_PARAMS.get("statuscode");
            String string = value = listJobsRequest.getStatuscode() == null ? null : StringUtils.fromString(listJobsRequest.getStatuscode());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{statuscode}", listJobsRequest.getStatuscode() == null ? "" : StringUtils.fromString(listJobsRequest.getStatuscode()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("completed")) {
            name = DYNAMIC_QUERY_PARAMS.get("completed");
            String string = value = listJobsRequest.getCompleted() == null ? null : StringUtils.fromString(listJobsRequest.getCompleted());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{completed}", listJobsRequest.getCompleted() == null ? "" : StringUtils.fromString(listJobsRequest.getCompleted()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        return request;
    }

    static {
        String path = "/{accountId}/vaults/{vaultName}/jobs?marker={marker};limit={limit};completed={completed};statuscode={statuscode}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

