/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogUtil
extends Formatter {
    Date dat = new Date(0L);
    private String format = "{0,date} {0,time}";
    private Object[] args = new Object[1];
    private MessageFormat formatter;
    private final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String logMethod(boolean bl, String string, String string2, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(string2);
        stringBuffer.append("(");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(LogUtil.logObject(objectArray[i], bl)).append("]").append(",");
        }
        stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), " ");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String logObject(Object object, boolean bl) {
        if (object instanceof String) {
            return "String = [" + object.toString();
        }
        if (object instanceof int[]) {
            if (bl) {
                return "int[] = [" + ((int[])object).length;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < ((int[])object).length; ++i) {
                stringBuffer.append(((int[])object)[i]).append(",");
            }
            if (stringBuffer.charAt(stringBuffer.length()) == ',') {
                stringBuffer.setCharAt(stringBuffer.length(), ' ');
            }
            return "int[] = [" + stringBuffer.toString();
        }
        if (object instanceof String[]) {
            if (bl) {
                return "String[] = [" + ((String[])object).length;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < ((String[])object).length; ++i) {
                stringBuffer.append(((String[])object)[i]).append(",");
            }
            if (stringBuffer.charAt(stringBuffer.length()) == ',') {
                stringBuffer.setCharAt(stringBuffer.length(), ' ');
            }
            return "String[] = [" + stringBuffer.toString();
        }
        if (object instanceof byte[]) {
            if (bl) {
                return "byte[] = [" + ((byte[])object).length;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < ((byte[])object).length; ++i) {
                stringBuffer.append(((byte[])object)[i]).append(",");
            }
            if (stringBuffer.charAt(stringBuffer.length()) == ',') {
                stringBuffer.setCharAt(stringBuffer.length(), ' ');
            }
            return "byte[] = [" + stringBuffer.toString();
        }
        if (object instanceof Savepoint) {
            try {
                return "Savepoint = [name = " + ((Savepoint)object).getSavepointName() + ", id = " + ((Savepoint)object).getSavepointId();
            }
            catch (SQLException sQLException) {
                return "Savepoint = [?";
            }
        }
        if (object instanceof Map) {
            if (bl) {
                return "Map.size = [" + ((Map)object).size();
            }
        } else {
            if (object instanceof Object[]) {
                if (bl) {
                    return "Object[].len = [" + ((Object[])object).length;
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    stringBuffer.append(((Object[])object)[i]).append(",");
                }
                if (stringBuffer.charAt(stringBuffer.length()) == ',') {
                    stringBuffer.setCharAt(stringBuffer.length(), ' ');
                }
                return "Object[] = [" + stringBuffer.toString();
            }
            if (object instanceof Properties) {
                if (bl) {
                    return "Properties.size = [" + ((Properties)object).size();
                }
                return "Properties = [" + ((Properties)object).values().toString();
            }
            if (object instanceof Class) {
                return "Class<?> = [" + ((Class)object).getName();
            }
            if (object instanceof Date) {
                return "Date = [" + ((Date)object).toString();
            }
            if (object instanceof Time) {
                return "Time = [" + ((Time)object).toString();
            }
            if (object instanceof Timestamp) {
                return "Timestamp = [" + ((Timestamp)object).toString();
            }
            if (object instanceof InputStream) {
                try {
                    return "InputStream.available = [" + ((InputStream)object).available();
                }
                catch (IOException iOException) {
                    return "InputStream =[?";
                }
            }
            if (object instanceof URL) {
                return "URL = [" + ((URL)object).toString();
            }
            if (object instanceof Reader) {
                return "Reader.hashCode = [" + ((Reader)object).toString();
            }
            if (object instanceof Blob) {
                if (bl) {
                    try {
                        return "Blob.length = [" + ((Blob)object).length();
                    }
                    catch (SQLException sQLException) {
                        return "Blob = [?";
                    }
                }
            } else if (object instanceof Clob) {
                if (bl) {
                    try {
                        return "Clob.length = [" + ((Clob)object).length();
                    }
                    catch (SQLException sQLException) {
                        return "Clob = [?";
                    }
                }
            } else if (object instanceof NClob) {
                if (bl) {
                    try {
                        return "NClob = [" + ((NClob)object).length() + "";
                    }
                    catch (SQLException sQLException) {
                        return "NClob = [?";
                    }
                }
            } else {
                if (object instanceof Ref) {
                    try {
                        return "Ref.BaseTypeName = [" + ((Ref)object).getBaseTypeName();
                    }
                    catch (SQLException sQLException) {
                        return "Ref = [?";
                    }
                }
                if (object instanceof Array) {
                    if (bl) {
                        try {
                            return "Array.hashcode = [" + ((Array)object).getArray().toString();
                        }
                        catch (SQLException sQLException) {
                            return "Array = [?";
                        }
                    }
                } else {
                    if (object instanceof Calendar) {
                        return "Calendar = [" + ((Calendar)object).toString();
                    }
                    if (object instanceof RowId) {
                        return "RowId = [" + ((Object)((RowId)object)).toString();
                    }
                    if (object instanceof SQLXML) {
                        if (bl) {
                            try {
                                return "SQLXML.getString = [" + ((SQLXML)object).getString();
                            }
                            catch (SQLException sQLException) {
                                return "SQLXML = [?";
                            }
                        }
                    } else {
                        if (object instanceof Integer) {
                            return "int = [" + (Integer)object;
                        }
                        if (object instanceof Long) {
                            return "long = [" + (Long)object;
                        }
                        if (object instanceof Byte) {
                            return "Byte = [" + (Byte)object;
                        }
                        if (object instanceof PrintWriter) {
                            return "PrintWriter = [ " + ((PrintWriter)object).getClass();
                        }
                    }
                }
            }
        }
        return object + " = [" + object.toString();
    }

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.dat.setTime(logRecord.getMillis());
        this.args[0] = this.dat;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(this.format);
        }
        this.formatter.format(this.args, stringBuffer, (FieldPosition)null);
        stringBuilder.append(stringBuffer);
        stringBuilder.append(" ");
        stringBuilder.append(logRecord.getLevel().getLocalizedName());
        if (logRecord.getLevel() == Level.FINE) {
            stringBuilder.append("   : ");
        } else if (logRecord.getLevel() == Level.FINER) {
            stringBuilder.append("  : ");
        } else {
            stringBuilder.append(" : ");
        }
        stringBuilder.append(this.formatMessage(logRecord));
        stringBuilder.append(this.LINE_SEPARATOR);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuilder.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    public static final boolean isLoggingEnabled(Logger logger) {
        return logger.getLevel() != null && logger.getLevel().intValue() <= Level.FINE.intValue();
    }
}

