/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.SybBCP;
import com.sybase.jdbc4.tds.SybBigDecimal;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsDataOutputStream;
import com.sybase.jdbc4.tds.TdsDateTime;
import com.sybase.jdbc4.tds.TdsInputStreamIOException;
import com.sybase.jdbc4.tds.TdsNumeric;
import com.sybase.jdbc4.tds.TdsParam;
import com.sybase.jdbc4.tds.Token;
import com.sybase.jdbc4.utils.Debug;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Hashtable;

public class BCPToken
extends Token {
    private int _lockScheme;
    Calendar _userCal = Calendar.getInstance();
    private SybBCP _sybBCP = null;
    private TdsDataOutputStream _tdsOut = null;
    private int _columnCount = -1;
    private final int BOUNDARY = 256;
    private int _textimageCount = 0;
    private boolean _hasValue = false;
    private int _iprev = 0;
    private boolean _lastTextColNull = false;
    private int[] _adjustmentTable;
    private int[] _offsetTable;
    private int _adjustptr = 0;
    private int _offsetptr = 0;
    private int[] _offsetTextImage;
    private int _textptr = 0;
    private Object[] _paramDataObject;
    private int[] _paramDataSqlTypes;
    private int[] _paramDataScale;
    private Calendar[] _paramDataCalendar;
    private int _fixedColumnLengthTotal;
    private int _numberOfVariableColumns;
    private byte[] _fixedDataBuffer;
    private byte[] _variableDataBuffer;
    private int _fixedDataPos;
    private int _variableDataPos;
    protected byte[] _numbuf = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected static final int LOW_BYTE = 255;
    protected static final long D_LOW_BYTE = 255L;
    protected static final int STARTFIXEDDATAPOS = 4;
    protected static final int STARTVARIABLEDATAPOS = 2;
    protected static final int STARTFIXEDDATAPOS_DOL = 8;
    private int[] _tableMDAInfo;
    private int _columnId;
    private String _columnName;
    private int _datatype;
    private int _usertype;
    private int _columnLength;
    private int _precision;
    private int _scale;
    private int _isColumnNullable;
    private int _identityCol;
    private int _sqlType;
    private int _colOffset = 0;
    private int _truncateVarbinaryZeros = 1;
    private int _inRowLobLen = 0;
    private int _isVariableColumn = 0;
    private ParamManager _paramMgr;
    private TdsParam _param = null;
    private boolean _fixedType = false;
    private int _varColLengthTotal = 0;
    private int[] _dataInfo;
    private int _totalBytesWritten = 0;
    private int _valColCounter = 0;
    private boolean _serverAcceptsDateData = false;
    private boolean _capTimeOn = false;
    private boolean _serverAcceptsBigDateTimeData = false;
    private boolean _serverAcceptsColumnStatusByte = false;
    private boolean _userDefinedIdentity = false;
    private boolean _isInRowLob = false;
    private boolean _doneWithInRowProcessing = false;
    private int _maxRowLen = 0;
    private int _totalInRowColumns = 0;
    private byte[] _bitValueArray;
    private int _bitColumnCount = 0;
    private boolean _bitWritten = false;
    private int[] _bitColumnNumber;
    protected static final int TDS_TYPE = 0;
    protected static final int LENGTH = 1;
    protected static final int PRECISION = 2;
    protected static final int SCALE = 3;
    protected static final int INFO_LENGTH = 4;
    protected static final int BUF_SIZE = 2048;
    public static final int INROWLOB_HEADER_SIZE = 20;
    public static final int TEXTPOINTER_SIZE = 16;
    public static final int DOL_OFFSET_BOUNDRY = 8191;
    private int[] _colValueArray = null;
    private int _lastVarColumn = 0;
    private int _typeCount = 0;
    private InRowLob[] _inRowLobs;
    private int _inRowLobCounter;
    private Hashtable _valueFromReader = new Hashtable();

    public BCPToken(SybBCP sybBCP, TdsDataOutputStream tdsDataOutputStream) throws SQLException, IOException {
        this.reinitialize(sybBCP, tdsDataOutputStream);
        this._lockScheme = this._sybBCP.getTableLockScheme();
        this._maxRowLen = this._sybBCP.getMaxRowLength();
        if (this._lockScheme == 0) {
            this.APL();
        } else {
            this.DOL();
        }
    }

    private void DOL() throws SQLException, IOException {
        Tds tds = this._tdsOut._tds;
        this._serverAcceptsDateData = tds.serverAcceptsDateData();
        this._serverAcceptsBigDateTimeData = tds.serverAcceptsBigDateTimeData();
        this._serverAcceptsColumnStatusByte = tds.serverAcceptsColumnStatusByte();
        try {
            this._capTimeOn = tds.getSybProperty().getBoolean(52);
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
        this._columnCount = this._sybBCP.getColumnCount();
        this._userCal = (Calendar)this._userCal.clone();
        this._fixedColumnLengthTotal = this._sybBCP.getFixedColumnLengthTotal();
        this.calcuateBitColumnCount();
        this.resetValuesDOL();
        int n = 8 + this._fixedColumnLengthTotal;
        if (this._numberOfVariableColumns > 0) {
            int n2 = this._sybBCP.getMaxRowLength() - this._fixedColumnLengthTotal;
            this._variableDataBuffer = new byte[n2 + this._numberOfVariableColumns * 2 + 1];
            n += 2;
            this._totalBytesWritten = this._fixedColumnLengthTotal + 8;
        }
        this._fixedDataBuffer = new byte[n];
        this._paramMgr = this._sybBCP.getParamManager();
        this._paramMgr.doSetParam(1, 0, null, 0);
        this._param = (TdsParam)this._paramMgr._params[0];
        this._dataInfo = new int[4];
        this._userDefinedIdentity = this._sybBCP.getUserDefinedIdentity();
        this._lastVarColumn = this._sybBCP._lastVarColumn;
        this._totalInRowColumns = this._sybBCP.getInRowLobCount();
    }

    private void APL() throws SQLException, IOException {
        this.resetValuesAPL();
        Tds tds = this._tdsOut._tds;
        this._serverAcceptsDateData = tds.serverAcceptsDateData();
        this._serverAcceptsBigDateTimeData = tds.serverAcceptsBigDateTimeData();
        this._serverAcceptsColumnStatusByte = tds.serverAcceptsColumnStatusByte();
        try {
            this._capTimeOn = tds.getSybProperty().getBoolean(52);
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
        this._columnCount = this._sybBCP.getColumnCount();
        this._userCal = (Calendar)this._userCal.clone();
        this._fixedColumnLengthTotal = this._sybBCP.getFixedColumnLengthTotal();
        this._numberOfVariableColumns = this._sybBCP.getNumberVarColumns();
        this.calcuateBitColumnCount();
        int n = 4 + this._fixedColumnLengthTotal;
        if (this._numberOfVariableColumns > 0) {
            int n2 = this._sybBCP.getMaxRowLength() - this._fixedColumnLengthTotal;
            this._variableDataBuffer = new byte[n2 + this._numberOfVariableColumns + 2 + n2 / 256 + 1];
            n2 = this._sybBCP.getMaxRowLength();
            this.initializeAPL(this._numberOfVariableColumns, n2 / 256 + 1);
            n += 2;
            this._totalBytesWritten = this._fixedColumnLengthTotal + 4;
        }
        this._fixedDataBuffer = new byte[n];
        this._paramMgr = this._sybBCP.getParamManager();
        this._paramMgr.doSetParam(1, 0, null, 0);
        this._param = (TdsParam)this._paramMgr._params[0];
        this._dataInfo = new int[4];
        this._userDefinedIdentity = this._sybBCP.getUserDefinedIdentity();
        this._totalInRowColumns = this._sybBCP.getInRowLobCount();
    }

    public void reinitialize(SybBCP sybBCP, TdsDataOutputStream tdsDataOutputStream) {
        this._sybBCP = sybBCP;
        this._tdsOut = tdsDataOutputStream;
        this._tableMDAInfo = this._sybBCP.getIntMDA();
    }

    private void resetValuesAPL() {
        this._fixedDataPos = 4;
        this._variableDataPos = 0;
        this._varColLengthTotal = 0;
        this._valColCounter = 0;
        this._totalBytesWritten = this._fixedColumnLengthTotal + 4;
        this._adjustptr = 0;
        this._offsetptr = this._numberOfVariableColumns + 1;
        this._textptr = 0;
        this._textimageCount = 0;
        this._inRowLobCounter = 0;
        this._iprev = 0;
        this._adjustmentTable = new int[this._sybBCP.getMaxRowLength() / 256 + 1];
        this._offsetTable = new int[this._numberOfVariableColumns + 1];
        this._bitWritten = false;
    }

    private void resetValuesDOL() {
        this._fixedDataPos = 8;
        this._variableDataPos = 0;
        this._varColLengthTotal = 0;
        this._valColCounter = 0;
        this._totalBytesWritten = this._fixedColumnLengthTotal + 8;
        this._numberOfVariableColumns = this._sybBCP.getNumberVarColumns();
        if (this._numberOfVariableColumns > 0) {
            this._offsetptr = this._numberOfVariableColumns;
        }
        this.initializeDOL(this._offsetptr);
        this._textptr = 0;
        this._typeCount = 0;
        this._colValueArray = null;
        this._textimageCount = 0;
        this._inRowLobCounter = 0;
        this._bitWritten = false;
    }

    public void writeBulkData(Object[] objectArray, int[] nArray, int[] nArray2, Calendar[] calendarArray) throws SQLException, IOException {
        this._paramDataObject = objectArray;
        this._paramDataSqlTypes = nArray;
        this._paramDataScale = nArray2;
        this._paramDataCalendar = calendarArray;
        this.calculateBitValue();
        if (this._lockScheme == 0) {
            this.writeAPL();
            this.resetValuesAPL();
        } else {
            this.writeDOL();
            this.resetValuesDOL();
        }
        this._param.clear(true);
    }

    private void writeIdentity() throws IOException {
        switch (this._columnLength) {
            case 2: {
                this.writeShort(0);
                break;
            }
            case 4: {
                this.writeInt(0);
                break;
            }
            case 8: {
                this.writeLong(0L);
                break;
            }
            default: {
                for (int i = 0; i < this._columnLength; ++i) {
                    this.writeByte(0);
                }
            }
        }
    }

    private void writeFixedColumn() throws SQLException, IOException {
        this._fixedType = true;
        int n = 0;
        this.convertDataToColumnType();
        switch (this._datatype) {
            case 47: {
                this.checkValue();
                n = this._columnLength - this.writeTdsBcpCol();
                if (n <= 0) break;
                for (int i = 0; i < n; ++i) {
                    this.writeByte(32);
                }
                break;
            }
            case 48: 
            case 52: 
            case 56: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 191: {
                if (this._identityCol == 1) {
                    this.writeIdentity();
                    break;
                }
                this.writeTdsBcpCol();
                break;
            }
            case 45: {
                this.checkValue();
                n = this._columnLength - this.writeTdsBcpCol();
                if (n <= 0) break;
                for (int i = 0; i < n; ++i) {
                    this.writeByte(0);
                }
                break;
            }
            case 60: 
            case 122: {
                String string = Convert.objectToString(this._param._inValue);
                if (this._columnLength == 4) {
                    int n2 = new Integer((int)(new Double(string) * 10000.0));
                    this.writeInt(n2);
                    break;
                }
                if (this._columnLength != 8) break;
                long l = new Long((long)(new Double(string) * 10000.0));
                this.writeLong(l);
                break;
            }
            case 225: {
                n = this.writeTdsBcpCol();
                n = (this._columnLength - n) / 2;
                for (int i = 0; i < n; ++i) {
                    this.writeShort(32);
                }
                break;
            }
            case 50: {
                if (this._bitValueArray == null || this._bitWritten) break;
                this.write(this._bitValueArray);
                this._bitWritten = true;
                break;
            }
            default: {
                this.writeTdsBcpCol();
            }
        }
    }

    private void getColumnMetaDataAll(int n) {
        int n2 = n * 14;
        this._columnId = this._tableMDAInfo[0 + n2];
        this._datatype = this._tableMDAInfo[1 + n2];
        this._usertype = this._tableMDAInfo[2 + n2];
        this._columnLength = this._tableMDAInfo[3 + n2];
        this._precision = this._tableMDAInfo[4 + n2];
        this._scale = this._tableMDAInfo[5 + n2];
        this._isColumnNullable = this._tableMDAInfo[6 + n2];
        this._identityCol = this._tableMDAInfo[7 + n2];
        if (this._userDefinedIdentity && this._identityCol == 1) {
            this._identityCol = 0;
        }
        this._sqlType = this._tableMDAInfo[8 + n2];
        this._colOffset = this._tableMDAInfo[9 + n2];
        this._truncateVarbinaryZeros = this._tableMDAInfo[10 + n2];
        this._isInRowLob = this._tableMDAInfo[11 + n2] != 0;
        this._inRowLobLen = this._tableMDAInfo[12 + n2];
        this._isVariableColumn = this._tableMDAInfo[13 + n2];
        this._columnName = this._sybBCP.getStrMDA()[0 + n * 2];
    }

    private void setParamData(int n) {
        this.getColumnMetaDataAll(n);
        this._param._cvtString = null;
        this._param._parameterAsAString = null;
        this._param._parameterHoldsUnicharData = false;
        if (this._paramDataSqlTypes[n] == -999) {
            this._param._sqlType = this._sybBCP.getTypesDefaults(n);
            this._param._inValue = this._sybBCP.getObjectDefaults(n);
            this._param._scale = this._sybBCP.getScaleDefaults(n);
        } else {
            this._param._sqlType = this._paramDataSqlTypes[n];
            this._param._inValue = this._paramDataObject[n];
            this._param._scale = this._paramDataScale[n];
        }
    }

    private void writeDOL() throws SQLException, IOException {
        int n = 0;
        while (true) {
            boolean bl = true;
            for (int i = 0; i < this._columnCount; ++i) {
                this.setParamData(i);
                if (this._isVariableColumn == 1) {
                    if (bl && this._lastVarColumn > 0) {
                        if (this._colValueArray == null) {
                            this._colValueArray = this.checkLastColumn(0);
                        }
                        bl = false;
                    }
                    this.checkValue();
                    this._varColLengthTotal += this.getVarColLengthDOL();
                }
                if (this._totalInRowColumns == 0 || this._doneWithInRowProcessing) {
                    if (this._isVariableColumn == 1) {
                        if (this._param._inValue != null) {
                            this.writeVariableColumn();
                        }
                    } else if (this._identityCol == 1 || this._param._inValue != null) {
                        this.writeFixedColumn();
                    }
                }
                if (!this._isInRowLob) continue;
                ++this._inRowLobCounter;
            }
            if (this._numberOfVariableColumns > 0) {
                this.recalculateVarColumnCount();
                this.recalculateOffsetTable();
            }
            n = 6 + (this._numberOfVariableColumns == 0 ? 0 : 2) + this._fixedColumnLengthTotal + this._varColLengthTotal + this._numberOfVariableColumns * 2;
            if (this._totalInRowColumns == 0) {
                if (this._sybBCP.isOldMdaInUse() || n <= this._maxRowLen) break;
                ErrorMessage.raiseError("JZBK7", "" + n, "" + this._maxRowLen, this._sybBCP.getTableName());
            }
            if (!this._doneWithInRowProcessing) {
                this.processInRowLobs(n);
                this._doneWithInRowProcessing = true;
                this.resetValuesDOL();
                continue;
            }
            if (this._sybBCP.isOldMdaInUse() || n <= this._maxRowLen) break;
            ErrorMessage.raiseError("JZBK7", "" + n, "" + this._maxRowLen, this._sybBCP.getTableName());
        }
        if (this._numberOfVariableColumns > 0) {
            this._fixedType = false;
            this.writeDOLOffSetTable();
            this._fixedType = true;
            this.writeShort(n);
        }
        this.writeDOLPageFormat(n);
        if (this._textimageCount > 0) {
            this.writeTextAndImage();
        }
        this._sybBCP.resetNumberVarColumns();
        this._doneWithInRowProcessing = false;
    }

    private void processInRowLobs(int n) throws SQLException {
        InRowLob inRowLob = null;
        int n2 = -1;
        while (n > this._maxRowLen) {
            for (int i = 0; i < this._inRowLobs.length; ++i) {
                InRowLob inRowLob2 = this._inRowLobs[i];
                if (!inRowLob2.mustKeepInRow) continue;
                if (inRowLob == null) {
                    inRowLob = inRowLob2;
                    continue;
                }
                if (inRowLob2.storageLength > inRowLob.storageLength) {
                    n2 = 1;
                    inRowLob = inRowLob2;
                    continue;
                }
                if (inRowLob2.storageLength != inRowLob.storageLength) continue;
                if (inRowLob2.inRowLobLen > inRowLob.inRowLobLen) {
                    n2 = 2;
                    inRowLob = inRowLob2;
                    continue;
                }
                if (inRowLob2.colId <= inRowLob.colId) continue;
                n2 = 3;
                inRowLob = inRowLob2;
            }
            if (inRowLob != null) {
                inRowLob.mustKeepInRow = false;
                n -= inRowLob.storageLength;
                n += 16;
                inRowLob = null;
                continue;
            }
            ErrorMessage.raiseError("JZBK7", "" + n, "" + this._maxRowLen, this._sybBCP.getTableName());
        }
    }

    private void recalculateVarColumnCount() {
        int n = 0;
        if (this._numberOfVariableColumns <= 1) {
            if (!this._hasValue) {
                this._numberOfVariableColumns = 0;
            }
            return;
        }
        switch (this._lastVarColumn) {
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 174: 
            case 187: 
            case 188: {
                int n2 = this._colValueArray.length;
                for (int i = n2 - 1; i >= 0 && this._colValueArray[i] <= 0; --i) {
                    ++n;
                }
                break;
            }
        }
        this._numberOfVariableColumns -= n;
    }

    private int[] checkLastColumn(int n) {
        if (this._numberOfVariableColumns <= 1) {
            return this._colValueArray;
        }
        if (this._lastVarColumn > 0) {
            n = this._lastVarColumn;
        } else {
            this._lastVarColumn = n;
        }
        switch (n) {
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 174: 
            case 187: 
            case 188: {
                this._colValueArray = new int[this._numberOfVariableColumns];
            }
        }
        return this._colValueArray;
    }

    private int getVarColLengthDOL() throws SQLException, IOException {
        int n = 0;
        if (this._param._inValue != null) {
            if (this._colValueArray == null) {
                this._colValueArray = this.checkLastColumn(this._datatype);
            }
            n = this.getVarColLength();
            this.setColumnValueArray();
        } else {
            this.incrementTypeCount();
        }
        this._totalBytesWritten += this.fillOffSetTable();
        return n;
    }

    private int fillOffSetTable() throws SQLException, IOException {
        int n = this.calculateVariableColLen();
        int n2 = this._totalBytesWritten;
        if (n2 > 8191) {
            if (!this._sybBCP.wideRowDOLSupported()) {
                ErrorMessage.raiseError("JZBK6");
            }
            n2 = n2 & 0x1FFF | (n2 & 0x6000) << 1;
        }
        if (n == 0) {
            n2 |= 0x2000;
        }
        if (this._columnId != this._columnCount || !this._lastTextColNull) {
            this.addoffset(n2, n, false);
        }
        return n;
    }

    private void setColumnValueArray() {
        if (this._numberOfVariableColumns <= 1) {
            return;
        }
        switch (this._lastVarColumn) {
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 174: 
            case 187: 
            case 188: {
                this._colValueArray[this._typeCount++] = 1;
            }
        }
    }

    private void incrementTypeCount() {
        if (this._numberOfVariableColumns <= 1) {
            return;
        }
        switch (this._lastVarColumn) {
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 123: 
            case 147: 
            case 174: 
            case 187: 
            case 188: {
                ++this._typeCount;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeAPL() throws SQLException, IOException {
        var1_1 = 0;
        while (true) lbl-1000:
        // 5 sources

        {
            for (var2_2 = 0; var2_2 < this._columnCount; ++var2_2) {
                this.setParamData(var2_2);
                if (this._isVariableColumn == 1) {
                    this.checkValue();
                    this._varColLengthTotal += this.getVarColLengthAPL();
                }
                if (this._totalInRowColumns == 0 || this._doneWithInRowProcessing) {
                    if (this._isVariableColumn == 1) {
                        if (this._param._inValue != null) {
                            this.writeVariableColumn();
                        }
                    } else if (this._identityCol == 1 || this._param._inValue != null) {
                        this.writeFixedColumn();
                    }
                }
                if (!this._isInRowLob) continue;
                ++this._inRowLobCounter;
            }
            var1_1 = 2 + this._fixedColumnLengthTotal + (this._numberOfVariableColumns == 0 ? 0 : 2 + this._varColLengthTotal + this._numberOfVariableColumns + 2);
            if (this._totalInRowColumns == 0) {
                if (this._sybBCP.isOldMdaInUse() || var1_1 <= this._maxRowLen) break;
                ErrorMessage.raiseError("JZBK7", "" + var1_1, "" + this._maxRowLen, this._sybBCP.getTableName());
            }
            if (!this._doneWithInRowProcessing) {
                this.processInRowLobs(var1_1);
                this._doneWithInRowProcessing = true;
                this.resetValuesAPL();
                ** continue;
            }
            if (this._sybBCP.isOldMdaInUse() || var1_1 <= this._maxRowLen) break;
            ErrorMessage.raiseError("JZBK7", "" + var1_1, "" + this._maxRowLen, this._sybBCP.getTableName());
        }
        if (this._numberOfVariableColumns > 0) {
            ++this._valColCounter;
            this.calculateAdjustLengthAPL(true);
            this._fixedType = false;
            this.writeAPLOffSetTable();
            this._fixedType = true;
            this.writeShort(var1_1 += this.getAdjustTableLength());
        }
        this.writeAPLPageFormat(var1_1);
        if (this._textimageCount > 0) {
            this.writeTextAndImage();
        }
        this._doneWithInRowProcessing = false;
    }

    private void writeVariableColumn() throws SQLException, IOException {
        this._fixedType = false;
        switch (this._datatype) {
            case 34: 
            case 35: 
            case 174: {
                if (!(this._param._inValue == null || this._isInRowLob && this._inRowLobs[this._inRowLobCounter].mustKeepInRow)) {
                    this.writeLong(0L);
                    this.writeLong(0L);
                    break;
                }
            }
            case 38: 
            case 68: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 123: 
            case 147: 
            case 187: 
            case 188: {
                this.convertDataToColumnType();
            }
            default: {
                this.writeTdsBcpCol();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeTextAndImage() throws SQLException, IOException {
        var1_1 = 0;
        var2_2 = null;
        var3_3 = 0;
        block5: for (var4_4 = 0; var4_4 < this._columnCount && var1_1 != this._textimageCount; ++var4_4) {
            this.setParamData(var4_4);
            if (this._param._inValue == null) continue;
            switch (this._datatype) {
                case 34: 
                case 35: 
                case 174: {
                    this._tdsOut.writeShort(0);
                    this._tdsOut.writeByte(this._datatype);
                    if (this._isInRowLob && this._inRowLobs[var3_3].mustKeepInRow) ** GOTO lbl42
                    if (!(this._param._inValue instanceof String)) ** GOTO lbl15
                    var2_2 = this._datatype == 174 ? this._param.stringToUnicodeBytes(this._param._inValue.toString()) : this.toBytes(this._param._inValue.toString());
                    ** GOTO lbl35
lbl15:
                    // 1 sources

                    if (!(this._param._inValue instanceof byte[])) ** GOTO lbl18
                    var2_2 = (byte[])this._param._inValue;
                    ** GOTO lbl35
lbl18:
                    // 1 sources

                    if (!(this._param._inValue instanceof InputStream)) ** GOTO lbl33
                    var5_5 = (InputStream)this._param._inValue;
                    var6_6 = 0;
                    var2_2 = new byte[var6_6];
                    for (var6_6 = this._param._scale == -1 ? var5_5.available() : this._param._scale; var6_6 > 0; var6_6 -= var7_7) {
                        var7_7 = 0;
                        try {
                            var7_7 = var5_5.read(var2_2);
                        }
                        catch (IOException var8_8) {
                            throw (IOException)new TdsInputStreamIOException(var8_8.toString()).initCause(var8_8);
                        }
                        if (var7_7 >= 0) {
                            continue;
                        }
                        ** GOTO lbl35
                    }
                    ** GOTO lbl35
lbl33:
                    // 1 sources

                    if (this._param._inValue instanceof Reader) {
                        var2_2 = (byte[])this._valueFromReader.get(this._columnName);
                    }
lbl35:
                    // 7 sources

                    if (var2_2.length == 0) {
                        var2_2 = new byte[]{32};
                    }
                    if (this._colOffset == -999) {
                        this._tdsOut.writeByte(256 - (var4_4 + 1));
                    } else {
                        this._tdsOut.writeByte(this._colOffset);
                    }
                    ** GOTO lbl44
lbl42:
                    // 1 sources

                    this._tdsOut.writeByte(0);
                    ++var3_3;
lbl44:
                    // 3 sources

                    this._tdsOut.writeShort(this._offsetTextImage[var1_1++]);
                    if (var2_2 != null) {
                        this._tdsOut.writeInt(var2_2.length);
                        this._tdsOut.write(var2_2);
                        var2_2 = null;
                        continue block5;
                    }
                    this._tdsOut.writeInt(0);
                }
            }
        }
    }

    private int calculateAdjustLengthAPL(boolean bl) throws SQLException, IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (!bl) {
            if (this._param._inValue != null) {
                n = this.calculateVariableColLen();
            }
            if ((n2 = this._totalBytesWritten / 256) > 0) {
                if (n > 0) {
                    n3 = this._totalBytesWritten;
                }
                this.addoffset(this._totalBytesWritten % 256, n3, true);
                n3 = 0;
                if (n2 != this._iprev) {
                    int n4 = n2 - this._iprev;
                    this._iprev = n2;
                    do {
                        this.addVariableColumnCounter();
                    } while (--n4 > 0);
                }
            } else {
                if (n > 0) {
                    n3 = this._totalBytesWritten;
                }
                this.addoffset(this._totalBytesWritten, n3, false);
                n3 = 0;
            }
        } else {
            n2 = this._totalBytesWritten / 256;
            if (n2 > 0) {
                this.addoffset(this._totalBytesWritten % 256);
                if (n2 != this._iprev) {
                    int n5 = n2 - this._iprev;
                    this._iprev = n2;
                    do {
                        this.addVariableColumnCounter();
                    } while (--n5 > 0);
                }
            } else {
                this.addoffset(this._totalBytesWritten);
            }
            this._iprev = 0;
        }
        return n;
    }

    private int calculateVariableColLen() throws SQLException, IOException {
        if (this._param._inValue == null) {
            return 0;
        }
        int n = this._dataInfo[1];
        switch (this._datatype) {
            case 111: 
            case 123: 
            case 147: 
            case 187: 
            case 188: {
                this._param._sqlType = this._sqlType;
            }
            case 38: 
            case 68: 
            case 108: 
            case 109: 
            case 110: {
                n = this._columnLength;
                break;
            }
            case 34: 
            case 35: 
            case 174: {
                if (this._isInRowLob) {
                    InRowLob inRowLob = this._inRowLobs[this._inRowLobCounter];
                    if (inRowLob.mustKeepInRow) {
                        n = inRowLob.storageLength;
                        break;
                    }
                    n = this._columnLength;
                    break;
                }
                n = this._columnLength;
                break;
            }
            case 106: {
                this._param._scale = this._scale;
                this._dataInfo[2] = this._param._precision = this._precision;
                n = this._columnLength;
            }
        }
        return n;
    }

    private int getVarColLengthAPL() throws SQLException, IOException {
        int n = 0;
        ++this._valColCounter;
        if (this._param._inValue != null) {
            n = this.getVarColLength();
        }
        this._totalBytesWritten += this.calculateAdjustLengthAPL(false);
        return n;
    }

    private int getVarColLength() throws SQLException, IOException {
        int n = 0;
        int n2 = this._dataInfo[1];
        switch (this._datatype) {
            case 39: {
                n = n2;
                if (this._lockScheme != 1) break;
                this._hasValue = true;
                break;
            }
            case 37: 
            case 225: {
                n = n2;
                if (this._datatype == 225) {
                    n = n2 * 2;
                }
                if (this._lockScheme != 1 || this._hasValue) break;
                this._hasValue = true;
                break;
            }
            case 34: 
            case 35: 
            case 174: {
                ++this._textimageCount;
                if (this._isInRowLob) {
                    n2 = this._dataInfo[1];
                    if (!this._doneWithInRowProcessing) {
                        InRowLob inRowLob = new InRowLob();
                        inRowLob.colId = this._columnId;
                        inRowLob.columnName = this._columnName;
                        inRowLob.inRowLobLen = this._inRowLobLen;
                        inRowLob.storageLength = n2 + 20;
                        if (n2 > this._inRowLobLen) {
                            inRowLob.mustKeepInRow = false;
                            n = this._columnLength;
                        } else {
                            n = inRowLob.storageLength;
                        }
                        this._inRowLobs[this._inRowLobCounter] = inRowLob;
                        if (this._lockScheme != 1 || this._hasValue) break;
                        this._hasValue = true;
                        break;
                    }
                    if (this._inRowLobs[this._inRowLobCounter].mustKeepInRow) {
                        n = 20 + n2;
                        if (this._lockScheme != 1 || this._hasValue) break;
                        this._hasValue = true;
                        break;
                    }
                }
            }
            default: {
                n = this._columnLength;
                if (this._lockScheme != 1 || this._hasValue) break;
                this._hasValue = true;
            }
        }
        return n;
    }

    public void writeAPLPageFormat(int n) throws SQLException, IOException {
        int n2 = this._fixedDataPos;
        this._fixedDataPos = 0;
        this.writeShort(n);
        this.writeByte(this._numberOfVariableColumns);
        this.writeByte(0);
        this._tdsOut.write(this._fixedDataBuffer, 0, n2);
        if (this._numberOfVariableColumns > 0) {
            this._tdsOut.write(this._variableDataBuffer, 0, this._variableDataPos);
        }
    }

    public void writeDOLPageFormat(int n) throws SQLException, IOException {
        this._fixedType = true;
        int n2 = this._fixedDataPos;
        this._fixedDataPos = 0;
        this.writeShort(n);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this._numberOfVariableColumns);
        this._tdsOut.write(this._fixedDataBuffer, 0, n2);
        if (this._numberOfVariableColumns > 0) {
            this._tdsOut.write(this._variableDataBuffer, 0, this._variableDataPos);
        }
    }

    private void initializeAPL(int n, int n2) {
        this._offsetptr = n + 1;
        this._offsetTable = new int[this._offsetptr];
        this._adjustmentTable = new int[n2];
        if (!this._doneWithInRowProcessing && this._sybBCP.getTextImageCount() > 0) {
            this._offsetTextImage = new int[this._sybBCP.getTextImageCount()];
            this._inRowLobs = new InRowLob[this._sybBCP.getInRowLobCount()];
        }
    }

    private void initializeDOL(int n) {
        this._offsetTable = new int[n];
        if (!this._doneWithInRowProcessing && this._sybBCP.getTextImageCount() > 0) {
            this._offsetTextImage = new int[this._sybBCP.getTextImageCount()];
            this._inRowLobs = new InRowLob[this._sybBCP.getInRowLobCount()];
        }
    }

    private void addoffset(int n) {
        this._offsetTable[--this._offsetptr] = n;
    }

    private void addoffset(int n, int n2, boolean bl) {
        if ((this._datatype == 35 || this._datatype == 34 || this._datatype == 174) && n2 > 0) {
            this._offsetTextImage[this._textptr] = bl ? n2 : (n > 8191 ? this._totalBytesWritten : n);
            ++this._textptr;
        }
        if (this._offsetTable.length == 0) {
            return;
        }
        this.addoffset(n);
    }

    private void addVariableColumnCounter() {
        this._adjustmentTable[this._adjustptr] = this._valColCounter;
        ++this._adjustptr;
    }

    private void writeAPLOffSetTable() throws IOException {
        int n = this._offsetTable.length;
        if (n > 0) {
            this.writeByte((byte)n);
            if (this._adjustmentTable.length > 0) {
                this.writeAdjustTable();
            }
            for (int i = 0; i < n; ++i) {
                this.writeByte(this._offsetTable[i]);
            }
        }
    }

    private void writeDOLOffSetTable() throws IOException {
        int n = this._offsetTable.length;
        for (int i = 0; i < n; ++i) {
            this.writeShort(this._offsetTable[i]);
        }
    }

    private void writeAdjustTable() throws IOException {
        int n = this.getAdjustTableLength();
        for (int i = n - 1; i >= 0; --i) {
            this.writeByte((byte)this._adjustmentTable[i]);
        }
    }

    private void recalculateOffsetTable() throws IOException {
        int n = this._sybBCP.getNumberVarColumns();
        if (n == this._numberOfVariableColumns || this._numberOfVariableColumns == 0) {
            return;
        }
        int[] nArray = new int[this._numberOfVariableColumns];
        System.arraycopy(this._offsetTable, n - this._numberOfVariableColumns, nArray, 0, this._numberOfVariableColumns);
        this._offsetTable = nArray;
    }

    private int getAdjustTableLength() throws IOException {
        int n = 0;
        if (this._adjustmentTable[0] == 0) {
            return n;
        }
        int n2 = this._adjustmentTable.length;
        for (int i = 0; i < n2 && this._adjustmentTable[i] != 0; ++i) {
            ++n;
        }
        return n;
    }

    private void convertDataToColumnType() throws SQLException, IOException {
        if (this._sqlType == this._param._sqlType && this._sqlType != 91 && this._sqlType != 92 && this._sqlType != 93) {
            return;
        }
        Object object = this._param._inValue;
        this._param._sqlType = this._sqlType;
        switch (this._datatype) {
            case 50: {
                object = Convert.objectToBoolean(object);
                this._param._sqlType = -7;
                break;
            }
            case 48: 
            case 52: 
            case 56: {
                object = Convert.objectToInt(object);
                break;
            }
            case 65: {
                object = Convert.objectToUSmallInt(object);
                this._param._sqlType = 5;
                break;
            }
            case 66: {
                object = Convert.objectToUInt(object);
                this._param._sqlType = 4;
                break;
            }
            case 191: {
                object = Convert.objectToLong(object);
                break;
            }
            case 68: {
                switch (this._columnLength) {
                    case 2: {
                        object = Convert.objectToUSmallInt(object);
                        this._param._sqlType = 5;
                        break;
                    }
                    case 4: {
                        object = Convert.objectToUInt(object);
                        this._param._sqlType = 4;
                        break;
                    }
                    case 8: {
                        object = Convert.objectToUBigInt(object);
                        this._param._sqlType = 2;
                    }
                }
                break;
            }
            case 38: {
                switch (this._columnLength) {
                    case 2: 
                    case 4: {
                        object = Convert.objectToInt(object);
                        break;
                    }
                    case 8: {
                        object = Convert.objectToLong(object);
                    }
                }
                break;
            }
            case 59: {
                object = Convert.objectToFloat(object);
                break;
            }
            case 62: {
                object = Convert.objectToDouble(object);
                break;
            }
            case 109: {
                switch (this._columnLength) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        object = Convert.objectToFloat(object);
                        break;
                    }
                    case 8: {
                        object = Convert.objectToDouble(object);
                    }
                }
                break;
            }
            case 39: 
            case 47: 
            case 175: {
                if (this._usertype == 34 || this._usertype == 35 || object instanceof String) break;
                object = Convert.objectToString(object);
                break;
            }
            case 37: {
                break;
            }
            case 67: {
                object = Convert.objectToUBigInt(object);
                this._param._sqlType = 2;
                break;
            }
            case 55: 
            case 60: 
            case 63: 
            case 106: 
            case 108: 
            case 110: 
            case 122: {
                if (object instanceof Number) {
                    object = new BigDecimal(object.toString());
                    break;
                }
                object = Convert.objectToBigDecimal(object);
                break;
            }
            case 45: {
                object = Convert.objectToBytes(object);
                break;
            }
            case 225: {
                if (this._param._cvtString == null) {
                    this._param._parameterAsAString = (String)object;
                }
                this._param._cvtString = this._param.stringToUnicodeBytes(this._param._parameterAsAString);
                object = this._param._cvtString;
                this._param._parameterHoldsUnicharData = true;
                break;
            }
            case 35: 
            case 174: {
                break;
            }
            case 34: {
                byte[] byArray = null;
                if (this._param._inValue instanceof InputStream) {
                    InputStream inputStream = (InputStream)this._param._inValue;
                    try {
                        byArray = new byte[inputStream.available()];
                        inputStream.read(byArray);
                    }
                    catch (IOException iOException) {}
                } else if (this._param._inValue instanceof String) {
                    byArray = this.toBytes(this._param._inValue.toString());
                } else if (this._param._inValue instanceof byte[]) {
                    byArray = (byte[])this._param._inValue;
                }
                object = byArray;
                break;
            }
            case 49: 
            case 51: 
            case 58: 
            case 61: 
            case 111: 
            case 123: 
            case 147: 
            case 187: 
            case 188: {
                if (object instanceof DateObject) break;
                DateObject dateObject = new DateObject(object, this._userCal, this._param._sqlType, true);
                object = dateObject;
            }
        }
        this._param._inValue = object;
    }

    private int writeTdsBcpCol() throws IOException, SQLException {
        int n = this._columnLength;
        switch (this._datatype) {
            case 55: 
            case 63: 
            case 106: 
            case 108: {
                this._dataInfo[0] = 108;
                this._dataInfo[2] = this._param._precision = this._precision;
                this._dataInfo[3] = this._param._scale = this._scale;
                this._dataInfo[1] = n;
                this.write(TdsNumeric.tdsNumeric((BigDecimal)this._param._inValue, this._param._scale, this._dataInfo, true));
                this._dataInfo[2] = this._param._precision = this._precision;
                return n;
            }
            case 47: {
                this._datatype = this._dataInfo[0];
                if (this._dataInfo[1] > n) {
                    this._dataInfo[1] = n;
                }
            }
            case 39: {
                if (this._param._parameterHoldsUnicharData) {
                    this._datatype = 225;
                }
                this.writeParam();
                return this._dataInfo[1];
            }
            case 48: 
            case 52: 
            case 56: 
            case 191: {
                this._datatype = 38;
            }
            case 38: {
                this.writeParam();
                return n;
            }
            case 50: {
                this.dataTypeInfo();
                this.writeParam();
                return n;
            }
            case 45: {
                this._datatype = this._dataInfo[0];
                if (this._dataInfo[1] > n) {
                    this._dataInfo[1] = n;
                }
            }
            case 37: {
                this.writeParam();
                return this._dataInfo[1];
            }
            case 34: 
            case 35: 
            case 174: {
                this.writeParam();
                return this._dataInfo[1];
            }
        }
        this.dataTypeInfo();
        switch (this._datatype) {
            case 59: 
            case 62: {
                this._dataInfo[1] = n;
                break;
            }
            case 67: 
            case 68: {
                if (n != 8) break;
                this._dataInfo[2] = this._param._precision = this._precision;
                this._dataInfo[3] = this._param._scale = this._scale;
                this._dataInfo[1] = n;
                this._datatype = this._dataInfo[0];
                break;
            }
            case 49: 
            case 51: 
            case 58: 
            case 61: 
            case 111: 
            case 123: 
            case 147: 
            case 187: 
            case 188: {
                this._dataInfo[1] = n;
                if (!(this._param._inValue instanceof DateObject)) {
                    this._param._inValue = new DateObject(this._param._inValue, this._userCal, this._param._sqlType, true);
                }
                if (this._datatype != 187 && this._datatype != 188) {
                    this._dataInfo[0] = 111;
                    this._dataInfo[3] = 0;
                    if (this._datatype == 147 || this._datatype == 51) {
                        this._dataInfo[0] = 147;
                    } else if (this._datatype == 123 || this._datatype == 49) {
                        this._dataInfo[0] = 123;
                    }
                }
                this._datatype = this._dataInfo[0];
            }
        }
        this.writeParam();
        return n;
    }

    private void writeParam() throws IOException, SQLException {
        block1 : switch (this._datatype) {
            case 50: {
                this.writeByte((Boolean)this._param._inValue != false ? 1 : 0);
                break;
            }
            case 38: {
                switch (this._columnLength) {
                    case 0: {
                        break block1;
                    }
                    case 1: {
                        this.writeByte((Integer)this._param._inValue);
                        break block1;
                    }
                    case 2: {
                        this.writeShort((Integer)this._param._inValue);
                        break block1;
                    }
                    case 4: {
                        this.writeInt((Integer)this._param._inValue);
                        break block1;
                    }
                    case 8: {
                        this.writeLong((Long)this._param._inValue);
                        break block1;
                    }
                }
                break;
            }
            case 109: {
                switch (this._columnLength) {
                    case 0: {
                        break block1;
                    }
                    case 4: {
                        this.writeFloat(((Float)this._param._inValue).floatValue());
                        break block1;
                    }
                    case 8: {
                        this.writeDouble((Double)this._param._inValue);
                        break block1;
                    }
                }
                break;
            }
            case 110: {
                Double d = Convert.objectToDouble(this._param._inValue);
                if (this._columnLength == 4) {
                    this.writeInt((int)(d * 10000.0));
                    break;
                }
                if (this._columnLength != 8) break;
                this.writeLong((long)(d * 10000.0));
                break;
            }
            case 35: 
            case 174: {
                this.writeLong(0L);
                this.writeLong(0L);
                this.writeInt(0);
            }
            case 39: 
            case 47: 
            case 175: {
                int n = this._dataInfo[1];
                if (n <= 0) break;
                this.write(this._param._cvtString, 0, n);
                break;
            }
            case 37: 
            case 45: {
                int n = this._dataInfo[1];
                if (n <= 0) break;
                this.write((byte[])this._param._inValue, 0, n);
                break;
            }
            case 34: {
                this.writeLong(0L);
                this.writeLong(0L);
                this.writeInt(0);
            }
            case 225: {
                int n;
                int n2;
                if (this._param._inValue instanceof byte[]) {
                    this.write((byte[])this._param._inValue, 0, n2);
                    break;
                }
                if (!(this._param._inValue instanceof InputStream)) break;
                InputStream inputStream = (InputStream)this._param._inValue;
                int n3 = n2 < 2048 ? n2 : 2048;
                byte[] byArray = new byte[n3];
                for (n2 = this._dataInfo[1]; n2 > 0; n2 -= n) {
                    n = 0;
                    try {
                        n = inputStream.read(byArray, 0, n2 > n3 ? n3 : n2);
                    }
                    catch (IOException iOException) {
                        throw new TdsInputStreamIOException(iOException.toString());
                    }
                    if (n < 0) break block1;
                    this.write(byArray, 0, n);
                }
                break;
            }
            case 108: {
                int n = this._dataInfo[1];
                byte[] byArray = TdsNumeric.tdsNumeric((BigDecimal)this._param._inValue, this._param._scale, this._dataInfo, false);
                if (n <= 0) break;
                this.write(byArray);
                break;
            }
            case 111: {
                int n = this._dataInfo[1];
                if (n <= 0) break;
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)this._param._inValue);
                if (n == 4) {
                    nArray[1] = nArray[2];
                    this.writeShort(nArray[0]);
                    this.writeShort(nArray[1]);
                    break;
                }
                this.writeInt(nArray[0]);
                this.writeInt(nArray[1]);
                break;
            }
            case 187: 
            case 188: {
                int n = this._dataInfo[1];
                if (n <= 0) break;
                long l = TdsDateTime.tdsDateTime((DateObject)this._param._inValue, this._dataInfo[0]);
                this.writeLong(l);
                break;
            }
            case 123: {
                int n = this._dataInfo[1];
                if (n <= 0) break;
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)this._param._inValue);
                this.writeInt(nArray[0]);
                break;
            }
            case 147: {
                int n = this._dataInfo[1];
                if (n <= 0) break;
                int[] nArray = TdsDateTime.tdsDateTime((DateObject)this._param._inValue);
                this.writeInt(nArray[1]);
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkValue() throws SQLException, IOException {
        if (this._param._inValue == null) {
            return;
        }
        var1_1 = 0;
        var2_2 = null;
        switch (this._datatype) {
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 174: 
            case 225: {
                this.dataTypeInfo();
                if (!(this._param._inValue instanceof String)) ** GOTO lbl33
                if (this._usertype == 34 || this._usertype == 35) {
                    this._param._cvtString = this._param.stringToUnicodeBytes(this._param._inValue.toString());
                    this._param._inValue = this._param._cvtString;
                    this._param._sqlType = -4;
                    this._param._parameterHoldsUnicharData = true;
                    var2_2 = (byte[])this._param._inValue;
                    if (var2_2.length == 0) {
                        var2_2 = new byte[]{0, 32};
                        this._param._inValue = var2_2;
                    }
                    this._dataInfo[1] = var1_1 = var2_2.length;
                    if (var1_1 > this._columnLength) {
                        this._dataInfo[1] = this._columnLength;
                    }
                    this._dataInfo[0] = this._datatype;
                } else {
                    this._dataInfo[1] = this._param._cvtString.length;
                    if (this._datatype != 35 && this._datatype != 34 && this._datatype != 174 && this._dataInfo[1] > this._columnLength) {
                        this._dataInfo[1] = this._columnLength;
                    } else if (this._dataInfo[1] == 0) {
                        var2_2 = new byte[]{32};
                        this._param._inValue = var2_2;
                        this._param._cvtString = var2_2;
                        this._dataInfo[1] = var2_2.length;
                    }
                    return;
lbl33:
                    // 1 sources

                    if (this._param._inValue instanceof byte[]) {
                        this._param._cvtString = (byte[])this._param._inValue;
                        var2_2 = this._param._cvtString;
                        this._dataInfo[0] = this._datatype;
                        this._dataInfo[1] = var2_2.length;
                    } else if (this._param._inValue instanceof InputStream) {
                        var3_3 = (InputStream)this._param._inValue;
                        var1_1 = this._param._scale == -1 ? var3_3.available() : this._param._scale;
                        this._dataInfo[1] = var1_1;
                        var2_2 = new byte[var1_1];
                    } else if (this._param._inValue instanceof Reader) {
                        var2_2 = new byte[this._param._cvtString.length];
                        this._dataInfo[1] = var2_2.length;
                    }
                }
                if (var2_2 != null && var2_2.length != 0) break;
                this._param._inValue = null;
            }
        }
        if (this._truncateVarbinaryZeros == 1) {
            this.truncateTrailingVarbinaryZeros();
        }
    }

    private void truncateTrailingVarbinaryZeros() throws IOException {
        if (this._datatype == 37 || this._datatype == 45 && this._isColumnNullable == 1) {
            byte[] byArray = null;
            if (this._param._inValue instanceof byte[]) {
                byArray = (byte[])this._param._inValue;
            } else if (this._param._inValue instanceof InputStream) {
                InputStream inputStream = (InputStream)this._param._inValue;
                byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                this._param._inValue = byArray;
            }
            int n = -1;
            if (byArray != null) {
                n = byArray.length - 1;
            }
            while (n >= 0 && byArray[n] == 0) {
                --n;
            }
            if (this._datatype != 37 && this._usertype != 80) {
                this._dataInfo[1] = n + 1;
            }
        }
    }

    private final void writeShort(int n) throws IOException {
        this.writeByte((byte)(n >>> 8 & 0xFF));
        this.writeByte((byte)(n >>> 0 & 0xFF));
    }

    private final void writeInt(int n) throws IOException {
        this.writeByte((byte)(n >>> 24 & 0xFF));
        this.writeByte((byte)(n >>> 16 & 0xFF));
        this.writeByte((byte)(n >>> 8 & 0xFF));
        this.writeByte((byte)(n >>> 0 & 0xFF));
    }

    private final void writeByte(byte by) throws IOException {
        if (this._fixedType) {
            this._fixedDataBuffer[this._fixedDataPos++] = by;
        } else {
            this._variableDataBuffer[this._variableDataPos++] = by;
        }
    }

    private final void writeByte(int n) throws IOException {
        this.writeByte((byte)n);
    }

    private final void writeLong(long l) throws IOException {
        this.writeByte((byte)((int)(l >>> 56) & 0xFF));
        this.writeByte((byte)((int)(l >>> 48) & 0xFF));
        this.writeByte((byte)((int)(l >>> 40) & 0xFF));
        this.writeByte((byte)((int)(l >>> 32) & 0xFF));
        this.writeByte((byte)((int)(l >>> 24) & 0xFF));
        this.writeByte((byte)((int)(l >>> 16) & 0xFF));
        this.writeByte((byte)((int)(l >>> 8) & 0xFF));
        this.writeByte((byte)((int)(l >>> 0) & 0xFF));
    }

    private final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    private final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    private final void write(byte[] byArray, int n, int n2) {
        if (this._fixedType) {
            System.arraycopy(byArray, 0, this._fixedDataBuffer, this._fixedDataPos, n2);
            this._fixedDataPos += n2;
        } else {
            System.arraycopy(byArray, 0, this._variableDataBuffer, this._variableDataPos, n2);
            this._variableDataPos += n2;
        }
    }

    private final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    private void dataTypeInfo() throws IOException {
        switch (this._param._sqlType) {
            case -7: {
                this._datatype = 50;
                break;
            }
            case -6: {
                this._datatype = 38;
                break;
            }
            case 5: {
                this._datatype = 38;
                break;
            }
            case 4: {
                this._datatype = 38;
                break;
            }
            case -5: {
                this._datatype = 38;
                break;
            }
            case 7: {
                this._datatype = 109;
                break;
            }
            case 6: 
            case 8: {
                this._datatype = 109;
                break;
            }
            case 2: 
            case 3: {
                this._dataInfo[0] = 108;
                if (this._param._regType == -999 || this._param._inValue instanceof SybBigDecimal) break;
                this._dataInfo[2] = 38;
                break;
            }
            case 9219: 
            case 9220: 
            case 9221: {
                this._dataInfo[0] = this._param._sqlType;
                this._dataInfo[1] = this._param._scale;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this._dataInfo[0] = this._param._sqlType == -1 ? 175 : 39;
                this.convertString();
                if (!this._param._parameterHoldsUnicharData) break;
                this._dataInfo[0] = 225;
                break;
            }
            case 91: {
                if (this._serverAcceptsDateData) {
                    this._dataInfo[0] = 123;
                    this._dataInfo[1] = 4;
                    break;
                }
                this._dataInfo[0] = 111;
                this._dataInfo[1] = 8;
                break;
            }
            case 92: {
                if (this._serverAcceptsBigDateTimeData) {
                    this._dataInfo[0] = 187;
                    this._dataInfo[1] = 8;
                    this._dataInfo[3] = 6;
                    if (!this._capTimeOn) break;
                    this._dataInfo[0] = 188;
                    break;
                }
                if (this._serverAcceptsBigDateTimeData && this._capTimeOn) {
                    this._dataInfo[0] = 147;
                    this._dataInfo[1] = 4;
                    break;
                }
                this._dataInfo[0] = 111;
                this._dataInfo[1] = 8;
                break;
            }
            case 93: {
                this._dataInfo[0] = 111;
                if (this._serverAcceptsBigDateTimeData) {
                    this._dataInfo[0] = 187;
                }
                this._dataInfo[1] = 8;
                break;
            }
            case -3: 
            case -2: {
                this._dataInfo[0] = 37;
                if (this._param._inValue == null) break;
                this._dataInfo[1] = ((byte[])this._param._inValue).length;
                break;
            }
            case -4: {
                this._dataInfo[0] = 225;
                if (this._param._inValue == null) break;
                if (this._param._inValue instanceof byte[]) {
                    this._dataInfo[1] = ((byte[])this._param._inValue).length;
                    break;
                }
                if (!(this._param._inValue instanceof InputStream)) break;
                if (this._param._scale == -1) {
                    InputStream inputStream = (InputStream)this._param._inValue;
                    this._dataInfo[1] = inputStream.available();
                    break;
                }
                this._dataInfo[1] = this._param._scale;
                break;
            }
            case 2000: {
                this._dataInfo[0] = 9217;
                this._dataInfo[1] = -1;
                break;
            }
            default: {
                ErrorMessage.raiseIOException("JZ0SL", "" + this._param._sqlType);
            }
        }
        if (this._param._inValue == null) {
            this._dataInfo[1] = 0;
        }
    }

    private void convertString() throws IOException {
        if (this._param._inValue instanceof String) {
            String string;
            this._param._parameterAsAString = string = (String)this._param._inValue;
            this.check0LNNString();
            if (this._tdsOut._tds.isUnicharEnabled()) {
                if (this._usertype == 34 || this._usertype == 35 || this._usertype == 36) {
                    this.setUnicharParameter(this._param);
                } else {
                    this._param._cvtString = this.stringToByte(string);
                }
            } else {
                this._param._cvtString = this.stringToByte(string);
            }
            this._dataInfo[1] = this._param._cvtString.length;
        } else if (this._param._inValue instanceof InputStream) {
            if (this._param._cvtString == null) {
                String string = null;
                this._param._parameterAsAString = string = this._param.getStringFromStream(0);
                this.check0LNNString();
                if (this._usertype == 34 || this._usertype == 35 || this._usertype == 36) {
                    this.setUnicharParameter(this._param);
                } else {
                    this._param._cvtString = this.stringToByte(string);
                }
            }
            this._dataInfo[1] = this._param._cvtString.length;
        } else if (this._param._inValue instanceof Reader) {
            Reader reader = (Reader)this._param._inValue;
            if (this._param._cvtString == null) {
                char[] cArray = new char[2048];
                StringBuffer stringBuffer = new StringBuffer(2048);
                int n = 0;
                while (true) {
                    int n2;
                    int n3 = 2048;
                    if (this._param._scale >= 0 && this._param._scale < 2048) {
                        n3 = this._param._scale - n;
                    }
                    if (n3 <= 0 || (n2 = reader.read(cArray, 0, n3)) <= 0) break;
                    stringBuffer.append(cArray, 0, n2);
                    n += n2;
                }
                this._param._parameterAsAString = stringBuffer.toString();
                this.check0LNNString();
                if (this._usertype == 34 || this._usertype == 35 || this._usertype == 36) {
                    this.setUnicharParameter(this._param);
                } else {
                    this._param._cvtString = this.stringToByte(stringBuffer.toString());
                }
                this._valueFromReader.put(this._columnName, this._param._cvtString);
            }
            this._dataInfo[1] = this._param._cvtString.length;
        } else {
            if (this._param._cvtString == null) {
                this._param._parameterAsAString = this._param._inValue.toString();
                this.check0LNNString();
                if (this._usertype == 34 || this._usertype == 35 || this._usertype == 36) {
                    this.setUnicharParameter(this._param);
                } else {
                    this._param._cvtString = this.stringToByte(this._param._inValue.toString());
                }
            }
            this._dataInfo[1] = this._param._cvtString.length;
        }
    }

    protected void check0LNNString() {
        if (this._param._parameterAsAString.length() == 0 && !this._serverAcceptsColumnStatusByte) {
            this._param._inValue = " ";
            this._param._parameterAsAString = " ";
        }
    }

    protected byte[] toBytes(String string) throws CharConversionException {
        if (string == null) {
            return null;
        }
        return this._tdsOut._tds._charsetConverter.fromUnicode(string);
    }

    private byte[] stringToByte(String string) throws IOException {
        try {
            return this.toBytes(string);
        }
        catch (CharConversionException charConversionException) {
            ErrorMessage.raiseIOException("JZ0I6", charConversionException.toString(), charConversionException);
            Debug.asrt(null, false);
            return null;
        }
    }

    private void setUnicharParameter(TdsParam tdsParam) throws IOException {
        tdsParam._cvtString = tdsParam.stringToUnicodeBytes(tdsParam._parameterAsAString);
        tdsParam._inValue = tdsParam._cvtString;
        tdsParam._sqlType = -4;
        tdsParam._parameterHoldsUnicharData = true;
    }

    private void calcuateBitColumnCount() {
        int n;
        int[] nArray = new int[1024];
        for (n = 0; n < this._columnCount; ++n) {
            this.getColumnMetaDataAll(n);
            if (this._datatype != 50) continue;
            nArray[this._bitColumnCount++] = n;
        }
        n = (int)Math.ceil((double)this._bitColumnCount / 8.0);
        this._bitValueArray = new byte[n];
        this._bitColumnNumber = new int[this._bitColumnCount];
        System.arraycopy(nArray, 0, this._bitColumnNumber, 0, this._bitColumnCount);
        this._fixedColumnLengthTotal = this._fixedColumnLengthTotal - this._bitColumnCount + n;
    }

    private void calculateBitValue() throws SQLException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this._bitColumnNumber.length; ++i) {
            this.setParamData(this._bitColumnNumber[i]);
            ++n;
            if (this._param._inValue != null && Convert.objectToBoolean(this._param._inValue).booleanValue()) {
                n2 = 1 << (n - 1) % 8 | n2;
            }
            if (n % 8 != 0 && n != this._bitColumnCount) continue;
            this._bitValueArray[n3++] = (byte)n2;
            n2 = 0;
        }
    }

    private class InRowLob {
        protected int colId;
        protected boolean mustKeepInRow = true;
        protected int storageLength;
        protected int inRowLobLen;
        protected String columnName;

        private InRowLob() {
        }
    }
}

