/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.Cursor;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.Escape;
import com.sybase.jdbc4.jdbc.EscapeTokenizer;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.ResultGetter;
import com.sybase.jdbc4.jdbc.SybBatchUpdateException;
import com.sybase.jdbc4.jdbc.SybConnection;
import com.sybase.jdbc4.jdbc.SybCursorResultSet;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybPooledConnection;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybScrollCursorResultSet;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.utils.CacheManager;
import com.sybase.jdbc4.utils.LogUtil;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybStatement
implements com.sybase.jdbcx.SybStatement {
    private static Logger LOG = Logger.getLogger(SybStatement.class.getName());
    private static volatile long _logIdCounter = 0L;
    protected String _logId = null;
    private SQLWarning _warning = null;
    protected int _rsType = 1003;
    protected int _rsConcur = -9;
    private int _rsHold;
    protected int _rsFetchDir = 1000;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _statementManager;
    protected boolean _doEscapes = true;
    protected String _rpcName = null;
    protected boolean _sendAsRpc = false;
    protected boolean _hasReturn = false;
    protected boolean _allowsOutputParms = false;
    protected boolean _returnHasBeenRegistered = false;
    protected boolean _closing = false;
    protected SybResultSet _currentRS = null;
    protected ResultGetter _resultGetter;
    protected Cursor _cursor = null;
    protected IConstants.CONNECTION_STATE _state = IConstants.CONNECTION_STATE.IDLE;
    private int _rowcount = -1;
    private boolean _validRowcount = false;
    private int _currentResult;
    protected static final int NORESULTS = 1;
    protected static final int ONERESULT = 2;
    protected static final int MANYRESULTS = 3;
    protected static final String CALL_DELIMS = "(), \t\n\r";
    protected static final int OTHER = 0;
    protected static final int CALL = 1;
    protected static final int SELECT = 2;
    protected static final int DELETE = 4;
    protected static final int UPDATE = 8;
    protected static final int INSERT = 16;
    protected static final int VALID = 4096;
    protected int _type;
    protected int _setStart;
    protected int _setEnd;
    protected String _table;
    protected Vector _batchCmds = null;
    protected int _batchCmdsCount = 0;
    protected boolean _doneinproc = false;
    protected SybDatabaseMetaData _dbmda = null;
    protected Vector _rowFmtIdxList = null;
    protected Vector _paramNameList = null;
    protected boolean _retGeneratedKeys = false;
    protected SybResultSet _genKeysRS = null;
    protected IConstants.STATEMENT_EXECUTION_MODE _executionMode = IConstants.STATEMENT_EXECUTION_MODE.LANGUAGE;
    protected Vector _currentOpenRS = null;
    private SQLException _storedBatchSQE = null;
    private long _maxBICounter = -1L;

    protected SybStatement(String string, ProtocolContext protocolContext) {
        this._logId = string + "_St" + _logIdCounter++;
        this._context = protocolContext;
        this._context._batch = false;
        this._protocol = protocolContext._protocol;
        this._statementManager = new CacheManager(protocolContext._is);
        this._statementManager.setSetable(false);
        this._resultGetter = new ResultGetter(this);
        this._resultGetter.setManager(this._statementManager);
        this._statementManager.register(this._resultGetter);
        this._rsHold = this._context._conn._rsHoldability;
        this._currentOpenRS = new Vector();
        this.setDoEscapes();
        try {
            this._maxBICounter = this._context._conn._props.getMaxBICount();
            this._maxBICounter = this._maxBICounter == -1L ? Integer.MAX_VALUE : this._maxBICounter * (long)this._context._conn._props.getBufferSize() / 1024L;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void setDoEscapes() {
        try {
            this._doEscapes = this._context._conn._props.getBoolean(46);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected int nextResult() throws SQLException {
        return this.nextResult(null);
    }

    protected int nextResult(ParamManager paramManager) throws SQLException {
        if (!this._retGeneratedKeys) {
            this.resetRowCount();
        }
        while (true) {
            try {
                this._currentResult = this._resultGetter.nextResult();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
                continue;
            }
            break;
        }
        return this.processResults(paramManager);
    }

    protected int processResults(ParamManager paramManager) throws SQLException {
        switch (this._currentResult) {
            case 1: 
            case 6: {
                ProtocolResultSet protocolResultSet = this._protocol.resultSet(this._context);
                if (protocolResultSet != null) {
                    protocolResultSet.setType(this._retGeneratedKeys ? 1004 : this._rsType);
                }
                SybResultSet sybResultSet = new SybResultSet(this._logId, this, protocolResultSet);
                try {
                    sybResultSet.setManager(this._statementManager);
                    this._statementManager.register(sybResultSet);
                    this._statementManager.open(sybResultSet);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this._retGeneratedKeys) {
                    this._genKeysRS = sybResultSet;
                    break;
                }
                this._currentRS = sybResultSet;
                break;
            }
            case 5: {
                this.setRowCount(this._protocol.count(this._context));
                break;
            }
            case 0: {
                this.setRowCount(-1);
                this._state = IConstants.CONNECTION_STATE.IDLE;
                break;
            }
            case 3: {
                this.handleParam(paramManager);
                break;
            }
        }
        this._validRowcount = true;
        return this._currentResult;
    }

    protected String processEscapes(String string) throws SQLException {
        if (string.length() == 0) {
            return string;
        }
        EscapeTokenizer escapeTokenizer = new EscapeTokenizer(this, string);
        StringBuffer stringBuffer = new StringBuffer();
        Object object = escapeTokenizer.next();
        while (object != null) {
            if (object instanceof String) {
                stringBuffer.append((String)object);
            } else {
                Escape escape = (Escape)object;
                switch (escape.getType()) {
                    case 4: {
                        String string2 = escape.getBody();
                        if (this._context._conn._props.getBoolean(52)) {
                            stringBuffer.append(string2);
                            break;
                        }
                        stringBuffer.append("'1970-1-1 ");
                        stringBuffer.append(string2.substring(1, string2.length()));
                        break;
                    }
                    case 3: {
                        String string3 = escape.getBody();
                        stringBuffer.append(string3.substring(0, string3.length() - 1));
                        stringBuffer.append(" 00:00:00'");
                        break;
                    }
                    case 5: {
                        String string4 = escape.getBody();
                        int n = string4.indexOf(".");
                        if (n > 0 && string4.length() - n > 4) {
                            stringBuffer.append(string4.substring(0, n + 4) + "'");
                            break;
                        }
                        stringBuffer.append(string4);
                        break;
                    }
                    case 2: {
                        this._hasReturn = true;
                        stringBuffer = new StringBuffer(this.handleCallBody(escape.getBody()));
                        break;
                    }
                    case 1: {
                        this._hasReturn = false;
                        stringBuffer = new StringBuffer(this.handleCallBody(escape.getBody()));
                        break;
                    }
                    case 7: {
                        stringBuffer.append(" ESCAPE " + escape.getBody());
                        break;
                    }
                    case 6: {
                        String string5;
                        String string6 = escape.functionName();
                        if (string6.equalsIgnoreCase("extract") || string6.equalsIgnoreCase("position")) {
                            string6 = this.getAlternateFunction(string6, escape.getBody());
                        }
                        if ((string5 = this._protocol.getStringOption(this._context, 10, string6)) == null) {
                            ErrorMessage.raiseError("JZ0SI", escape.functionName());
                        }
                        stringBuffer.append(escape.doMap(string5));
                        break;
                    }
                    case 8: {
                        if (((SybDatabaseMetaData)this._context._conn.getMetaData()).supportsOuterJoinEscapeSyntax()) {
                            stringBuffer.append(escape.getBody());
                            break;
                        }
                        ErrorMessage.raiseError("JZ0SK");
                        break;
                    }
                }
            }
            object = escapeTokenizer.next();
        }
        return stringBuffer.toString();
    }

    private String getAlternateFunction(String string, String string2) throws SQLException {
        if (string.equalsIgnoreCase("extract")) {
            String[] stringArray = string2.split("[()]|[fF]+[rR]+[oO]+[mM]");
            if (stringArray.length == 3) {
                if (stringArray[1].trim().equalsIgnoreCase("day")) {
                    return "dayofmonth";
                }
                return stringArray[1].trim();
            }
            ErrorMessage.raiseError("JZ0S8", string2);
        } else if (string.equalsIgnoreCase("position")) {
            return "locate";
        }
        return string;
    }

    protected String doEscapeProcessing(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            ErrorMessage.raiseError("JZ0S4");
        }
        if (this._doEscapes) {
            return this.processEscapes(string);
        }
        return string;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " executeQuery(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeQuery(String)");
            }
        }
        string = this.doEscapeProcessing(string);
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
        tdsProtocolContext.resetRowFmt();
        return this.executeQuery(string, null);
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " executeUpdate(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String)");
            }
        }
        string = this.doEscapeProcessing(string);
        return this.executeUpdate(string, (ParamManager)null);
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " executeUpdate(String = [" + string + "] , int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String, int)");
            }
        }
        string = this.doEscapeProcessing(string);
        string = this.processGenKeysRequest(n, string);
        int n2 = this.executeUpdate(string, (ParamManager)null);
        this._retGeneratedKeys = false;
        return n2;
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " executeUpdate", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " executeUpdate", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String, int[])");
            }
        }
        if (nArray == null || nArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnIndexes");
        }
        return this.executeUpdate(string, 1);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " executeUpdate", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " executeUpdate", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " executeUpdate(String, String[])");
            }
        }
        if (stringArray == null || stringArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnNames");
        }
        return this.executeUpdate(string, 1);
    }

    @Override
    public void close() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " close()");
        }
        this.close(true);
    }

    protected void close(boolean bl) throws SQLException {
        if (this._state == IConstants.CONNECTION_STATE.DEAD) {
            return;
        }
        this._context._conn.checkConnection();
        this._context._conn._stmtList.removeElement(this);
        this._closing = true;
        this.doCancel(true, false);
        try {
            this.deallocateDynamic();
            this._statementManager.clear();
            if (this._cursor != null) {
                this._cursor.close(true);
                this._cursor = null;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        this._statementManager = null;
        if (bl) {
            this._context.drop();
        }
        this._state = IConstants.CONNECTION_STATE.DEAD;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxFielsSize()");
        }
        this.checkDead();
        return this._context._maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setMaxFieldSize(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setMaxFieldSize(int)");
            }
        }
        if (n < 0) {
            ErrorMessage.raiseError("JZ0SN");
        }
        this.checkStatement(true);
        this._context._maxFieldSize = n;
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMaxRows()");
        }
        this.checkDead();
        return this._protocol.getIntOption(this._context, 4);
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setMaxRows(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setMaxRows(int)");
            }
        }
        if (n < 0) {
            ErrorMessage.raiseError("JZ0SR");
        }
        this.checkDead();
        try {
            this._protocol.setOption(this._context, 4, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setEscapeProcessing(boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setEscapeProcessing(boolean)");
            }
        }
        this.checkDead();
        this._doEscapes = bl;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getQueryTimeout()");
        }
        this.checkDead();
        return this._context._timeout / 1000;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setQueryTimeout(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setQueryTimeout(int)");
            }
        }
        if (n < 0) {
            ErrorMessage.raiseError("JZ0SS");
        }
        this.checkDead();
        this._context._timeout = n * 1000;
    }

    @Override
    public void cancel() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " cancel()");
        }
        this.checkDead();
        this.doCancel(true, false);
    }

    private void doCancel(boolean bl, boolean bl2) throws SQLException {
        if (!bl2 && this._context._conn.getHAState() != 8) {
            this._protocol.cancel(this._context, false);
        }
        if (this._cursor != null) {
            this._cursor.close(bl);
            if (bl) {
                this._cursor = null;
            }
        }
        if (this._currentRS != null) {
            if (this._context._conn.getHAState() == 8) {
                this._currentRS.close(false);
            } else {
                this._currentRS.close(true);
            }
            this._currentRS = null;
        }
        if (this._genKeysRS != null) {
            this._genKeysRS.close();
            this._genKeysRS = null;
        }
        if (!this._currentOpenRS.isEmpty()) {
            Enumeration enumeration = this._currentOpenRS.elements();
            while (enumeration.hasMoreElements()) {
                ((SybResultSet)enumeration.nextElement()).close();
            }
            this._currentOpenRS.clear();
        }
        try {
            this._statementManager.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.resetRowCount();
        this._state = IConstants.CONNECTION_STATE.IDLE;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getWarnings()");
        }
        if (this._state == IConstants.CONNECTION_STATE.DEAD) {
            ErrorMessage.raiseError("JZ0S2");
        }
        return this._warning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " clearWarnings()");
        }
        this.checkDead();
        this._warning = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkDead();
        try {
            this.checkCursor(true, 1008);
            this._cursor.setName(string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setFetchSize(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setFetchSize(int)");
            }
        }
        if (n == 0) {
            return;
        }
        int n2 = this.getMaxRows();
        if (n < 0 || n2 > 0 && n > n2) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this.checkCursor(false, 1007);
        this._cursor.setFetchSize(n);
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getFetchSize()");
        }
        if (this._cursor != null) {
            return this._cursor.getFetchSize();
        }
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getGeneratedKeys()");
        }
        this.checkDead();
        if (this._genKeysRS == null || this._genKeysRS.next() && this._genKeysRS.getBigDecimal(1).longValue() == 0L) {
            ErrorMessage.raiseError("JZ0NK");
        }
        if (!this._genKeysRS.isBeforeFirst()) {
            this._genKeysRS.beforeFirst();
        }
        return this._genKeysRS;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultSetConcurrency()");
        }
        if (this._currentRS != null) {
            return this._currentRS.getConcurrency();
        }
        if (this._rsConcur == -9) {
            return 1007;
        }
        return this._rsConcur;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultSetHoldability()");
        }
        return this._rsHold;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getConnection()");
        }
        if (this._context._conn instanceof SybPooledConnection) {
            return ((SybPooledConnection)this._context._conn).getConnectionProxy();
        }
        return this._context._conn;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " execute(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " execute(String)");
            }
        }
        string = this.doEscapeProcessing(string);
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
        tdsProtocolContext.resetRowFmt();
        return this.execute(string, (ParamManager)null);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " execute(String = [" + string + "] , int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " execute(String, int)");
            }
        }
        string = this.doEscapeProcessing(string);
        string = this.processGenKeysRequest(n, string);
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
        tdsProtocolContext.resetRowFmt();
        boolean bl = this.execute(string, (ParamManager)null);
        if (this._retGeneratedKeys) {
            this.nextResult();
        }
        this._retGeneratedKeys = false;
        return bl;
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " execute", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " execute", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " execute(String, int[])");
            }
        }
        if (nArray == null || nArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnIndexes");
        }
        return this.execute(string, 1);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " execute", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " execute", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " execute(String, String[])");
            }
        }
        if (stringArray == null || stringArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnNames");
        }
        return this.execute(string, 1);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultSet()");
        }
        this.checkDead();
        if (this._currentResult != 5) {
            this.setRowCount(-1);
        }
        if (this._context.getState() == 5) {
            ErrorMessage.raiseError("JZ0PA");
        }
        return this._currentRS;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getUpdateCount()");
        }
        this.checkDead();
        if (this._context.getState() == 5) {
            ErrorMessage.raiseError("JZ0PA");
        }
        if (!this._validRowcount) {
            return -1;
        }
        int n = this._rowcount;
        this.resetRowCount();
        return n;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMoreResults()");
        }
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getMoreResults(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getMoreResults(int)");
            }
        }
        if (n != 1 && n != 2 && n != 3) {
            ErrorMessage.raiseError("JZ0FP", "current");
        }
        this.checkDead();
        if (this._state == IConstants.CONNECTION_STATE.IDLE) {
            this._validRowcount = true;
            return false;
        }
        if (this._currentResult == 1 && this._currentRS != null && this instanceof CallableStatement) {
            this._currentRS._currentStatus = n;
        }
        int n2 = this.nextResult();
        switch (n2) {
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setFetchDirection(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setFetchDirection(int)");
            }
        }
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this._rsFetchDir = n;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0I3", String.valueOf(n), "setFetchDirection(int)");
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getFetchDirection()");
        }
        return this._rsFetchDir;
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getResultSetType()");
        }
        if (this._currentRS != null) {
            return this._currentRS.getType();
        }
        return this._rsType;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " addBatch(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " addBatch(String)");
            }
        }
        this.checkBatch();
        if (this._batchCmds == null) {
            this._batchCmds = new Vector();
            this._batchCmdsCount = 0;
        }
        if ((long)this._batchCmdsCount == this._maxBICounter) {
            ErrorMessage.raiseError("JZ045", "" + (this._batchCmdsCount + 1), "" + this._maxBICounter);
        }
        this._batchCmds.add(string);
        ++this._batchCmdsCount;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " clearBatch()");
        }
        this.checkBatch();
        this._batchCmds = null;
        this._batchCmdsCount = 0;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " executeBatch()");
        }
        return this.executeBatch(null, true);
    }

    protected void setResultSetParams(int n, int n2) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 1003: 
            case 1004: {
                break;
            }
            case 1005: {
                bl = true;
                n = 1004;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", String.valueOf(n));
            }
        }
        switch (n2) {
            case 1007: {
                break;
            }
            case 1008: {
                if (n != 1004) break;
                n2 = 1007;
                bl = true;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SO", String.valueOf(n2));
            }
        }
        this._rsType = n;
        this._rsConcur = n2;
        if (bl) {
            this._context._conn.chainWarnings(ErrorMessage.createWarning("010RC"));
        }
    }

    protected void setResultSetHoldability(int n) throws SQLException {
        if (n != 1 && n != 2) {
            ErrorMessage.raiseError("JZ0SW", String.valueOf(n));
        }
        if (n == 2) {
            this._context._conn._stmtList.addElement(this);
        }
        this._rsHold = n;
    }

    protected int[] executeBatch(ParamManager paramManager) throws SQLException {
        return this.executeBatch(paramManager, true);
    }

    protected int[] executeBatch(ParamManager paramManager, boolean bl) throws SQLException {
        if (this._batchCmds == null) {
            return new int[0];
        }
        int[] nArray = new int[this._batchCmds.size()];
        try {
            if (this.checkBatch()) {
                if (paramManager != null) {
                    int[] nArray2 = this.sendBatch((String)this._batchCmds.elementAt(0), paramManager);
                    return nArray2;
                }
                for (int i = 0; i < this._batchCmds.size(); ++i) {
                    try {
                        int[] nArray3 = this.sendBatch((String)this._batchCmds.elementAt(i), paramManager);
                        nArray[i] = nArray3[0];
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.handleBatchException(sQLException, nArray, i);
                    }
                }
            } else {
                nArray = this.sendBatch(this.batchToString(), paramManager);
            }
        }
        catch (SQLException sQLException) {
            if (!this.checkBatch()) {
                this.clearBatch();
            }
            this._context._batch = false;
            throw sQLException;
        }
        finally {
            if (bl) {
                if (!this.checkBatch()) {
                    this.clearBatch();
                }
                this._context._batch = false;
            }
        }
        return nArray;
    }

    protected int[] sendBatch(String string, ParamManager paramManager) throws SQLException {
        String string2 = this.doEscapeProcessing(string);
        this._context._batch = true;
        this.checkStatement(true);
        this.sendQuery(string2, paramManager);
        return this.batchLoop(paramManager);
    }

    protected int[] batchLoop(ParamManager paramManager) throws SQLException {
        Object object;
        int n;
        int n2 = 0;
        this._context._batch = true;
        int[] nArray = new int[this._batchCmdsCount];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = paramManager != null && paramManager._rowUpdatedStatus != null ? paramManager._rowUpdatedStatus[n] : 0;
        }
        n = 0;
        int n3 = 5;
        boolean bl = this._context._conn._props.getBoolean(80);
        while (true) {
            if (n3 != 3) {
                n3 = 5;
                n2 = 0;
            }
            block11: while (true) {
                try {
                    while (true) {
                        int n4 = this.nextResult(paramManager);
                        switch (n4) {
                            case 5: {
                                if (this._doneinproc) {
                                    object = (TdsProtocolContext)this._context;
                                    if (((TdsProtocolContext)object).isProcDone()) {
                                        n2 += this._rowcount;
                                        n3 = 5;
                                        break block11;
                                    }
                                    n2 += this._rowcount;
                                    break;
                                }
                                n2 += this._rowcount;
                                break block11;
                            }
                            case 0: {
                                n3 = 0;
                                break block11;
                            }
                            case 3: {
                                if (!this._doneinproc) continue block11;
                                n3 = 3;
                                break block11;
                            }
                            default: {
                                ErrorMessage.raiseError("JZ0P1");
                                break;
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    if ("JZ0F2".equals(sQLException.getSQLState())) {
                        this.doCancel(false, true);
                        throw sQLException;
                    }
                    if (bl) {
                        n = this.skipEarlyRowFailures(n, paramManager);
                        if (this._storedBatchSQE != null) {
                            sQLException.setNextException(this._storedBatchSQE);
                        }
                        this._storedBatchSQE = sQLException;
                        nArray[n] = -3;
                        continue;
                    }
                    try {
                        this.doCancel(false, false);
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException2.getSQLState().equals("JZ0F2")) {
                            sQLException2.setNextException(sQLException);
                        }
                        throw sQLException2;
                    }
                    int[] nArray2 = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray2[i] = nArray[i];
                    }
                    ErrorMessage.raiseBatchUpdateException(sQLException, nArray2);
                    continue;
                }
                break;
            }
            if (n3 == 3) continue;
            if (bl) {
                n = this.skipEarlyRowFailures(n, paramManager);
            }
            if (n < nArray.length) {
                if (nArray[n] != -3) {
                    nArray[n] = n2;
                }
                ++n;
            }
            if (n3 == 0) break;
        }
        if (this._storedBatchSQE != null) {
            while (n < nArray.length) {
                nArray[n++] = -3;
            }
            if (paramManager != null) {
                paramManager._rowException = null;
                paramManager._rowUpdatedStatus = null;
            }
            object = this._storedBatchSQE;
            this._storedBatchSQE = null;
            ErrorMessage.raiseBatchUpdateException((SQLException)object, nArray);
        }
        return nArray;
    }

    private int skipEarlyRowFailures(int n, ParamManager paramManager) {
        if (paramManager != null && paramManager._rowUpdatedStatus != null) {
            while (n < paramManager._rowUpdatedStatus.length && paramManager._rowUpdatedStatus[n] == -3) {
                if (this._storedBatchSQE == null) {
                    this._storedBatchSQE = paramManager._rowException[n];
                } else {
                    this._storedBatchSQE.setNextException(paramManager._rowException[n]);
                }
                ++n;
            }
        }
        return n;
    }

    protected String batchToString() {
        int n = this._batchCmds.size() * (((String)this._batchCmds.elementAt(this._batchCmds.size() / 2)).length() + 1);
        StringWriter stringWriter = new StringWriter(n);
        stringWriter.write((String)this._batchCmds.elementAt(0));
        for (int i = 1; i < this._batchCmds.size(); ++i) {
            stringWriter.write(" ");
            stringWriter.write((String)this._batchCmds.elementAt(i));
        }
        String string = stringWriter.toString();
        return string;
    }

    protected boolean sendQuery(String string, ParamManager paramManager) throws SQLException {
        if (this._type == 4100 || this._type == 4104) {
            string.trim();
            int n = string.lastIndexOf(32);
            String string2 = string.substring(n + 1);
            SybCursorResultSet sybCursorResultSet = (SybCursorResultSet)this._context._conn.getCursorResultSet(string2);
            if (sybCursorResultSet != null && !sybCursorResultSet._cursor.isLanguageCursor()) {
                sybCursorResultSet._cursor.setTable(this._table);
                if (this._type == 4100) {
                    sybCursorResultSet.deleteRow();
                } else {
                    sybCursorResultSet._cursor.update(sybCursorResultSet._prs, paramManager, string.substring(0, this._setEnd));
                }
                return true;
            }
            if (paramManager != null) {
                paramManager.literalizeAll();
            }
        }
        try {
            this._protocol.language(this._context, string, paramManager);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        this._state = IConstants.CONNECTION_STATE.BUSY;
        return false;
    }

    protected ResultSet executeQuery(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        if (this._rsConcur == -9) {
            this._rsConcur = 1007;
        }
        if (this._cursor == null && this._rsConcur == 1008) {
            this.checkCursor(false, 1008);
        }
        this.checkForImplicitCursor();
        if (this._cursor != null) {
            this._cursor.setTable(this._table);
            ProtocolResultSet protocolResultSet = null;
            if (this instanceof SybPreparedStatement && ((SybPreparedStatement)this)._dynStmtName != null) {
                this._cursor.setDynamic(true);
                paramManager = ((SybPreparedStatement)this).setParamsFromArrays();
                protocolResultSet = this._cursor.open(((SybPreparedStatement)this)._dynStmtName, paramManager, false);
            } else {
                protocolResultSet = this._cursor.open(string, paramManager, false);
            }
            if (protocolResultSet == null) {
                ErrorMessage.raiseError("JZ0R2");
            }
            protocolResultSet.setType(this._rsType);
            this._currentRS = this._cursor.scrollingAtServer() ? new SybScrollCursorResultSet(this._logId, this, protocolResultSet) : new SybCursorResultSet(this._logId, this, protocolResultSet);
            this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
            this._state = IConstants.CONNECTION_STATE.BUSY;
        } else {
            this.sendQuery(string, paramManager);
            this.queryLoop();
        }
        return this._currentRS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResultSet queryLoop() throws SQLException {
        boolean bl = true;
        try {
            block10: while (true) {
                int n = this.nextResult();
                switch (n) {
                    case 1: {
                        return this._currentRS;
                    }
                    case 5: {
                        continue block10;
                    }
                    case 0: {
                        bl = false;
                        ErrorMessage.raiseError("JZ0R2");
                    }
                    case 3: {
                        continue block10;
                    }
                }
                ErrorMessage.raiseError("JZ0P1");
            }
        }
        catch (SQLException sQLException) {
            if (!bl) throw sQLException;
            if ("JZ0T4".equals(sQLException.getSQLState())) throw sQLException;
            if (this._context._conn.isDead()) throw sQLException;
            try {
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    this.doCancel(false, true);
                    throw sQLException;
                }
                this.doCancel(false, false);
                throw sQLException;
            }
            catch (SQLException sQLException2) {
                if (sQLException2.getSQLState().equals("JZ0F2")) {
                    sQLException2.setNextException(sQLException);
                    throw sQLException2;
                }
                sQLException.setNextException(sQLException2);
            }
            throw sQLException;
        }
    }

    protected int executeUpdate(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        if (this.sendQuery(string, paramManager)) {
            return 1;
        }
        return this.updateLoop();
    }

    protected int updateLoop() throws SQLException {
        int n = 0;
        try {
            block8: while (true) {
                int n2 = this.nextResult();
                switch (n2) {
                    case 5: {
                        n = this._rowcount;
                        continue block8;
                    }
                    case 0: {
                        this._rowcount = n;
                        break block8;
                    }
                    case 3: {
                        if (!(this instanceof CallableStatement)) continue block8;
                        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
                        this.setRowCount(tdsProtocolContext.getPreviousCount());
                        n = this._rowcount;
                        break block8;
                    }
                    case 1: {
                        if (this._retGeneratedKeys) break block8;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0P1");
                        continue block8;
                    }
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            boolean bl = false;
            if ("JZ0F2".equals(sQLException.getSQLState())) {
                bl = true;
            }
            this.doCancel(false, bl);
            throw sQLException;
        }
        return n;
    }

    protected boolean execute(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        this.sendQuery(string, paramManager);
        boolean bl = this.executeLoop();
        if (this._retGeneratedKeys && this._executionMode != IConstants.STATEMENT_EXECUTION_MODE.LANGUAGE) {
            this.nextResult();
            this._retGeneratedKeys = false;
        }
        return bl;
    }

    protected boolean executeLoop() throws SQLException {
        int n = this.nextResult();
        switch (n) {
            case 0: 
            case 1: 
            case 5: {
                break;
            }
            case 3: {
                TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
                this.setRowCount(tdsProtocolContext.getPreviousCount());
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0P1");
            }
        }
        return this._currentRS != null;
    }

    @Override
    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._context.setMessageHandler(sybMessageHandler);
    }

    @Override
    public SybMessageHandler getSybMessageHandler() {
        return this._context.getMessageHandler();
    }

    public SybMessageHandler getMessageHandler() {
        return this.getSybMessageHandler();
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        if (!bl) {
            sQLWarning = (SQLWarning)sQLException;
        } else {
            sQLWarning = SybConnection.getAllTheWarnings(sQLException);
            if (this._context._conn._props.getBoolean(76)) {
                sQLException = SybConnection.getAllExceptions(sQLException);
            }
        }
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl) {
            throw sQLException;
        }
    }

    protected void chainWarning(SQLWarning sQLWarning) {
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
    }

    protected void handleBatchException(SQLException sQLException, int[] nArray, int n) throws SQLException {
        if (sQLException instanceof BatchUpdateException) {
            int[] nArray2 = ((BatchUpdateException)sQLException).getUpdateCounts();
            for (int i = 0; i < nArray2.length; ++i) {
                nArray[n] = nArray2[i];
                ++n;
            }
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            if (sQLException instanceof SybBatchUpdateException) {
                SQLException sQLException2 = ((SybBatchUpdateException)sQLException).getOrigSQE();
                ErrorMessage.raiseBatchUpdateException(sQLException2, nArray3);
            } else {
                ErrorMessage.raiseBatchUpdateException(sQLException, nArray3);
            }
        } else {
            throw sQLException;
        }
    }

    protected void checkStatement(boolean bl) throws SQLException {
        this.checkDead();
        if (this._cursor != null && this._currentRS != null && this._currentRS._state == IConstants.CONNECTION_STATE.BUSY && this._cursor.isLanguageCursor()) {
            ErrorMessage.raiseError("JZ00E");
        }
        if (this._closing) {
            return;
        }
        if (bl) {
            this._warning = null;
            this.doCancel(false, false);
            this._state = IConstants.CONNECTION_STATE.BUSY;
        } else if (this._state != IConstants.CONNECTION_STATE.BUSY) {
            ErrorMessage.raiseError("JZ0S1");
        }
    }

    protected void checkDead() throws SQLException {
        if (this._state == IConstants.CONNECTION_STATE.DEAD) {
            ErrorMessage.raiseError("JZ0S2");
        }
        this._context._conn.checkConnection();
    }

    @Override
    public boolean isClosed() {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isClosed()");
        }
        return this._closing;
    }

    protected void handleParam(ParamManager paramManager) throws SQLException {
        if (this._rowcount == -1) {
            this.setRowCount(0);
        }
        if (!this._retGeneratedKeys) {
            this.resetRowCount();
        }
        do {
            try {
                this._currentResult = this._resultGetter.nextResult();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
        } while (this._currentResult == 3);
        this.processResults(null);
    }

    protected void setRowCount(int n) {
        this._rowcount = n;
    }

    private void resetRowCount() {
        this._validRowcount = false;
        this._rowcount = -1;
    }

    protected String handleCallBody(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = string;
        boolean bl = false;
        String string3 = null;
        this._allowsOutputParms = true;
        this._sendAsRpc = true;
        try {
            String string4;
            this._rpcName = stringTokenizer.nextToken(CALL_DELIMS);
            int n = this._rpcName.length();
            if (this._rpcName.toLowerCase().equals("exec")) {
                bl = true;
                this._rpcName = stringTokenizer.nextToken(CALL_DELIMS);
                int n2 = string.indexOf(this._rpcName);
                string3 = string.substring(0, n2);
                string2 = string.substring(n2);
                n += this._rpcName.length();
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(string.indexOf(this._rpcName) + this._rpcName.length()));
            String string5 = stringTokenizer2.nextToken(" ");
            int n3 = string.lastIndexOf(41);
            if (string5.startsWith("(") && n3 > 0) {
                string2 = this._rpcName + " " + string.substring(string.indexOf(40) + 1, n3);
            }
            while ((string4 = stringTokenizer.nextToken(CALL_DELIMS)).charAt(0) == '?') {
            }
            this._sendAsRpc = false;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (bl && !this._protocol.getBoolOption(this._context, 12)) {
            string2 = string3 + string2;
        }
        this._executionMode = this._sendAsRpc ? IConstants.STATEMENT_EXECUTION_MODE.DBRPC : IConstants.STATEMENT_EXECUTION_MODE.PARAMETERIZED;
        return string2;
    }

    protected void deallocateDynamic() throws SQLException {
    }

    protected void checkCursor(boolean bl, int n) throws SQLException {
        try {
            if (this._cursor == null) {
                this._cursor = this._protocol.getCursor(this._context, bl);
                this._cursor.setFetchSize(this._context._conn._props.getInteger(16));
            }
            if (n != 1007 || this._rsConcur != 1008) {
                this._rsConcur = n;
            }
            this._cursor.setTypeAndConcurrency(this._rsType, this._rsConcur);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    protected boolean checkBatch() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (this._dbmda == null) {
                this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        bl2 = this._dbmda.supportsBatchUpdates();
        if (bl2) {
            bl = this._dbmda.execBatchUpdatesInLoop();
        }
        return bl;
    }

    protected void checkForImplicitCursor() throws SQLException {
        int n;
        if (this._cursor != null) {
            return;
        }
        if (this._context._conn._props.getBoolean(33) && !this._context._conn._props.getBoolean(27) && (n = this._context._conn._props.getInteger(47)) > 0) {
            int n2 = this.getMaxRows();
            if (n2 > 0 && n > n2) {
                n = n2;
            }
            this.setFetchSize(n);
        }
    }

    protected String processGenKeysRequest(int n, String string) throws SQLException {
        if (n != 1 && n != 2) {
            ErrorMessage.raiseError("JZ0FP", "autoGeneratedKeys");
        }
        boolean bl = this._retGeneratedKeys = this._type == 16 && n == 1;
        if (this._retGeneratedKeys) {
            if (this._dbmda == null) {
                this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
            }
            string = string + " " + this._dbmda.getIdentityQuery();
        }
        return string;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " isWrapperFor", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " isWrapperFor", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " isWrapperFor(Class<?>)");
            }
        }
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " unwrap", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " unWrap", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " unWrap(Class<T>)");
            }
        }
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName());
        }
        return t;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setPoolable(boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setPoolable(boolean)");
            }
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isPoolable()");
        }
        return false;
    }

    protected final IConstants.STATEMENT_EXECUTION_MODE getExecutionMode() {
        return this._executionMode;
    }

    protected final void setExecutionMode(IConstants.STATEMENT_EXECUTION_MODE sTATEMENT_EXECUTION_MODE) {
        this._executionMode = sTATEMENT_EXECUTION_MODE;
    }
}

