/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.Cursor;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.JdbcDataObject;
import com.sybase.jdbc4.jdbc.LimiterInputStream;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.tds.SybBigDecimal;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybCursorResultSet
extends SybResultSet
implements com.sybase.jdbcx.SybCursorResultSet {
    private static Logger LOG = Logger.getLogger(SybCursorResultSet.class.getName());
    private static volatile long _logIdCounter = 0L;
    protected Cursor _cursor;
    protected ParamManager _paramMgr;
    protected ParamManager _insertParamMgr;
    protected boolean _rowDeleted = false;
    protected boolean _rowUpdated = false;
    protected boolean _rowInserted = false;
    private int _savedCurrentRow = -4;

    protected SybCursorResultSet(String string, SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        super(string, sybStatement, protocolResultSet);
        this._cursor = this._statement._cursor;
        this._concurType = this._cursor.getConcurrency();
        if (this._concurType != 1007) {
            int n = protocolResultSet.getMetaData().getColumnCount();
            this._paramMgr = new ParamManager(n, sybStatement);
            this._insertParamMgr = new ParamManager(n, sybStatement);
        }
        this._logId = string + "_Cr" + _logIdCounter++;
    }

    @Override
    public String getCursorName() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getCursorName()");
        }
        return this._cursor.getName();
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getConcurrency()");
        }
        if (this._cursor == null) {
            ErrorMessage.raiseError("JZ00D");
        }
        return this._cursor.getConcurrency();
    }

    @Override
    public boolean next() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " next()");
        }
        this.checkResultSet();
        this.clearWarnings();
        this.moveToCurrentRow();
        if (this.checkRowIndexBeforeProtocolNext()) {
            return false;
        }
        if (this._paramMgr != null) {
            try {
                this._paramMgr.clearParamArray(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._rowDeleted = false;
        this._rowUpdated = false;
        this._rowInserted = false;
        boolean bl = this._prs.next();
        if (!bl) {
            this.prepareForNextFetch();
            this._prs = this._cursor.fetch();
            bl = this._prs == null ? false : this._prs.next();
        }
        if (!bl) {
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            this.adjustRowIndexesAfterProtocolNext();
        }
        return bl;
    }

    protected void prepareForNextFetch() throws SQLException {
        SQLWarning sQLWarning = this._prs.getWarnings();
        this._prs.clearWarnings();
        if (this._savedWarnings != null) {
            this._savedWarnings.setNextWarning(sQLWarning);
        } else {
            this._savedWarnings = sQLWarning;
        }
        this._prs.close(false);
        if (this._cm != null) {
            this._cm.doneReading();
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " moveToCurrentRow()");
        }
        if (this._rowIndex == -3) {
            this._rowIndex = this._savedCurrentRow;
            this._rowInserted = false;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " moveToInsertRow()");
        }
        if (this._concurType == 1008) {
            if (this._rowIndex != -3) {
                this._savedCurrentRow = this._rowIndex;
                this._rowIndex = -3;
                try {
                    this._insertParamMgr.clearParamArray(true);
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseError("JZ006", iOException.getMessage());
                }
            }
        } else {
            ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
        }
    }

    @Override
    protected void close(boolean bl) throws SQLException {
        this._cursor.close(true);
        super.close(bl);
    }

    @Override
    public boolean isLanguageCursor() {
        return this._cursor.isLanguageCursor();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setFetchSize(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setFetchSize(int)");
            }
        }
        if (n == 0) {
            return;
        }
        int n2 = this._statement.getMaxRows();
        if (n < 0 || n2 > 0 && n > n2) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._cursor.setFetchSize(n);
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getFetchSize()");
        }
        return this._cursor.getFetchSize();
    }

    @Override
    public void insertRow() throws SQLException {
        int n;
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " insertRow()");
        }
        this.checkUpdatability("insertRow()");
        if (this._rowIndex != -3) {
            ErrorMessage.raiseError("JZ0BR", "insertRow()");
        }
        String string = "INSERT INTO " + this._cursor.getTable() + " ";
        ResultSetMetaData resultSetMetaData = this._prs.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        Param[] paramArray = this._insertParamMgr.getParams();
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            if (paramArray[n]._sqlType == -999) continue;
            string = !bl ? string + ", " : string + "( ";
            string = string + resultSetMetaData.getColumnName(n + 1);
            bl = false;
        }
        if (!bl) {
            string = string + " ) ";
            bl = true;
        }
        string = string + "VALUES (";
        n = string.length();
        for (int i = 0; i < n2; ++i) {
            if (paramArray[i]._sqlType == -999) {
                paramArray[i]._sqlType = -998;
                continue;
            }
            if (!bl) {
                string = string + ", ";
                n += 2;
            }
            string = string + "?";
            bl = false;
            paramArray[i]._paramMarkerOffset = n++;
        }
        if (1 == this._cursor.insert(this._prs, this._insertParamMgr, string = string + ")")) {
            this._rowInserted = true;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " rowUpdated()");
        }
        return this._rowUpdated;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " rowDeleted()");
        }
        return this._rowDeleted;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " rowInserted()");
        }
        return this._rowInserted;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateNull(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNull(int)");
            }
        }
        this.checkUpdatability("updateNull(int)");
        Object object = null;
        int n2 = this.getMetaData().getColumnType(n);
        if (n2 == 2005) {
            object = this._pc._conn._nullClob;
        } else if (n2 == 2004) {
            object = this._pc._conn._nullBlob;
        }
        this.setParam(n2, n, object);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updatedBoolean(int = [" + n + "], boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBoolean(int, boolean)");
            }
        }
        this.checkUpdatability("updateBoolean(int, boolean)");
        Boolean bl2 = new Boolean(bl);
        this.setParam(-7, n, bl2);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateByte(int = [" + n + "], byte = [" + by + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateByte(int, byte)");
            }
        }
        this.checkUpdatability("updateByte(int, byte)");
        Integer n2 = new Integer(by);
        if (n2 < 0) {
            this.setParam(5, n, n2);
        } else {
            this.setParam(-6, n, n2);
        }
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateShort(int = [" + n + "], short = [" + s + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateShort(int, short)");
            }
        }
        this.checkUpdatability("updateShort(int, short)");
        Integer n2 = new Integer(s);
        this.setParam(5, n, n2);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateInt(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateInt(int, int)");
            }
        }
        this.checkUpdatability("updateInt(int, int)");
        Integer n3 = new Integer(n2);
        this.setParam(4, n, n3);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateLong(int = [" + n + "], long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateLong(int, long)");
            }
        }
        this.checkUpdatability("updateLong(int, long)");
        Long l2 = new Long(l);
        this.setParam(-5, n, l2);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateFloat(int = [" + n + "], float = [" + f + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateFloat(int, float)");
            }
        }
        this.checkUpdatability("updateFloat(int, float)");
        Float f2 = new Float(f);
        this.setParam(7, n, f2);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateDouble(int = [" + n + "], double = [" + d + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateDouble(int, double)");
            }
        }
        this.checkUpdatability("updateDouble(int, double)");
        Double d2 = new Double(d);
        this.setParam(8, n, d2);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateBigDecimal(int = [" + n + "], BigDecimal = [" + bigDecimal + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBigDecimal(int, BigDecimal)");
            }
        }
        this.checkUpdatability("updateBigDecimal(int, BigDecimal)");
        if (bigDecimal == null) {
            this.setParam(2, n, bigDecimal);
        } else {
            this.setParam(2, n, bigDecimal, bigDecimal.scale());
        }
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        this.checkUpdatability("updateBigDecimal(int, BigDecimal, int, int)");
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal("0");
        }
        SybBigDecimal sybBigDecimal = new SybBigDecimal(bigDecimal, n2, n3);
        this.setParam(2, n, sybBigDecimal);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateString(int = [" + n + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateString(int, String)");
            }
        }
        this.checkUpdatability("updateString(int, String)");
        this.setParam(12, n, string);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, "updateBytes", new Object[]{n, byArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "updateBytes", new Object[]{n, byArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBytes(int, byte)");
            }
        }
        this.checkUpdatability("updateBytes(int, byte[])");
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        if (n2 > 255) {
            this.setParam(-4, n, byArray);
        } else {
            this.setParam(-3, n, byArray);
        }
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateDate", new Object[]{n, date}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateDate(int, java.sql.Date)");
            }
        }
        this.checkUpdatability("updateDate(int, java.sql.Date)");
        this.setParam(91, n, new DateObject((Object)date, 91));
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateTime", new Object[]{n, time}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateTime(int, java.sql.Time)");
            }
        }
        this.checkUpdatability("updateTime(int, java.sql.Time)");
        this.setParam(92, n, new DateObject((Object)time, 92));
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateTimestamp", new Object[]{n, timestamp}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateTimestamp(int, java.sql.Timestamp)");
            }
        }
        this.checkUpdatability("updateTimestamp(int, java.sql.Timestamp)");
        this.setParam(93, n, new DateObject((Object)timestamp, 93));
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(int, java.io.InputStream, int)");
            }
        }
        this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, int)");
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n2), "ISO8859_1");
            String string = this._paramMgr.drainReader(inputStreamReader, n2);
            if (string != null) {
                this.setParam(12, n, string, 0);
            } else {
                this.setParam(-1, n, inputStreamReader, n2);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{n, inputStream, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(int, java.io.InputStream, int)");
            }
        }
        this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, int)");
        byte[] byArray = this._paramMgr.drainStreams(inputStream, n2);
        if (byArray != null) {
            this.updateBytes(n, byArray);
        } else {
            this.setParam(-4, n, inputStream, n2);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{n, reader, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateChracterStream(int, java.io.Redear, int)");
            }
        }
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader, int)");
        String string = this._paramMgr.drainReader(reader, n2);
        if (string != null) {
            this.setParam(12, n, string, 0);
        } else {
            this.setParam(-1, n, reader, n2);
        }
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateObject", new Object[]{n, object, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateObject(int, Object, int)");
            }
        }
        this.checkUpdatability("updateObject(int, Object, int)");
        if (object == null) {
            this.updateNull(n);
        } else if (object instanceof String) {
            this.updateString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setParam(2, n, object, n2);
        } else if (object instanceof Boolean) {
            this.setParam(-7, n, object, n2);
        } else if (object instanceof Integer) {
            this.setParam(4, n, object, n2);
        } else if (object instanceof Long) {
            this.setParam(-5, n, object, n2);
        } else if (object instanceof Float) {
            this.setParam(7, n, object, n2);
        } else if (object instanceof Double) {
            this.setParam(8, n, object, n2);
        } else if (object instanceof byte[]) {
            this.updateBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.updateDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.updateTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.updateTimestamp(n, (Timestamp)object);
        } else if (object instanceof Clob) {
            this.updateClob(n, (Clob)object);
        } else if (object instanceof Blob) {
            this.updateBlob(n, (Blob)object);
        } else if (object instanceof Serializable) {
            this.setParam(2000, n, object, n2);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateObject", new Object[]{n, object}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateObject(int, Object)");
            }
        }
        this.checkUpdatability("updateObject(int, Object)");
        int n2 = 0;
        if (object != null && object instanceof BigDecimal) {
            n2 = ((BigDecimal)object).scale();
        }
        this.updateObject(n, object, n2);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateNull(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNull(String)");
            }
        }
        this.checkUpdatability("updateNull(String)");
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateBoolean(String = [" + string + "], boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBoolean(String, boolean)");
            }
        }
        this.checkUpdatability("updateBoolean(String, boolean)");
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateByte(String = [" + string + "], byte = [" + by + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateByte(String, byte)");
            }
        }
        this.checkUpdatability("updateByte(String, byte)");
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateShort(String = [" + string + "], short = [" + s + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateShort(String, short)");
            }
        }
        this.checkUpdatability("updateShort(String, short)");
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateInt(String = [" + string + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateInt(String, int)");
            }
        }
        this.checkUpdatability("updateInt(String, int)");
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateLong(String = [" + string + "], long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateLong(String, long)");
            }
        }
        this.checkUpdatability("updateLong(String, long)");
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateFloat(String = [" + string + "], float = [" + f + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateFloat(String, float)");
            }
        }
        this.checkUpdatability("updateFloat(String, float)");
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateDouble(String = [" + string + "], double = [" + d + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateDouble(String, double)");
            }
        }
        this.checkUpdatability("updateDouble(String, double)");
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateBigDecimal(String = [" + string + "], BigDecimal = [" + bigDecimal + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBigDecimal(String, BigDecimal)");
            }
        }
        this.checkUpdatability("updateBigDecimal(String, BigDecimal)");
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal, int n, int n2) throws SQLException {
        this.checkUpdatability("updateBigDecimal(String, BigDecimal, int, int)");
        this.updateBigDecimal(this.findColumn(string), bigDecimal, n, n2);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateString(String = [" + string + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateString(String, String)");
            }
        }
        this.checkUpdatability("updateString(String, String)");
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBytes", new Object[]{string, byArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBytes", new Object[]{string, byArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBytes(String, byte)");
            }
        }
        this.checkUpdatability("updateBytes(String, byte[])");
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateDate", new Object[]{string, date}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateDate(String, java.sql.Date)");
            }
        }
        this.checkUpdatability("updateDate(String, java.sql.Date)");
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateTime", new Object[]{string, time}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateTime(String, java.sql.Time)");
            }
        }
        this.checkUpdatability("updateTime(String, java.sql.Time)");
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateTimestamp", new Object[]{string, timestamp}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateTimestamp(String, java.sql.Timestamp)");
            }
        }
        this.checkUpdatability("updateTimestamp(String, java.sql.Timestamp)");
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(String, java.io.InputStream, int)");
            }
        }
        this.checkUpdatability("updateAsciiStream(String, java.io.InputStream, int)");
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(String, java.io.InputStream, int)");
            }
        }
        this.checkUpdatability("updateBinaryStream(String, java.io.InputStream, int)");
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{string, reader, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(String, java.io.Reader, int)");
            }
        }
        this.checkUpdatability("updateCharacterStream(String, java.io.Reader, int)");
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateObject", new Object[]{string, object, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateObject(String, Object, int)");
            }
        }
        this.checkUpdatability("updateObject(String, Object, int)");
        int n2 = 0;
        if (object != null && object instanceof BigDecimal) {
            n2 = ((BigDecimal)object).scale();
        }
        this.updateObject(this.findColumn(string), object, n2);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateObject", new Object[]{string, object}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateObject(String, Object)");
            }
        }
        this.checkUpdatability("updateObject(String, Object)");
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateNString(int = [" + n + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNString(int, String)");
            }
        }
        this.checkUpdatability("updateNString(int, String)");
        this.setParam(-9, n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " updateNString(String = [" + string + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNString(String, String)");
            }
        }
        this.checkUpdatability("updateNString(String, String)");
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNCharacterStream", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNCharacterStream(int, Reader)");
            }
        }
        this.checkUpdatability("updateNCharacterStream(int, java.io.Reader)");
        this.setParam(-16, n, reader, -1);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNCharacterStream(String, Reader)");
            }
        }
        this.checkUpdatability("updateNCharacterStream(String, java.io.Reader)");
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNCharacterStream", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNCharacterStream(int, Reader, long)");
            }
        }
        this.checkUpdatability("updateNCharacterStream(int, java.io.Reader, long)");
        int n2 = this.checkLongLength(l);
        this.setParam(-16, n, reader, n2);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateNCharacterStream", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateNCharacterStream(String, Reader, long)");
            }
        }
        this.checkUpdatability("updateNCharacterStream(String, java.io.Reader, long)");
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(int, InputStream)");
            }
        }
        this.checkUpdatability("updateAsciiStream(int, java.io.InputStream)");
        this.updateAsciiStream(n, inputStream, -1);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(String, InputStream)");
            }
        }
        this.checkUpdatability("updateAsciiStream(String, java.io.InputStream)");
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(int, InputStream, long)");
            }
        }
        this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, long)");
        int n2 = this.checkLongLength(l);
        this.updateAsciiStream(n, inputStream, n2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateAsciiStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateAsciiStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateAsciiStream(String, InputStream, long)");
            }
        }
        this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, long)");
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(int, InputStream)");
            }
        }
        this.checkUpdatability("updateBinaryStream(int, java.io.InputStream)");
        this.updateBinaryStream(n, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(String, InputStream)");
            }
        }
        this.checkUpdatability("updateBinaryStream(String, java.io.InputStream)");
        this.updateBinaryStream(this.findColumn(string), inputStream, -1);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(int, InputStream, long)");
            }
        }
        this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, long)");
        int n2 = this.checkLongLength(l);
        this.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBinaryStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBinaryStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBinaryStream(String, InputStream, long)");
            }
        }
        this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, long)");
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(int, Reader)");
            }
        }
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader)");
        this.updateCharacterStream(n, reader, -1);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(String, Reader)");
            }
        }
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader)");
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(int, Reader, long)");
            }
        }
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader, long)");
        int n2 = this.checkLongLength(l);
        this.updateCharacterStream(n, reader, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(String, Reader, long)");
            }
        }
        this.checkUpdatability("updateCharacterStream(int, java.io.Reader, long)");
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, "updateClob", new Object[]{n, clob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "updateClob", new Object[]{n, clob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(int, Clob)");
            }
        }
        this.checkUpdatability("updateClob(int, Clob)");
        if (clob == null) {
            clob = this._pc._conn._nullClob;
        }
        this.setParam(2005, n, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateClob", new Object[]{string, clob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateClob", new Object[]{string, clob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(String, Clob)");
            }
        }
        this.checkUpdatability("updateClob(String, Clob)");
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateClob", new Object[]{n, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(int, Reader)");
            }
        }
        this.checkUpdatability("updateClob(int, Reader)");
        this.setParam(-1, n, reader, -1);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateClob", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(String, Reader)");
            }
        }
        this.checkUpdatability("updateClob(String, Reader)");
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateClob", new Object[]{n, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateClob(int, Reader, long)");
            }
        }
        this.checkUpdatability("updateClob(int, Reader, long)");
        int n2 = this.checkLongLength(l);
        this.setParam(-1, n, reader, n2);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateCharacterStream(String, Reader)");
            }
        }
        this.checkUpdatability("updateClob(String, Reader, long)");
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, "updateBlob", new Object[]{n, blob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "updateBlob", new Object[]{n, blob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(int, Blob)");
            }
        }
        this.checkUpdatability("updateBlob(int, Blob)");
        if (blob == null) {
            blob = this._pc._conn._nullBlob;
        }
        this.setParam(2004, n, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{string, blob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{string, blob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(String, Blob)");
            }
        }
        this.checkUpdatability("updateBlob(String, Blob)");
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{n, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(int, InputStream)");
            }
        }
        this.checkUpdatability("updateBlob(int, InputStream)");
        this.setParam(-4, n, inputStream, -1);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(String, InputStream)");
            }
        }
        this.checkUpdatability("updateBlob(String, InputStream)");
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{n, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(int, InputStream, long)");
            }
        }
        this.checkUpdatability("updateBlob(int, InputStream, long)");
        int n2 = this.checkLongLength(l);
        this.setParam(-4, n, inputStream, n2);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " updateBlob", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " updateBlob", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " updateBlob(String, InputStream, long)");
            }
        }
        this.checkUpdatability("updateBlob(String, InputStream, long)");
        int n = this.checkLongLength(l);
        this.updateBlob(this.findColumn(string), inputStream, (long)n);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " cancelRowUpdates()");
        }
        this.checkUpdatability("cancelRowUpdates()");
        if (this._rowDeleted || this._rowUpdated || this._rowInserted) {
            ErrorMessage.raiseError("JZ0RM", "cancelRowUpdates");
        }
        try {
            this._paramMgr.clearParamArray(true);
            this._insertParamMgr.clearParamArray(true);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " deleteRow()");
        }
        this.checkUpdatability("deleteRow()");
        int n = this._cursor.delete(this._prs);
        if (n > 0) {
            this._rowDeleted = true;
        }
    }

    @Override
    public void deleteRow(String string) throws SQLException {
        this.checkUpdatability("deleteRow(String)");
        this._cursor.setTable(string);
        int n = this._cursor.delete(this._prs);
        if (n > 0) {
            this._rowDeleted = true;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        int n;
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " updateRow()");
        }
        this.checkUpdatability("updateRow()");
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this._cursor.getTable() + " SET ");
        int n2 = stringBuffer.length();
        ResultSetMetaData resultSetMetaData = this._prs.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        Param[] paramArray = this._paramMgr.getParams();
        boolean bl = true;
        for (n = 0; n < n3; ++n) {
            if (paramArray[n]._sqlType == -999) {
                paramArray[n]._sqlType = -998;
                continue;
            }
            if (paramArray[n]._sqlType == -998) continue;
            if (!bl) {
                stringBuffer.append(", ");
                n2 += 2;
            }
            String string = resultSetMetaData.getColumnName(n + 1);
            n2 += string.length() + 3;
            stringBuffer.append(string + " = ?");
            paramArray[n]._paramMarkerOffset = n2++;
            bl = false;
        }
        if (bl) {
            ErrorMessage.raiseError("JZ00G");
        }
        if (1 == this._cursor.update(this._prs, this._paramMgr, stringBuffer.toString())) {
            this._rowUpdated = true;
        }
        for (n = 0; n < n3; ++n) {
            if (paramArray[n]._sqlType != -998) continue;
            paramArray[n]._sqlType = -999;
        }
    }

    @Override
    public void updateRow(String string) throws SQLException {
        this.checkUpdatability("updateRow(String)");
        this._cursor.setTable(string);
        this.updateRow();
    }

    private void setParam(int n, int n2, Object object) throws SQLException {
        this.setParam(n, n2, object, 0);
    }

    private void setParam(int n, int n2, Object object, int n3) throws SQLException {
        this.checkResultSet();
        if (this._paramMgr != null) {
            if (this._rowIndex != -3) {
                this._paramMgr.setParam(n2, n, object, n3);
            } else {
                this._insertParamMgr.setParam(n2, n, object, n3);
                this._rowInserted = false;
            }
        } else {
            ErrorMessage.raiseError("JZ00H");
        }
    }

    @Override
    protected JdbcDataObject getColumn(int n) throws SQLException {
        this.checkResultSet();
        if (this._rowIndex == -3) {
            Param[] paramArray = this._insertParamMgr.getParams();
            if (n < 1 || n > paramArray.length) {
                ErrorMessage.raiseError("JZ008", "" + n);
            }
            this._currentColumn = paramArray[n - 1]._sqlType == -999 || paramArray[n - 1]._sqlType == -998 ? null : (JdbcDataObject)((Object)paramArray[n - 1]);
        } else if (this._paramMgr != null) {
            Param[] paramArray = this._paramMgr.getParams();
            if (n < 1 || n > paramArray.length) {
                ErrorMessage.raiseError("JZ008", "" + n);
            }
            this.checkIfReadableRow();
            this._currentColumn = paramArray[n - 1]._sqlType == -999 || paramArray[n - 1]._sqlType == -998 ? this._prs.getColumn(n) : (JdbcDataObject)((Object)paramArray[n - 1]);
        } else {
            this.checkIfReadableRow();
            this._currentColumn = this._prs.getColumn(n);
        }
        return this._currentColumn;
    }

    @Override
    protected void checkIfReadableRow() throws SQLException {
        if (this._rowDeleted) {
            ErrorMessage.raiseError("JZ0RD");
        }
        if (this._rowIndex == -1) {
            ErrorMessage.raiseError("JZ0R1");
        } else if (this._rowIndex == -2) {
            ErrorMessage.raiseError("JZ0R5");
        }
    }

    @Override
    protected void checkForScrollability(String string) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", string, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: {
                if (!this._cursor.isLanguageCursor()) break;
                ErrorMessage.raiseError("JZ0LC", string);
                break;
            }
            case 1005: {
                Debug.notImplemented(this, string + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    protected void checkUpdatability(String string) throws SQLException {
        if (this._concurType == 1007) {
            ErrorMessage.raiseError("JZ0BT", string, this._concurTypeString);
        }
    }

    private int checkLongLength(long l) {
        int n;
        if (l > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
            this._statement._context._conn.chainWarnings(ErrorMessage.createWarning("01S11"));
        } else {
            n = (int)l;
        }
        return n;
    }
}

