/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybBinaryClientLob;
import com.sybase.jdbc4.jdbc.SybCallableStatement;
import com.sybase.jdbc4.jdbc.SybCallableStatementCopy;
import com.sybase.jdbc4.jdbc.SybCharClientLob;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybPreparedStatementCopy;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybSavepoint;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.jdbc.SybUrlProvider;
import com.sybase.jdbc4.utils.CacheManager;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.LogUtil;
import com.sybase.jdbc4.utils.SybInputPassword;
import com.sybase.jdbcx.Capture;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybConnection
implements com.sybase.jdbcx.SybConnection {
    private static Logger LOG = Logger.getLogger(SybConnection.class.getName());
    private static volatile long _logIdCounter = 0L;
    protected String _logId = null;
    static final int TRANSACTION_NONE = 0;
    static final int TRANSACTION_READ_UNCOMMITTED = 1;
    static final int TRANSACTION_READ_COMMITTED = 2;
    static final int TRANSACTION_REPEATABLE_READ = 4;
    static final int TRANSACTION_SERIALIZABLE = 8;
    private MdaManager _mda = null;
    protected SybDatabaseMetaData _sybDBMD = null;
    private SQLWarning _warning = null;
    protected Protocol _protocol;
    protected ProtocolContext _pc;
    private ProtocolContext _sharedPc;
    private CacheManager _sharedCm;
    protected SybProperty _props;
    protected boolean _dynamicPrepare;
    protected String _dbName;
    protected String _dbProductName;
    protected String _dbProductVersion;
    protected String _url = null;
    private int _loginTimeout;
    private long _loginStartTime;
    private IConstants.CONNECTION_STATE _state = IConstants.CONNECTION_STATE.NEW;
    private int _dynStmtNum = 100;
    private Hashtable _cursors;
    private Vector _hostPortList = null;
    private Vector _secondaryHostPortList = null;
    private int _haLoginStatus = 0;
    private int _haState = -1;
    private boolean _wasConnected = false;
    private String _currentHostPort;
    private boolean _inClose = false;
    private boolean _duringConnect = false;
    boolean _batchSBPIInitialized = false;
    private Vector _savepoints = null;
    private int _savepointId = 1;
    private int _defaultQueryTimeout = 0;
    private int _internalQueryTimeout = 0;
    protected Vector _stmtList = null;
    protected int _rsHoldability;
    private Properties _clientInfoProperties = new Properties();
    protected Blob _nullBlob = null;
    protected Clob _nullClob = null;
    protected NClob _nullNClob = null;

    public SybConnection(String string, SybUrlProvider sybUrlProvider, String string2) throws SQLException {
        this(string, sybUrlProvider, string2, DriverManager.getLoginTimeout());
    }

    protected SybConnection(String string, SybUrlProvider sybUrlProvider, String string2, int n) throws SQLException {
        this._logId = string + "_Co" + _logIdCounter++;
        this._url = string2;
        this._protocol = sybUrlProvider.getProtocol();
        this._props = sybUrlProvider.getSybProperty();
        this._hostPortList = sybUrlProvider.getHostPortList();
        this._dbName = sybUrlProvider.getDatabaseName();
        this._dynamicPrepare = this.isPropertySet(25);
        this._loginTimeout = n;
        this._haState = -1;
        this._duringConnect = true;
        this._savepoints = new Vector();
        this._defaultQueryTimeout = this._props.getInteger(62);
        this._internalQueryTimeout = this._props.getInteger(61);
        this._stmtList = new Vector();
        this._rsHoldability = 1;
        try {
            if (this.isPropertySet(34)) {
                String string3 = this._props.getString(45);
                if (string3 != null) {
                    this._secondaryHostPortList = new Vector();
                    this._secondaryHostPortList.addElement(string3);
                } else {
                    this._secondaryHostPortList = sybUrlProvider.getSecondaryHostPortList();
                }
                this.setHALoginStatus(1);
                this.handleHAFailover();
                if (this._secondaryHostPortList == null || this._secondaryHostPortList.size() == 0) {
                    if (this._haState != 8) {
                        ErrorMessage.raiseError("JZ0F1");
                    }
                }
            } else if (this.isPropertySet(72)) {
                this.setHALoginStatus(0);
                this.handleHAFailover();
            } else {
                this.regularConnect();
            }
        }
        catch (SQLException sQLException) {
            this._protocol.abort();
            throw sQLException;
        }
        finally {
            this._duringConnect = false;
        }
    }

    private void regularConnect() throws SQLException {
        if (this._dynamicPrepare && this.isPropertySet(15)) {
            this.handleSQLE(ErrorMessage.createWarning("010PO"));
        }
        this.tryLogin(this._hostPortList);
    }

    private void tryLogin(Vector vector) throws SQLException {
        boolean bl = true;
        boolean bl2 = this.isPropertySet(26);
        if (this._haState == 9) {
            bl = false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this._loginStartTime = System.currentTimeMillis();
            try {
                String string;
                this._currentHostPort = string = (String)enumeration.nextElement();
                this._protocol.login(string, this._props, this, true);
                break;
            }
            catch (SQLWarning sQLWarning) {
                this.chainWarnings(sQLWarning);
                break;
            }
            catch (SQLException sQLException) {
                block27: {
                    block26: {
                        if (this._protocol.getRedirectImmed()) {
                            this._hostPortList = this._protocol.getRedirectionHostPort();
                            enumeration = this._hostPortList.elements();
                            this._protocol.setRedirectImmed(false);
                            this._haLoginStatus &= 0xFFFFFFF7;
                        }
                        if (bl2 && enumeration.hasMoreElements()) {
                            this.chainWarnings(sQLException);
                            try {
                                ErrorMessage.raiseWarning("010SQ");
                            }
                            catch (SQLWarning sQLWarning) {
                                this.chainWarnings(sQLWarning);
                            }
                            continue;
                        }
                        if (this.isPropertySet(34) && this.getHAState() == 10) break block26;
                        if (!this.isPropertySet(72) || this.getHAState() != 9) break block27;
                    }
                    this.markDead(false);
                    this.handleSQLE(sQLException);
                    continue;
                }
                if (this.isPropertySet(34) && ("JZ006".equals(sQLException.getSQLState()) || "JZ00L".equals(sQLException.getSQLState())) && this.getHAState() != 1 && this.getHAState() != 6) {
                    this.handleHAFailover();
                    bl = false;
                    break;
                }
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    this.handleSQLE(sQLException);
                    continue;
                }
                this.markDead(false);
                this.handleSQLE(sQLException);
            }
        }
        if (bl) {
            this._state = IConstants.CONNECTION_STATE.IDLE;
            this._pc = this.initProtocol();
            long l = this.getLoginTimeRemaining();
            if (l < 0L) {
                ErrorMessage.raiseError("JZ00M");
            }
            try {
                if (this._warning != null && "01ZZZ".equals(this._warning.getSQLState()) && this._warning.getErrorCode() == 4022) {
                    try {
                        CallableStatement callableStatement = this.prepareCall("{call sp_password(?,?)}");
                        String string = null;
                        String string2 = null;
                        String string3 = null;
                        string = this._props.getString(4);
                        string2 = this._props.getString(69);
                        if (this._props.getBoolean(70)) {
                            SybInputPassword sybInputPassword = new SybInputPassword(string);
                            string = sybInputPassword.getOldPassword();
                            string2 = sybInputPassword.getNewPassword();
                            string3 = sybInputPassword.getConfirmPassword();
                        } else {
                            string2 = this._props.getString(69);
                        }
                        if (string2 != null) {
                            callableStatement.setString(1, string);
                            callableStatement.setString(2, string2);
                            callableStatement.executeUpdate();
                            this._props.setProperty(4, string2);
                            this._props.setProperty(69, null);
                            this._warning = null;
                        } else {
                            ErrorMessage.raiseError("01ZZZ");
                        }
                    }
                    catch (SQLException sQLException) {
                        this.handleSQLE(sQLException);
                    }
                }
                this.init();
            }
            catch (SQLWarning sQLWarning) {
                this.chainWarnings(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void init() throws SQLException {
        var1_1 = null;
        var2_2 = this._props;
        var3_3 = this._dbName;
        var4_4 = false;
        if (var2_2.getBoolean(6)) {
            try {
                this.checkMDA(this._pc);
                this.determineCharset();
                var4_4 = true;
                this._protocol.setOption(null, 11, false);
                if (var3_3 == null || var3_3.length() <= 0) ** GOTO lbl90
                try {
                    this.setCatalog(var3_3);
                }
                catch (SQLException var5_5) {
                    this.checkForHAException(var5_5);
                    this.handleSQLE(ErrorMessage.createWarning("010DF", var5_5.getMessage()));
                }
            }
            catch (Exception var5_6) {
                this.checkForHAException(var5_6);
                this.checkUnsupportedCharsetException(var5_6);
                this.checkForLoginTimeout(var5_6);
                if (!var4_4) {
                    try {
                        this.determineCharset();
                    }
                    catch (SQLException var6_8) {
                        this.checkUnsupportedCharsetException(var6_8);
                        this.checkForHAException(var6_8);
                    }
                }
                try {
                    ErrorMessage.raiseWarning("010MX", var5_6.toString());
                }
                catch (SQLWarning var6_9) {
                    var7_21 = null;
                    try {
                        if (var3_3 == null || var3_3.length() <= 0) ** GOTO lbl90
                        var7_21 = this.prepareInternalStatement("use ?");
                        var7_21.setString(1, var3_3);
                        var7_21.executeUpdate();
                    }
                    catch (SQLException var8_24) {
                        this.checkForHAException(var8_24);
                        this.handleSQLE(ErrorMessage.createWarning("010UF", var8_24.getMessage()));
                    }
                    finally {
                        if (var7_21 != null) {
                            try {
                                var7_21.close();
                                var7_21 = null;
                            }
                            catch (SQLException var8_25) {
                                var7_21 = null;
                                this.handleSQLE(var8_25);
                            }
                            catch (RuntimeException var8_26) {
                                var7_21 = null;
                                throw var8_26;
                            }
                        }
                        this.handleSQLE(var6_9);
                    }
                }
            }
        } else {
            this.determineCharset();
            var5_7 = null;
            try {
                if (var3_3 != null && var3_3.length() > 0) {
                    var5_7 = this.prepareInternalStatement("use ?");
                    var5_7.setString(1, var3_3);
                    var5_7.executeUpdate();
                }
            }
            catch (SQLException var6_13) {
                this.checkForHAException(var6_13);
                this.handleSQLE(ErrorMessage.createWarning("010SK", var6_13.getMessage()));
            }
            finally {
                if (var5_7 != null) {
                    try {
                        var5_7.close();
                        var5_7 = null;
                    }
                    catch (SQLException var6_14) {
                        var5_7 = null;
                        this.handleSQLE(var6_14);
                    }
                    catch (RuntimeException var6_15) {
                        var5_7 = null;
                        throw var6_15;
                    }
                }
            }
        }
        var5_7 = var2_2.getString(18);
        if (var5_7 != null && var5_7.length() > 0) {
            try {
                var1_1 = this.createInternalStatement();
                var1_1.executeUpdate((String)var5_7);
            }
            catch (SQLException var6_18) {
                this.handleSQLE(var6_18);
            }
            finally {
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                        var1_1 = null;
                    }
                    catch (SQLException var6_19) {
                        var1_1 = null;
                        this.handleSQLE(var6_19);
                    }
                    catch (RuntimeException var6_20) {
                        var1_1 = null;
                        throw var6_20;
                    }
                }
            }
        }
        this._state = IConstants.CONNECTION_STATE.NEW;
        var6_10 = (String[])this._props.getObject(38);
        if (var6_10 != null) {
            var7_21 = this._protocol.getClassLoader();
            if (var7_21 == null) {
                ErrorMessage.raiseError("JZ0CL");
            } else {
                try {
                    var7_21.preloadJars(var6_10);
                }
                catch (SQLException var8_28) {
                    this.chainWarnings(var8_28);
                    try {
                        ErrorMessage.raiseWarning("010PF");
                    }
                    catch (SQLWarning var9_30) {
                        this.chainWarnings(var9_30);
                    }
                }
            }
        }
        this.resetNullLobs();
    }

    private boolean isSurrogateProcessingDisabled() throws SQLException {
        boolean bl = false;
        Statement statement = this.createInternalStatement();
        ResultSet resultSet = statement.executeQuery("select value2 from master.dbo.syscurconfigs where config = (select config from master.dbo.sysconfigures where name='enable surrogate processing' and parent != 19 and config != 19)");
        if (resultSet.next()) {
            bl = resultSet.getInt(1) == 1;
        }
        resultSet.close();
        statement.close();
        resultSet = null;
        statement = null;
        return bl;
    }

    private boolean isSurrogateProcessingDisabledOnServer() throws SQLException {
        if (!this._props.getBoolean(6)) {
            return this.isSurrogateProcessingDisabled();
        }
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("SURROGATEPROCESS", this._pc);
            SybResultSet sybResultSet = (SybResultSet)preparedStatement.executeQuery();
            if (sybResultSet.next()) {
                bl = sybResultSet.getInt(1) == 0;
            }
            sybResultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("JZ0SJ")) {
                return this.isSurrogateProcessingDisabled();
            }
            throw sQLException;
        }
        return bl;
    }

    public boolean okToThrowLoginTimeoutException() {
        switch (this._haState) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        return this._duringConnect;
    }

    public int getLoginTimeout() {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getLoginTimeout()");
        }
        return this._loginTimeout;
    }

    protected long getLoginTimeRemaining() {
        int n = this._loginTimeout * 1000;
        if (n == 0) {
            return 0L;
        }
        long l = 0L;
        switch (this._haState) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 0L;
            }
        }
        l = (long)n - (System.currentTimeMillis() - this._loginStartTime);
        if (l == 0L) {
            l = -1L;
        }
        return l;
    }

    private void determineCharset() throws SQLException {
        String string;
        String string2 = this._props.getString(8);
        if (string2 == null) {
            string2 = this.getDefaultServerCharset();
            if (string2 == null) {
                string2 = "ascii_7";
                try {
                    ErrorMessage.raiseWarning("010TQ");
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
            }
            this._protocol.setOption(null, 6, string2);
        }
        if (string2.equalsIgnoreCase("utf8") && this._protocol.isAse() && this.isSurrogateProcessingDisabledOnServer() && (string = this._props.getString(77)) == null) {
            this._props.setProperty(77, "x-SybUTF8");
            this._protocol.setOption(null, 6, string2);
        }
    }

    public void checkForHAException(Exception exception) throws SQLException {
        SQLException sQLException;
        if (exception instanceof SQLException && "JZ0F2".equals((sQLException = (SQLException)exception).getSQLState())) {
            throw sQLException;
        }
    }

    public void checkForLoginTimeout(Exception exception) throws SQLException {
        boolean bl = false;
        SQLException sQLException = null;
        if (exception instanceof SQLException) {
            for (sQLException = (SQLException)exception; sQLException != null; sQLException = sQLException.getNextException()) {
                if (!"JZ00M".equals(sQLException.getSQLState())) continue;
                bl = true;
                try {
                    this.close();
                }
                catch (SQLException sQLException2) {}
                break;
            }
            if (bl) {
                throw sQLException;
            }
        }
    }

    public void checkUnsupportedCharsetException(Exception exception) throws SQLException {
        boolean bl = false;
        SQLException sQLException = null;
        if (exception instanceof SQLException) {
            for (sQLException = (SQLException)exception; sQLException != null; sQLException = sQLException.getNextException()) {
                if (!"JZ0IB".equals(sQLException.getSQLState())) continue;
                bl = true;
                try {
                    this.close();
                }
                catch (SQLException sQLException2) {}
                break;
            }
            if (bl) {
                throw sQLException;
            }
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " createStatement()");
        }
        this.checkConnection();
        SybStatement sybStatement = new SybStatement(this._logId, this.initProtocol());
        sybStatement.setQueryTimeout(this._defaultQueryTimeout);
        sybStatement.setResultSetHoldability(this._rsHoldability);
        return sybStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " prepareStatement(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareStatement(String)");
            }
        }
        return this.prepareStatement(string, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " prepareStatement(String = [" + string + "] , int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareStatement(String, int)");
            }
        }
        try {
            return this.prepareStatement(string, this._dynamicPrepare, n);
        }
        catch (SQLException sQLException) {
            if (this._dynamicPrepare) {
                return this.prepareStatement(string, false, n);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " prepareStatement", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " prepareStatement", new Object[]{string, nArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareStatement(String, int[])");
            }
        }
        if (nArray == null || nArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnIndexes");
        }
        return this.prepareStatement(string, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " prepareStatement", new Object[]{string, stringArray}));
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " prepareStatement", new Object[]{string, stringArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareStatement(String, String[])");
            }
        }
        if (stringArray == null || stringArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnNames");
        }
        return this.prepareStatement(string, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        return this.prepareStatement(string, bl, 2);
    }

    private PreparedStatement prepareStatement(String string, boolean bl, int n) throws SQLException {
        this.checkConnection();
        SybPreparedStatement sybPreparedStatement = bl ? new SybPreparedStatement(this._logId, this.initProtocol(), string, this._dynStmtNum++, n) : new SybPreparedStatement(this._logId, this.initProtocol(), string, n);
        sybPreparedStatement.setQueryTimeout(this._defaultQueryTimeout);
        sybPreparedStatement.setResultSetHoldability(this._rsHoldability);
        return sybPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " prepareCall(String = [" + string + "] )");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareCall(String)");
            }
        }
        this.checkConnection();
        SybCallableStatement sybCallableStatement = new SybCallableStatement(this._logId, this.initProtocol(), string);
        sybCallableStatement.setQueryTimeout(this._defaultQueryTimeout);
        sybCallableStatement.setResultSetHoldability(this._rsHoldability);
        return sybCallableStatement;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + "nativeSQL(String = [" + string + "] )");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " nativeSQL(String)");
            }
        }
        this.checkConnection();
        SybStatement sybStatement = (SybStatement)this.createStatement();
        return sybStatement.processEscapes(string);
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + "setAutoCommit(boolean = [" + bl + "] )");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAutoCommit(boolean)");
            }
        }
        this.checkConnection();
        try {
            this._protocol.setOption(null, 1, bl);
            if (this.isPropertySet(79)) {
                this._protocol.setOption(null, 13, !bl);
            }
            this.resetNullLobs();
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetNullLobs() throws SQLException {
        if (!this.canUseLocators()) {
            this._nullClob = new SybCharClientLob(this._logId, this._pc, new StringBuilder(), SybLob.LOB_TYPE.TEXT);
            this._nullBlob = new SybBinaryClientLob(this._logId, this._pc, new byte[0]);
        } else {
            PreparedStatement preparedStatement = null;
            SybResultSet sybResultSet = null;
            try {
                preparedStatement = this._mda.getMetaDataAccessor("INIT_NULL_LOBS", this._pc);
                sybResultSet = (SybResultSet)preparedStatement.executeQuery();
                if (sybResultSet.next()) {
                    this._nullBlob = sybResultSet.getInitializedBlob(1);
                    this._nullClob = sybResultSet.getInitializedClob(2);
                }
            }
            finally {
                if (sybResultSet != null) {
                    sybResultSet.close();
                    sybResultSet = null;
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getAutoCommit()");
        }
        this.checkConnection();
        boolean bl = false;
        try {
            bl = this._protocol.getBoolOption(null, 1);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return bl;
    }

    @Override
    public void commit() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " commit()");
        }
        this.checkConnection();
        try {
            this._protocol.endTransaction(true);
            if (!this._stmtList.isEmpty()) {
                Enumeration enumeration = this._stmtList.elements();
                while (enumeration.hasMoreElements()) {
                    ((SybStatement)enumeration.nextElement()).cancel();
                }
            }
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        this.resetNullLobs();
    }

    @Override
    public void rollback() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " rollback()");
        }
        this.checkConnection();
        try {
            this._protocol.endTransaction(false);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        this.resetNullLobs();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " rollback", new Object[]{savepoint}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " rollback(Savepoint)");
            }
        }
        this.checkConnection();
        int n = this.getSavepointIdx(savepoint);
        if (n == -1) {
            ErrorMessage.raiseError("JZ017");
        }
        PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("ROLL_TO_SAVEPOINT", " " + ((SybSavepoint)savepoint)._name, this._pc);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this._savepoints.subList(n + 1, this._savepoints.size()).clear();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " setSavepoint()");
        }
        SybSavepoint sybSavepoint = (SybSavepoint)this.setSavepoint("jConn_autogen_svpt" + this._savepointId);
        sybSavepoint._id = this._savepointId++;
        sybSavepoint._isNamed = false;
        return sybSavepoint;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setSavepoint(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setSavepoint(String)");
            }
        }
        this.checkConnection();
        PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("SAVEPOINT", " " + string, this._pc);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        SybSavepoint sybSavepoint = new SybSavepoint(this._logId, string);
        sybSavepoint._isNamed = true;
        int n = this.getSavepointIdx(sybSavepoint);
        if (n != -1) {
            this._savepoints.removeElementAt(n);
        }
        this._savepoints.addElement(sybSavepoint);
        return sybSavepoint;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        int n;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " releaseSavepoint", new Object[]{savepoint}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " releaseSavepoint(Savepoint)");
            }
        }
        if ((n = this.getSavepointIdx(savepoint)) == -1) {
            ErrorMessage.raiseError("JZ017");
        }
        this._savepoints.removeElementAt(n);
    }

    private int getSavepointIdx(Savepoint savepoint) throws SQLException {
        int n = -1;
        for (int i = 0; i < this._savepoints.size(); ++i) {
            SybSavepoint sybSavepoint = (SybSavepoint)this._savepoints.get(i);
            if (!sybSavepoint._name.equals(((SybSavepoint)savepoint)._name)) continue;
            n = i;
            break;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " close()");
        }
        if (this._state == IConstants.CONNECTION_STATE.DEAD) {
            return;
        }
        this._inClose = true;
        if (this._cursors != null) {
            Enumeration enumeration = this._cursors.keys();
            try {
                while (true) {
                    String string = (String)enumeration.nextElement();
                    this._cursors.remove(string);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.markDead(false);
        try {
            this._protocol.logout();
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        finally {
            this._pc.drop();
            if (this._sharedPc != null) {
                this._sharedPc.drop();
            }
            this._inClose = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isClosed()");
        }
        String string = this._props.getString(36);
        if (this._state != IConstants.CONNECTION_STATE.DEAD && !"INTERNAL".equals(string)) {
            CallableStatement callableStatement = null;
            Statement statement = null;
            try {
                if (string == null) {
                    callableStatement = this.prepareInternalCall("{call sp_mda(?,?)}");
                    callableStatement.setInt(1, 0);
                    callableStatement.setInt(2, 9);
                    callableStatement.executeQuery();
                } else {
                    statement = this.createInternalStatement();
                    statement.executeQuery(string);
                }
            }
            catch (SQLException sQLException) {
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
            }
            finally {
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                        callableStatement = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return this._state == IConstants.CONNECTION_STATE.DEAD;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getMetaData()");
        }
        this.checkConnection();
        this.checkDBMD();
        return this._sybDBMD;
    }

    protected String getDatabaseProductName() throws SQLException {
        return this._dbProductName;
    }

    protected synchronized void setDatabaseProductName(String string) throws SQLException {
        this._dbProductName = string;
    }

    protected String getDatabaseProductVersion() throws SQLException {
        return this._dbProductVersion;
    }

    protected synchronized void setDatabaseProductVersion(String string) throws SQLException {
        this._dbProductVersion = string;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setReadOnly(boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setReadOnly(boolean)");
            }
        }
        this.checkConnection();
        try {
            this._protocol.setOption(null, 3, bl);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " isReadOnly()");
        }
        this.checkConnection();
        boolean bl = false;
        try {
            bl = this._protocol.getBoolOption(null, 3);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return bl;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setCatalog(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCatalog(String)");
            }
        }
        this.checkConnection();
        try {
            this._protocol.setOption(null, 9, string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getCatalog()");
        }
        this.checkConnection();
        String string = null;
        try {
            string = this._protocol.getStringOption(null, 9, null);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return string;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setTransactionIsolation(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTransactionIsolation(int)");
            }
        }
        this.checkConnection();
        try {
            this._protocol.setOption(null, 2, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getTransactionIsolation()");
        }
        this.checkConnection();
        int n = -1;
        try {
            n = this._protocol.getIntOption(null, 2);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return n;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getWarnings()");
        }
        return this._warning;
    }

    public SQLWarning getWarningsNoCheckConnection() throws SQLException {
        return this._warning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " clearWarnings()");
        }
        this.checkConnection();
        this._warning = null;
    }

    @Override
    public int getHoldability() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getHoldability()");
        }
        return this._rsHoldability;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setHoldability(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setHoldability(int)");
            }
        }
        if (n != 1 && n != 2) {
            ErrorMessage.raiseError("JZ0SW", String.valueOf(n));
        }
        this._rsHoldability = n;
    }

    @Override
    public String getSessionID() throws SQLException {
        return this._protocol.getStringOption(null, 5, null);
    }

    @Override
    public void regWatch(String string, SybEventHandler sybEventHandler, int n) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.makeEventContext(string, sybEventHandler, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public void regNoWatch(String string) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.killEventContext(string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public Capture createCapture() throws SQLException {
        return (Capture)this._protocol.getObjectOption(this._pc, 8);
    }

    public Object getEndpoint() throws SQLException {
        return this._protocol.getObjectOption(this._pc, 7);
    }

    @Override
    public void cancel() throws SQLException {
        this._protocol.cancel(this._pc, true);
    }

    public void markDead() {
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void markDead(boolean bl) throws SQLException {
        this._state = IConstants.CONNECTION_STATE.DEAD;
        if (bl) {
            this.checkConnection();
        }
    }

    public void markDeadTryHA() throws IOException {
        boolean bl = false;
        try {
            bl = this.isPropertySet(34) || this.isPropertySet(72);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException) {
            if ("JZ0F2".equals(sQLException.getSQLState())) {
                ErrorMessage.raiseHAException("JZ0F2");
            }
            IOException iOException = new IOException(sQLException.getMessage());
            ErrorMessage.raiseSybConnectionDeadException(iOException);
        }
        if (bl) {
            ErrorMessage.raiseHAException("JZ0F2");
        }
    }

    public String getDefaultServerCharset() throws SQLException {
        this.checkConnection();
        String string = null;
        try {
            string = this._protocol.getStringOption(null, 6, null);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return string;
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        if (!bl) {
            sQLWarning = (SQLWarning)sQLException;
        } else {
            sQLWarning = SybConnection.getAllTheWarnings(sQLException);
            if (this._props.getBoolean(76)) {
                sQLException = SybConnection.getAllExceptions(sQLException);
            }
        }
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl && this._props != null) {
            throw sQLException;
        }
    }

    public int getHALoginStatus() {
        return this._haLoginStatus;
    }

    protected int getHAState() {
        return this._haState;
    }

    public void setHAState(int n) {
        this._haState = n;
    }

    protected void setHALoginStatus(int n) {
        this._haLoginStatus = n;
        try {
            if (this.isPropertySet(71)) {
                this._haLoginStatus |= 8;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isDead() {
        return this._state == IConstants.CONNECTION_STATE.DEAD;
    }

    public static SQLWarning getAllTheWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = null;
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            if (!(sQLException2 instanceof SQLWarning)) continue;
            if (sQLWarning == null) {
                sQLWarning = new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode());
                continue;
            }
            sQLWarning.setNextWarning(new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode()));
        }
        return sQLWarning;
    }

    public static SQLException getAllExceptions(SQLException sQLException) {
        SQLException sQLException2 = null;
        for (SQLException sQLException3 = sQLException; sQLException3 != null; sQLException3 = sQLException3.getNextException()) {
            if (sQLException3 instanceof SQLWarning) continue;
            if (sQLException2 == null) {
                sQLException2 = new SQLException(sQLException3.getMessage(), sQLException3.getSQLState(), sQLException3.getErrorCode());
                if (sQLException2.getCause() != null || sQLException.getCause() == null) continue;
                sQLException2.initCause(sQLException.getCause());
                continue;
            }
            sQLException2.setNextException(new SQLException(sQLException3.getMessage(), sQLException3.getSQLState(), sQLException3.getErrorCode()));
            if (sQLException2.getCause() != null || sQLException.getCause() == null) continue;
            sQLException2.initCause(sQLException.getCause());
        }
        return sQLException2;
    }

    public static SQLWarning convertToWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = null;
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            SQLWarning sQLWarning2 = new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode());
            if (sQLWarning == null) {
                sQLWarning = sQLWarning2;
                continue;
            }
            sQLWarning.setNextWarning(sQLWarning2);
        }
        return sQLWarning;
    }

    public void chainWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = SybConnection.convertToWarnings(sQLException);
        if (this._warning == null) {
            this._warning = sQLWarning;
        } else {
            this._warning.setNextWarning(sQLWarning);
        }
    }

    public static boolean thisChainHasAnException(SQLException sQLException) {
        boolean bl = false;
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            if (sQLException2 instanceof SQLWarning) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._pc.setMessageHandler(sybMessageHandler);
    }

    @Override
    public SybMessageHandler getSybMessageHandler() {
        return this._pc.getMessageHandler();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " createStatement(int = [" + n + "] , int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " createStatement(int, int)");
            }
        }
        SybStatement sybStatement = (SybStatement)this.createStatement();
        sybStatement.setResultSetParams(n, n2);
        return sybStatement;
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " createStatement(int = [" + n + "] , int = [" + n2 + "] , int = [" + n3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " createStatement(int, int, int)");
            }
        }
        SybStatement sybStatement = (SybStatement)this.createStatement(n, n2);
        sybStatement.setResultSetHoldability(n3);
        return sybStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " prepareStatement(String = [" + string + "] , int = [" + n + "] , int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareStatement(String, int, int)");
            }
        }
        SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this.prepareStatement(string);
        sybPreparedStatement.setResultSetParams(n, n2);
        return sybPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " prepareStatement(String = [" + string + "] , int = [" + n + "] , int = [" + n2 + "] , int = [" + n3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareStatement(String, int, int, int)");
            }
        }
        SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this.prepareStatement(string, n, n2);
        sybPreparedStatement.setResultSetHoldability(n3);
        return sybPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " prepareCall(String = [" + string + "] , int = [" + n + "] , int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareCall(String, int, int)");
            }
        }
        SybCallableStatement sybCallableStatement = (SybCallableStatement)this.prepareCall(string);
        sybCallableStatement.setResultSetParams(n, n2);
        return sybCallableStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " prepareCall(String = [" + string + "] , int = [" + n + "] , int = [" + n2 + "] , int = [" + n3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " prepareCall(String, int, int, int)");
            }
        }
        SybCallableStatement sybCallableStatement = (SybCallableStatement)this.prepareCall(string, n, n2);
        sybCallableStatement.setResultSetHoldability(n3);
        return sybCallableStatement;
    }

    public Map getTypeMap() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getTypeMap()");
        }
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setTypeMap", new Object[]{map}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTypeMap", new Object[]{map}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTypeMap(Java.util.Map)");
            }
        }
        Debug.notImplemented(this, "setTypeMap(java.util.Map)");
    }

    protected ProtocolContext initProtocol() throws SQLException {
        ProtocolContext protocolContext = this._protocol.getProtocolContext(this._props);
        protocolContext._protocol = this._protocol;
        protocolContext._conn = this;
        if (this._pc != null) {
            protocolContext._msgHandler = this._pc._msgHandler;
        }
        return protocolContext;
    }

    public MdaManager getMDA(ProtocolContext protocolContext) throws SQLException {
        this.checkMDA(protocolContext);
        return this._mda;
    }

    protected void handleHAFailover() throws SQLException {
        this.nextHAState();
        switch (this.getHAState()) {
            case 0: {
                if (this.isPropertySet(34)) {
                    this.setHALoginStatus(1);
                }
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                if (this._haState == 7) {
                    this.setHAState(8);
                    break;
                }
                this.setHAState(2);
                break;
            }
            case 4: {
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 5: {
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 1: {
                if (this._secondaryHostPortList == null || this._secondaryHostPortList.size() == 0) {
                    ErrorMessage.raiseError("JZ0F1");
                }
                this.setHALoginStatus(5);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
            case 6: {
                this.setHALoginStatus(7);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
            case 7: {
                this.setHALoginStatus(1);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(8);
                break;
            }
            case 10: {
                this.setHALoginStatus(3);
                if (this._protocol.getRedirectionHostPort() != null) {
                    this._hostPortList = this._protocol.getRedirectionHostPort();
                }
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(8);
                break;
            }
            case 9: {
                if (this.isPropertySet(34)) {
                    this.setHALoginStatus(17);
                } else {
                    this.setHALoginStatus(16);
                }
                this.tryLogin(this._protocol.getRedirectionHostPort());
                this._wasConnected = true;
                this.setHAState(8);
                break;
            }
        }
    }

    private void nextHAState() {
        if (!this._wasConnected) {
            switch (this._haState) {
                case -1: {
                    this._haState = 0;
                    break;
                }
                case 0: {
                    this._haState = 1;
                    break;
                }
                case 7: {
                    break;
                }
            }
        } else {
            switch (this._haState) {
                case 2: {
                    this._haState = 4;
                    break;
                }
                case 4: 
                case 5: {
                    this._haState = 6;
                    break;
                }
                case 3: {
                    this._haState = 5;
                    break;
                }
                case 8: {
                    this._haState = 10;
                    break;
                }
                case 9: {
                    break;
                }
            }
        }
    }

    protected void checkConnection() throws SQLException {
        if (this._state == IConstants.CONNECTION_STATE.DEAD) {
            if (this.isPropertySet(34) && !this._inClose && this.getHAState() != 1 && this.getHAState() != 6) {
                this._state = IConstants.CONNECTION_STATE.NEW;
                this.handleHAFailover();
            } else if (this.isPropertySet(72) && !this._inClose && this.getHAState() == 9) {
                this._state = IConstants.CONNECTION_STATE.NEW;
                this.handleHAFailover();
            } else {
                this._protocol.abort();
                ErrorMessage.raiseError("JZ0C0");
            }
        }
    }

    protected ResultSet getCursorResultSet(String string) {
        if (this._cursors == null) {
            return null;
        }
        return (ResultSet)this._cursors.get(string);
    }

    protected void addCursorResultSet(String string, ResultSet resultSet) {
        if (this._cursors == null) {
            this._cursors = new Hashtable();
        }
        this._cursors.put(string, resultSet);
    }

    public void removeCursorResultSet(String string) {
        if (this._cursors == null) {
            return;
        }
        try {
            this._cursors.remove(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public com.sybase.jdbcx.SybPreparedStatement copyPreparedStatement(com.sybase.jdbcx.SybPreparedStatement sybPreparedStatement) throws SQLException {
        SybPreparedStatementCopy sybPreparedStatementCopy = new SybPreparedStatementCopy(this.getSharedProtocolContext(), (SybPreparedStatement)sybPreparedStatement);
        sybPreparedStatementCopy.setMaxRows(0);
        return sybPreparedStatementCopy;
    }

    @Override
    public com.sybase.jdbcx.SybCallableStatement copyCallableStatement(com.sybase.jdbcx.SybCallableStatement sybCallableStatement) throws SQLException {
        SybCallableStatementCopy sybCallableStatementCopy = new SybCallableStatementCopy(this.getSharedProtocolContext(), (SybCallableStatement)sybCallableStatement);
        sybCallableStatementCopy.setMaxRows(0);
        return sybCallableStatementCopy;
    }

    protected synchronized ProtocolContext getSharedProtocolContext() throws SQLException {
        if (this._sharedPc == null) {
            this._sharedPc = this.initProtocol();
        }
        return this._sharedPc;
    }

    protected synchronized CacheManager getSharedCacheManager() {
        return this._sharedCm;
    }

    protected synchronized void setSharedCacheManager(CacheManager cacheManager) {
        this._sharedCm = cacheManager;
    }

    protected int getDynStmtNum() {
        return this._dynStmtNum;
    }

    protected void setDynStmtNum(int n) {
        this._dynStmtNum = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMDA(ProtocolContext protocolContext) throws SQLException {
        block7: {
            if (this._mda == null) {
                try {
                    if (protocolContext == null) {
                        SybConnection sybConnection = this;
                        synchronized (sybConnection) {
                            this._mda = new MdaManager(this._logId, this, this._pc);
                            break block7;
                        }
                    }
                    this._mda = new MdaManager(this._logId, this, protocolContext);
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
            }
        }
    }

    private void checkDBMD() throws SQLException {
        this.checkMDA(null);
        if (this._sybDBMD == null) {
            this._sybDBMD = new SybDatabaseMetaData(this._logId, this);
        }
    }

    public Statement createInternalStatement() throws SQLException {
        Statement statement = this.createStatement();
        statement.setQueryTimeout(this._internalQueryTimeout);
        return statement;
    }

    public PreparedStatement prepareInternalStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        preparedStatement.setQueryTimeout(this._internalQueryTimeout);
        return preparedStatement;
    }

    public PreparedStatement prepareInternalStatement(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string, bl);
        preparedStatement.setQueryTimeout(this._internalQueryTimeout);
        return preparedStatement;
    }

    public CallableStatement prepareInternalCall(String string) throws SQLException {
        CallableStatement callableStatement = this.prepareCall(string);
        callableStatement.setQueryTimeout(this._internalQueryTimeout);
        return callableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " isValid(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " isValid(int)");
            }
        }
        Statement statement = null;
        ResultSet resultSet = null;
        if (n < 0) {
            ErrorMessage.raiseError("JZ0SS");
        }
        try {
            statement = this.createStatement();
            statement.setQueryTimeout(n);
            resultSet = statement.executeQuery("select 1");
            boolean bl = resultSet.next();
            return bl;
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
        return false;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " createArrayOf", new Object[]{string, objectArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " createArrayOf", new Object[]{string, objectArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " createArrayOf(String, Object[])");
            }
        }
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " createBlob()");
        }
        if (!this.canUseLocators()) {
            return new SybBinaryClientLob(this._logId, this._pc, new byte[0]);
        }
        if (this._batchSBPIInitialized) {
            ErrorMessage.raiseError("JZ044");
        }
        PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("INIT_IMAGELOCATOR", this._pc);
        SybResultSet sybResultSet = (SybResultSet)preparedStatement.executeQuery();
        Blob blob = null;
        if (sybResultSet.next()) {
            blob = sybResultSet.getInitializedBlob(1);
        }
        return blob;
    }

    @Override
    public Clob createClob() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " createClob()");
        }
        if (!this.canUseLocators()) {
            return new SybCharClientLob(this._logId, this._pc, new StringBuilder(), SybLob.LOB_TYPE.TEXT);
        }
        if (this._batchSBPIInitialized) {
            ErrorMessage.raiseError("JZ044");
        }
        PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("INIT_TEXTLOCATOR", this._pc);
        SybResultSet sybResultSet = (SybResultSet)preparedStatement.executeQuery();
        Clob clob = null;
        if (sybResultSet.next()) {
            clob = sybResultSet.getInitializedClob(1);
        }
        return clob;
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " createNClob()");
        }
        ErrorMessage.raiseMethodNotSupportedException(this, "createNClob()");
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " createSQLXML()");
        }
        Debug.notImplemented(this, "public SQLXML createSQLXML()");
        return null;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " createStruct", new Object[]{string, objectArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " createStruct", new Object[]{string, objectArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " createStruct(String, Object[])");
            }
        }
        Debug.notImplemented(this, "public Struct createStruct(String arg0, Object[] arg1)");
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getClientInfo()");
        }
        this.checkConnection();
        if (this._clientInfoProperties.size() == 0) {
            PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("GET_CLIENT_INFO", this._pc);
            preparedStatement.execute();
            ResultSet resultSet = preparedStatement.getResultSet();
            if (resultSet.next()) {
                this._clientInfoProperties.put("ApplicationName", resultSet.getString(1));
                this._clientInfoProperties.put("ClientUser", resultSet.getString(2));
                this._clientInfoProperties.put("ClientHostname", resultSet.getString(3));
            }
        }
        return this._clientInfoProperties;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getClientInfo(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getClientInfo(String)");
            }
        }
        this.checkConnection();
        this.getClientInfo();
        Object object = this._clientInfoProperties.get(string);
        if (object != null) {
            return object.toString();
        }
        if (string.equalsIgnoreCase("ENABLE_FUNCTIONALITY_GROUP")) {
            return null;
        }
        Object object2 = this._props.getConnProperty(string);
        if (object2 == null || object2.toString().equalsIgnoreCase("null")) {
            return null;
        }
        return object2.toString();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setClientInfo", new Object[]{properties}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setClientInfo", new Object[]{properties}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setClientInfo(Properties)");
            }
        }
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        String string = null;
        Set<Object> set = properties.keySet();
        SQLException sQLException = null;
        ClientInfoStatus clientInfoStatus = ClientInfoStatus.REASON_UNKNOWN;
        try {
            this.checkConnection();
        }
        catch (SQLException sQLException2) {
            throw new SQLClientInfoException(hashMap, (Throwable)sQLException2);
        }
        for (Object object : set) {
            string = object.toString();
            Object object2 = properties.get(string);
            try {
                CLIENT_INFO cLIENT_INFO = CLIENT_INFO.getValue(string);
                if (cLIENT_INFO != null) {
                    PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("SET_CLIENT_INFO", this._pc);
                    preparedStatement.setString(1, cLIENT_INFO.getValue());
                    preparedStatement.setString(2, object2.toString());
                    preparedStatement.executeUpdate();
                    this._clientInfoProperties.put(string, object2.toString());
                    continue;
                }
                throw new SQLException();
            }
            catch (SQLException sQLException3) {
                if (sQLException == null) {
                    sQLException = sQLException3;
                } else {
                    sQLException.setNextException(sQLException3);
                }
                hashMap.put(string, clientInfoStatus);
            }
        }
        if (!hashMap.isEmpty()) {
            SQLClientInfoException sQLClientInfoException = sQLException != null ? new SQLClientInfoException(hashMap, sQLException) : new SQLClientInfoException(hashMap);
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        Object object;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setClientInfo(String = [" + string + "] , String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setClientInfo(String, String)");
            }
        }
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        try {
            this.checkConnection();
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(hashMap, (Throwable)sQLException);
        }
        String string3 = string;
        ClientInfoStatus clientInfoStatus = ClientInfoStatus.REASON_UNKNOWN;
        SQLException sQLException = null;
        try {
            object = CLIENT_INFO.getValue(string3);
            if (object != null) {
                PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("SET_CLIENT_INFO", this._pc);
                preparedStatement.setString(1, object.getValue());
                preparedStatement.setString(2, string2);
                preparedStatement.executeUpdate();
                this._clientInfoProperties.put(string3, string2);
                return;
            }
            int n = this._props.getKey(string3);
            if (n == -1) {
                hashMap.put(string3, clientInfoStatus);
            } else if (string2 == null || string2.isEmpty() || string2.equalsIgnoreCase("null")) {
                clientInfoStatus = ClientInfoStatus.REASON_VALUE_INVALID;
                this._props.setConnProperty(string3, null, true, false);
            } else {
                clientInfoStatus = ClientInfoStatus.REASON_VALUE_INVALID;
                this._props.setConnProperty(string3, string2, true, false);
            }
            if (string3.equalsIgnoreCase("DYNAMIC_PREPARE")) {
                this._dynamicPrepare = this.isPropertySet(n);
            }
            if (string3.equalsIgnoreCase("DEFAULT_QUERY_TIMEOUT")) {
                this._defaultQueryTimeout = this._props.getInteger(62);
            }
            if (string3.equalsIgnoreCase("INTERNAL_QUERY_TIMEOUT")) {
                this._internalQueryTimeout = this._props.getInteger(61);
            }
        }
        catch (SQLException sQLException2) {
            if (sQLException == null) {
                sQLException = sQLException2;
            } else {
                sQLException.setNextException(sQLException2);
            }
            hashMap.put(string3, clientInfoStatus);
        }
        if (!hashMap.isEmpty()) {
            object = sQLException != null ? new SQLClientInfoException(hashMap, (Throwable)sQLException) : new SQLClientInfoException(hashMap);
            throw object;
        }
    }

    protected boolean isLobLocatorSupported() throws SQLException {
        return this._protocol.isLocatorSupported();
    }

    public boolean canUseLocators() throws SQLException {
        return this.isLobLocatorSupported() && this.isLOBLocatorEnabled() && !this.getAutoCommit();
    }

    public boolean isPropertySet(int n) throws SQLException {
        return this._props.getBoolean(n);
    }

    public boolean isLOBLocatorEnabled() throws SQLException {
        return this.isPropertySet(79);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " isWrapperFor", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " isWrapperFor", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " isWrapperFor(Class<?>)");
            }
        }
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " unwrap", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " unwrap", new Object[]{clazz}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " unwrap(Class<T>)");
            }
        }
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName());
        }
        return t;
    }

    private static enum CLIENT_INFO {
        ApplicationName("ApplicationName", "clientapplname"),
        ClientHostname("ClientHostname", "clienthostname"),
        ClientUser("ClientUser", "clientname");

        private final String key;
        private final String value;

        private CLIENT_INFO(String string2, String string3) {
            this.key = string2;
            this.value = string3;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static CLIENT_INFO getValue(String string) {
            if (string.equals(CLIENT_INFO.ApplicationName.key)) {
                return ApplicationName;
            }
            if (string.equals(CLIENT_INFO.ClientHostname.key)) {
                return ClientHostname;
            }
            if (string.equals(CLIENT_INFO.ClientUser.key)) {
                return ClientUser;
            }
            return null;
        }
    }
}

