/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LimiterInputStream;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybCursorResultSet;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybScrollCursorResultSet;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SybCallableStatement
extends SybPreparedStatement
implements com.sybase.jdbcx.SybCallableStatement {
    private static Logger LOG = Logger.getLogger(SybCallableStatement.class.getName());
    private static volatile long _logIdCounter = 0L;
    protected boolean _hasOutParam = false;

    SybCallableStatement(String string, ProtocolContext protocolContext, String string2) throws SQLException {
        super(string, protocolContext, string2, 2);
        this._logId = string + "_Cs" + _logIdCounter++;
        this._sqlStr = string2;
        if (this._hasReturn) {
            this._paramMgr.doSetParam(1, -998, new Integer(0), 0);
            this._paramMgr.doRegisterParam(1, 4);
            this._returnHasBeenRegistered = false;
        }
    }

    SybCallableStatement(String string, ProtocolContext protocolContext, SybCallableStatement sybCallableStatement) throws SQLException {
        super(string, protocolContext, sybCallableStatement);
        this._logId = string + "_Cs" + _logIdCounter++;
        this._allowsOutputParms = sybCallableStatement._allowsOutputParms;
        this._rpcName = sybCallableStatement._rpcName;
        this._sendAsRpc = sybCallableStatement._sendAsRpc;
        this._hasReturn = sybCallableStatement._hasReturn;
        if (this._hasReturn) {
            this._paramMgr.doSetParam(1, -998, new Integer(0), 0);
            this._paramMgr.doRegisterParam(1, 4);
            this._returnHasBeenRegistered = false;
        }
    }

    @Override
    protected void setDoEscapes() {
        this._doEscapes = true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " executeQuery()");
        }
        this.clearParams();
        if (this._sendAsRpc) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.queryLoop();
            }
            return this._currentRS;
        }
        return super.executeQuery(this._query, this._paramMgr);
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " executeUpdate()");
        }
        this.clearParams();
        int n = -1;
        if (this._sendAsRpc) {
            this.checkStatement(true);
            if (this._cursor != null) {
                ErrorMessage.raiseError("JZ0S3");
            }
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                n = this.updateLoop();
            }
        } else {
            n = super.executeUpdate(this._query, this._paramMgr);
        }
        return n;
    }

    @Override
    public boolean execute() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " execute()");
        }
        this.clearParams();
        if (this._sendAsRpc) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.executeLoop();
            }
            return this._currentRS != null;
        }
        return super.execute(this._query, this._paramMgr);
    }

    @Override
    public void addBatch() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " addBatch()");
        }
        if (this._sendBatchParamsImmediate && (this._hasReturn || this._hasOutParam)) {
            ErrorMessage.raiseError("JZ0BP");
        }
        if (this._batchCmdsCount < 1) {
            this._query = this.handleCallBody(this._query);
        }
        super.addBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " executeBatch()");
        }
        if (this._hasReturn || this._hasOutParam) {
            ErrorMessage.raiseError("JZ0BP");
        }
        return super.executeBatch();
    }

    @Override
    public void cancel() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " cancel()");
        }
        this.checkStatement(false);
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.cancel();
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " registerOutParameter(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " registerOutParameter(int, int)");
            }
        }
        this.checkOutParamRegistration(n);
        this._paramMgr.registerParam(n, n2);
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " registerOutParameter(String = [" + string + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " registerOutParameter(String, int)");
            }
        }
        this._paramMgr.registerParam(string, n);
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " registerOutParameter(int = [" + n + "], int = [" + n2 + "], int = [" + n3 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " registerOutParameter(int, int, int)");
            }
        }
        this.checkOutParamRegistration(n);
        this._paramMgr.registerParam(n, n2, n3);
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " registerOutParameter(String = [" + string + "], int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " registerOutParameter(String, int, int)");
            }
        }
        this._paramMgr.registerParam(string, n, n2);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " registerOutParameter(int = [" + n + "], int = [" + n2 + "], String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " registerOutParameter(int, int, String)");
            }
        }
        this._paramMgr.registerParam(n, n2, string);
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " registerOutParameter(String = [" + string + "], int = [" + n + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " registerOutParameter(String, int, String)");
            }
        }
        this._paramMgr.registerParam(string, n, string2);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " wassNull()");
        }
        return this._paramMgr.wasNull();
    }

    @Override
    public String getString(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getString(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getString(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getString();
    }

    @Override
    public String getString(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getString(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getString(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getString();
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getString(String = [" + string + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getString(String, String)");
            }
        }
        this.setParam(12, string, string2);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBoolean(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBoolean(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getBoolean();
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getString(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getString(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getBoolean();
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setBoolean(String = [" + string + "], boolean = [" + bl + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBoolean(String, boolean)");
            }
        }
        Boolean bl2 = new Boolean(bl);
        this.setParam(-7, string, bl2);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getByte(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getByte(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getByte();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getByte(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getByte(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getByte();
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        Integer n;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setByte(String = [" + string + "], byte = [" + by + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setByte(String, byte)");
            }
        }
        if ((n = new Integer(by)) < 0) {
            this.setParam(5, string, n);
        } else {
            this.setParam(-6, string, n);
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getShort(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getShort(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getShort();
    }

    @Override
    public short getShort(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getShort(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getShort(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getShort();
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setShort(String = [" + string + "], short = [" + s + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setShort(String, short)");
            }
        }
        Integer n = new Integer(s);
        this.setParam(5, string, n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getInt(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getInt(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getInt();
    }

    @Override
    public int getInt(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getInt(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getInt(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getInt();
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setInt(String = [" + string + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setInt(String, int)");
            }
        }
        Integer n2 = new Integer(n);
        this.setParam(4, string, n2);
    }

    @Override
    public long getLong(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getLong(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getLong(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getLong();
    }

    @Override
    public long getLong(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getLong(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getLong(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getLong();
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setLong(String = [" + string + "], long = [" + l + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setLong(String, long)");
            }
        }
        Long l2 = new Long(l);
        this.setParam(-5, string, l2);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getFloat(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getFloat(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getFloat();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getFloat(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getFloat(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getFloat();
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setFloat(String = [" + string + "], float = [" + f + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setFloat(String, float)");
            }
        }
        Float f2 = new Float(f);
        this.setParam(7, string, f2);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getDouble(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDouble(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getDouble();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getDouble(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDouble(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getDouble();
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setDouble(String = [" + string + "], double = [" + d + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setDouble(String, double)");
            }
        }
        Double d2 = new Double(d);
        this.setParam(8, string, d2);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBigDecimal(int = [" + n + "], int = [" + n2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBigDecimal(int, int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getBigDecimal(n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBigDecimal(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBigDecimal(int)");
            }
        }
        return this.getBigDecimal(n, -1);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBigDecimal(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBigDecimal(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getBigDecimal(-1);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setBigDecimal(String = [" + string + "], BigDecimal = [" + bigDecimal + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBigDecimal(String, BigDecimal)");
            }
        }
        if (bigDecimal == null) {
            this.setNull(string, 2);
        } else {
            this.setParam(2, string, bigDecimal, bigDecimal.scale());
        }
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBytes(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBytes(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getBytes();
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBytes(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBytes(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getBytes();
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBytes", new Object[]{string, byArray}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBytes", new Object[]{string, byArray}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBytes(String, byte[])");
            }
        }
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        if (n > 255) {
            this.setParam(-4, string, byArray);
        } else {
            this.setParam(-3, string, byArray);
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getDate(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDate(int)");
            }
        }
        return Convert.objectToDate(this._paramMgr.getOutValueAt(n).getDateObject(91, null));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getDate(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDate(String)");
            }
        }
        return Convert.objectToDate(this._paramMgr.getOutValueAt(string).getDateObject(91, null));
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setDate", new Object[]{string, date}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setDate(String, java.sql.Date)");
            }
        }
        if (date == null) {
            this.setParam(91, string, date);
        } else {
            this.setParam(91, string, new DateObject((Object)date, 91));
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " gettime(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTime(int)");
            }
        }
        return Convert.objectToTime(this._paramMgr.getOutValueAt(n).getDateObject(92, null));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getTime(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTime(String)");
            }
        }
        return Convert.objectToTime(this._paramMgr.getOutValueAt(string).getDateObject(92, null));
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTime", new Object[]{string, time}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTime(String, java.sql.Time)");
            }
        }
        if (time == null) {
            this.setParam(92, string, time);
        } else {
            this.setParam(92, string, new DateObject((Object)time, 92));
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getTimestamp(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTimestamp(int)");
            }
        }
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n).getDateObject(93, null));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getTimestamp(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTimestamp(String)");
            }
        }
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(string).getDateObject(93, null));
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTimestamp", new Object[]{string, timestamp}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTimestamp(String, java.sql.Timestamp)");
            }
        }
        if (timestamp == null) {
            this.setParam(93, string, timestamp);
        } else {
            this.setParam(93, string, new DateObject((Object)timestamp, 93));
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getObject(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getObject(int)");
            }
        }
        return this._paramMgr.getOutObjectAt(n);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getObject(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getObject(String)");
            }
        }
        return this._paramMgr.getOutObjectAt(string);
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setObject", new Object[]{string, object}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setObject(String, Object)");
            }
        }
        if (object == null) {
            ErrorMessage.raiseError("JZ0SE");
        }
        if (object instanceof Short) {
            this.setShort(string, (short)((Short)object));
        } else if (object instanceof Byte) {
            this.setByte(string, (byte)((Byte)object));
        } else if (object instanceof String) {
            this.setString(string, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(string, (BigDecimal)object);
        } else if (object instanceof Boolean) {
            this.setParam(-7, string, object);
        } else if (object instanceof Integer) {
            this.setParam(4, string, object);
        } else if (object instanceof Long) {
            this.setParam(-5, string, object);
        } else if (object instanceof Float) {
            this.setParam(7, string, object);
        } else if (object instanceof Double) {
            this.setParam(8, string, object);
        } else if (object instanceof byte[]) {
            this.setBytes(string, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(string, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(string, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(string, (Timestamp)object);
        } else if (object instanceof Serializable) {
            this.setParam(2000, string, object);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setObject", new Object[]{string, object, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setObject(String, Object, int)");
            }
        }
        this.setObject(string, object, n, 0);
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setObject", new Object[]{string, object, n, n2}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setObject(String, Object, int, int )");
            }
        }
        if (object == null) {
            this.setParam(n, string, null, n2);
        }
        switch (n) {
            case -7: {
                this.setParam(n, string, Convert.objectToBoolean(object), n2);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                this.setParam(n, string, Convert.objectToInt(object), n2);
                break;
            }
            case -5: {
                this.setParam(n, string, Convert.objectToLong(object), n2);
                break;
            }
            case 1: 
            case 12: {
                this.setString(string, Convert.objectToString(object));
                break;
            }
            case -15: 
            case -9: {
                this.setNString(string, Convert.objectToString(object));
                break;
            }
            case -1: {
                this.setParam(-1, string, Convert.objectToString(object));
                break;
            }
            case 2: 
            case 3: {
                if (n2 < 0) {
                    ErrorMessage.raiseError("JZ00I");
                }
                this.setParam(n, string, Convert.objectToBigDecimal(object), n2);
                break;
            }
            case 7: {
                this.setParam(n, string, Convert.objectToFloat(object), n2);
                break;
            }
            case 6: 
            case 8: {
                this.setParam(n, string, Convert.objectToDouble(object), n2);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(string, Convert.objectToBytes(object));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.setParam(n, string, Convert.objectToDateObject(object, n, null), n2);
                break;
            }
            case 1111: 
            case 2000: {
                if (object instanceof Serializable || object == null) {
                    this.setParam(2000, string, object);
                    break;
                }
            }
            default: {
                ErrorMessage.raiseError("JZ0SE");
            }
        }
    }

    public boolean sendRpc(String string, ParamManager paramManager) throws SQLException {
        try {
            if (this._rsConcur == -9) {
                this._rsConcur = 1007;
            }
            if (this._rsConcur == 1008) {
                this.checkCursor(false, 1008);
            }
            if (this._cursor != null) {
                ProtocolResultSet protocolResultSet = this._cursor.open(string, paramManager, true);
                protocolResultSet.setType(this._rsType);
                this._currentRS = this._cursor.scrollingAtServer() ? new SybScrollCursorResultSet(this._logId, this, protocolResultSet) : new SybCursorResultSet(this._logId, this, protocolResultSet);
                this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
                this._state = IConstants.CONNECTION_STATE.BUSY;
                return false;
            }
            this._protocol.rpc(this._context, string, paramManager);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return true;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getRef(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getRef(int)");
            }
        }
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getRef(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getRef(String)");
            }
        }
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBlob(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBlob(int)");
            }
        }
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getBlob(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getBlob(String)");
            }
        }
        Debug.notSupported(this, "getBlob(String)");
        return null;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getClob(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getClob(int)");
            }
        }
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getClob(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getClob(String)");
            }
        }
        Debug.notSupported(this, "getClob(String)");
        return null;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getArray(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getArray(int)");
            }
        }
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getArray(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getArray(String)");
            }
        }
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getDate", new Object[]{n, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDate(int, Calendar)");
            }
        }
        return Convert.objectToDate(this._paramMgr.getOutValueAt(n).getDateObject(91, calendar));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "getDate", new Object[]{string, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getDate(String, Calendar)");
            }
        }
        return Convert.objectToDate(this._paramMgr.getOutValueAt(string).getDateObject(91, calendar));
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setDate", new Object[]{string, date, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setDate(String, java.sql.Date, Calendar)");
            }
        }
        if (date == null) {
            this.setParam(91, string, date);
        } else {
            this.setParam(91, string, new DateObject(date, calendar, 91));
        }
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getTime", new Object[]{n, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTime(int, Calendar)");
            }
        }
        return Convert.objectToTime(this._paramMgr.getOutValueAt(n).getDateObject(92, calendar));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, "getTime", new Object[]{string, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTime(String, Calendar)");
            }
        }
        return Convert.objectToTime(this._paramMgr.getOutValueAt(string).getDateObject(92, calendar));
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTime", new Object[]{string, time, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTime(String, java.sql.Time, Calendar)");
            }
        }
        if (time == null) {
            this.setParam(92, string, time);
        } else {
            this.setParam(92, string, new DateObject(time, calendar, 92));
        }
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getTimestamp", new Object[]{n, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTimestamp(int, Calendar)");
            }
        }
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n).getDateObject(93, calendar));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getTimestamp", new Object[]{string, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getTimestamp(String, Calendar)");
            }
        }
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(string).getDateObject(93, calendar));
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setTimestamp", new Object[]{string, timestamp, calendar}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setTimestamp(String, java.sql.Timestamp, Calendar)");
            }
        }
        if (timestamp == null) {
            this.setParam(93, string, timestamp);
        } else {
            this.setParam(93, string, new DateObject(timestamp, calendar, 93));
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getURL(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getURL(int)");
            }
        }
        Debug.notSupported(this, "getURL(int)");
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getURL(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getURL(String)");
            }
        }
        Debug.notSupported(this, "getURL(String)");
        return null;
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setURL", new Object[]{string, uRL}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setURL(String, URL)");
            }
        }
        Debug.notSupported(this, "setURL(String, URL)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setAsciiStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setAsciiStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAsciiStream(String, InputStream, int)");
            }
        }
        if (inputStream == null) {
            this.setNull(string, -1);
        } else {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n), "ISO8859_1");
                String string2 = this._paramMgr.drainReader(inputStreamReader, n);
                if (string2 != null) {
                    this.setParam(12, string, string2, 0);
                } else {
                    this.setParam(-1, string, inputStreamReader, n);
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        byte[] byArray;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBinaryStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBinaryStream", new Object[]{string, inputStream, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBinaryStream(String, InputStream, int)");
            }
        }
        if ((byArray = this._paramMgr.drainStreams(inputStream, n)) != null) {
            this.setBytes(string, byArray);
        } else {
            this.setParam(-4, string, inputStream, n);
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        String string2;
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setCharacterStream", new Object[]{string, reader, n}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCharacterStream(String, Reader, int)");
            }
        }
        if ((string2 = this._paramMgr.drainReader(reader, n)) != null) {
            this.setParam(12, string, string2, 0);
        } else {
            this.setParam(-1, string, reader, n);
        }
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setNull(String = [" + string + "], int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNull(String, int)");
            }
        }
        this.setParam(n, string, null);
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setNull(String = [" + string + "], int = [" + n + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNull(String, int, String)");
            }
        }
        Debug.notImplemented(this, "setNull(String, int, String)");
    }

    public void clearParams() throws SQLException {
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    protected void handleParam(ParamManager paramManager) throws SQLException {
        if (this._batchCmds == null) {
            this._paramMgr.getParameter();
        } else {
            paramManager.getParameter();
        }
    }

    private void checkOutParamRegistration(int n) throws SQLException {
        if (!this._allowsOutputParms) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(n));
        }
    }

    @Override
    public void setParameterName(int n, String string) {
        Param[] paramArray = this._paramMgr.getParams();
        if (paramArray.length >= n && n > 0) {
            paramArray[n - 1]._name = string;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG) && LOG.isLoggable(Level.FINE)) {
            LOG.fine(this._logId + " getParameterMetaData()");
        }
        if (this._type != 1) {
            return super.getParameterMetaData();
        }
        try {
            if (this._dbmda == null) {
                this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
            }
            if (this._dbmda.getDatabaseProductName().indexOf("Anywhere") != -1) {
                return null;
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
        SybCallableStatement sybCallableStatement = new SybCallableStatement(this._logId, this._context, "{call sp_jdbc_getprocedurecolumns (@sp_name=?, @parammetadata=1, @paramcolids=?, @paramnames=?)}");
        if (this._paramMgr.getParamSetType() == 1) {
            this._paramNames = this._paramMgr.getColumnNames();
            this._paramColids = this._hasReturn ? "0" : null;
        }
        sybCallableStatement.setString(1, this._rpcName);
        sybCallableStatement.setString(2, this._paramColids);
        sybCallableStatement.setString(3, this._paramNames);
        ResultSet resultSet = sybCallableStatement.executeQuery();
        this._paramMgr.setParamMd(resultSet);
        return this;
    }

    private void setParam(int n, String string, Object object) throws SQLException {
        this.setParam(n, string, object, 0);
    }

    private void setParam(int n, String string, Object object, int n2) throws SQLException {
        this._paramMgr.setParam(string, n, object, n2);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getCharacterStream(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getCharacterSream(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getCharacterStream(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getCharacterStream(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNCharacterStream(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNCharacterStream(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNCharacterStream(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNCharacterStream(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getCharacterStream();
    }

    @Override
    public String getNString(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNString(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNString(int)");
            }
        }
        return this._paramMgr.getOutValueAt(n).getString();
    }

    @Override
    public String getNString(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNString(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNString(String)");
            }
        }
        return this._paramMgr.getOutValueAt(string).getString();
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " setNString(String = [" + string + "], String = [" + string2 + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNString(String, String)");
            }
        }
        this.setParam(-9, string, string2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setNCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNCharacterStream(String, Reader)");
            }
        }
        this.setParam(-16, string, reader, -1);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setNCharacterStream", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNCharacterStream", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNCharacterStream(String, Reader, long)");
            }
        }
        int n = this.checkLongLength(l);
        this.setParam(-16, string, reader, n);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setAsciiStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setAsciiStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAsciiStream(String, InputStream)");
            }
        }
        this.setAsciiStream(string, inputStream, -1);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setAsciiStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setAsciiStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setAsciiStream(String, InputStream, long)");
            }
        }
        if (inputStream == null) {
            this.setNull(string, -1);
        } else {
            int n = this.checkLongLength(l);
            this.setAsciiStream(string, inputStream, n);
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBinaryStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBinaryStream", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBinaryStream(String, InputStream)");
            }
        }
        this.setBinaryStream(string, inputStream, -1);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBinaryStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBinaryStream", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBinaryStream(String, InputStream, long)");
            }
        }
        int n = this.checkLongLength(l);
        this.setBinaryStream(string, inputStream, n);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setCharacterStream", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCharacterStream(String, Reader)");
            }
        }
        this.setCharacterStream(string, reader, -1);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setCharacterStream", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setCharacterStream(String, Reader, long)");
            }
        }
        int n = this.checkLongLength(l);
        this.setCharacterStream(string, reader, n);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getRowId(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getRowId(int)");
            }
        }
        Debug.notImplemented(this, "public RowId getRowId(int arg0)");
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getRowId(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getRowId(String)");
            }
        }
        Debug.notImplemented(this, "public RowId getRowId(String arg0)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSQLXML(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSQLXML(int)");
            }
        }
        Debug.notImplemented(this, "public SQLXML getSQLXML(int arg0)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getSQLXML(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getSQLXML(String)");
            }
        }
        Debug.notImplemented(this, "public SQLXML getSQLXML(String arg0)");
        return null;
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBlob", new Object[]{string, blob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBlob", new Object[]{string, blob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBlob(String, Blob)");
            }
        }
        Debug.notImplemented(this, "public void setBlob(String arg0, Blob arg1)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBlob", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBlob", new Object[]{string, inputStream}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBlob(String, InputStream)");
            }
        }
        this.setParam(-4, string, inputStream, -1);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setBlob", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setBlob", new Object[]{string, inputStream, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setBlob(String, InputStream, long)");
            }
        }
        if (l < -1L) {
            ErrorMessage.raiseError("JZ039");
        }
        int n = this.checkLongLength(l);
        this.setParam(-4, string, inputStream, n);
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setClob", new Object[]{string, clob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setClob", new Object[]{string, clob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setClob(String, Clob)");
            }
        }
        Debug.notImplemented(this, "public void setClob(String arg0, Clob arg1)");
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setClob", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setClob(String, Reader)");
            }
        }
        this.setParam(-1, string, reader, -1);
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setClob", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setClob(String, Reader, long)");
            }
        }
        if (l < -1L) {
            ErrorMessage.raiseError("JZ039");
        }
        int n = this.checkLongLength(l);
        this.setParam(-1, string, reader, n);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " setNClob", new Object[]{string, nClob}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNClob", new Object[]{string, nClob}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNClob(String, NClob)");
            }
        }
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, NClob)");
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNClob", new Object[]{string, reader}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNClob(String, Reader)");
            }
        }
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, Reader)");
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setNClob", new Object[]{string, reader, l}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setNClob(String, Reader, long)");
            }
        }
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, Reader, long)");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setRowId", new Object[]{string, rowId}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setRowId(String, RowId)");
            }
        }
        Debug.notImplemented(this, "public void setRowId(String arg0, RowId arg1)");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " setSQLXML", new Object[]{string, sQLXML}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " setSQLXML(String, SQLXML)");
            }
        }
        Debug.notImplemented(this, "public void setSQLXML(String arg0, SQLXML arg1)");
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " getObject", new Object[]{n, map}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getObject", new Object[]{n, map}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getObject(int, Map<String, Class<?>>)");
            }
        }
        Debug.notImplemented(this, "public Object getObject(int arg0, Map<String, Class<?>> arg1)");
        return null;
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(LogUtil.logMethod(false, this._logId, " getObject", new Object[]{string, map}));
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(LogUtil.logMethod(true, this._logId, " getObject", new Object[]{string, map}));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getObject(String, Map<String, Class<?>>)");
            }
        }
        Debug.notImplemented(this, "public Object getObject(String arg0, Map<String, Class<?>> arg1)");
        return null;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNclob(int = [" + n + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNClob(int)");
            }
        }
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(int)");
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        if (LogUtil.isLoggingEnabled(LOG)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this._logId + " getNClob(String = [" + string + "])");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this._logId + " getNClob(String)");
            }
        }
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(String)");
        return null;
    }
}

